/*+*****************************************************************************
*                                                                              *
* File: host.h                                                                 *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)host.h	1.4	01/06/98	Written by Lionel Cons
 */

#ifndef _host_h_
#define _host_h_

/******* Include Files ********************************************************/

#include "xmd.h"

#include <sys/types.h>
#include <netinet/in.h>

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

typedef struct HOST_ {
  char *name;			/* (meaningful) host name */
  char ip_name[16];		/* host name in decimal dot notation */
  char *short_name;		/* host name without the domain */
  char *fq_name;		/* fully qualified host name */
  char *domain;			/* domain name */
  struct in_addr addr;		/* host address */
} HOST;

/******* Variables ************************************************************/

extern HOST *localhost;		/* local host information */

/******* Functions ************************************************************/

char *host_name(U32BITS);
HOST *host_create_by_addr(struct in_addr *);
HOST *host_create_by_name(char *);
void  host_destroy(HOST *);
void  host_setup(void);

#endif /* _host_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
