/*+*****************************************************************************
*                                                                              *
* File: conn.h                                                                 *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)conn.h	1.6	03/16/99	Written by Lionel Cons
 */

#ifndef _conn_h_
#define _conn_h_

/******* Include Files ********************************************************/

#include "io.h"
#include "ui.h"
#include "host.h"
#include "xp.h"
#include "iconn.h"

/******* Constants ************************************************************/

/* connection flags */
#define CF_FROZEN	(1 << 0)  /* no more I/O allowed */
#define CF_CHECKED	(1 << 1)  /* X requests are inspected */
#define CF_SAFE		(1 << 2)  /* replace dubious packets by a noops */
#define CF_NOOP		(1 << 3)  /* replace next packet by a noop */

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

typedef struct CONN_ {
  /* connection stuff */
  HOST *host;			/* source of the connection */
  IO client;			/* IO from client */
  IO server;			/* IO from server */
  UI ui;			/* user interface stuff */
  time_t start;			/* creation time */
  time_t idle_since;		/* time of last thing read */
  int flags;			/* flags for the connection, see CF_* */
  XINFO xinfo;			/* X information */
  /* internal stuff */
  struct CONN_ *prev;		/* previous conn in list */
  struct CONN_ *next;		/* next conn in list */
  char *id;			/* (almost) unique ID */
  char *name;			/* name = [user@]host */
  char tag[6];			/* debugging tag */
} CONN;

/******* Variables ************************************************************/

/******* Functions ************************************************************/

void  conn_init(CONN *, ICONN *, int);
void  conn_close(CONN *);
int   conn_position(CONN *);
CONN *conn_at_position(int);
void  conn_client_write(CONN *);
void  conn_server_write(CONN *);
void  conn_client_read(CONN *);
void  conn_server_read(CONN *);
CONN *conn_oldest_alert(void);

#endif /* _conn_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
