'\" t
.\" -*-nroff-*-
.\"
.\"     Copyright (C) 1996-2000 Michael R. Elkins <me@cs.hmc.edu>
.\"	Copyright (C) 1999-2000 Thomas Roessler <roessler@guug.de>
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
.\"
.TH muttrc 5 "September 2002" Unix "User Manuals"
.SH NAME
muttrc \- Configuration file for the Mutt Mail User Agent
.SH DESCRIPTION
.PP
A mutt configuration file consists of a series of \(lqcommands\(rq.
Each line of the file may contain one or more commands.  When
multiple commands are used, they must be separated by a semicolon
(\(lq\fB;\fP\(rq).
.PP
The hash mark, or pound sign (\(lq\fB#\fP\(rq), is used as a
\(lqcomment\(rq character. You can use it to annotate your
initialization file. All text after the comment character to the end
of the line is ignored.
.PP
Single quotes (\(lq\fB'\fP\(rq) and double quotes (\(lq\fB"\fP\(rq)
can be used to quote strings which contain spaces or other special
characters.  The difference between the two types of quotes is
similar to that of many popular shell programs, namely that a single
quote is used to specify a literal string (one that is not
interpreted for shell variables or quoting with a backslash [see
next paragraph]), while double quotes indicate a string for which
should be evaluated.  For example, backtics are evaluated inside of
double quotes, but not for single quotes.
.PP
\fB\(rs\fP quotes the next character, just as in shells such as bash and zsh.
For example, if want to put quotes (\(lq\fB"\fP\(rq) inside of a
string, you can use \(lq\fB\(rs\fP\(rq to force the next character
to be a literal instead of interpreted character.
.PP
\(lq\fB\(rs\(rs\fP\(rq means to insert a literal \(lq\fB\(rs\fP\(rq into the
line.  \(lq\fB\(rsn\fP\(rq and \(lq\fB\(rsr\fP\(rq have their usual
C meanings of linefeed and carriage-return, respectively.
.PP
A \(lq\fB\(rs\fP\(rq at the end of a line can be used to split commands over
multiple lines, provided that the split points don't appear in the
middle of command names.
.PP
It is also possible to substitute the output of a Unix command in an
initialization file.  This is accomplished by enclosing the command
in backquotes (\fB`\fP\fIcommand\fP\fB`\fP).
.PP
UNIX environments can be accessed like the way it is done in shells
like sh and bash: Prepend the name of the environment by a dollar
(\(lq\fB\(Do\fP\(rq) sign.
.PP
.SH COMMANDS
.PP
.nf
\fBalias\fP \fIkey\fP \fIaddress\fP [\fB,\fP \fIaddress\fP [ ... ]]
\fBunalias\fP [\fB * \fP | \fIkey\fP ]
.fi
.IP
\fBalias\fP defines an alias \fIkey\fP for the given addresses.
\fBunalias\fP removes the alias corresponding to the given \fIkey\fP or
all aliases when \(lq\fB*\fP\(rq is used as an argument.
.PP
.nf
\fBalternative_order\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunalternative_order\fP [\fB * \fP | \fItype\fP/\fIsubtype\fP] [...]
.fi
.IP
\fBalternative_order\fP command permits you to define an order of preference which is
used by mutt to determine which part of a
\fBmultipart/alternative\fP body to display.
A subtype of \(lq\fB*\fP\(rq matches any subtype, as does an empty
subtype.   \fBunalternative_order\fP removes entries from the
ordered list or deletes the entire list when \(lq\fB*\fP\(rq is used
as an argument.
.PP
.nf
\fBauto_view\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunauto_view\fP \fItype\fP[fB/\fP\fIsubtype\fP] [ ... ]
.fi
.IP
This commands permits you to specify that mutt should automatically
convert the given MIME types to text/plain when displaying messages.
For this to work, there must be a 
.BR mailcap (5)
entry for the given MIME type with the 
.B copiousoutput
flag set.  A subtype of \(lq\fB*\fP\(rq 
matches any subtype, as does an empty subtype.
.PP
.nf
\fBmime_lookup\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunmime_lookup\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
.fi
.IP
This command permits you to define a list of "data" MIME content
types for which mutt will try to determine the actual file type from
the file name, and not use a 
.BR mailcap (5)
entry given for the original MIME type.  For instance, you may add
the \fBapplication/octet-stream\fP MIME type to this list.
.TP
\fBbind\fP \fImap\fP \fIkey\fP \fIfunction\fP
This command binds the given \fIkey\fP for the given \fImap\fP to
the given \fIfunction\fP.
.IP
Valid maps are:
.BR generic ", " alias ", " attach ", " 
.BR browser ", " editor ", "
.BR index ", " compose ", " 
.BR pager ", " pgp ", " postpone ", "
.BR mix .
.IP
For more information on keys and functions, please consult the Mutt
Manual.
.TP
\fBaccount-hook\fP [\fB!\fP]\fIregexp\fP \fIcommand\fP
This hook is executed whenever you access a remote mailbox. Useful
to adjust configuration settings to different IMAP or POP servers.
.TP
\fBcharset-hook\fP \fIalias\fP \fIcharset\fP
This command defines an alias for a character set.  This is useful
to properly display messages which are tagged with a character set
name not known to mutt.
.TP
\fBiconv-hook\fP \fIcharset\fP \fIlocal-charset\fP
This command defines a system-specific name for a character set.
This is useful when your system's 
.BR iconv (3)
implementation does not understand MIME character set names (such as 
.BR iso-8859-1 ),
but instead insists on being fed with implementation-specific
character set names (such as
.BR 8859-1 ).
In this specific case, you'd put this into your configuration file:
.IP
.B "iconv-hook iso-8859-1 8859-1"
.TP
\fBmessage-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
Before mutt displays (or formats for replying or forwarding) a
message which matches the given \fIpattern\fP (or, when it is
preceded by an exclamation mark, does not match the \fIpattern\fP),
the given \fIcommand\fP is executed.  When multiple
\fBmessage-hook\fPs match, they are  executed  in  the order in
which they occur in the configuration file.
.TP
\fBfolder-hook\fP [\fB!\fP]\fIregexp\fP \fIcommand\fP
When mutt enters a folder which matches \fIregexp\fP (or, when
\fIregexp\fP is preceded by an exclamation mark, does not match
\fIregexp\fP), the given \fIcommand\fP is executed.
.IP
When several \fBfolder-hook\fPs match a given mail folder, they are
executed in the order given in the configuration file.
.TP
\fBmacro\fP \fImap\fP \fIkey\fP \fIsequence\fP [ \fIdescription\fP ]
This command binds the given \fIsequence\fP of keys to the given
\fIkey\fP in the given \fImap\fP.  For valid maps, see \fBbind\fP.
.PP
.nf
\fBcolor\fP \fIobject\fP \fIforeground\fP \fIbackground\fP [ \fI regexp\fP ]
\fBcolor\fP index \fIforeground\fP \fIbackground\fP [ \fI pattern\fP ]
\fBuncolor\fP index \fIpattern\fP [ \fIpattern\fP ... ]
.fi
.IP
If your terminal supports color, these commands can be used to
assign \fIforeground\fP/\fIbackgound\fP combinations to certain
objects.  Valid objects are:
.BR attachment ", " body ", " bold ", " header ", "
.BR hdrdefault ", " index ", " indicator ", " markers ", "
.BR message ", " normal ", " quoted ", " quoted\fIN\fP ", "
.BR search ", " signature ", " status ", " tilde ", " tree ", "
.BR underline .
The
.BR body " and " header
objects allow you to restrict the colorization to a regular
expression.  The \fBindex\fP object permits you to select colored
messages by pattern.
.IP
Valid colors include:
.BR white ", " black ", " green ", " magenta ", " blue ", "
.BR cyan ", " yellow ", " red ", " default ", " color\fIN\fP .
.PP
.nf
\fBmono\fP \fIobject\fP \fIattribute\fP [ \fIregexp\fP ]
\fBmono\fP index \fIattribute\fP [ \fIpattern\fP ]
.fi
.IP
For terminals which don't support color, you can still assign
attributes to objects.  Valid attributes include:
.BR none ", " bold ", " underline ", " 
.BR reverse ", and " standout .
.TP
[\fBun\fP]\fBignore\fP \fIpattern\fP [ \fIpattern\fP ... ]
The \fBignore\fP command permits you to specify header fields which
you usually don't wish to see.  Any header field whose tag
\fIbegins\fP with an \(lqignored\(rq pattern will be ignored.
.IP
The \fBunignore\fP command permits you to define exceptions from
the above mentioned list of ignored headers.
.PP
.nf
\fBlists\fP \fIaddress\fP [ \fIaddress\fP ... ]
\fBunlists\fP \fIaddress\fP [ \fIaddress\fP ... ]
\fBsubscribe\fP \fIaddress\fP [ \fIaddress\fP ... ]
\fBunsubscribe\fP \fIaddress\fP [ \fIaddress\fP ... ]
.fi
.IP
Mutt maintains two lists of mailing list addresses, a list of
subscribed mailing lists, and a list of known mailing lists.  All
subscribed mailing lists are known.  A mail address matches a
mailing list if it begins with the given address.  For example, the
lists pattern \(lqmutt-\(rq will match mutt-dev@mutt.org and
mutt-users@mutt.org.
.IP
The \fBlists\fP command adds a mailing list address to the list of
known mailing lists.  The \fBunlists\fP command removes a mailing
list from the lists of known and subscribed mailing lists.  The
\fBsubscribe\fP command adds a mailing list to the lists of known
and subscribed mailing lists.  The \fBunsubscribe\fP command removes
it from the list of subscribed mailing lists.
.TP
\fBmbox-hook\fP [\fB!\fP]\fIpattern\fP \fImailbox\fP
When mutt changes to a mail folder which matches \fIpattern\fP,
\fImailbox\fP will be used as the \(lqmbox\(rq folder, i.e., read
messages will be moved to that folder when the mail folder is left.
.IP
The first matching \fBmbox-hook\fP applies.
.PP
.nf
\fBmailboxes\fP \fIfilename\fP [ \fIfilename\fP ... ]
\fBunmailboxes\fP [ \fB*\fP | \fIfilename\fP ... ]
.fi
.IP
The \fBmailboxes\fP specifies folders which can receive mail and which will
be checked for new messages.  When changing folders, pressing space
will cycle through folders with new mail.  The \fBunmailboxes\fP
command is used to remove a file name from the list of folders which
can receive mail.  If "\fB*\fP" is specified as the file name, the
list is emptied.
.PP
.nf
\fBmy_hdr\fP \fIstring\fP
\fBunmy_hdr\fP \fIfield\fP
.fi
.IP
Using \fBmy_hdr\fP, you can define headers which will be added to
the messages you compose.  \fBunmy_hdr\fP will remove the given
user-defined headers.
.TP
\fBhdr_order\fP \fIheader1\fP \fIheader2\fP [ ... ]
With this command, you can specify an order in which mutt will
attempt to present headers to you when viewing messages.
.TP
\fBsave-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
When a message matches \fIpattern\fP, the default file name when
saving it will be the given \fIfilename\fP.
.TP
\fBfcc-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
When an outgoing message matches \fIpattern\fP, the default file
name for storing a copy (fcc) will be the given \fIfilename\fP.
.TP
\fBfcc-save-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
This command is an abbreviation for identical \fBfcc-hook\fP and
\fBsave-hook\fP commands.
.TP
\fBsend-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
When composing a message matching \fIpattern\fP, \fIcommand\fP is
executed.  When multiple \fBsend-hook\fPs match, they are executed
in the order in which they occur in the configuration file.
.TP
\fBcrypt-hook\fP \fIpattern\fP \fIkey-id\fP
The crypt-hook command provides a method by which you can
specify the ID of the public key to be used when encrypting messages
to a certain recipient.  The meaning of "key ID" is to be taken
broadly: This can be a different e-mail address, a numerical key ID,
or even just an arbitrary search string.
.TP
\fBpush\fP \fIstring\fP
This command adds the named \fIstring\fP to the keyboard buffer.
.PP
.nf
\fBset\fP [\fBno\fP|\fBinv\fP]\fIvariable\fP[=\fIvalue\fP] [ ... ]
\fBtoggle\fP \fIvariable\fP [ ... ]
\fBunset\fP \fIvariable\fP [ ... ]
\fBreset\fP \fIvariable\fP [ ... ]
.fi
.IP
These commands are used to set and manipulate configuration
varibles.
.IP
Mutt knows four basic types of variables: boolean, number, string
and quadoption.  Boolean variables can be \fBset\fP (true),
\fBunset\fP (false), or \fBtoggle\fPd. Number variables can be assigned
a positive integer value.
.IP
String variables consist of any number of printable characters.
Strings must be enclosed in quotes if they contain spaces or tabs.
You may also use the \(lqC\(rq escape sequences \fB\\n\fP and
\fB\\t\fP for newline and tab, respectively.
.IP
Quadoption variables are used to control whether or not to be
prompted for certain actions, or to specify a default action.  A
value of \fByes\fP will cause the action to be carried out automatically
as if you had answered yes to the question.  Similarly, a value of
\fBno\fP will cause the the action to be carried out as if you had
answered \(lqno.\(rq A value of \fBask-yes\fP will cause a prompt
with a default answer of \(lqyes\(rq and \fBask-no\fP will provide a
default answer of \(lqno.\(rq
.IP
The \fBreset\fP command resets all given variables to the compile
time defaults.  If you reset the special variabe \fBall\fP, all
variables will reset to their system defaults.
.TP
\fBsource\fP \fIfilename\fP
The given file will be evaluated as a configuration file.
.TP
\fBunhook\fP [\fB * \fP | \fIhook-type\fP ]
This command will remove all hooks of a given type, or all hooks
when \(lq\fB*\fP\(rq is used as an argument.  \fIhook-type\fP
can be any of the \fB-hook\fP commands documented above.
.SH PATTERNS
.PP
In various places with mutt, including some of the abovementioned
\fBhook\fP commands, you can specify patterns to match messages.
.SS Constructing Patterns
.PP
A simple pattern consists of an operator of the form
\(lq\fB~\fP\fIcharacter\fP\(rq, possibly followed by a parameter
against which mutt is supposed to match the object specified by
this operator.  (For a list of operators, see below.)
.PP
With some of these operators, the object to be matched consists of
several e-mail addresses.  In these cases, the object is matched if
at least one of these e-mail addresses matches. You can prepend a
hat (\(lq\fB^\fP\(rq) character to such a pattern to indicate that
\fIall\fP addresses must match in order to match the object.
.PP
You can construct complex patterns by combining simple patterns with
logical operators.  Logical AND is specified by simply concatenating
two simple patterns, for instance \(lq~C mutt-dev ~s bug\(rq.
Logical OR is specified by inserting a vertical bar (\(lq\fB|\fP\(rq)
between two patterns, for instance \(lq~C mutt-dev | ~s bug\(rq.
Additionally, you can negate a pattern by prepending a bang
(\(lq\fB!\fP\(rq) character.  For logical grouping, use braces
(\(lq()\(rq). Example: \(lq!(~t mutt|~c mutt) ~f elkins\(rq.
.SS Simple Patterns
.PP
Mutt understands the following simple patterns:
.PP
.TS
l l.
~A	all messages
~b \fIEXPR\fP	messages which contain \fIEXPR\fP in the message body
~B \fIEXPR\fP	messages which contain \fIEXPR\fP in the whole message
~c \fIEXPR\fP	messages carbon-copied to \fIEXPR\fP
~C \fIEXPR\fP	message is either to: or cc: \fIEXPR\fP
~D	deleted messages
~d \fIMIN\fP-\fIMAX\fP	messages with \(lqdate-sent\(rq in a Date range
~E	expired messages
~e \fIEXPR\fP	message which contains \fIEXPR\fP in the \(lqSender\(rq field
~F	flagged messages
~f \fIEXPR\fP	messages originating from \fIEXPR\fP
~g	PGP signed messages
~G	PGP encrypted messages
~h \fIEXPR\fP	messages which contain \fIEXPR\fP in the message header
~k	message contains PGP key material
~i \fIEXPR\fP	message which match \fIEXPR\fP in the \(lqMessage-ID\(rq field
~L \fIEXPR\fP	message is either originated or received by \fIEXPR\fP
~l	message is addressed to a known mailing list
~m \fIMIN\fP-\fIMAX\fP	message in the range \fIMIN\fP to \fIMAX\fP
~n \fIMIN\fP-\fIMAX\fP	messages with a score in the range \fIMIN\fP to \fIMAX\fP
~N	new messages
~O	old messages
~p	message is addressed to you (consults $alternates)
~P	message is from you (consults $alternates)
~Q	messages which have been replied to
~R	read messages
~r \fIMIN\fP-\fIMAX\fP	messages with \(lqdate-received\(rq in a Date range
~S	superseded messages
~s \fIEXPR\fP	messages having \fIEXPR\fP in the \(lqSubject\(rq field.
~T	tagged messages
~t \fIEXPR\fP	messages addressed to \fIEXPR\fP
~U	unread messages
~v	message is part of a collapsed thread.
~x \fIEXPR\fP	messages which contain \fIEXPR\fP in the \(lqReferences\(rq field
~z \fIMIN\fP-\fIMAX\fP	messages with a size in the range \fIMIN\fP to \fIMAX\fP
~=	duplicated messages (see $duplicate_threads)
.TE
.PP
In the above, \fIEXPR\fP is a regular expression.
.PP
With the \fB~m\fP, \fB~n\fP, and \fB~z\fP operators, you can also
specify ranges in the forms \fB<\fP\fIMAX\fP, \fB>\fP\fIMIN\fP,
\fIMIN\fP\fB-\fP, and \fB-\fP\fIMAX\fP.
.SS Matching dates
.PP
The \fB~d\fP and \fB~r\fP operators are used to match date ranges,
which are interpreted to be given in your local time zone.
.PP
A date is of the form
\fIDD\fP[\fB/\fP\fIMM\fP[\fB/\fP[\fIcc\fP]\fIYY\fP]], that is, a
two-digit date, optionally followed by a two-digit month, optionally
followed by a year specifications.  Omitted fields default to the
current month and year.
.PP
Mutt understands either two or four digit year specifications.  When
given a two-digit year, mutt will interpret values less than 70 as
lying in the 21st century (i.e., \(lq38\(rq means 2038 and not 1938,
and \(lq00\(rq is interpreted as 2000), and values
greater than or equal to 70 as lying in the 20th century.
.PP
Note that this behaviour \fIis\fP Y2K compliant, but that mutt
\fIdoes\fP have a Y2.07K problem.
.PP
If a date range consists of a single date, the operator in question
will match that precise date.  If the date range consists of a dash
(\(lq\fB-\fP\(rq), followed by a date, this range will match any
date before and up to the date given.  Similarly, a date followed by
a dash matches the date given and any later point of time.  Two
dates, separated by a dash, match any date which lies in the given
range of time.
.PP
You can also modify any absolute date by giving an error range.  An
error range consists of one of the characters
.BR + ,
.BR - ,
.BR * ,
followed by a positive number, followed by one of the unit
characters
.BR y ,
.BR m ,
.BR w ", or"
.BR d ,
specifying a unit of years, months, weeks, or days.  
.B +
increases the maximum date matched by the given interval of time,
.B - 
decreases the minimum date matched by the given interval of time, and
.B *
increases the maximum date and decreases the minimum date matched by
the given interval of time.  It is possible to give multiple error
margins, which cumulate.  Example:
.B "1/1/2001-1w+2w*3d"
.PP
You can also specify offsets relative to the current date.  An
offset is specified as one of the characters
.BR < ,
.BR > ,
.BR = ,
followed by a positive number, followed by one of the unit
characters
.BR y ,
.BR m ,
.BR w ", or"
.BR d .
.B >
matches dates which are older than the specified amount of time, an
offset which begins with the character
.B < 
matches dates which are more recent than the specified amount of time,
and an offset which begins with the character
.B =
matches points of time which are precisely the given amount of time
ago.
.SH CONFIGURATION VARIABLES

.TP
.B abort_nosubject
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
If set to \fIyes\fP, when composing messages and no subject is given
at the subject prompt, composition will be aborted.  If set to
\fIno\fP, composing messages with no subject given at the subject
prompt will never be aborted.


.TP
.B abort_unmodified
.nf
Type: quadoption
Default: yes
.fi
.IP
If set to \fIyes\fP, composition will automatically abort after
editing the message body if no changes are made to the file (this
check only happens after the \fIfirst\fP edit of the file).  When set
to \fIno\fP, composition will never be aborted.


.TP
.B alias_file
.nf
Type: path
Default: \(lq~/.muttrc\(rq
.fi
.IP
The default file in which to save aliases created by the 
\(lqcreate-alias\(rq function.
.IP
\fBNote:\fP Mutt will not automatically source this file; you must
explicitly use the \(lqsource\(rq command for it to be executed.


.TP
.B alias_format
.nf
Type: string
Default: \(lq%4n %2f %t %-10a   %r\(rq
.fi
.IP
Specifies the format of the data displayed for the `alias' menu.  The
following printf(3)-style sequences are available:
.IP

.RS
.IP %a 
alias name

.IP %f 
flags - currently, a \(rqd\(rq for an alias marked for deletion

.IP %n 
index number

.IP %r 
address which alias expands to

.IP %t 
character which indicates if the alias is tagged for inclusion

.RE

.TP
.B allow_8bit
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether 8-bit data is converted to 7-bit using either Quoted-
Printable or Base64 encoding when sending mail.


.TP
.B allow_ansi
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether ANSI color codes in messages (and color tags in 
rich text messages) are to be interpreted.
Messages containing these codes are rare, but if this option is set,
their text will be colored accordingly. Note that this may override
your color choices, and even present a security problem, since a
message could include a line like \(rq[-- PGP output follows ...\(rq and
give it the same color as your attachment color.


.TP
.B alternates
.nf
Type: regular expression
Default: \(lq\(rq
.fi
.IP
A regexp that allows you to specify \fIalternate\fP addresses where
you receive mail.  This affects Mutt's idea about messages from you
and addressed to you.


.TP
.B arrow_cursor
.nf
Type: boolean
Default: no
.fi
.IP
When set, an arrow (\(lq->\(rq) will be used to indicate the current entry
in menus instead of highlighting the whole line.  On slow network or modem
links this will make response faster because there is less that has to
be redrawn on the screen when moving to the next or previous entries
in the menu.


.TP
.B ascii_chars
.nf
Type: boolean
Default: no
.fi
.IP
If set, Mutt will use plain ASCII characters when displaying thread
and attachment trees, instead of the default \fIACS\fP characters.


.TP
.B askbcc
.nf
Type: boolean
Default: no
.fi
.IP
If set, Mutt will prompt you for blind-carbon-copy (Bcc) recipients
before editing an outgoing message.


.TP
.B askcc
.nf
Type: boolean
Default: no
.fi
.IP
If set, Mutt will prompt you for carbon-copy (Cc) recipients before
editing the body of an outgoing message.


.TP
.B attach_format
.nf
Type: string
Default: \(lq%u%D%I %t%4n %T%.40d%> [%.7m/%.10M, %.6e%?C?, %C?, %s] \(rq
.fi
.IP
This variable describes the format of the `attachment' menu.  The
following printf-style sequences are understood:
.IP

.RS
.IP %C  
charset

.IP %c  
reqiures charset conversion (n or c)

.IP %D  
deleted flag

.IP %d  
description

.IP %e  
MIME content-transfer-encoding

.IP %f  
filename

.IP %I  
disposition (I=inline, A=attachment)

.IP %m  
major MIME type

.IP %M  
MIME subtype

.IP %n  
attachment number

.IP %s  
size

.IP %t  
tagged flag

.IP %T  
graphic tree characters

.IP %u  
unlink (=to delete) flag

.IP %>X 
right justify the rest of the string and pad with character \(rqX\(rq

.IP %|X 
pad to the end of the line with character \(rqX\(rq

.RE

.TP
.B attach_sep
.nf
Type: string
Default: \(lq\\n\(rq
.fi
.IP
The separator to add between attachments when operating (saving,
printing, piping, etc) on a list of tagged attachments.


.TP
.B attach_split
.nf
Type: boolean
Default: yes
.fi
.IP
If this variable is unset, when operating (saving, printing, piping,
etc) on a list of tagged attachments, Mutt will concatenate the
attachments and will operate on them as a single attachment. The
\(lq$attach_sep\(rq separator is added after each attachment. When set,
Mutt will operate on the attachments one by one.


.TP
.B attribution
.nf
Type: string
Default: \(lqOn %d, %n wrote:\(rq
.fi
.IP
This is the string that will precede a message which has been included
in a reply.  For a full listing of defined printf()-like sequences see
the section on \(lq$index_format\(rq.


.TP
.B autoedit
.nf
Type: boolean
Default: no
.fi
.IP
When set along with \(lq$edit_headers\(rq, Mutt will skip the initial
send-menu and allow you to immediately begin editing the body of your
message.  The send-menu may still be accessed once you have finished
editing the body of your message.
.IP
Also see \(lq$fast_reply\(rq.


.TP
.B auto_tag
.nf
Type: boolean
Default: no
.fi
.IP
When set, functions in the \fIindex\fP menu which affect a message
will be applied to all tagged messages (if there are any).  When
unset, you must first use the tag-prefix function (default: \(rq;\(rq) to
make the next function apply to all tagged messages.


.TP
.B beep
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is set, mutt will beep when an error occurs.


.TP
.B beep_new
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is set, mutt will beep whenever it prints a message
notifying you of new mail.  This is independent of the setting of the
\(lq$beep\(rq variable.


.TP
.B bounce
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether you will be asked to confirm bouncing messages.
If set to \fIyes\fP you don't get asked if you want to bounce a
message. Setting this variable to \fIno\fP is not generally useful,
and thus not recommended, because you are unable to bounce messages.


.TP
.B bounce_delivered
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is set, mutt will include Delivered-To headers when
bouncing messages.  Postfix users may wish to unset this variable.


.TP
.B charset
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Character set your terminal uses to display and enter textual data.


.TP
.B check_new
.nf
Type: boolean
Default: yes
.fi
.IP
\fBNote:\fP this option only affects \fImaildir\fP and \fIMH\fP style
mailboxes.
.IP
When \fIset\fP, Mutt will check for new mail delivered while the
mailbox is open.  Especially with MH mailboxes, this operation can
take quite some time since it involves scanning the directory and
checking each file to see if it has already been looked at.  If
\fIcheck_new\fP is \fIunset\fP, no check for new mail is performed
while the mailbox is open.


.TP
.B collapse_unread
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, Mutt will not collapse a thread if it contains any
unread messages.


.TP
.B uncollapse_jump
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will jump to the next unread message, if any,
when the current thread is \fIun\fPcollapsed.


.TP
.B compose_format
.nf
Type: string
Default: \(lq-- Mutt: Compose  [Approx. msg size: %l   Atts: %a]%>-\(rq
.fi
.IP
Controls the format of the status line displayed in the \\fCompose\fP
menu.  This string is similar to \(lq$status_format\(rq, but has its own
set of printf()-like sequences:
.IP

.RS
.IP %a 
total number of attachments 

.IP %h 
local hostname

.IP %l 
approximate size (in bytes) of the current message

.IP %v 
Mutt version string

.RE
.IP
See the text describing the \(lq$status_format\(rq option for more 
information on how to set \(lq$compose_format\(rq.


.TP
.B confirmappend
.nf
Type: boolean
Default: yes
.fi
.IP
When set, Mutt will prompt for confirmation when appending messages to
an existing mailbox.


.TP
.B confirmcreate
.nf
Type: boolean
Default: yes
.fi
.IP
When set, Mutt will prompt for confirmation when saving messages to a
mailbox which does not yet exist before creating it.


.TP
.B connect_timeout
.nf
Type: number
Default: 30
.fi
.IP
Causes Mutt to timeout a network connection (for IMAP or POP) after this
many seconds if the connection is not able to be established.  A negative
value causes Mutt to wait indefinitely for the connection to succeed.


.TP
.B content_type
.nf
Type: string
Default: \(lqtext/plain\(rq
.fi
.IP
Sets the default Content-Type for the body of newly composed messages.


.TP
.B copy
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether or not copies of your outgoing messages
will be saved for later references.  Also see \(lq$record\(rq,
\(lq$save_name\(rq, \(lq$force_name\(rq and \(lqfcc-hook\(rq.


.TP
.B crypt_autopgp
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether or not mutt may automatically enable
PGP encryption/signing for messages.  See also \(lq$crypt_autoencrypt\(rq,
\(lq$crypt_replyencrypt\(rq,
\(lq$crypt_autosign\(rq, \(lq$crypt_replysign\(rq and \(lq$smime_is_default\(rq.


.TP
.B crypt_autosmime
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether or not mutt may automatically enable
S/MIME encryption/signing for messages. See also \(lq$crypt_autoencrypt\(rq,
\(lq$crypt_replyencrypt\(rq,
\(lq$crypt_autosign\(rq, \(lq$crypt_replysign\(rq and \(lq$smime_is_default\(rq.


.TP
.B date_format
.nf
Type: string
Default: \(lq!%a, %b %d, %Y at %I:%M:%S%p %Z\(rq
.fi
.IP
This variable controls the format of the date printed by the \(lq%d\(rq
sequence in \(lq$index_format\(rq.  This is passed to the \fIstrftime\fP
call to process the date. See the man page for \fIstrftime(3)\fP for
the proper syntax.
.IP
Unless the first character in the string is a bang (\(lq!\(rq), the month
and week day names are expanded according to the locale specified in
the variable \(lq$locale\(rq. If the first character in the string is a
bang, the bang is discarded, and the month and week day names in the
rest of the string are expanded in the \fIC\fP locale (that is in US
English).


.TP
.B default_hook
.nf
Type: string
Default: \(lq~f %s !~P | (~P ~C %s)\(rq
.fi
.IP
This variable controls how send-hooks, message-hooks, save-hooks,
and fcc-hooks will
be interpreted if they are specified with only a simple regexp,
instead of a matching pattern.  The hooks are expanded when they are
declared, so a hook will be interpreted according to the value of this
variable at the time the hook is declared.  The default value matches
if the message is either from a user matching the regular expression
given, or if it is from you (if the from address matches
\(lq$alternates\(rq) and is to or cc'ed to a user matching the given
regular expression.


.TP
.B delete
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether or not messages are really deleted when closing or
synchronizing a mailbox.  If set to \fIyes\fP, messages marked for
deleting will automatically be purged without prompting.  If set to
\fIno\fP, messages marked for deletion will be kept in the mailbox.


.TP
.B delete_untag
.nf
Type: boolean
Default: yes
.fi
.IP
If this option is \fIset\fP, mutt will untag messages when marking them
for deletion.  This applies when you either explicitly delete a message,
or when you save it to another folder.


.TP
.B digest_collapse
.nf
Type: boolean
Default: yes
.fi
.IP
If this option is \fIset\fP, mutt's revattach menu will not show the subparts of
individual messages in a digest.  To see these subparts, press 'v' on that menu.


.TP
.B display_filter
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
When set, specifies a command used to filter messages.  When a message
is viewed it is passed as standard input to $display_filter, and the
filtered message is read from the standard output.


.TP
.B dotlock_program
.nf
Type: path
Default: \(lq/usr/local/bin/mutt_dotlock\(rq
.fi
.IP
Contains the path of the mutt_dotlock (8) binary to be used by
mutt.


.TP
.B dsn_notify
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
\fBNote:\fP you should not enable this unless you are using Sendmail
8.8.x or greater.
.IP
This variable sets the request for when notification is returned.  The
string consists of a comma separated list (no spaces!) of one or more
of the following: \fInever\fP, to never request notification,
\fIfailure\fP, to request notification on transmission failure,
\fIdelay\fP, to be notified of message delays, \fIsuccess\fP, to be
notified of successful transmission.
.IP
Example: set dsn_notify=\(rqfailure,delay\(rq


.TP
.B dsn_return
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
\fBNote:\fP you should not enable this unless you are using Sendmail
8.8.x or greater.
.IP
This variable controls how much of your message is returned in DSN
messages.  It may be set to either \fIhdrs\fP to return just the
message header, or \fIfull\fP to return the full message.
.IP
Example: set dsn_return=hdrs


.TP
.B duplicate_threads
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether mutt, when sorting by threads, threads
messages with the same message-id together.  If it is set, it will indicate
that it thinks they are duplicates of each other with an equals sign
in the thread diagram.


.TP
.B edit_headers
.nf
Type: boolean
Default: no
.fi
.IP
This option allows you to edit the header of your outgoing messages
along with the body of your message.


.TP
.B editor
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable specifies which editor is used by mutt.
It defaults to the value of the VISUAL, or EDITOR, environment
variable, or to the string \(rqvi\(rq if neither of those are set.


.TP
.B encode_from
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will quoted-printable encode messages when
they contain the string \(rqFrom \(rq in the beginning of a line.
Useful to avoid the tampering certain mail delivery and transport
agents tend to do with messages.


.TP
.B envelope_from
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will try to derive the message's \fIenvelope\fP
sender from the \(rqFrom:\(rq header.  Note that this information is passed 
to sendmail command using the \(rq-f\(rq command line switch, so don't set this
option if you are using that switch in $sendmail yourself,
or if the sendmail on your machine doesn't support that command
line switch.


.TP
.B escape
.nf
Type: string
Default: \(lq~\(rq
.fi
.IP
Escape character to use for functions in the builtin editor.


.TP
.B fast_reply
.nf
Type: boolean
Default: no
.fi
.IP
When set, the initial prompt for recipients and subject are skipped
when replying to messages, and the initial prompt for subject is
skipped when forwarding messages.
.IP
\fBNote:\fP this variable has no effect when the \(lq$autoedit\(rq
variable is set.


.TP
.B fcc_attach
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether or not attachments on outgoing messages
are saved along with the main body of your message.


.TP
.B fcc_clear
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is set, FCCs will be stored unencrypted and
unsigned, even when the actual message is encrypted and/or
signed.
(PGP only)


.TP
.B folder
.nf
Type: path
Default: \(lq~/Mail\(rq
.fi
.IP
Specifies the default location of your mailboxes.  A `+' or `=' at the
beginning of a pathname will be expanded to the value of this
variable.  Note that if you change this variable from the default
value you need to make sure that the assignment occurs \fIbefore\fP
you use `+' or `=' for any other variables since expansion takes place
during the `set' command.


.TP
.B folder_format
.nf
Type: string
Default: \(lq%2C %t %N %F %2l %-8.8u %-8.8g %8s %d %f\(rq
.fi
.IP
This variable allows you to customize the file browser display to your
personal taste.  This string is similar to \(lq$index_format\(rq, but has
its own set of printf()-like sequences:
.IP

.RS
.IP %C  
current file number

.IP %d  
date/time folder was last modified

.IP %f  
filename

.IP %F  
file permissions

.IP %g  
group name (or numeric gid, if missing)

.IP %l  
number of hard links

.IP %N  
N if folder has new mail, blank otherwise

.IP %s  
size in bytes

.IP %t  
* if the file is tagged, blank otherwise

.IP %u  
owner name (or numeric uid, if missing)

.IP %>X 
right justify the rest of the string and pad with character \(rqX\(rq

.IP %|X 
pad to the end of the line with character \(rqX\(rq

.RE

.TP
.B followup_to
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether or not the \fIMail-Followup-To\fP header field is
generated when sending mail.  When \fIset\fP, Mutt will generate this
field when you are replying to a known mailing list, specified with
the \(lqsubscribe\(rq or \(lqlists\(rq commands.
.IP
This field has two purposes.  First, preventing you from
receiving duplicate copies of replies to messages which you send
to mailing lists, and second, ensuring that you do get a reply
separately for any messages sent to known lists to which you are
not subscribed.  The header will contain only the list's address
for subscribed lists, and both the list address and your own
email address for unsubscribed lists.  Without this header, a
group reply to your message sent to a subscribed list will be
sent to both the list and your address, resulting in two copies
of the same email for you.


.TP
.B force_name
.nf
Type: boolean
Default: no
.fi
.IP
This variable is similar to \(lq$save_name\(rq, except that Mutt will
store a copy of your outgoing message by the username of the address
you are sending to even if that mailbox does not exist.
.IP
Also see the \(lq$record\(rq variable.


.TP
.B forward_decode
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the decoding of complex MIME messages into text/plain when
forwarding a message.  The message header is also RFC2047 decoded.
This variable is only used, if \(lq$mime_forward\(rq is \fIunset\fP,
otherwise \(lq$mime_forward_decode\(rq is used instead.


.TP
.B forward_edit
.nf
Type: quadoption
Default: yes
.fi
.IP
This quadoption controls whether or not the user is automatically
placed in the editor when forwarding messages.  For those who always want
to forward with no modification, use a setting of \(lqno\(rq.


.TP
.B forward_format
.nf
Type: string
Default: \(lq[%a: %s]\(rq
.fi
.IP
This variable controls the default subject when forwarding a message.
It uses the same format sequences as the \(lq$index_format\(rq variable.


.TP
.B forward_quote
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP forwarded messages included in the main body of the
message (when \(lq$mime_forward\(rq is \fIunset\fP) will be quoted using
\(lq$indent_string\(rq.


.TP
.B from
.nf
Type: e-mail address
Default: \(lq\(rq
.fi
.IP
When set, this variable contains a default from address.  It
can be overridden using my_hdr (including from send-hooks) and
\(lq$reverse_name\(rq.
.IP
Defaults to the contents of the environment variable EMAIL.


.TP
.B gecos_mask
.nf
Type: regular expression
Default: \(lq^[^,]*\(rq
.fi
.IP
A regular expression used by mutt to parse the GECOS field of a password
entry when expanding the alias.  By default the regular expression is set
to \(rq^[^,]*\(rq which will return the string up to the first \(rq,\(rq encountered.
If the GECOS field contains a string like \(rqlastname, firstname\(rq then you
should set the gecos_mask=\(rq.*\(rq.
.IP
This can be useful if you see the following behavior: you address a e-mail
to user ID stevef whose full name is Steve Franklin.  If mutt expands 
stevef to \(rqFranklin\(rq stevef@foo.bar then you should set the gecos_mask to
a regular expression that will match the whole name so mutt will expand
\(rqFranklin\(rq to \(rqFranklin, Steve\(rq.


.TP
.B hdrs
.nf
Type: boolean
Default: yes
.fi
.IP
When unset, the header fields normally added by the \(lqmy_hdr\(rq
command are not created.  This variable \fImust\fP be unset before
composing a new message or replying in order to take effect.  If set,
the user defined header fields are added to every new message.


.TP
.B header
.nf
Type: boolean
Default: no
.fi
.IP
When set, this variable causes Mutt to include the header
of the message you are replying to into the edit buffer.
The \(lq$weed\(rq setting applies.


.TP
.B help
.nf
Type: boolean
Default: yes
.fi
.IP
When set, help lines describing the bindings for the major functions
provided by each menu are displayed on the first line of the screen.
.IP
\fBNote:\fP The binding will not be displayed correctly if the
function is bound to a sequence rather than a single keystroke.  Also,
the help line may not be updated if a binding is changed while Mutt is
running.  Since this variable is primarily aimed at new users, neither
of these should present a major problem.


.TP
.B hidden_host
.nf
Type: boolean
Default: no
.fi
.IP
When set, mutt will skip the host name part of \(lq$hostname\(rq variable
when adding the domain part to addresses.  This variable does not
affect the generation of Message-IDs, and it will not lead to the 
cut-off of first-level domains.


.TP
.B hide_limited
.nf
Type: boolean
Default: no
.fi
.IP
When set, mutt will not show the presence of missing messages in the
thread tree.


.TP
.B hide_missing
.nf
Type: boolean
Default: yes
.fi
.IP
When set, mutt will not show the presence of messages that are hidden
by limiting, in the thread tree.


.TP
.B hide_top_limited
.nf
Type: boolean
Default: no
.fi
.IP
When set, mutt will not show the presence of missing messages at the
top of threads in the thread tree.  Note that when $hide_limited is
set, this option will have no effect.


.TP
.B hide_top_missing
.nf
Type: boolean
Default: yes
.fi
.IP
When set, mutt will not show the presence of messages that are hidden
by limiting, at the top of threads in the thread tree.Note that when
$hide_missing is set, this option will have no effect.


.TP
.B history
.nf
Type: number
Default: 10
.fi
.IP
This variable controls the size (in number of strings remembered) of
the string history buffer. The buffer is cleared each time the
variable is set.


.TP
.B honor_followup_to
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether or not a Mail-Followup-To header is
honored when group-replying to a message.


.TP
.B hostname
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the hostname to use after the \(lq@\(rq in local e-mail
addresses.  This overrides the compile time definition obtained from
/etc/resolv.conf.


.TP
.B ignore_list_reply_to
.nf
Type: boolean
Default: no
.fi
.IP
Affects the behaviour of the \fIreply\fP function when replying to
messages from mailing lists.  When set, if the \(lqReply-To:\(rq field is
set to the same value as the \(lqTo:\(rq field, Mutt assumes that the
\(lqReply-To:\(rq field was set by the mailing list to automate responses
to the list, and will ignore this field.  To direct a response to the
mailing list when this option is set, use the \fIlist-reply\fP
function; \fIgroup-reply\fP will reply to both the sender and the
list.


.TP
.B imap_authenticators
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a colon-delimited list of authentication methods mutt may
attempt to use to log in to an IMAP server, in the order mutt should
try them.  Authentication methods are either 'login' or the right
side of an IMAP 'AUTH=xxx' capability string, eg 'digest-md5',
'gssapi' or 'cram-md5'. This parameter is case-insensitive. If this
parameter is unset (the default) mutt will try all available methods,
in order from most-secure to least-secure.
.IP
Example: set imap_authenticators=\(rqgssapi:cram-md5:login\(rq
.IP
\fBNote:\fP Mutt will only fall back to other authentication methods if
the previous methods are unavailable. If a method is available but
authentication fails, mutt will not connect to the IMAP server.


.TP
.B imap_delim_chars
.nf
Type: string
Default: \(lq/.\(rq
.fi
.IP
This contains the list of characters which you would like to treat
as folder separators for displaying IMAP paths. In particular it
helps in using the '=' shortcut for your \fIfolder\fP variable.


.TP
.B imap_force_ssl
.nf
Type: boolean
Default: no
.fi
.IP
If this variable is set, Mutt will always use SSL when
connecting to IMAP servers.


.TP
.B imap_home_namespace
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
You normally want to see your personal folders alongside
your INBOX in the IMAP browser. If you see something else, you may set
this variable to the IMAP path to your folders.


.TP
.B imap_keepalive
.nf
Type: number
Default: 900
.fi
.IP
This variable specifies the maximum amount of time in seconds that mutt
will wait before polling open IMAP connections, to prevent the server
from closing them before mutt has finished with them. The default is
well within the RFC-specified minimum amount of time (30 minutes) before
a server is allowed to do this, but in practice the RFC does get
violated every now and then. Reduce this number if you find yourself
getting disconnected from your IMAP server due to inactivity.


.TP
.B imap_list_subscribed
.nf
Type: boolean
Default: no
.fi
.IP
This variable configures whether IMAP folder browsing will look for
only subscribed folders or all folders.  This can be toggled in the
IMAP browser with the \fItoggle-subscribed\fP function.


.TP
.B imap_pass
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the password for your IMAP account.  If unset, Mutt will
prompt you for your password when you invoke the fetch-mail function.
\fBWarning\fP: you should only use this option when you are on a
fairly secure machine, because the superuser can read your muttrc even
if you are the only one who can read the file.


.TP
.B imap_passive
.nf
Type: boolean
Default: yes
.fi
.IP
When set, mutt will not open new IMAP connections to check for new
mail.  Mutt will only check for new mail over existing IMAP
connections.  This is useful if you don't want to be prompted to
user/password pairs on mutt invocation, or if opening the connection
is slow.


.TP
.B imap_peek
.nf
Type: boolean
Default: yes
.fi
.IP
If set, mutt will avoid implicitly marking your mail as read whenever
you fetch a message from the server. This is generally a good thing,
but can make closing an IMAP folder somewhat slower. This option
exists to appease speed freaks.


.TP
.B imap_servernoise
.nf
Type: boolean
Default: yes
.fi
.IP
When set, mutt will display warning messages from the IMAP
server as error messages. Since these messages are often
harmless, or generated due to configuration problems on the
server which are out of the users' hands, you may wish to suppress
them at some point.


.TP
.B imap_user
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Your login name on the IMAP server.
.IP
This variable defaults to your user name on the local machine.


.TP
.B implicit_autoview
.nf
Type: boolean
Default: no
.fi
.IP
If set to \(lqyes\(rq, mutt will look for a mailcap entry with the
copiousoutput flag set for \fIevery\fP MIME attachment it doesn't have
an internal viewer defined for.  If such an entry is found, mutt will
use the viewer defined in that entry to convert the body part to text
form.


.TP
.B include
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether or not a copy of the message(s) you are replying to
is included in your reply.


.TP
.B indent_string
.nf
Type: string
Default: \(lq> \(rq
.fi
.IP
Specifies the string to prepend to each line of text quoted in a
message to which you are replying.  You are strongly encouraged not to
change this value, as it tends to agitate the more fanatical netizens.


.TP
.B index_format
.nf
Type: string
Default: \(lq%4C %Z %{%b %d} %-15.15L (%?l?%4l&%4c?) %s\(rq
.fi
.IP
This variable allows you to customize the message index display to
your personal taste.
.IP
\(lqFormat strings\(rq are similar to the strings used in the \(lqC\(rq
function printf to format output (see the man page for more detail).
The following sequences are defined in Mutt:
.IP

.RS
.IP %a 
address of the author

.IP %A 
reply-to address (if present; otherwise: address of author)

.IP %b 
filename of the original message folder (think mailBox)

.IP %B 
the list to which the letter was sent, or else the folder name (%b).

.IP %c 
number of characters (bytes) in the message

.IP %C 
current message number

.IP %d 
date and time of the message in the format specified by
\(lqdate_format\(rq converted to sender's time zone

.IP %D 
date and time of the message in the format specified by
\(lqdate_format\(rq converted to the local time zone

.IP %e 
current message number in thread

.IP %E 
number of messages in current thread

.IP %f 
entire From: line (address + real name)

.IP %F 
author name, or recipient name if the message is from you

.IP %i 
message-id of the current message

.IP %l 
number of lines in the message (does not work with maildir,
mh, and possibly IMAP folders)

.IP %L 
If an address in the To or CC header field matches an address
defined by the users \(lqsubscribe\(rq command, this displays
\(rqTo <list-name>\(rq, otherwise the same as %F.

.IP %m 
total number of message in the mailbox

.IP %M 
number of hidden messages if the thread is collapsed.

.IP %N 
message score

.IP %n 
author's real name (or address if missing)

.IP %O 
(_O_riginal save folder)  Where mutt would formerly have
stashed the message: list name or recipient name if no list

.IP %s 
subject of the message

.IP %S 
status of the message (N/D/d/!/r/*)

.IP %t 
`to:' field (recipients)

.IP %T 
the appropriate character from the $to_chars string

.IP %u 
user (login) name of the author

.IP %v 
first name of the author, or the recipient if the message is from you

.IP %y 
`x-label:' field, if present

.IP %Y 
`x-label' field, if present, and (1) not at part of a thread tree,
(2) at the top of a thread, or (3) `x-label' is different from
preceding message's `x-label'.

.IP %Z 
message status flags

.IP %{fmt} 
the date and time of the message is converted to sender's
time zone, and \(lqfmt\(rq is expanded by the library function
\(lqstrftime\(rq; a leading bang disables locales

.IP %[fmt] 
the date and time of the message is converted to the local
time zone, and \(lqfmt\(rq is expanded by the library function
\(lqstrftime\(rq; a leading bang disables locales

.IP %(fmt) 
the local date and time when the message was received.
\(lqfmt\(rq is expanded by the library function \(lqstrftime\(rq;
a leading bang disables locales

.IP %<fmt> 
the current local time. \(lqfmt\(rq is expanded by the library
function \(lqstrftime\(rq; a leading bang disables locales.

.IP %>X    
right justify the rest of the string and pad with character \(rqX\(rq

.IP %|X    
pad to the end of the line with character \(rqX\(rq

.RE
.IP
See also: \(lq$to_chars\(rq.


.TP
.B ispell
.nf
Type: path
Default: \(lq/usr/bin/ispell\(rq
.fi
.IP
How to invoke ispell (GNU's spell-checking software).


.TP
.B keep_flagged
.nf
Type: boolean
Default: no
.fi
.IP
If set, read messages marked as flagged will not be moved
from your spool mailbox to your \(lq$mbox\(rq mailbox, or as a result of
a \(lqmbox-hook\(rq command.


.TP
.B locale
.nf
Type: string
Default: \(lqC\(rq
.fi
.IP
The locale used by \fIstrftime(3)\fP to format dates. Legal values are
the strings your system accepts for the locale variable \fILC_TIME\fP.


.TP
.B mail_check
.nf
Type: number
Default: 5
.fi
.IP
This variable configures how often (in seconds) mutt should look for
new mail.


.TP
.B mailcap_path
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable specifies which files to consult when attempting to
display MIME bodies not directly supported by Mutt.


.TP
.B mailcap_sanitize
.nf
Type: boolean
Default: yes
.fi
.IP
If set, mutt will restrict possible characters in mailcap % expandos
to a well-defined set of safe characters.  This is the safe setting,
but we are not sure it doesn't break some more advanced MIME stuff.
.IP
\fBDON'T CHANGE THIS SETTING UNLESS YOU ARE REALLY SURE WHAT YOU ARE
DOING!\fP


.TP
.B maildir_trash
.nf
Type: boolean
Default: no
.fi
.IP
If set, messages marked as deleted will be saved with the maildir
(T)rashed flag instead of unlinked.  \fBNOTE:\fP this only applies
to maildir-style mailboxes.  Setting it will have no effect on other
mailbox types.


.TP
.B mark_old
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether or not mutt marks \fInew\fP \fBunread\fP
messages as \fIold\fP if you exit a mailbox without reading them.
With this option set, the next time you start mutt, the messages
will show up with an \(rqO\(rq next to them in the index menu,
indicating that they are old.


.TP
.B markers
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the display of wrapped lines in the internal pager. If set, a
\(lq+\(rq marker is displayed at the beginning of wrapped lines. Also see
the \(lq$smart_wrap\(rq variable.


.TP
.B mask
.nf
Type: regular expression
Default: \(lq!^\\.[^.]\(rq
.fi
.IP
A regular expression used in the file browser, optionally preceded by
the \fInot\fP operator \(lq!\(rq.  Only files whose names match this mask
will be shown. The match is always case-sensitive.


.TP
.B mbox
.nf
Type: path
Default: \(lq~/mbox\(rq
.fi
.IP
This specifies the folder into which read mail in your \(lq$spoolfile\(rq
folder will be appended.


.TP
.B mbox_type
.nf
Type: folder magic
Default: mbox
.fi
.IP
The default mailbox type used when creating new folders. May be any of
mbox, MMDF, MH and Maildir.


.TP
.B metoo
.nf
Type: boolean
Default: no
.fi
.IP
If unset, Mutt will remove your address (see the \(lq$alternates\(rq
variable) from the list of recipients when replying to a message.


.TP
.B menu_scroll
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, menus will be scrolled up or down one line when you
attempt to move across a screen boundary.  If \fIunset\fP, the screen
is cleared and the next or previous page of the menu is displayed
(useful for slow links to avoid many redraws).


.TP
.B meta_key
.nf
Type: boolean
Default: no
.fi
.IP
If set, forces Mutt to interpret keystrokes with the high bit (bit 8)
set as if the user had pressed the ESC key and whatever key remains
after having the high bit removed.  For example, if the key pressed
has an ASCII value of 0xf4, then this is treated as if the user had
pressed ESC then \(lqx\(rq.  This is because the result of removing the
high bit from \(lq0xf4\(rq is \(lq0x74\(rq, which is the ASCII character
\(lqx\(rq.


.TP
.B mh_purge
.nf
Type: boolean
Default: no
.fi
.IP
When unset, mutt will mimic mh's behaviour and rename deleted messages
to \fI,<old file name>\fP in mh folders instead of really deleting
them.  If the variable is set, the message files will simply be
deleted.


.TP
.B mh_seq_flagged
.nf
Type: string
Default: \(lqflagged\(rq
.fi
.IP
The name of the MH sequence used for flagged messages.


.TP
.B mh_seq_replied
.nf
Type: string
Default: \(lqreplied\(rq
.fi
.IP
The name of the MH sequence used to tag replied messages.


.TP
.B mh_seq_unseen
.nf
Type: string
Default: \(lqunseen\(rq
.fi
.IP
The name of the MH sequence used for unseen messages.


.TP
.B mime_forward
.nf
Type: quadoption
Default: no
.fi
.IP
When set, the message you are forwarding will be attached as a
separate MIME part instead of included in the main body of the
message.  This is useful for forwarding MIME messages so the receiver
can properly view the message as it was delivered to you. If you like
to switch between MIME and not MIME from mail to mail, set this
variable to ask-no or ask-yes.
.IP
Also see \(lq$forward_decode\(rq and \(lq$mime_forward_decode\(rq.


.TP
.B mime_forward_decode
.nf
Type: boolean
Default: no
.fi
.IP
Controls the decoding of complex MIME messages into text/plain when
forwarding a message while \(lq$mime_forward\(rq is \fIset\fP. Otherwise
\(lq$forward_decode\(rq is used instead.


.TP
.B mime_forward_rest
.nf
Type: quadoption
Default: yes
.fi
.IP
When forwarding multiple attachments of a MIME message from the recvattach
menu, attachments which cannot be decoded in a reasonable manner will
be attached to the newly composed message if this option is set.


.TP
.B mix_entry_format
.nf
Type: string
Default: \(lq%4n %c %-16s %a\(rq
.fi
.IP
This variable describes the format of a remailer line on the mixmaster
chain selection screen.  The following printf-like sequences are 
supported:
.IP

.RS
.IP %n 
The running number on the menu.

.IP %c 
Remailer capabilities.

.IP %s 
The remailer's short name.

.IP %a 
The remailer's e-mail address.

.RE

.TP
.B mixmaster
.nf
Type: path
Default: \(lqmixmaster\(rq
.fi
.IP
This variable contains the path to the Mixmaster binary on your
system.  It is used with various sets of parameters to gather the
list of known remailers, and to finally send a message through the
mixmaster chain.


.TP
.B move
.nf
Type: quadoption
Default: ask-no
.fi
.IP
Controls whether you will be asked to confirm moving read messages
from your spool mailbox to your \(lq$mbox\(rq mailbox, or as a result of
a \(lqmbox-hook\(rq command.


.TP
.B message_format
.nf
Type: string
Default: \(lq%s\(rq
.fi
.IP
This is the string displayed in the \(lqattachment\(rq menu for
attachments of type message/rfc822.  For a full listing of defined
printf()-like sequences see the section on \(lq$index_format\(rq.


.TP
.B narrow_tree
.nf
Type: boolean
Default: no
.fi
.IP
This variable, when set, makes the thread tree narrower, allowing
deeper threads to fit on the screen.


.TP
.B pager
.nf
Type: path
Default: \(lqbuiltin\(rq
.fi
.IP
This variable specifies which pager you would like to use to view
messages.  builtin means to use the builtin pager, otherwise this
variable should specify the pathname of the external pager you would
like to use.
.IP
Using an external pager may have some disadvantages: Additional
keystrokes are necessary because you can't call mutt functions
directly from the pager, and screen resizes cause lines longer than
the screen width to be badly formatted in the help menu.


.TP
.B pager_context
.nf
Type: number
Default: 0
.fi
.IP
This variable controls the number of lines of context that are given
when displaying the next or previous page in the internal pager.  By
default, Mutt will display the line after the last one on the screen
at the top of the next page (0 lines of context).


.TP
.B pager_format
.nf
Type: string
Default: \(lq-%Z- %C/%m: %-20.20n   %s\(rq
.fi
.IP
This variable controls the format of the one-line message \(lqstatus\(rq
displayed before each message in either the internal or an external
pager.  The valid sequences are listed in the \(lq$index_format\(rq
section.


.TP
.B pager_index_lines
.nf
Type: number
Default: 0
.fi
.IP
Determines the number of lines of a mini-index which is shown when in
the pager.  The current message, unless near the top or bottom of the
folder, will be roughly one third of the way down this mini-index,
giving the reader the context of a few messages before and after the
message.  This is useful, for example, to determine how many messages
remain to be read in the current thread.  One of the lines is reserved
for the status bar from the index, so a \fIpager_index_lines\fP of 6
will only show 5 lines of the actual index.  A value of 0 results in
no index being shown.  If the number of messages in the current folder
is less than \fIpager_index_lines\fP, then the index will only use as
many lines as it needs.


.TP
.B pager_stop
.nf
Type: boolean
Default: no
.fi
.IP
When set, the internal-pager will \fBnot\fP move to the next message
when you are at the end of a message and invoke the \fInext-page\fP
function.


.TP
.B crypt_autosign
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to always attempt to
cryptographically sign outgoing messages.  This can be overridden
by use of the \fIpgp-menu\fP, when signing is not required or
encryption is requested as well. If \(lq$smime_is_default\(rq is set,
then OpenSSL is used instead to create S/MIME messages and settings can
be overridden by use of the \fIsmime-menu\fP.
(Crypto only)


.TP
.B crypt_autoencrypt
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to always attempt to PGP
encrypt outgoing messages.  This is probably only useful in
connection to the \fIsend-hook\fP command.  It can be overridden
by use of the \fIpgp-menu\fP, when encryption is not required or
signing is requested as well.  IF \(lq$smime_is_default\(rq is set,
then OpenSSL is used instead to create S/MIME messages and
settings can be overridden by use of the \fIsmime-menu\fP.
(Crypto only)


.TP
.B pgp_ignore_subkeys
.nf
Type: boolean
Default: yes
.fi
.IP
Setting this variable will cause Mutt to ignore OpenPGP subkeys. Instead,
the principal key will inherit the subkeys' capabilities.  Unset this
if you want to play interesting key selection games.
(PGP only)


.TP
.B crypt_replyencrypt
.nf
Type: boolean
Default: yes
.fi
.IP
If set, automatically PGP or OpenSSL encrypt replies to messages which are
encrypted.
(Crypto only)


.TP
.B crypt_replysign
.nf
Type: boolean
Default: no
.fi
.IP
If set, automatically PGP or OpenSSL sign replies to messages which are
signed.
.IP
\fBNote:\fP this does not work on messages that are encrypted
\fBand\fP signed!
(Crypto only)


.TP
.B crypt_replysignencrypted
.nf
Type: boolean
Default: no
.fi
.IP
If set, automatically PGP or OpenSSL sign replies to messages
which are encrypted. This makes sense in combination with
\(lq$crypt_replyencrypt\(rq, because it allows you to sign all
messages which are automatically encrypted.  This works around
the problem noted in \(lq$crypt_replysign\(rq, that mutt is not able
to find out whether an encrypted message is also signed.
(Crypto only)


.TP
.B crypt_timestamp
.nf
Type: boolean
Default: yes
.fi
.IP
If set, mutt will include a time stamp in the lines surrounding
PGP or S/MIME output, so spoofing such lines is more difficult.
If you are using colors to mark these lines, and rely on these,
you may unset this setting.
(Crypto only)


.TP
.B pgp_use_gpg_agent
.nf
Type: boolean
Default: no
.fi
.IP
If set, mutt will use a possibly-running gpg-agent process.
(PGP only)


.TP
.B crypt_verify_sig
.nf
Type: quadoption
Default: yes
.fi
.IP
If \(lqyes\(rq, always attempt to verify PGP or S/MIME signatures.
If \(lqask\(rq, ask whether or not to verify the signature. 
If \(lqno\(rq, never attempt to verify cryptographic signatures.
(Crypto only)


.TP
.B smime_is_default
.nf
Type: boolean
Default: no
.fi
.IP
The default behaviour of mutt is to use PGP on all auto-sign/encryption
operations. To override and to use OpenSSL instead this must be set.
However, this has no effect while replying, since mutt will automatically 
select the same application that was used to sign/encrypt the original
message.  (Note that this variable can be overridden by unsetting $crypt_autosmime.)
(S/MIME only)


.TP
.B smime_ask_cert_label
.nf
Type: boolean
Default: yes
.fi
.IP
This flag controls whether you want to be asked to enter a label
for a certificate about to be added to the database or not. It is
set by default.
(S/MIME only)


.TP
.B smime_decrypt_use_default_key
.nf
Type: boolean
Default: yes
.fi
.IP
If set (default) this tells mutt to use the default key for decryption. Otherwise,
if manage multiple certificate-key-pairs, mutt will try to use the mailbox-address
to determine the key to use. It will ask you to supply a key, if it can't find one.
(S/MIME only)


.TP
.B pgp_entry_format
.nf
Type: string
Default: \(lq%4n %t%f %4l/0x%k %-4a %2c %u\(rq
.fi
.IP
This variable allows you to customize the PGP key selection menu to
your personal taste. This string is similar to \(lq$index_format\(rq, but
has its own set of printf()-like sequences:
.IP

.RS
.IP %n     
number

.IP %k     
key id

.IP %u     
user id

.IP %a     
algorithm

.IP %l     
key length

.IP %f     
flags

.IP %c     
capabilities

.IP %t     
trust/validity of the key-uid association

.IP %[<s>] 
date of the key where <s> is an strftime(3) expression

.RE
.IP
(PGP only)


.TP
.B pgp_good_sign
.nf
Type: regular expression
Default: \(lq\(rq
.fi
.IP
If you assign a text to this variable, then a PGP signature is only
considered verified if the output from $pgp_verify_command contains
the text. Use this variable if the exit code from the command is 0
even for bad signatures.
(PGP only)


.TP
.B pgp_check_exit
.nf
Type: boolean
Default: yes
.fi
.IP
If set, mutt will check the exit code of the PGP subprocess when
signing or encrypting.  A non-zero exit code means that the
subprocess failed.
(PGP only)


.TP
.B pgp_long_ids
.nf
Type: boolean
Default: no
.fi
.IP
If set, use 64 bit PGP key IDs. Unset uses the normal 32 bit Key IDs.
(PGP only)


.TP
.B pgp_retainable_sigs
.nf
Type: boolean
Default: no
.fi
.IP
If set, signed and encrypted messages will consist of nested
multipart/signed and multipart/encrypted body parts.
.IP
This is useful for applications like encrypted and signed mailing
lists, where the outer layer (multipart/encrypted) can be easily
removed, while the inner multipart/signed part is retained.
(PGP only)


.TP
.B pgp_show_unusable
.nf
Type: boolean
Default: yes
.fi
.IP
If set, mutt will display non-usable keys on the PGP key selection
menu.  This includes keys which have been revoked, have expired, or
have been marked as \(lqdisabled\(rq by the user.
(PGP only)


.TP
.B pgp_sign_as
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
If you have more than one key pair, this option allows you to specify
which of your private keys to use.  It is recommended that you use the
keyid form to specify your key (e.g., \(lq0x00112233\(rq).
(PGP only)


.TP
.B pgp_strict_enc
.nf
Type: boolean
Default: yes
.fi
.IP
If set, Mutt will automatically encode PGP/MIME signed messages as
\fIquoted-printable\fP.  Please note that unsetting this variable may
lead to problems with non-verifyable PGP signatures, so only change
this if you know what you are doing.
(PGP only)


.TP
.B pgp_timeout
.nf
Type: number
Default: 300
.fi
.IP
The number of seconds after which a cached passphrase will expire if
not used.
(PGP only)


.TP
.B pgp_sort_keys
.nf
Type: sort order
Default: address
.fi
.IP
Specifies how the entries in the `pgp keys' menu are sorted. The
following are legal values:
.IP

.RS
.IP address 
sort alphabetically by user id

.IP keyid   
sort alphabetically by key id

.IP date    
sort by key creation date

.IP trust   
sort by the trust of the key

.RE
.IP
If you prefer reverse order of the above values, prefix it with
`reverse-'.
(PGP only)


.TP
.B pgp_create_traditional
.nf
Type: quadoption
Default: no
.fi
.IP
This option controls whether Mutt generates old-style inline PGP
encrypted or signed messages.
.IP
Note that PGP/MIME will be used automatically for messages which have
a character set different from us-ascii, or which consist of more than
a single MIME part.
.IP
Also note that using the old-style PGP message format is \fBstrongly\fP
\fBdeprecated\fP.
(PGP only)


.TP
.B pgp_auto_traditional
.nf
Type: boolean
Default: no
.fi
.IP
This option causes Mutt to generate an old-style inline PGP
encrypted or signed message when replying to an old-style
message, and a PGP/MIME message when replying to a PGP/MIME
message.  Note that this option is only meaningful when using
\(lq$crypt_replyencrypt\(rq, \(lq$crypt_replysign\(rq, or
\(lq$crypt_replysignencrypted\(rq.
.IP
Also note that PGP/MIME will be used automatically for messages
which have a character set different from us-ascii, or which
consist of more than a single MIME part.
.IP
This option overrides \(lq$pgp_create_traditional\(rq
(PGP only)


.TP
.B pgp_decode_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format strings specifies a command which is used to decode 
application/pgp attachments.
.IP
The PGP command formats have their own set of printf-like sequences:
.IP

.RS
.IP %p 
Expands to PGPPASSFD=0 when a pass phrase is needed, to an empty
string otherwise. Note: This may be used with a %? construct.

.IP %f 
Expands to the name of a file containing a message.

.IP %s 
Expands to the name of a file containing the signature part
           of a multipart/signed attachment when verifying it.

.IP %a 
The value of $pgp_sign_as.

.IP %r 
One or more key IDs.

.RE
.IP
For examples on how to configure these formats for the various versions
of PGP which are floating around, see the pgp*.rc and gpg.rc files in
the samples/ subdirectory which has been installed on your system
alongside the documentation.
(PGP only)


.TP
.B pgp_getkeys_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is invoked whenever mutt will need public key information.
%r is the only printf-like sequence used with this format.
(PGP only)


.TP
.B pgp_verify_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify PGP signatures.
(PGP only)


.TP
.B pgp_decrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to decrypt a PGP encrypted message.
(PGP only)


.TP
.B pgp_clearsign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format is used to create a old-style \(rqclearsigned\(rq PGP
message.  Note that the use of this format is \fBstrongly\fP
\fBdeprecated\fP.
(PGP only)


.TP
.B pgp_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to create the detached PGP signature for a 
multipart/signed PGP/MIME body part.
(PGP only)


.TP
.B pgp_encrypt_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to both sign and encrypt a body part.
(PGP only)


.TP
.B pgp_encrypt_only_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to encrypt a body part without signing it.
(PGP only)


.TP
.B pgp_import_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to import a key from a message into 
the user's public key ring.
(PGP only)


.TP
.B pgp_export_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to export a public key from the user's
key ring.
(PGP only)


.TP
.B pgp_verify_key_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify key information from the key selection
menu.
(PGP only)


.TP
.B pgp_list_secring_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to list the secret key ring's contents.  The
output format must be analogous to the one used by 
gpg --list-keys --with-colons.
.IP
This format is also generated by the pgpring utility which comes 
with mutt.
(PGP only)


.TP
.B pgp_list_pubring_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to list the public key ring's contents.  The
output format must be analogous to the one used by 
gpg --list-keys --with-colons.
.IP
This format is also generated by the pgpring utility which comes 
with mutt.
(PGP only)


.TP
.B forward_decrypt
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the handling of encrypted messages when forwarding a message.
When set, the outer layer of encryption is stripped off.  This
variable is only used if \(lq$mime_forward\(rq is \fIset\fP and
\(lq$mime_forward_decode\(rq is \fIunset\fP.
(PGP only)


.TP
.B smime_timeout
.nf
Type: number
Default: 300
.fi
.IP
The number of seconds after which a cached passphrase will expire if
not used.
(S/MIME only)


.TP
.B smime_encrypt_with
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This sets the algorithm that should be used for encryption.
Valid choices are \(rqdes\(rq, \(rqdes3\(rq, \(rqrc2-40\(rq, \(rqrc2-64\(rq, \(rqrc2-128\(rq.
If unset \(rq3des\(rq (TripleDES) is used.
(S/MIME only)


.TP
.B smime_keys
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Since there is no pubring/secring as with PGP, mutt has to handle
storage ad retrieval of keys/certs by itself. This is very basic right now,
and stores keys and certificates in two different directories, both
named as the hash-value retrieved from OpenSSL. There is an index file
which contains mailbox-address keyid pair, and which can be manually
edited. This one points to the location of the private keys.
(S/MIME only)


.TP
.B smime_ca_location
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable contains the name of either a directory, or a file which
contains trusted certificates for use with OpenSSL.
(S/MIME only)


.TP
.B smime_certificates
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Since there is no pubring/secring as with PGP, mutt has to handle
storage and retrieval of keys by itself. This is very basic right
now, and keys and certificates are stored in two different
directories, both named as the hash-value retrieved from
OpenSSL. There is an index file which contains mailbox-address
keyid pairs, and which can be manually edited. This one points to
the location of the certificates.
(S/MIME only)


.TP
.B smime_decrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format string specifies a command which is used to decrypt
application/x-pkcs7-mime attachments.
.IP
The OpenSSL command formats have their own set of printf-like sequences
similar to PGP's:
.IP

.RS
.IP %f 
Expands to the name of a file containing a message.

.IP %s 
Expands to the name of a file containing the signature part
           of a multipart/signed attachment when verifying it.

.IP %k 
The key-pair specified with $smime_default_key

.IP %c 
One or more certificate IDs.

.IP %a 
The algorithm used for encryption.

.IP %C 
CA location:  Depending on whether $smime_ca_location
           points to a directory or file, this expands to 
           \(rq-CApath $smime_ca_location\(rq or \(rq-CAfile $smime_ca_location\(rq.

.RE
.IP
For examples on how to configure these formats, see the smime.rc in
the samples/ subdirectory which has been installed on your system
alongside the documentation.
(S/MIME only)


.TP
.B smime_verify_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify S/MIME signatures of type multipart/signed.
(S/MIME only)


.TP
.B smime_verify_opaque_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify S/MIME signatures of type
application/x-pkcs7-mime.
(S/MIME only)


.TP
.B smime_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to created S/MIME signatures of type
multipart/signed, which can be read by all mail clients.
(S/MIME only)


.TP
.B smime_sign_opaque_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to created S/MIME signatures of type
application/x-pkcs7-signature, which can only be handled by mail
clients supporting the S/MIME extension.
(S/MIME only)


.TP
.B smime_encrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to create encrypted S/MIME messages.
(S/MIME only)


.TP
.B smime_pk7out_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract PKCS7 structures of S/MIME signatures,
in order to extract the public X509 certificate(s).
(S/MIME only)


.TP
.B smime_get_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract X509 certificates from a PKCS7 structure.
(S/MIME only)


.TP
.B smime_get_signer_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract only the signers X509 certificate from a S/MIME
signature, so that the certificate's owner may get compared to the email's 
'From'-field.
(S/MIME only)


.TP
.B smime_import_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to import a certificate via smime_keys.
(S/MIME only)


.TP
.B smime_get_cert_email_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract the mail address(es) used for storing
X509 certificates, and for verification purposes (to check whether the
certificate was issued for the sender's mailbox).
(S/MIME only)


.TP
.B smime_default_key
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is the default key-pair to use for signing. This must be set to the
keyid (the hash-value that OpenSSL generates) to work properly
(S/MIME only)


.TP
.B ssl_starttls
.nf
Type: quadoption
Default: yes
.fi
.IP
If set (the default), mutt will attempt to use STARTTLS on servers
advertising the capability. When unset, mutt will not attempt to
use STARTTLS regardless of the server's capabilities.


.TP
.B certificate_file
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable specifies the file where the certificates you trust
are saved. When an unknown certificate is encountered, you are asked
if you accept it or not. If you accept it, the certificate can also 
be saved in this file and further connections are automatically 
accepted.
.IP
You can also manually add CA certificates in this file. Any server
certificate that is signed with one of these CA certificates are 
also automatically accepted.
.IP
Example: set certificate_file=~/.mutt/certificates


.TP
.B ssl_usesystemcerts
.nf
Type: boolean
Default: yes
.fi
.IP
If set to \fIyes\fP, mutt will use CA certificates in the
system-wide certificate store when checking if server certificate 
is signed by a trusted CA.


.TP
.B entropy_file
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
The file which includes random data that is used to initialize SSL
library functions.


.TP
.B ssl_use_sslv2
.nf
Type: boolean
Default: yes
.fi
.IP
This variables specifies whether to attempt to use SSLv2 in the
SSL authentication process.


.TP
.B ssl_use_sslv3
.nf
Type: boolean
Default: yes
.fi
.IP
This variables specifies whether to attempt to use SSLv3 in the
SSL authentication process.


.TP
.B ssl_use_tlsv1
.nf
Type: boolean
Default: yes
.fi
.IP
This variables specifies whether to attempt to use TLSv1 in the
SSL authentication process.


.TP
.B pipe_split
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the \fIpipe-message\fP command and the \(lqtag-
prefix\(rq operator.  If this variable is unset, when piping a list of
tagged messages Mutt will concatenate the messages and will pipe them
as a single folder.  When set, Mutt will pipe the messages one by one.
In both cases the messages are piped in the current sorted order,
and the \(lq$pipe_sep\(rq separator is added after each message.


.TP
.B pipe_decode
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the \fIpipe-message\fP command.  When unset,
Mutt will pipe the messages without any preprocessing. When set, Mutt
will weed headers and will attempt to PGP/MIME decode the messages
first.


.TP
.B pipe_sep
.nf
Type: string
Default: \(lq\\n\(rq
.fi
.IP
The separator to add between messages when piping a list of tagged
messages to an external Unix command.


.TP
.B pop_authenticators
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a colon-delimited list of authentication methods mutt may
attempt to use to log in to an POP server, in the order mutt should
try them.  Authentication methods are either 'user', 'apop' or any
SASL mechanism, eg 'digest-md5', 'gssapi' or 'cram-md5'.
This parameter is case-insensitive. If this parameter is unset
(the default) mutt will try all available methods, in order from
most-secure to least-secure.
.IP
Example: set pop_authenticators=\(rqdigest-md5:apop:user\(rq


.TP
.B pop_auth_try_all
.nf
Type: boolean
Default: yes
.fi
.IP
If set, Mutt will try all available methods. When unset, Mutt will
only fall back to other authentication methods if the previous
methods are unavailable. If a method is available but authentication
fails, Mutt will not connect to the POP server.


.TP
.B pop_checkinterval
.nf
Type: number
Default: 60
.fi
.IP
This variable configures how often (in seconds) POP should look for
new mail.


.TP
.B pop_delete
.nf
Type: quadoption
Default: ask-no
.fi
.IP
If set, Mutt will delete successfully downloaded messages from the POP
server when using the fetch-mail function.  When unset, Mutt will
download messages but also leave them on the POP server.


.TP
.B pop_host
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The name of your POP server for the fetch-mail function.  You
can also specify an alternative port, username and password, ie:
.IP
[pop[s]://][username[:password]@]popserver[:port]


.TP
.B pop_last
.nf
Type: boolean
Default: no
.fi
.IP
If this variable is set, mutt will try to use the \(rqLAST\(rq POP command
for retrieving only unread messages from the POP server when using
the fetch-mail function.


.TP
.B pop_reconnect
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether or not Mutt will try to reconnect to POP server when
connection lost.


.TP
.B pop_user
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Your login name on the POP server.
.IP
This variable defaults to your user name on the local machine.


.TP
.B pop_pass
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the password for your POP account.  If unset, Mutt will
prompt you for your password when you open POP mailbox.
\fBWarning\fP: you should only use this option when you are on a
fairly secure machine, because the superuser can read your muttrc
even if you are the only one who can read the file.


.TP
.B post_indent_string
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Similar to the \(lq$attribution\(rq variable, Mutt will append this
string after the inclusion of a message which is being replied to.


.TP
.B postpone
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether or not messages are saved in the \(lq$postponed\(rq
mailbox when you elect not to send immediately.


.TP
.B postponed
.nf
Type: path
Default: \(lq~/postponed\(rq
.fi
.IP
Mutt allows you to indefinitely \(lqpostpone sending a message\(rq which
you are editing.  When you choose to postpone a message, Mutt saves it
in the mailbox specified by this variable.  Also see the \(lq$postpone\(rq
variable.


.TP
.B preconnect
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
If set, a shell command to be executed if mutt fails to establish
a connection to the server. This is useful for setting up secure
connections, e.g. with ssh(1). If the command returns a  nonzero
status, mutt gives up opening the server. Example:
.IP
preconnect=\(rqssh -f -q -L 1234:mailhost.net:143 mailhost.net
sleep 20 < /dev/null > /dev/null\(rq
.IP
Mailbox 'foo' on mailhost.net can now be reached
as '{localhost:1234}foo'.
.IP
NOTE: For this example to work, you must be able to log in to the
remote machine without having to enter a password.


.TP
.B print
.nf
Type: quadoption
Default: ask-no
.fi
.IP
Controls whether or not Mutt asks for confirmation before printing.
This is useful for people (like me) who accidentally hit \(lqp\(rq often.


.TP
.B print_command
.nf
Type: path
Default: \(lqlpr\(rq
.fi
.IP
This specifies the command pipe that should be used to print messages.


.TP
.B print_decode
.nf
Type: boolean
Default: yes
.fi
.IP
Used in connection with the print-message command.  If this
option is set, the message is decoded before it is passed to the
external command specified by $print_command.  If this option
is unset, no processing will be applied to the message when
printing it.  The latter setting may be useful if you are using
some advanced printer filter which is able to properly format
e-mail messages for printing.


.TP
.B print_split
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the print-message command.  If this option
is set, the command specified by $print_command is executed once for
each message which is to be printed.  If this option is unset, 
the command specified by $print_command is executed only once, and
all the messages are concatenated, with a form feed as the message
separator.
.IP
Those who use the \fBenscript\fP(1) program's mail-printing mode will
most likely want to set this option.


.TP
.B prompt_after
.nf
Type: boolean
Default: yes
.fi
.IP
If you use an \fIexternal\fP \(lq$pager\(rq, setting this variable will
cause Mutt to prompt you for a command when the pager exits rather
than returning to the index menu.  If unset, Mutt will return to the
index menu when the external pager exits.


.TP
.B query_command
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This specifies the command that mutt will use to make external address
queries.  The string should contain a %s, which will be substituted
with the query string the user types.  See \(lqquery\(rq for more
information.


.TP
.B quit
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether \(lqquit\(rq and \(lqexit\(rq actually quit
from mutt.  If it set to yes, they do quit, if it is set to no, they
have no effect, and if it is set to ask-yes or ask-no, you are
prompted for confirmation when you try to quit.


.TP
.B quote_regexp
.nf
Type: regular expression
Default: \(lq^([ \\t]*[|>:}#])+\(rq
.fi
.IP
A regular expression used in the internal-pager to determine quoted
sections of text in the body of a message.
.IP
\fBNote:\fP In order to use the \fIquoted\fP\fBx\fP patterns in the
internal pager, you need to set this to a regular expression that
matches \fIexactly\fP the quote characters at the beginning of quoted
lines.


.TP
.B read_inc
.nf
Type: number
Default: 10
.fi
.IP
If set to a value greater than 0, Mutt will display which message it
is currently on when reading a mailbox.  The message is printed after
\fIread_inc\fP messages have been read (e.g., if set to 25, Mutt will
print a message when it reads message 25, and then again when it gets
to message 50).  This variable is meant to indicate progress when
reading large mailboxes which may take some time.
When set to 0, only a single message will appear before the reading
the mailbox.
.IP
Also see the \(lq$write_inc\(rq variable.


.TP
.B read_only
.nf
Type: boolean
Default: no
.fi
.IP
If set, all folders are opened in read-only mode.


.TP
.B realname
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable specifies what \(rqreal\(rq or \(rqpersonal\(rq name should be used
when sending messages.
.IP
By default, this is the GECOS field from /etc/passwd.  Note that this
variable will \fInot\fP be used when the user has set a real name
in the $from variable.


.TP
.B recall
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
Controls whether or not you are prompted to recall postponed messages
when composing a new message.  Also see \(lq$postponed\(rq.
.IP
Setting this variable to \(lqyes\(rq is not generally useful, and thus not
recommended.


.TP
.B record
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This specifies the file into which your outgoing messages should be
appended.  (This is meant as the primary method for saving a copy of
your messages, but another way to do this is using the \(lqmy_hdr\(rq
command to create a \fIBcc:\fP field with your email address in it.)
.IP
The value of \fI$record\fP is overridden by the \(lq$force_name\(rq and
\(lq$save_name\(rq variables, and the \(lqfcc-hook\(rq command.


.TP
.B reply_regexp
.nf
Type: regular expression
Default: \(lq^(re([\\[0-9\\]+])*|aw):[ \\t]*\(rq
.fi
.IP
A regular expression used to recognize reply messages when threading
and replying. The default value corresponds to the English \(rqRe:\(rq and
the German \(rqAw:\(rq.


.TP
.B reply_self
.nf
Type: boolean
Default: no
.fi
.IP
If unset and you are replying to a message sent by you, Mutt will
assume that you want to reply to the recipients of that message rather
than to yourself.


.TP
.B reply_to
.nf
Type: quadoption
Default: ask-yes
.fi
.IP
If set, Mutt will ask you if you want to use the address listed in the
Reply-To: header field when replying to a message.  If you answer no,
it will use the address in the From: header field instead.  This
option is useful for reading a mailing list that sets the Reply-To:
header field to the list address and you want to send a private
message to the author of a message.


.TP
.B resolve
.nf
Type: boolean
Default: yes
.fi
.IP
When set, the cursor will be automatically advanced to the next
(possibly undeleted) message whenever a command that modifies the
current message is executed.


.TP
.B reverse_alias
.nf
Type: boolean
Default: no
.fi
.IP
This variable controls whether or not Mutt will display the \(rqpersonal\(rq
name from your aliases in the index menu if it finds an alias that
matches the message's sender.  For example, if you have the following
alias:
.IP

.IP
.DS
.sp
.ft CR
.nf
alias juser abd30425@somewhere.net (Joe User)

.fi
.ec
.ft P
.sp
.IP
and then you receive mail which contains the following header:
.IP

.IP
.DS
.sp
.ft CR
.nf
From: abd30425@somewhere.net

.fi
.ec
.ft P
.sp
.IP
It would be displayed in the index menu as \(lqJoe User\(rq instead of
\(lqabd30425@somewhere.net.\(rq  This is useful when the person's e-mail
address is not human friendly (like CompuServe addresses).


.TP
.B reverse_name
.nf
Type: boolean
Default: no
.fi
.IP
It may sometimes arrive that you receive mail to a certain machine,
move the messages to another machine, and reply to some the messages
from there.  If this variable is set, the default \fIFrom:\fP line of
the reply messages is built using the address where you received the
messages you are replying to.  If the variable is unset, the
\fIFrom:\fP line will use your address on the current machine.


.TP
.B reverse_realname
.nf
Type: boolean
Default: yes
.fi
.IP
This variable fine-tunes the behaviour of the reverse_name feature.
When it is set, mutt will use the address from incoming messages as-is,
possibly including eventual real names.  When it is unset, mutt will
override any such real names with the setting of the realname variable.


.TP
.B rfc2047_parameters
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is set, Mutt will decode RFC-2047-encoded MIME 
parameters. You want to set this variable when mutt suggests you
to save attachments to files named like this: 
=?iso-8859-1?Q?file=5F=E4=5F991116=2Ezip?=
.IP
When this variable is set interactively, the change doesn't have
the desired effect before you have changed folders.
.IP
Note that this use of RFC 2047's encoding is explicitly,
prohibited by the standard, but nevertheless encountered in the
wild.
Also note that setting this parameter will \fInot\fP have the effect 
that mutt \fIgenerates\fP this kind of encoding.  Instead, mutt will
unconditionally use the encoding specified in RFC 2231.


.TP
.B save_address
.nf
Type: boolean
Default: no
.fi
.IP
If set, mutt will take the sender's full address when choosing a
default folder for saving a mail. If \(lq$save_name\(rq or \(lq$force_name\(rq
is set too, the selection of the fcc folder will be changed as well.


.TP
.B save_empty
.nf
Type: boolean
Default: yes
.fi
.IP
When unset, mailboxes which contain no saved messages will be removed
when closed (the exception is \(lq$spoolfile\(rq which is never removed).
If set, mailboxes are never removed.
.IP
\fBNote:\fP This only applies to mbox and MMDF folders, Mutt does not
delete MH and Maildir directories.


.TP
.B save_name
.nf
Type: boolean
Default: no
.fi
.IP
This variable controls how copies of outgoing messages are saved.
When set, a check is made to see if a mailbox specified by the
recipient address exists (this is done by searching for a mailbox in
the \(lq$folder\(rq directory with the \fIusername\fP part of the
recipient address).  If the mailbox exists, the outgoing message will
be saved to that mailbox, otherwise the message is saved to the
\(lq$record\(rq mailbox.
.IP
Also see the \(lq$force_name\(rq variable.


.TP
.B score
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIunset\fP, scoring is turned off.  This can
be useful to selectively disable scoring for certain folders when the
\(lq$score_threshold_delete\(rq variable and friends are used.


.TP
.B score_threshold_delete
.nf
Type: number
Default: -1
.fi
.IP
Messages which have been assigned a score equal to or lower than the value
of this variable are automatically marked for deletion by mutt.  Since
mutt scores are always greater than or equal to zero, the default setting
of this variable will never mark a message for deletion.


.TP
.B score_threshold_flag
.nf
Type: number
Default: 9999
.fi
.IP
Messages which have been assigned a score greater than or equal to this 
variable's value are automatically marked \(rqflagged\(rq.


.TP
.B score_threshold_read
.nf
Type: number
Default: -1
.fi
.IP
Messages which have been assigned a score equal to or lower than the value
of this variable are automatically marked as read by mutt.  Since
mutt scores are always greater than or equal to zero, the default setting
of this variable will never mark a message read.


.TP
.B send_charset
.nf
Type: string
Default: \(lqus-ascii:iso-8859-1:utf-8\(rq
.fi
.IP
A list of character sets for outgoing messages. Mutt will use the
first character set into which the text can be converted exactly.
If your \(lq$charset\(rq is not iso-8859-1 and recipients may not
understand UTF-8, it is advisable to include in the list an
appropriate widely used standard character set (such as
iso-8859-2, koi8-r or iso-2022-jp) either instead of or after
\(rqiso-8859-1\(rq.


.TP
.B sendmail
.nf
Type: path
Default: \(lq/usr/sbin/sendmail -oem -oi\(rq
.fi
.IP
Specifies the program and arguments used to deliver mail sent by Mutt.
Mutt expects that the specified program interprets additional
arguments as recipient addresses.


.TP
.B sendmail_wait
.nf
Type: number
Default: 0
.fi
.IP
Specifies the number of seconds to wait for the \(lq$sendmail\(rq process
to finish before giving up and putting delivery in the background.
.IP
Mutt interprets the value of this variable as follows:

.RS
.IP >0 
number of seconds to wait for sendmail to finish before continuing

.IP 0  
wait forever for sendmail to finish

.IP <0 
always put sendmail in the background without waiting

.RE
.IP
Note that if you specify a value other than 0, the output of the child
process will be put in a temporary file.  If there is some error, you
will be informed as to where to find the output.


.TP
.B shell
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Command to use when spawning a subshell.  By default, the user's login
shell from /etc/passwd is used.


.TP
.B sig_dashes
.nf
Type: boolean
Default: yes
.fi
.IP
If set, a line containing \(lq-- \(rq will be inserted before your
\(lq$signature\(rq.  It is \fBstrongly\fP recommended that you not unset
this variable unless your \(lqsignature\(rq contains just your name.  The
reason for this is because many software packages use \(lq-- \\n\(rq to
detect your signature.  For example, Mutt has the ability to highlight
the signature in a different color in the builtin pager.


.TP
.B sig_on_top
.nf
Type: boolean
Default: no
.fi
.IP
If set, the signature will be included before any quoted or forwarded
text.  It is \fBstrongly\fP recommended that you do not set this variable
unless you really know what you are doing, and are prepared to take
some heat from netiquette guardians.


.TP
.B signature
.nf
Type: path
Default: \(lq~/.signature\(rq
.fi
.IP
Specifies the filename of your signature, which is appended to all
outgoing messages.   If the filename ends with a pipe (\(lq|\(rq), it is
assumed that filename is a shell command and input should be read from
its stdout.


.TP
.B simple_search
.nf
Type: string
Default: \(lq~f %s | ~s %s\(rq
.fi
.IP
Specifies how Mutt should expand a simple search into a real search
pattern.  A simple search is one that does not contain any of the ~
operators.  See \(lqpatterns\(rq for more information on search patterns.
.IP
For example, if you simply type joe at a search or limit prompt, Mutt
will automatically expand it to the value specified by this variable.
For the default value it would be:
.IP
~f joe | ~s joe


.TP
.B smart_wrap
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the display of lines longer than the screen width in the
internal pager. If set, long lines are wrapped at a word boundary.  If
unset, lines are simply wrapped at the screen edge. Also see the
\(lq$markers\(rq variable.


.TP
.B smileys
.nf
Type: regular expression
Default: \(lq(>From )|(:[-^]?[][)(><}{|/DP])\(rq
.fi
.IP
The \fIpager\fP uses this variable to catch some common false
positives of \(lq$quote_regexp\(rq, most notably smileys in the beginning
of a line


.TP
.B sleep_time
.nf
Type: number
Default: 1
.fi
.IP
Specifies time, in seconds, to pause while displaying certain informational
messages, while moving from folder to folder and after expunging
messages from the current folder.  The default is to pause one second, so 
a value of zero for this option suppresses the pause.


.TP
.B sort
.nf
Type: sort order
Default: date
.fi
.IP
Specifies how to sort messages in the \fIindex\fP menu.  Valid values
are:
.IP

.IP
.DS
.sp
.ft CR
.nf
   date or date-sent
   date-received
   from
   mailbox-order (unsorted)
   score
   size
   subject
   threads
   to

.fi
.ec
.ft P
.sp
.IP
You may optionally use the reverse- prefix to specify reverse sorting
order (example: set sort=reverse-date-sent).


.TP
.B sort_alias
.nf
Type: sort order
Default: alias
.fi
.IP
Specifies how the entries in the `alias' menu are sorted.  The
following are legal values:
.IP

.IP
.DS
.sp
.ft CR
.nf
   address (sort alphabetically by email address)
   alias (sort alphabetically by alias name)
   unsorted (leave in order specified in .muttrc)

.fi
.ec
.ft P
.sp


.TP
.B sort_aux
.nf
Type: sort order
Default: date
.fi
.IP
When sorting by threads, this variable controls how threads are sorted
in relation to other threads, and how the branches of the thread trees
are sorted.  This can be set to any value that \(lq$sort\(rq can, except
threads (in that case, mutt will just use date-sent).  You can also
specify the last- prefix in addition to the reverse- prefix, but last-
must come after reverse-.  The last- prefix causes messages to be
sorted against its siblings by which has the last descendant, using
the rest of sort_aux as an ordering.  For instance, set sort_aux=last-
date-received would mean that if a new message is received in a
thread, that thread becomes the last one displayed (or the first, if
you have set sort=reverse-threads.) Note: For reversed \(lq$sort\(rq
order $sort_aux is reversed again (which is not the right thing to do,
but kept to not break any existing configuration setting).


.TP
.B sort_browser
.nf
Type: sort order
Default: subject
.fi
.IP
Specifies how to sort entries in the file browser.  By default, the
entries are sorted alphabetically.  Valid values:
.IP

.IP
.DS
.sp
.ft CR
.nf
   alpha (alphabetically)
   date
   size
   unsorted

.fi
.ec
.ft P
.sp
.IP
You may optionally use the reverse- prefix to specify reverse sorting
order (example: set sort_browser=reverse-date).


.TP
.B sort_re
.nf
Type: boolean
Default: yes
.fi
.IP
This variable is only useful when sorting by threads with
\(lq$strict_threads\(rq unset.  In that case, it changes the heuristic
mutt uses to thread messages by subject.  With sort_re set, mutt will
only attach a message as the child of another message by subject if
the subject of the child message starts with a substring matching the
setting of \(lq$reply_regexp\(rq.  With sort_re unset, mutt will attach
the message whether or not this is the case, as long as the
non-\(lq$reply_regexp\(rq parts of both messages are identical.


.TP
.B spoolfile
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
If your spool mailbox is in a non-default place where Mutt cannot find
it, you can specify its location with this variable.  Mutt will
automatically set this variable to the value of the environment
variable $MAIL if it is not set.


.TP
.B status_chars
.nf
Type: string
Default: \(lq-*%A\(rq
.fi
.IP
Controls the characters used by the \(rq%r\(rq indicator in
\(lq$status_format\(rq. The first character is used when the mailbox is
unchanged. The second is used when the mailbox has been changed, and
it needs to be resynchronized. The third is used if the mailbox is in
read-only mode, or if the mailbox will not be written when exiting
that mailbox (You can toggle whether to write changes to a mailbox
with the toggle-write operation, bound by default to \(rq%\(rq). The fourth
is used to indicate that the current folder has been opened in attach-
message mode (Certain operations like composing a new mail, replying,
forwarding, etc. are not permitted in this mode).


.TP
.B status_format
.nf
Type: string
Default: \(lq-%r-Mutt: %f [Msgs:%?M?%M/?%m%?n? New:%n?%?o? Old:%o?%?d? Del:%d?%?F? Flag:%F?%?t? Tag:%t?%?p? Post:%p?%?b? Inc:%b?%?l? %l?]---(%s/%S)-%>-(%P)---\(rq
.fi
.IP
Controls the format of the status line displayed in the \fIindex\fP
menu.  This string is similar to \(lq$index_format\(rq, but has its own
set of printf()-like sequences:
.IP

.RS
.IP %b  
number of mailboxes with new mail *

.IP %d  
number of deleted messages *

.IP %f  
the full pathname of the current mailbox

.IP %F  
number of flagged messages *

.IP %h  
local hostname

.IP %l  
size (in bytes) of the current mailbox *

.IP %L  
size (in bytes) of the messages shown 
(i.e., which match the current limit) *

.IP %m  
the number of messages in the mailbox *

.IP %M  
the number of messages shown (i.e., which match the current limit) *

.IP %n  
number of new messages in the mailbox *

.IP %o  
number of old unread messages

.IP %p  
number of postponed messages *

.IP %P  
percentage of the way through the index

.IP %r  
modified/read-only/won't-write/attach-message indicator,
according to $status_chars

.IP %s  
current sorting mode ($sort)

.IP %S  
current aux sorting method ($sort_aux)

.IP %t  
number of tagged messages *

.IP %u  
number of unread messages *

.IP %v  
Mutt version string

.IP %V  
currently active limit pattern, if any *

.IP %>X 
right justify the rest of the string and pad with \(rqX\(rq

.IP %|X 
pad to the end of the line with \(rqX\(rq

.RE
.IP
* = can be optionally printed if nonzero
.IP
Some of the above sequences can be used to optionally print a string
if their value is nonzero.  For example, you may only want to see the
number of flagged messages if such messages exist, since zero is not
particularly meaningful.  To optionally print a string based upon one
of the above sequences, the following construct is used
.IP
%?<sequence_char>?<optional_string>?
.IP
where \fIsequence_char\fP is a character from the table above, and
\fIoptional_string\fP is the string you would like printed if
\fIstatus_char\fP is nonzero.  \fIoptional_string\fP \fBmay\fP contain
other sequence as well as normal text, but you may \fBnot\fP nest
optional strings.
.IP
Here is an example illustrating how to optionally print the number of
new messages in a mailbox:
%?n?%n new messages.?
.IP
Additionally you can switch between two strings, the first one, if a
value is zero, the second one, if the value is nonzero, by using the
following construct:
%?<sequence_char>?<if_string>&<else_string>?
.IP
You can additionally force the result of any printf-like sequence to
be lowercase by prefixing the sequence character with an underscore
(_) sign.  For example, if you want to display the local hostname in
lowercase, you would use:
%_h
.IP
If you prefix the sequence character with a colon (:) character, mutt
will replace any dots in the expansion by underscores. This might be helpful 
with IMAP folders that don't like dots in folder names.


.TP
.B status_on_top
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable causes the \(lqstatus bar\(rq to be displayed on
the first line of the screen rather than near the bottom.


.TP
.B strict_threads
.nf
Type: boolean
Default: no
.fi
.IP
If set, threading will only make use of the \(lqIn-Reply-To\(rq and
\(lqReferences\(rq fields when you \(lq$sort\(rq by message threads.  By
default, messages with the same subject are grouped together in
\(lqpseudo threads.\(rq  This may not always be desirable, such as in a
personal mailbox where you might have several unrelated messages with
the subject \(lqhi\(rq which will get grouped together.


.TP
.B suspend
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, mutt won't stop when the user presses the terminal's
\fIsusp\fP key, usually \(lqcontrol-Z\(rq. This is useful if you run mutt
inside an xterm using a command like xterm -e mutt.


.TP
.B text_flowed
.nf
Type: boolean
Default: no
.fi
.IP
When set, mutt will generate text/plain; format=flowed attachments.
This format is easier to handle for some mailing software, and generally
just looks like ordinary text.  To actually make use of this format's 
features, you'll need support in your editor.
.IP
Note that $indent_string is ignored when this option is set.


.TP
.B thread_received
.nf
Type: boolean
Default: no
.fi
.IP
When set, mutt uses the date received rather than the date sent
to thread messages by subject.


.TP
.B thorough_search
.nf
Type: boolean
Default: no
.fi
.IP
Affects the \fI~b\fP and \fI~h\fP search operations described in
section \(lqpatterns\(rq above.  If set, the headers and attachments of
messages to be searched are decoded before searching.  If unset,
messages are searched as they appear in the folder.


.TP
.B tilde
.nf
Type: boolean
Default: no
.fi
.IP
When set, the internal-pager will pad blank lines to the bottom of the
screen with a tilde (~).


.TP
.B timeout
.nf
Type: number
Default: 600
.fi
.IP
This variable controls the \fInumber of seconds\fP Mutt will wait
for a key to be pressed in the main menu before timing out and
checking for new mail.  A value of zero or less will cause Mutt
to never time out.


.TP
.B tmpdir
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable allows you to specify where Mutt will place its
temporary files needed for displaying and composing messages.  If
this variable is not set, the environment variable TMPDIR is
used.  If TMPDIR is not set then \(rq/tmp\(rq is used.


.TP
.B to_chars
.nf
Type: string
Default: \(lq +TCFL\(rq
.fi
.IP
Controls the character used to indicate mail addressed to you.  The
first character is the one used when the mail is NOT addressed to your
address (default: space).  The second is used when you are the only
recipient of the message (default: +).  The third is when your address
appears in the TO header field, but you are not the only recipient of
the message (default: T).  The fourth character is used when your
address is specified in the CC header field, but you are not the only
recipient.  The fifth character is used to indicate mail that was sent
by \fIyou\fP.  The sixth character is used to indicate when a mail
was sent to a mailing-list you subscribe to (default: L).


.TP
.B tunnel
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Setting this variable will cause mutt to open a pipe to a command
instead of a raw socket. You may be able to use this to set up
preauthenticated connections to your IMAP/POP3 server. Example:
.IP
tunnel=\(rqssh -q mailhost.net /usr/local/libexec/imapd\(rq
.IP
NOTE: For this example to work you must be able to log in to the remote
machine without having to enter a password.


.TP
.B use_8bitmime
.nf
Type: boolean
Default: no
.fi
.IP
\fBWarning:\fP do not set this variable unless you are using a version
of sendmail which supports the -B8BITMIME flag (such as sendmail
8.8.x) or you may not be able to send mail.
.IP
When \fIset\fP, Mutt will invoke \(lq$sendmail\(rq with the -B8BITMIME
flag when sending 8-bit messages to enable ESMTP negotiation.


.TP
.B use_domain
.nf
Type: boolean
Default: yes
.fi
.IP
When set, Mutt will qualify all local addresses (ones without the
@host portion) with the value of \(lq$hostname\(rq.  If \fIunset\fP, no
addresses will be qualified.


.TP
.B use_from
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will generate the `From:' header field when
sending messages.  If \fIunset\fP, no `From:' header field will be
generated unless the user explicitly sets one using the \(lqmy_hdr\(rq
command.


.TP
.B use_ipv6
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will look for IPv6 addresses of hosts it tries to
contact.  If this option is unset, Mutt will restrict itself to IPv4 addresses.
Normally, the default should work.


.TP
.B user_agent
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will add a \(rqUser-Agent\(rq header to outgoing
messages, indicating which version of mutt was used for composing
them.


.TP
.B visual
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Specifies the visual editor to invoke when the \fI~v\fP command is
given in the builtin editor.


.TP
.B wait_key
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether Mutt will ask you to press a key after \fIshell-
escape\fP, \fIpipe-message\fP, \fIpipe-entry\fP, \fIprint-message\fP,
and \fIprint-entry\fP commands.
.IP
It is also used when viewing attachments with \(lqauto_view\(rq, provided
that the corresponding mailcap entry has a \fIneedsterminal\fP flag,
and the external program is interactive.
.IP
When set, Mutt will always ask for a key. When unset, Mutt will wait
for a key only if the external command returned a non-zero status.


.TP
.B weed
.nf
Type: boolean
Default: yes
.fi
.IP
When set, mutt will weed headers when when displaying, forwarding,
printing, or replying to messages.


.TP
.B wrap_search
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether searches wrap around the end of the mailbox.
.IP
When set, searches will wrap around the first (or last) message. When
unset, searches will not wrap.


.TP
.B wrapmargin
.nf
Type: number
Default: 0
.fi
.IP
Controls the size of the margin remaining at the right side of
the terminal when mutt's pager does smart wrapping.


.TP
.B write_inc
.nf
Type: number
Default: 10
.fi
.IP
When writing a mailbox, a message will be printed every
\fIwrite_inc\fP messages to indicate progress.  If set to 0, only a
single message will be displayed before writing a mailbox.
.IP
Also see the \(lq$read_inc\(rq variable.


.TP
.B write_bcc
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether mutt writes out the Bcc header when preparing
messages to be sent.  Exim users may wish to use this.


.\" -*-nroff-*-
.SH SEE ALSO
.PP
.BR iconv (1),
.BR iconv (3),
.BR mailcap (5),
.BR maildir (5),
.BR mbox (5),
.BR mutt (1),
.BR printf (3),
.BR regex (7),
.BR strftime (3)
.PP
The Mutt Manual
.PP
The Mutt home page: http://www.mutt.org/
.SH AUTHOR
.PP
Michael Elkins, and others.  Use <mutt-dev@mutt.org> to contact
the developers.
