/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 messages.h  -  Message definitions for mutella client, for message events.
 
    begin                : Mon Jan 28 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __MESSAGES_H__INCLUDED__
#define __MESSAGES_H__INCLUDED__

// message IDs
#define MSG_FIRST								0x1000
#define MSG_TIMER								0x1001
#define MSG_DOWNLOAD_COMPLETED					0x1100
#define MSG_DOWNLOAD_FILE_MOVED					0x1101
#define MSG_DOWNLOAD_FILE_MOVE_FAILED			0x1102
#define MSG_DOWNLOAD_REMOVING_COMPL				0x1103
#define MSG_DOWNLOAD_REMOVING_FAILED			0x1104
#define MSG_DOWNLOAD_FILE_ERROR					0x1105
#define MSG_DOWNLOAD_FILE_MISSMATCH				0x1106
#define MSG_DOWNLOAD_STORAGE_DENIED				0x1107
#define MSG_DOWNLOAD_STORE_WHILE_CLOSE_FAILED	0x1108
#define MSG_SHARE_SCANNED						0x1200
#define MSG_SHARE_COMMAND						0x1201
#define MSG_SHARE_REQUEST						0x1202
#define MSG_AUTOGET								0x1300
#define MSG_DOWNLOAD_TO_AUTOGET					0x1301
#define MSG_FAILED_TO_LISTEN					0x1302
#define MSG_FAILED_TO_CREATE_LISTEN_SOCKET		0x1303
#define MSG_UPLOAD_FILE_OPEN_FAILED				0x1400
#define MSG_UPLOAD_FINISHED						0x1401
#define MSG_REMOTE_ACCESS						0x1500
#define MSG_LOGGING_FAILED						0x1600
#define MSG_PACKET_RECEIVED						0x1700
#define MSG_PACKET_SENT							0x1701
#define MSG_PACKET_REMOVED_GOOD					0x1702
#define MSG_PACKET_REMOVED_BAD					0x1703
#define MSG_PACKET_RECEIVED_UNKNOWN				0x1704
#define MSG_SHA1_REQUEST						0x1801
#define MSG_SHA1_PROGRESS_UPDATE				0x1802
#define MSG_SHA1_READY							0x1803
#define MSG_SHA1_RESET_QUEUE					0x1804
#define MSG_SHA1_LAST_IN_THE_ROW				0x1805
#define MSG_CONNECTION_HANDSHAKE_OK				0x1900
#define MSG_CONNECTION_HANDSHAKE_FAIL			0x1901
#define MSG_CONNECTION_LOST						0x1902
#define MSG_CONNECTION_BYE						0x1903

#define MSG_MUTELLA_EXIT						0x1F00

// message source IDs
#define MSGSRC_DIRECTOR					1
#define MSGSRC_DOWNLOAD					2
#define MSGSRC_UPLOAD					3
#define MSGSRC_NODE						4
#define MSGSRC_SHARE					5
#define MSGSRC_LOGCENTRE				6
#define MSGSRC_REMOTE_UI				7
#define MSGSRC_CONTROLLER				8

CString GetMessageString(int nMessageID);

#endif //__MESSAGES_H__INCLUDED__

