/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnunode.h  -  Definition of a node in the gnutella network

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUNODE_H_INCLUDED__)
#define __GNUNODE_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuNode

#define PACKET_BUFF     32768
#define PACKETCACHE_SIZE 1000

//class CGnuTransfers;
//class CGnuPrefs;
//class CGnuCore;
//class CGnuCache;
//class CGnuShare;
//class CGnuControl;

struct packet_Header;
struct packet_Ping;
struct packet_Pong;
struct packet_Push;
struct packet_Query;
struct packet_QueryHit;
struct packet_RouteTablePatch;
struct packet_RouteTableReset;

struct RecentQuery
{
	GUID Guid;
	int  SecsOld;

	RecentQuery()
	{
		Guid    = GUID_NULL;
		SecsOld = 0;
	}

	RecentQuery(GUID cGuid)
	{
		Guid    = cGuid;
		SecsOld = 0;
	}
};

struct PriorityPacket
{
	PriorityPacket(void* pData, int nLen) : Length(nLen) {
		Packet = new BYTE[nLen];
		memcpy(Packet, pData, nLen);
	}
	~PriorityPacket() {
		if (Packet)
			delete [] Packet;
	}
	PriorityPacket(const PriorityPacket& orig) : Packet(orig.Packet), Length(orig.Length) {
		const_cast<PriorityPacket*>(&orig)->Packet = NULL;
		const_cast<PriorityPacket*>(&orig)->Length = 0;
	}
	//
	int   Length;
	BYTE* Packet;
	private:
	PriorityPacket();
	const PriorityPacket& operator=(const PriorityPacket&);
};

enum SendPacket {
	PACKET_QRP,
	PACKET_PUSH,
	PACKET_QUERYHIT,
	PACKET_QUERY,
	PACKET_PONG,
	PACKET_PING
};

class MGnuDirecror;
class MGnuPreferences;
class MGnuCache;
struct MapPongList;

class MGnuNode : public MAsyncSocket, public SGnuNode
{
public:
	//MGnuNode(MGnuDirector* pComm, CString Host, UINT Port);
	MGnuNode(MGnuDirector* pComm, IP ipHost, UINT Port, bool bInbound, bool bForceV4);
	virtual ~MGnuNode();

	inline bool  IsConnected() const { return m_nStatus == SOCK_CONNECTED; }
	inline bool  IsIncoming() const { return m_bInbound; }
	inline IP    GetHost() const { return m_ipHost; }
	inline DWORD GetID() const { return m_dwID; }
	inline const SGnuNode& GetSGnuNode() const { return *this; }
	inline void  SetMaxInRate(DWORD dwRate) { m_dwMaxInBytesPerSec = dwRate; }
	inline int   GetPeerMode() { return m_nPeerMode; }
	inline int   GetStatus() { return m_nStatus; }
	inline int   GetEfficeincy() { return m_nEfficiency; }

	void  ForceDisconnect(bool bExernal = false);
	void  OnTimer();
	void  Send_Host(const Node& Host);
	
	// New connections
	void    ParseHandshake04(CString, BYTE*, int);
	bool    ParseIncomingHandshake06(CString, BYTE*, int, bool bHandshakeInBuf);
	void    ParseOutboundHandshake06(CString, BYTE*, int);
	//bool ParseHandshake(const CString& Data, BYTE* pStream, int StreamLength, bool bHandshakeInBuf);

	void    ParseTryHeader(CString TryHeader, bool Super=false);

	void SetConnected();
	void Send_ConnectOK(bool, int);
	void Send_ConnectBusy();

	// Sending packets
	void SendPacket(void*, int, int, bool);

	void Send_Ping(int);
	void Send_Pong(const GUID&, int);
	void Send_QueryHit(const QueryComp&, const BYTE*, DWORD, BYTE, const CString &);
	void Send_ForwardQuery(const QueryComp& );
	void Send_PatchTable();

	// Misc functions
	bool GetAlternateHostList(CString &);
	bool GetAlternateSuperList(CString &);
	void AvoidTriangles();

	void Refresh();
	void Timer();

	int  UpdateStats(int type);
	void AddGoodStat(int type);
	void RemovePacket(int);

	// Connected Node's info
	int m_nSecsTrying;
	int m_nSecsDead;
	int m_ClosedSecs;
	int m_nSecsAlive;
	int m_nSecsRefresh;                  // Seconds since last refresh
	int m_IntervalPing;
	int m_nOrigDistance;
	int m_NextReSearchWait;

	CString m_StatusText;

	CString m_NetworkName;

	CString m_InitData;

	CString m_WholeHandshake;
	CString m_Handshake;
	CString m_lowHandshake;

	CString m_Challenge;
	CString m_ChallengeAnswer;

	CString m_RemoteChallenge;
	CString m_RemoteChallengeAnswer;

	UINT      m_NodeFileCount;
	int       m_NodeLeafMax;

	bool    m_DowngradeRequest; // Is true if we request node to become child, or remote node requests us to become a child node
	bool    m_PatchUpdateNeeded;

	bool    m_UltraPongSent;

	bool IsRecentQuery(GUID Guid);
	vector<RecentQuery> m_RecentQueryList;

	// Ultrapeers
	UINT    m_TableInfinity;
	UINT    m_TableLength;

	char*   m_PatchTable;
	UINT    m_TableNextPos;

	BYTE*   m_CompressedTable;
	UINT    m_CompressedSize;

	UINT    m_CurrentSeq;

	int  m_LastHops;                  // where to send the next pongs
	GUID m_LastGuid;                  // last guid recieved from a ping
	//void Send_Pong(MapPongList*);   // send cached pong

	// Bandwidth & statistics, [0] is Received, [1] is Sent, [2] is Dropped
	//DWORD	m_dwSecPackets[3];          // packets received/sent during last second
	//DWORD	m_adwHistPackets[3][180];   // history for the last 3 minutes
	//DWORD	m_dwHistTotalPackets[3];    // running history total
	//DWORD	m_dwSecBytes[3];            // BYTEs received/sent during last second
	//DWORD	m_adwHistBytes[3][180];     // history for the last 3 minutes
	//DWORD	m_dwHistTotalBytes[3];      // running history total
	//DWORD	m_dwSecReplyPackets;        // quiery-reply packets receiver during last second
	//DWORD	m_adwHistReplyPackets[180]; // history for last 3 minutes
	//DWORD	m_dwHistTotalReplyPackets;  // running history total
	long m_nStatisticsSec      [NR_LAST];      // statistics collected in last second
	long m_nStatisticsHist     [NR_LAST][180]; // statistics history for the last 3 minutes
	long m_nStatisticsHistTotal[NR_LAST];      // sum of all history elements

	long m_nSecDroppedPackets;

	// Packet Stats
	BYTE  m_StatPackets[PACKETCACHE_SIZE][2]; // Last 1000 packet, can be set either bad(0) or good(1)
	int   m_StatPos;                          // Position in array
	int   m_StatElements;
	int   m_StatPings[2],     m_StatPongs[2], m_StatQueries[2],
	      m_StatQueryHits[2], m_StatPushes[2];  // Total received during last 1000 packets and total that were good

	// Mapping
	void MapPong(packet_Pong* Pong, bool Near);
	void MapQueryHit(packet_QueryHit* QueryHit);

	//std::vector<MapNode> NearMap[2];
	//std::vector<UINT>        LocalMap[MAX_TTL];
	//std::vector<MapLink> MapLinkList;

	// Bandwidth, [0] is Received, [1] is Sent, [2] is Dropped

	int m_nSecNum;              // Number of elements in array
	int m_nSecCounter;

public:
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
	virtual int Send(const void* lpBuf, int nBufLen, int nFlags = 0);
	virtual void OnSend(int nErrorCode);
	virtual void Close();

protected:
	// Packet handlers
	bool SplitBundle(BYTE*, DWORD, DWORD*);
	void  HandlePacket(packet_Header*, DWORD);
	bool  InspectPacket(packet_Header*);

	// Receiving packets
	void Receive_Ping(packet_Ping*,   int);
	void Receive_Pong(packet_Pong*,   int);
	void Receive_Push(packet_Push*,   int);
	void Receive_Query(packet_Query*, int);
	void Receive_QueryHit(packet_QueryHit*, DWORD);

	void Receive_RouteTableReset(packet_RouteTableReset*, UINT);
	void Receive_RouteTablePatch(packet_RouteTablePatch*, UINT);

	void Receive_Unknown(BYTE*, DWORD);

	DWORD GetSpeed();
	void  NodeManagement();

	MGnuPreferences* m_pPrefs;
	MGnuDirector*    m_pComm;
	MGnuCache*       m_pHostCatcher;
	MGnuCache*       m_pHostStore;
	MGnuCache*       m_pUltraCatcher;

	bool m_bReceiveBlocked;
	DWORD m_dwMaxInBytesPerSec;

	DWORD m_ExtraLength;
	BYTE* m_pBuff;

	// Packet Prioritization functions and variables
	MMutex m_BufferAccess;
	void FlushSendBuffer();

	list<PriorityPacket> m_PacketList[6];
	int m_PacketListLength[6];

	BYTE* m_pBackBuff;
	int  m_BackBuffLength;
};

#if 0

class MGnuPreferences;
class MGnuCache;
class MGnuShare;
class MGnuDirector;

struct QueuedPacket
{
	int   size;
	char* pData;
};

class MGnuNode : public MAsyncSocket, public SGnuNode
{
friend class MGnuSock;
public:
	MGnuNode(MGnuDirector* pComm, IP ipHost, UINT Port, bool bInbound, bool bForceV4);
	virtual ~MGnuNode();

	// New connections
	bool ParseHandshake(const CString& Data, BYTE* pStream, int StreamLength, bool bHandshakeInBuf);
	void Send_ConnectOK(bool bVersion6, bool bReply);
	void Send_Hello(bool bVersion6);
	void SetConnected();
	//void Receive_ConnectOK();

	// Sending packets
	void Send_Ping(int);
	void Send_Pong(GUID, int);
	void Send_QueryHit(QueryComp*, BYTE*, DWORD &, BYTE &);
	void Send_HostCache();
	void Send_Host(Node);

	// Misc functions
	void ForceDisconnect(bool bExernal = false);
	void OnTimer();
    inline bool  IsConnected() const {return m_nStatus == SOCK_CONNECTED;}
    inline bool  IsIncoming() const {return m_bInbound;}
    inline IP    GetHost() const {return m_ipHost;}
    inline DWORD GetID() const {return m_dwID;}
    void SetMaxInRate(DWORD dwRate){m_dwMaxInBYTEsPerSec = dwRate;}
    // tricky function
    inline const SGnuNode& GetSGnuNode() const {return *this;}
// Overrides
public:
	virtual int Send(const void* lpBuf, int nBufLen, int nFlags = 0);
protected:
	virtual void OnSend(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
protected:
	MGnuNode();                      // no implementation
	MGnuNode(const MGnuNode& rSrc);  // no implementation
protected:
	// packet.handlers
	DWORD SplitBundle(BYTE*, DWORD);
	void  HandlePacket(packet_Header*, DWORD);
	bool  InspectPacket(packet_Header*, DWORD);

	// Receiving packets
	void Receive_Ping(packet_Ping*, int);
	void Receive_Pong(packet_Pong*, int);
	void Receive_Push(packet_Push*, int);
	void Receive_Query(packet_Query*, int);
	void Receive_QueryHit(packet_QueryHit*, DWORD);
	void Receive_Unknown(BYTE*, DWORD);

	DWORD GetOurSpeed();
	void  NodeManagement(int nLastSecPackets);

	MGnuPreferences* m_pPrefs;
	MGnuDirector*  m_pDirector;
	MGnuCache*	  m_pHostCatcher;
	MGnuCache*	  m_pHostStore;
	MGnuShare*	  m_pShare;
	//
	std::queue<QueuedPacket> m_sendQueue;
	MMutex                   m_sendQueueMutex;
	// Connected Node's info
	int	m_nSecsTrying;
	int	m_nSecsDead;
    //
	CString m_sHandshake; // why do we store this crap?

	// Bandwidth & statistics, [0] is Received, [1] is Sent
	DWORD	m_dwSecPackets[2];          // packets received/sent during last second
	DWORD	m_adwHistPackets[2][180];   // history for the last 3 minutes
	DWORD	m_dwHistTotalPackets[2];    // running history total
	DWORD	m_dwSecBYTEs[2];            // BYTEs received/sent during last second
	DWORD	m_adwHistBYTEs[2][180];     // history for the last 3 minutes
	DWORD	m_dwHistTotalBYTEs[2];      // running history total
	DWORD	m_dwSecReplyPackets;        // quiery-reply packets receiver during last second
	DWORD	m_adwHistReplyPackets[180]; // history for last 3 minutes
	DWORD	m_dwHistTotalReplyPackets;  // running history total

	// Bandwidth limiting
	DWORD m_dwMaxInBYTEsPerSec;
	bool  m_bReceiveBlocked;

	// set to true when repeating the connection effort using v0.4 handshake
	bool m_bForceV4;
	//	family business
	int m_nSecCounter;	       // Counter of seconds since the connection start
	bool m_bHaveReceivedPongs;
	bool m_bHaveReceivedPings;

	DWORD m_dwExtraLength;
	BYTE* m_pReceiveBuffer;
	BYTE* m_pExtraBuffer;
};

#ifdef _DEBUG

#include "event.h"

class MPacketEvent : public MEvent {
public:
	MPacketEvent(packet_Header* pPH, DWORD length, IP host, DWORD dwID);
	virtual ~MPacketEvent(){}
	// pure virtual functions
	virtual int GetMemUsage(){return sizeof(MPacketEvent);}
	virtual CString Format();
protected:
	DWORD m_dwLength;
	IP    m_ipHost;
	BYTE  m_nTTL;
	BYTE  m_nHops;
	BYTE  m_nFunction;
};

#endif //_DEBUG

#endif // 0

#endif // __GNUNODE_H_INCLUDED__

