/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 conversions.h  -  Various IP naming/numbering conversions and base64 codec

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__CONVERSIONS_H_INCLUDED__)
#define __CONVERSIONS_H_INCLUDED__

CString DWrdtoStr(DWORD);     // Convert DWORD to a CString

union IP;
struct IPNET;

CString Ip2Str(const IP&);               // Convert IP to CString
bool Str2Ip_lookup(const CString&, IP&); // Convert CString to an IP optinally calling DNS lookup
bool Str2Ip(const CString&, IP&);        // Convert CString to an IP without DNS
CString IpNet2Str(const IPNET& subnet);  // Convert IP-net into string
bool Str2IpNet(const CString& sNet, IPNET& ipn); // Converts string "back"

DWORD GetSpeedinBytes(CString Speed);
CString GetSpeedString(DWORD dwSpeed);

bool    ValidVendor(CString VendorID);
CString GetVendor(CString VendorID);

// string manipulation functions
inline void MakeLower(CString& s){s.make_lower();}
inline void MakeUpper(CString& s){s.make_upper();}
void MakeLower(char *);
void MakeUpper(char *);
char ToLower(char);
char ToUpper(char);
CString StripWhite(const CString& str);
char* StripWhite(char* string );
CString StripAnyOf(const CString& str, const char* szCharSet);
void ReplaceSubStr(CString&, const CString&, const CString&);

// simple parser that splits the string into the parts
int  split_str(const CString& str, char cSeparator,  list<CString>& parts);
int  split_str(const CString& str, const char* lpszSeparator,  list<CString>& parts);
bool parse_params(const CString& sBuffer, const char* lpszPairsSep, const char* lpszEqualSep,  map<CString, CString>& values);

// advanced converters of strings into numbers
bool asc2num( char * arg, double * pRet );
bool asc2num( char * arg, int * pRet );
bool asc2num( const CString& sArg, double * pRet );
bool asc2num( const CString& sArg, int * pRet );


// and back
CString FormatSize(u_long n);
CString FormatSizeLL(long long n);
CString FormatKSize(u_long n);
CString FormatKSizeLL(long long n);
CString FormatMSize(u_long n);
CString FormatNumber(double d);
CString FormatPercent(double part, double whole);

// time formatting
CString FormatTime(time_t nSec);
CString FormatTimeFull(time_t nSec);
CString FormatAbsTime(time_t nSec);
CString FormatAbsTimeFull(time_t nSec);
time_t ParseAbsTimeFull(const CString& sTime);
//
CString InsertElypsis(const CString& s, int nMaxLen);




//*********************************************************************
//* C_Base64 - a simple base64 encoder and decoder.
//*
//*     Copyright (c) 1999, Bob Withers - bwit@pobox.com
//*
//* This code may be freely used for any purpose, either personal
//* or commercial, provided the authors copyright notice remains
//* intact.
//*********************************************************************
class Base64
{
public:
    static CString encode(CString data);
    static CString decode(CString data);
private:
    static const char fillchar;
    static const CString cvt;
};

// Base32

/*
 * base32_encode
 *
 * Encode `len' bytes starting at `buf' into new allocated buffer.
 * No trailing padding chars are emitted.
 *
 * Returns the new encoded buffer, NUL-terminated, and the added amount
 * of padding chars in `retpad' if it is a non-NULL pointer.
 */
char *base32_encode(const BYTE *buf, int len, int *retpad);

/*
 * base32_decode
 *
 * Decode `len' bytes starting at `buf' into new allocated buffer.
 *
 * Returns the new decoded buffer, or NULL if the input was not valid base32
 * encoding.  The caller knows the length of the returned buffer: it's the
 * size of the input divided by 8 and multiplied by 5.
 */
char *base32_decode(const char *buf, int len);

#endif //__CONVERSIONS_H_INCLUDED__

