#define WAIT_FOR_FILE_DELAY	250	/* sleep when waiting for a file to become available */
#define MAX_N_RE_MATCHES	16	/* max. number of regex matches: used for coloring matches */
#define MIN_N_BUFFERLINES	100	/* number of lines to buffer at minimum */
#define MAX_N_SPAWNED_PROCESSES	16	/* max. nr. of processes executed by matching regexps */
#define MAX_N_COLUMNS		15	/* max number of columns */

#define LOADAVG_STR_LEN		20
#define AMOUNT_STR_LEN		(3 + 2 + 1)

#define TERM_MISC	0
#define TERM_XTERM	1

#define VAL_ZERO_POSITIVE	1	/* >= 0 */
#define VAL_POSITIVE_NOT_1	2	/* >= 0 && != 1 */
#define VAL_POSITIVE		3	/* > 0 */

#define M_KB (1024)
#define M_MB (M_KB * 1024)
#define M_GB (M_MB * 1024)

#ifndef _BSD_SOURCE
#define _BSD_SOURCE	/* don't worry: it'll still work if you don't have a BSD system */
#endif
#ifndef __USE_BSD
#define __USE_BSD	/* manpage says _BSD_SOURCE, stdlib.h says __USE_BSD */
#endif

#if defined(sun) || defined(__sun)
	#include <ncurses/panel.h>
	#include <ncurses/ncurses.h>
#else
	#include <panel.h>
	#include <ncurses.h>
#endif

#define N_CURSES

/* Tru64 workaround */
#if defined(OSF1)
	#undef getmaxyx
	#define getmaxyx(w,y,x) y = w->_maxy;  x = w->_maxx
#endif

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__APPLE__)
#define off64_t off_t
#define stat64 stat
#define open64 open
#endif


#define SEL_WIN		0
#define SEL_SUBWIN	1
#define SEL_FILES	2
#define SEL_CSCHEME	3
#define SEL_COLORS	4

typedef struct
{
	WINDOW *win;
	PANEL *pwin;

	int x_off, y_off;
	int width, height;

} NEWWIN;

typedef struct
{
        char *regex_str;
        regex_t regex;
        char invert_regex;
	char use_regex;

	int count;

	/* command to run if matches */
	char *cmd;
} re;

#define STRIP_TYPE_REGEXP	1
#define STRIP_TYPE_RANGE	2
#define STRIP_TYPE_COLUMN	3
typedef struct
{
	int type;
	
	regex_t  regexp;

	int start, end;

	int col_nr;
	char *del;
} strip_t;

typedef struct _subwindow_
{
	char *filename;
	char is_command;
	int check_interval;
	int fd;		/* read */
	int wfd;	/* write */
	pid_t pid;

	int term_emul;

	char paused;

	char *incomplete_line;

	char *win_title;

	char line_wrap;
	int line_wrap_offset;

	int win_height;

	/* repeatingly start a program */
	int restart;
	char first;
	char do_diff;
	char **bcur, **bprev;
	int ncur, nprev;

	int initial_n_lines_tail;

	char colorize;
	char field_nr;
	char *field_del;
	int color_scheme;
	int color_index;

	char hidden;
	char follow_filename;
	char retry_open;

	time_t lastevent;
	double prev_deltat, total_deltat;
	double med;
	double dev;
	int n_events;

	NEWWIN *status;
	NEWWIN *data;

	int n_re;
	re *pre;

	int n_strip;
	strip_t *pstrip;

	struct _subwindow_ *next;
} proginfo;

typedef struct
{
	char **Blines;
	proginfo **pi;
	int curpos;
	char markset;
	int maxnlines;
} buffer;

typedef struct
{
	char *name;
	int n;
	int *color;
        regex_t *regex;
} color_scheme;

typedef struct
{
	int scheme_nr;
	regex_t	regex;
} scheme_per_file;

typedef struct
{
	regoff_t start;
	regoff_t end;
	int color_index;
} color_offset_in_line;

typedef struct
{
	char key;
	char *command;
} keybinding;

void do_exit(int sig);
char * select_file(char *input, int what_help);
char check_no_suppress_lines_filter(proginfo *cur);
void color_print(NEWWIN *win, proginfo *cur, unsigned char *string, regmatch_t *matches, int matching_regex);
int select_window(int what_help, char *heading);
void toggle_colors(void);
char check_filter(proginfo *cur, char *string, regmatch_t **pmatch, char **error, int *matching_regex, char do_re, char *display);
int wait_for_keypress(int what_help, int max_wait, NEWWIN *popup, char shift_cursor);

void LOG(char *str, ...);
