/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"


void show_paths(void)
{
    static int		 current;
    	   PATH    	*path;
    	   char    	*str;
    	   int      	 line, i, width, height, centre, wsize;

    width  = LEN_COL-4;
    height = 20;
    wsize  = height-2;
    centre = ((width-2)/2)-1;

    wresize(wMsg, height, width);
    werase(wMsg);
    move_panel(pMsg, 1, 2);

    if (panel_hidden(pMsg) == PANEL_HIDDEN)
	current = 0;

    for (line=1, i=0, path = settings->path_list; path; path = path->next) {
    	if (!path->name || !path->path)
            continue;

	i+=2;
	if (i < (current*wsize)+2)
	    continue;

        mvwprintw(wMsg, line++, 1, "Name: %s", path->name);
        mvwprintw(wMsg, line++, 1, "Path: %s", path->path);

	if (line >= wsize && path->next) {
	    current++;
	    break;
	}

	if (!path->next)	/* last one */
	    current = 0;
    }

    draw_border(wMsg);
    str = "Paths";
    mvwprintw(wMsg, 0, centre-strlen(str)/2, str);
    show_panel(pMsg);
    return;
}

PATH *new_path(bool last)
{
    PATH *path;

    if (!(path = (PATH *)malloc(sizeof(PATH))))
        return NULL;

    if (last && settings->path_list) {
        PATH *iPath;

        for (iPath = settings->path_list; iPath; iPath = iPath->next) {
            if (!iPath->next)
                break;
        }
        iPath->next = path;
        path->next  = NULL;
    }
    else {
    	path->next = settings->path_list;
    	settings->path_list = path;
    }

    path->name = NULL;
    path->path = NULL;

    return path;
}

void free_path(PATH *pPath)
{
    PATH *path;

    if (!pPath)
	return;

    for (path = settings->path_list; path; path = path->next) {
    	if (path->next == pPath) {
            path->next = pPath->next;
            break;
        }
    }

    if (pPath == settings->path_list)
        settings->path_list = pPath->next;

    if (pPath->name)
	free(pPath->name);
    if (pPath->path)
    	free(pPath->path);
    free(pPath);
}

bool process_path(char *pBuffer)
{
    static char  path[MAX_STRING];
	   char *pPath, *pTmp;
           char  temp[10];
	   int   count;

    pPath = path;
    while (*pBuffer) {
	count = 1;
	if (isdigit(*pBuffer)) {
    	    pTmp  = temp;
	    while (isdigit(*pBuffer))
		*pTmp++ = *pBuffer++;
	    *pTmp = '\0';
	    count = atoi(temp);
	}
	    
	switch (*pBuffer) {
	    case 'n':
	    case 'e':
	    case 's':
	    case 'w':
	    case 'u':
	    case 'd':
	    default:
		while (count--) {
		    *pPath++ = *pBuffer;
		    *pPath++ = '\n';
		}
		break;
	    case 'o':
		strcpy(pPath, "open ");
		pPath += 5;
	        if (*(pBuffer+1))
		    *pPath++ = *(++pBuffer);
		*pPath++ = '\n';
		break;
	    case '{':
		pBuffer = get_arg(pBuffer, pPath);
		pBuffer--; /* get_arg makes it point one too far for here */
		while (*pPath)
		    pPath++;
		*pPath++ = '\n';
		break;
	}
	if (!(*pBuffer++))
	    break;
    }	    
    *pPath = '\0';
		
    if (pPath != path) {
	process_input(path, NULL, FALSE);
	return TRUE;
    }

    return FALSE;
}
