/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <sys/time.h>
#include <ctype.h>
#include <stdio.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"

/* 
 * Locals
 */
FILE *fp_log = NULL;

/*
 * Externals
 */
extern time_t	current_time;

bool init_log(char *filename)
{
    if (fp_log) {
	do_status("Already logging!", 3);
	return FALSE;
    }
	
    strcat(filename, ".log");
    if (!(fp_log = fopen(filename, "a")))
	return FALSE;

    setbuf(fp_log, NULL);
    fprintf(fp_log, "%%%% STARTING NEW LOG, %s\n", ctime(&current_time));

    return TRUE;
} 

bool close_log(void)
{
    if (!fp_log) {
	do_status("Not logging yet.", 3);
	return FALSE;
    }

    fprintf(fp_log, "\n%%%% END OF LOG.\n");
    fclose(fp_log);
    fp_log = NULL;

    return TRUE;
}
	
void write_log(char *log_start, char *log_end)
{
    char *pLog = log_start;

    if (!fp_log)
	return;

    while (pLog < log_end) {
	if (*pLog == ESC) {
	    while (!isalpha(*pLog) && pLog < log_end)
		pLog++;
	}
	else if (*pLog == '\n' || isprint(*pLog))
	    fputc(*pLog, fp_log);

	pLog++;
    }  

    return;
}
