/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"

char *fread_string(FILE *fp) 
{
    static char  string[MAX_STRING];
           char *pStr = string;

    while ((*pStr++ = fgetc(fp)) != '~') 
	;
    *(pStr-1) = '\0';

    while (!feof(fp) && fgetc(fp) != '\n') 
	;

    return &string[0];
}

char *fread_to_eol(FILE *fp) 
{
    static char  string[MAX_STRING];
           char *pStr = string;

    while (!feof(fp) && (*pStr = fgetc(fp)) != '\n') {
	if (!isprint(*pStr))
	    continue;
	pStr++;
    }
    *pStr = '\0';

    return &string[0];
}

char *fread_word(FILE *fp) 
{
    static char  word[MAX_STRING];
           char *pWord = word;

    while (isprint((*pWord = fgetc(fp)))) {
	if (*pWord == ' ')
	    break;
	pWord++;
    }
    *pWord = '\0';

    return &word[0];
}
