#!/usr/bin/perl -w
#
# 14all.cgi
#
# create html pages and graphics with rrdtool for mrtg + rrdtool
#
# (c) 1999 Rainer.Bawidamann@informatik.uni-ulm.de
#
# use freely, but: NO WARRANTY - USE AT YOUR OWN RISK!

use lib '/home/rb1/lib/perl5';

# RCS History
#
# $Log: 14all.cgi,v $
# Revision 0.16  2000/01/12 14:59:48  rb1
# * added support for logarithmic graphs (userrdtool[..]: logarithmic)
#
# Revision 0.15  2000/01/11 17:28:17  rb1
# * use "options[^]: bits" like mrtg (aka legacy support part 316)
# * multiple column mode (userrdtool: columns: 2)
#
# Revision 0.14  2000/01/11 15:22:48  rb1
# * apply $factor to the usage percentage with options bits/perminute/perhour
#
# Revision 0.13  2000/01/10 17:25:33  rb1
# * clean up NT support
# * change config file parser: add 14all specific options
# * make cgi more flexible - part one: define graph params, disable small graphs
#
# Revision 0.12  2000/01/10 13:01:56  rb1
# * can use / as path delimiter on NT, revert older change ($SL)
#
# Revision 0.11  1999/12/21 09:57:29  rb1
# * added Unscaled functionality
#
# Revision 0.10  1999/11/10 14:32:22  rb1
# * another change to run with NT: use '\' as path delimiter when on NT
# * display percentage of 'maxbytes' in legend
#
# Revision 0.9  1999/10/26 14:57:53  rb1
# * changed options parsing
# * the graphics show now the same time interval as mrtg
# * design changes: "last updated..." (thx Matija Grabnar),
#   unknaszero (with rrdtool 1.0.8), GRID color is now black
# * allow multiple config files (thx David Frasch)
# * added binmode calls for NT (untested) (thx Hoorelbeke Rik)
#
# Revision 0.8  1999/09/27 08:03:13  rb1
# * set defaults for optional settings
# * use MAX rra for GPRINT...MAX when withpeak is set
#
# Revision 0.7  1999/09/23 13:09:31  rb1
# * removed manual midnight line for daily graph
#
# Revision 0.6  1999/09/23 12:23:35  rb1
# * don't do a lower-case on global options
# * icondir can be without a final /
# * print a helpful error message when called with wrong parameters
#   (this is a workaround, script should be more tolerante)
# * added kilo option
# * corrected withpeak option to work with perminute... and better legend
# * check workdir option
#
# Revision 0.5  1999/09/23 12:20:34  rb1
# * put under RCS control
#
#
# pre-RCS History
#
# 1999-08-19
#	* v0.1
#	* first release
# 1999-08-25
#	* v0.2
#	* recognizes more options: perhour, perminute, integer
#	* integrates fully in mrtg (-> 2.8.7) with "useRRDTool: Yes"-switch
# 1999-08-27
#	* v0.3
#	* added: "options[...]: bits"
#	* mrtg/rrd-patch runs without installed rrdtools perl module
# 1999-08-30
#	* v0.4
#	* added: "interval: ..."
#	* changed graphics a bit (idea from Alex van den Bogaerdt)
#	* v0.4.1
#	* added support for pseudo targets "^" and "$"
#	* added: "AddHead[...]: ..."
#	* added support for multiple config files (get cfgfile name from script name)

my $rcsid = '$Id: 14all.cgi,v 0.16 2000/01/12 14:59:48 rb1 Exp $';
my $version = join(' ', (split(/ /,$rcsid))[1,2]);
$version =~ s',v''; #'

use strict;
use CGI;

sub print_error(@);
sub read_mrtg_config();
sub intmax(@);
sub yesorno($);
sub get_graph_params($$);

my ($q, %targets, @sorted, %config, $cfgfile, $cfgfiledir, %options);
my ($cgidir, @author, @style);

### where the mrtg.cfg file is
# anywhere in the filespace
#$cfgfile = '/home/mrtg/mrtg.cfg';
# relative to the script
#$cfgfile = 'mrtg.cfg';
# use this so 14all.cgi gets the cfgfile name from the script name 
# (14all.cgi -> 14all.cfg)
$cfgfile = '';

# if you want to store your config files in a different place than your cgis:
$cfgfiledir = '';

### cusotmize the html pages
@author = ( -author => 'Rainer.Bawidamann@informatik.uni-ulm.de');
# one possibility to enable stylesheets (second is to use "AddHead[_]:..." in mrtg.cfg)
#@style = ( -style => { -src => 'general.css' });
###

# initialize CGI
$q = new CGI;
$q->import_names('CGI');

# look for the config file
my $meurl = $q->url();
if (defined $CGI::cfg) {
	$cfgfile = $CGI::cfg;
	$cfgfile = "$cfgfiledir/$cfgfile" unless -r $cfgfile;
	print_error("Cannot find the given config file: \<tt>$CGI::cfg\</tt>")
		unless -r $cfgfile;
} elsif (!$cfgfile) {
	$meurl =~ m|/([^/]*)\.cgi$|;
	$cfgfile = $1 . '.cfg';
	$cfgfile = "$cfgfiledir/$cfgfile" unless -r $cfgfile;
}

# read the config file
read_mrtg_config();
# fix some settings
#   make sure icondir ends with /
$config{icondir} .= "/" if $config{icondir} !~ m|/$|;
#   does the configured workdir exist?
#   (if no workdir is given we can use the actual dir)
if ($config{workdir} && ! -d $config{workdir}) {
	print_error($q->p("Cannot access the configured working directory, please check if the line"),
		$q->p($q->tt("Workdir: $config{workdir}")),
		$q->p("(in ",$q->tt($cfgfile),") is typed correctly."),
		$q->p("Remember: this is a path into the global filesystem, not a web server path"));
	exit 0;
}

my @headeropts = ( @author, @style, -bgcolor => $config{background} );

# the footer we print on every page
my $footer = <<"EOT";
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR>
    <TD WIDTH=63><A ALT="MRTG"
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-l.gif"></A></TD>
    <TD WIDTH=25><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-m.gif"></A></TD>
    <TD WIDTH=388><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-r.gif"></A></TD>
  </TR>
</TABLE>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR VALIGN=top>
  <TD WIDTH=88 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>Version 2.8.x-rrd</FONT></TD>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>
  <A HREF="http://ee-staff.ethz.ch/~oetiker/">Tobias Oetiker</A>
  <A HREF="mailto:oetiker\@ee.ethz.ch">&lt;oetiker\@ee.ethz.ch&gt;</A> and
  <A HREF="http://www.bungi.com">Dave&nbsp;Rand</A>&nbsp;
  <A HREF="mailto:dlr\@bungi.com">&lt;dlr\@bungi.com&gt;</A>
  <TR VALIGN=top>
  <TD WIDTH=88 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>$version</FONT></TD>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>
  <A HREF="http://www.uni-ulm.de/~rbawidam/">Rainer&nbsp;Bawidamann</A>&nbsp;
  <A HREF="mailto:rb1\@informatik.uni-ulm.de">&lt;rb1\@informatik.uni-ulm.de&gt;</A></FONT>
  </TD>
</TR>
</TABLE>
EOT
$footer .= $q->end_html;

### the main switch
# the modes:
# if parameter "dir" is given show a list of the targets in this "directory"
# elsif parameter "png" is given show a graphic for the target given w/ parameter "log"
# elsif parameter "log" is given show the page for this target
# else show a list of directories and of targets w/o directory
# parameter "cfg" can hold the name of the config file to use
if (defined $CGI::dir) {
	# show a list of targets in the given directory
	my @addhead;
	if ($targets{_}{addhead}) {
		@addhead = ( -head => "$targets{_}{addhead}" );
	}
	print $q->header(-expires => "+300s"), $q->start_html(
		-title => "MRTG/RRD - Group $CGI::dir",
		@headeropts,
		@addhead);
	print $q->h1("Available Targets"),"\n\<table width=100\%>\n";
	my $cfgstr = (defined $CGI::cfg ? "&cfg=$CGI::cfg" : '');
	my $column = 0;
	foreach my $tar (@sorted) {
		my $small = 0;
		if (yesorno($options{$tar}{indexgraph})) {
			$small = $options{$tar}{indexgraph};
		}
		next if $tar =~ m/^[\$\^\_]$/; # _ is not a real target
		next if $targets{$tar}{directory} ne $CGI::dir;
		print '<tr>' if $column == 0;
		print '<td>',
			$q->p($q->a({href => "$meurl?log=$tar$cfgstr"}, "$targets{$tar}{title}"));
		print $q->a({href => "$meurl?log=$tar$cfgstr"},
			$q->img({src => "$meurl?log=$tar&png=$small&small=1$cfgstr",alt => "index-graph"}))
			if $small;
		print "\</td>\n";
		$column++;
		if ($column >= $config{'columns'}) {
			$column = 0;
			print '</tr>';
		}
	}
	if ($column != 0 and $column < $config{'columns'}) {
		print '<td>&nbsp;</td>' x ($config{'columns'} - $column),"\</tr>\n";
	}
	print '</table>', $footer;
} elsif (defined $CGI::png) {
	# send a graphic, create it if necessary
	print_error("CGI call error") if (!defined $CGI::log);
	my ($start, $end, $maxage, $xs, $ys) = get_graph_params($CGI::log, $CGI::png);
	print_error("undefined graph") unless $start;

	my $workdir = "$config{workdir}";
	$workdir .= "/" unless $workdir =~ m|/$|;
	$workdir .= $targets{$CGI::log}{directory};
	$workdir .= "/" unless $workdir =~ m|/$|;
	my $rrd = "$workdir$CGI::log.rrd";
	# replace ':' by '\:' in $rrd (to avoid Skript error 'cant parse DEF')
	$rrd =~ s/:/\\:/;
	my $suffix = (defined $CGI::small ? '.s.png' : '.png');
	my $pngfile = "$workdir$CGI::log-$CGI::png$suffix";
	if (!-w $workdir) {
		# does NT have a default world-writable tmp dir ?
		my $tmpdir;
		if ($^O =~ m/Win/i) {
			$tmpdir = $ENV{'TEMP'};
			$tmpdir = $ENV{'TMP'} unless $tmpdir;
			$tmpdir = '' unless $tmpdir;
			$tmpdir .= '/' unless $tmpdir =~ m|/$|;
		} else {
			$tmpdir = '/tmp/';
		}
		$pngfile = $tmpdir."$CGI::log-$CGI::png$suffix";
	}
	
	require 'RRDs.pm'; # load RRDs.pm only when needed
	# build the rrd command line: set the starttime and the graphics format (PNG)
	my @args = ($pngfile, '-s', $start, '-e', $end, '-a', 'PNG');
	# if it's not a small picture set the legends
	my ($l1,$l2,$l3,$l4,$li,$lo) = ('','','','','','');
	my ($ri, $ro) = ('','');

	if (!defined $CGI::small) {
		if ($targets{$CGI::log}{ylegend}) {
			push @args, '-v', $targets{$CGI::log}{ylegend}; }
		if ($targets{$CGI::log}{xsize}) {
			push @args, '-w', $targets{$CGI::log}{xsize}; }
		if ($targets{$CGI::log}{ysize}) {
			push @args, '-h', $targets{$CGI::log}{ysize}; }
		if ($targets{$CGI::log}{legend1}) {
			$l1 = ":".$targets{$CGI::log}{legend1}."\\l"; }
		if ($targets{$CGI::log}{legend2}) {
			$l2 = ":".$targets{$CGI::log}{legend2}."\\l"; }
		if ($targets{$CGI::log}{legend3} ne '--CALC--') {
			$l3 = ":".$targets{$CGI::log}{legend3}."\\l";
		} else {
			$l3 = ":Maximal 5 Minute ".$targets{$CGI::log}{legend1}."\\l";
		}
		if ($targets{$CGI::log}{legend4} ne '--CALC--') {
			$l4 = ":".$targets{$CGI::log}{legend4}."\\l";
		} else {
			$l4 = ":Maximal 5 Minute ".$targets{$CGI::log}{legend2}."\\l";
		}
		if ($targets{$CGI::log}{legendi}) {
			$li = $targets{$CGI::log}{legendi}; }
		else {	$li = "In: "; }
		$li =~ s':'\\:'; # ' quote :
		if ($targets{$CGI::log}{legendo}) {
			$lo = $targets{$CGI::log}{legendo}; }
		else {	$lo = "Out:"; }
		$lo =~ s':'\\:'; # ' quote :
		if ($options{$CGI::log}{integer}) {
			$li = $li . ' %9.0lf';
			$lo = $lo . ' %9.0lf';
			$ri = '%3.0lf%%';
			$ro = '%3.0lf%%';
		} else {
			$li = $li . ' %8.3lf';
			$lo = $lo . ' %8.3lf';
			$ri = '%6.2lf%%';
			$ro = '%6.2lf%%';
		}
		if ($targets{$CGI::log}{kmg}) {
			$li = $li . ' %s';
			$lo = $lo . ' %s';
			if ($targets{$CGI::log}{kilo}) {
				push @args, '-b', $targets{$CGI::log}{kilo};
			}
		}
	} else {
		push @args, '-w', $xs, '-h', $ys;
	}
	my $pngchar = substr($CGI::png,0,1);
	if ($pngchar and $targets{$CGI::log}{unscaled} and
		   $targets{$CGI::log}{unscaled} =~ m/$pngchar/) {
		my $max = intmax($targets{$CGI::log}{maxbytes},
			$targets{$CGI::log}{maxbytes1},
			$targets{$CGI::log}{maxbytes2},
			$targets{$CGI::log}{absmax});
		push @args, '-l', 0, '-u', $max, '-r';
	} elsif (yesorno($options{$CGI::log}{'logarithmic'})) {
		push @args, '-o';
	}
	push @args,'--alt-y-grid','--lazy','-c','MGRID#ee0000','-c','GRID#000000';
	my $factor = 1; # should we scale the values?
	if ($options{$CGI::log}{perminute}) {
		$factor = 60; # perminute -> 60x
	} elsif ($options{$CGI::log}{perhour}) {
		$factor = 3600; # perhour -> 3600x
	}
	if ($options{$CGI::log}{bits}) {
		$factor *= 8; # bits instead of bytes -> 8x
	}
	# now build the graph calculation commands
	my ($ds0, $ds1) = ('in', 'out');
	push @args, "DEF:$ds0=$rrd:ds0:AVERAGE", "DEF:$ds1=$rrd:ds1:AVERAGE";
	### if you have rrdtool-1.0.8 (or a beta of it) uncomment the next lines
	# my $unkn_val = ($options{$CGI::log}{unknaszero} ? 0 : 'PREV');
	# push @args, "CDEF:uin=$ds0,UN,$unkn_val,$ds0,IF",
	#	"CDEF:uout=$ds1,UN,$unkn_val,$ds1,IF";
	# ($ds0, $ds1) = ('uin', 'uout');
	if ($factor > 1) {
		# scale the values. we need a CDEF for this
		push @args, "CDEF:fin=$ds0,$factor,*","CDEF:fout=$ds1,$factor,*";
		($ds0, $ds1) = ('fin', 'fout');
	}
	my $maximum0 = $targets{$CGI::log}{maxbytes1};
	$maximum0 = $targets{$CGI::log}{maxbytes} unless $maximum0;
	$maximum0 = 1 unless $maximum0;
	my $maximum1 = $targets{$CGI::log}{maxbytes2};
	$maximum1 = $targets{$CGI::log}{maxbytes} unless $maximum1;
	$maximum1 = 1 unless $maximum1;
	my ($ps0, $ps1) = ('pin', 'pout');
	push @args, "CDEF:pin=$ds0,$maximum0,/,100,*,$factor,/",
		"CDEF:pout=$ds1,$maximum1,/,100,*,$factor,/";
	# the commands to draw the values
	push @args, "AREA:$ds0#00cc00$l1", "LINE1:$ds1#0000ff$l2";
	my ($mx0, $mx1) = ($ds0, $ds1);
	my ($px0, $px1) = ($ps0, $ps1);
	# the commands for the peaks
	if (!defined $CGI::small && (substr($CGI::png,0,1) =~ /[$targets{$CGI::log}{withpeak} ]/)) {
		push @args, "DEF:min=$rrd:ds0:MAX", "DEF:mout=$rrd:ds1:MAX";
		($mx0, $mx1) = ('min', 'mout');
		### only with rrdtool-1.0.8
		# push @args, "CDEF:umin=$mx0,UN,$unkn_val,$mx0,IF",
		# 	"CDEF:umout=$mx1,UN,$unkn_val,$mx1,IF";
		# ($ds0, $ds1) = ('umin', 'umout');
		if ($factor > 1) {
			# scale the values. we need a CDEF for this
			push @args, "CDEF:fmin=$mx0,$factor,*","CDEF:fmout=$mx1,$factor,*";
			($mx0, $mx1) = ('fmin', 'fmout');
		}
		push @args, "LINE1:$mx0#006600$l3", "LINE1:$mx1#ff00ff$l4";
		push @args, "CDEF:pmin=$mx0,$maximum0,/,100,*,$factor,/",
			"CDEF:pmout=$mx1,$maximum1,/,100,*,$factor,/";
		($px0, $px1) = ('pmin', 'pmout');
	}
	if (!defined $CGI::small) {
		# print the legends
		if ($options{$CGI::log}{nopercent}) {
			push @args, "GPRINT:$mx1:MAX:Max $lo",
				"GPRINT:$ds1:AVERAGE:Average $lo",
				"GPRINT:$ds1:LAST:Current $lo\\l",
				"GPRINT:$mx0:MAX:Max $li",
				"GPRINT:$ds0:AVERAGE:Average $li",
				"GPRINT:$ds0:LAST:Current $li\\l";
		} else {
			push @args, "GPRINT:$mx1:MAX:Max $lo",
				"GPRINT:$px1:MAX:($ro)",
				"GPRINT:$ds1:AVERAGE:Average $lo",
				"GPRINT:$ps1:AVERAGE:($ro)",
				"GPRINT:$ds1:LAST:Current $lo",
				"GPRINT:$ps1:LAST:($ro)\\l",
				"GPRINT:$mx0:MAX:Max $li",
				"GPRINT:$px0:MAX:($ri)",
				"GPRINT:$ds0:AVERAGE:Average $li",
				"GPRINT:$ps0:AVERAGE:($ri)",
				"GPRINT:$ds0:LAST:Current $li",
				"GPRINT:$ps0:LAST:($ri)\\l";
		}
	}
	# fire up rrdtool
	# print STDERR "@args\n"; # debugging
	RRDs::graph(@args);
	my $e = RRDs::error();
	print_error("Cannot create graph: $e") if $e;
	# no error, try to send the file
	open(PNG, "<$pngfile") || print_error("Cannot read graph file (with @args)");
	# ok, send it as image/png
	print $q->header(-type => "image/png",
		-expires => "+${maxage}s",
		-refresh => $maxage);
	# NT needs this:
	binmode(PNG); binmode(STDOUT);
	my $buf;
	while(read PNG,$buf,4096) {
		print STDOUT $buf;
	}
	close PNG;
} elsif (defined $CGI::log) {
	# show the graphics for one target
	print_error ("Target $CGI::log unknown") if (!exists $targets{$CGI::log});
	my $title;
	# user defined title?
	if ($targets{$CGI::log}{title}) {
		$title = $targets{$CGI::log}{title};
	} else {
		$title = "MRTG/RRD - Target $CGI::log";
	}
	my @addhead;
	if ($targets{$CGI::log}{addhead}) {
		@addhead = ( -head => "$targets{$CGI::log}{addhead}" );
	}
	print $q->header(-expires => "+300s"), $q->start_html(
		-title => $title,
		@headeropts,
		@addhead);
	# user defined header line? (should exist as mrtg requires it)
	if (exists $targets{$CGI::log}{pagetop}) {
		print $targets{$CGI::log}{pagetop},"\n";
	} else {
		print $q->h1("Target $targets{$CGI::log}{title}"),"\n";
	}
	require 'RRDs.pm';
	my $lasttime = RRDs::last("$config{workdir}/$targets{$CGI::log}{directory}/${CGI::log}.rrd");
	print $q->hr,
		"The statistics were last updated: ",$q->b(scalar(localtime($lasttime))),
		$q->hr;
	my $sup = $targets{$CGI::log}{suppress};
	my $url = "$meurl?log=$CGI::log";
	$url .= "&cfg=$CGI::cfg" if defined $CGI::cfg;
	$url .= "&png";
	# the header lines and tags for the graphics
	if ($sup !~ /d/) {
		print $q->h2("'Daily' graph (5 Minute Average)"),"\n",
			$q->img({src => "$url=daily", alt => "daily-graph"}),
			"\n";
	}
	if ($sup !~ /w/) {
		print $q->h2("'Weekly' graph (30 Minute Average)"),"\n",
			$q->img({src => "$url=weekly", alt => "weekly-graph"}),
			"\n";
	}
	if ($sup !~ /m/) {
		print $q->h2("'Monthly' graph (2 Hour Average)"),"\n",
			$q->img({src => "$url=monthly", alt => "monthly-graph"}),
			"\n";
	}
	if ($sup !~ /y/) {
		print $q->h2("'Yearly' graph (1 Day Average)"),"\n",
			$q->img({src => "$url=yearly", alt => "yearly-graph"}),
			"\n";
	}
	print $footer;
} else {
	# no parameter - show a list of directories and targets without "Directory[...]" (aka root-targets)
	my @addhead;
	if ($targets{_}{addhead}) {
		@addhead = ( -head => "$targets{_}{addhead}" );
	}
	print $q->header(-expires => "+1d"), $q->start_html(
		-title => "MRTG/RRD $version",
		@headeropts,
		@addhead);
	my (@dirs, %dirs, @logs);
	# get the list of directories and "root"-targets
	foreach my $tar (@sorted) {
		next if $tar =~ m/^[_\$\^]$/; # pseudo targets
		if ($targets{$tar}{directory}) {
			next if exists $dirs{$targets{$tar}{directory}};
			$dirs{$targets{$tar}{directory}} = $tar;
			push @dirs, $targets{$tar}{directory};
		} else {
			push @logs, $tar;
		}
	}
	my $cfgstr = (defined $CGI::cfg ? "&cfg=$CGI::cfg" : '');
	print $q->h1("Available Targets"),"\n";
	if ($#dirs > -1) {
		print $q->h2("Directories"),"\n\<table width=100\%>\n";
		my $column = 0;
		foreach my $tar (@dirs) {
			print '<tr>' if $column == 0;
			print $q->td($q->a({href => "$meurl?dir=$tar$cfgstr"},
				"Group $tar")),"\n";
			$column++;
			if ($column >= $config{'columns'}) {
				$column = 0;
				print '</tr>';
			}
		}
		if ($column != 0 and $column < $config{'columns'}) {
			print '<td>&nbsp;</td>' x ($config{'columns'} - $column),"\</tr>\n";
		}
		print '</table><hr>';
	}
	if ($#logs > -1) {
		print $q->h2("Targets"),"\n\<table width=100\%>\n";
		my $column = 0;
		foreach my $tar (@logs) {
			my $small = 0;
			if (yesorno($options{$tar}{indexgraph})) {
				$small = $options{$tar}{indexgraph};
			}
			next if $tar =~ m/^[\$\^_]$/;
			next if $targets{$tar}{directory};
			print '<tr>' if $column == 0;
			print '<td>',
				$q->p($q->a({href => "$meurl?log=$tar$cfgstr"},"$targets{$tar}{title}"));
			print $q->a({href => "$meurl?log=$tar$cfgstr"},
				$q->img({src => "$meurl?log=$tar&png=$small&small=1$cfgstr",alt => "index-graph"}))
				if $small;
			print "\</td>\n";
			$column++;
			if ($column >= $config{'columns'}) {
				$column = 0;
				print '</tr>';
			}
		}
		if ($column != 0 and $column < $config{'columns'}) {
			print '<td>&nbsp;</td>' x ($config{'columns'} - $column),"\</tr>\n";
		}
		print '</table>';
	}
	print $footer;
}
exit 0;

sub build_value($$) {
	my ($opt, $cval) = @_;
	my $val = ($targets{'^'}{$opt} ? $targets{'^'}{$opt}.' ' : '')
		. $cval
		. ($targets{'$'}{$opt} ? ' '.$targets{'$'}{$opt} : '');
	return $val;
}

# read the mrtg.cfg file
sub read_mrtg_config()
{
	my ($opt, $tar, $val);
	my $line = '';
	my @lines;
	open(CFG, "<$cfgfile") || print_error("Cannot open config file");
	while(<CFG>) {
		chomp;		# remove newline
		s/\s+$//g;	# remove trailing space
		s/\s/ /g;	# collapse white space to one space
		next if /^ *\#/;# ignore comment lines
		next if /^ *$/;	# ignore empty lines
		if (/^ +(.*)$/) {	# continuation lines
			$lines[$#lines] .= "\n".$1;
		} else {
			push @lines, $_;
		}
	}
	close CFG;
	# set some defaults
	my %defaults = (
		directory => '',
		suppress => '',
		interval => 5,
		xsize => 400,
		ysize => 100,
		withpeak => '',
		ylegend => 'Bytes per Second',
		legend1 => 'Incoming Traffic in Bytes per Second',
		legend2 => 'Outgoing Traffic in Bytes per Second',
		legend3 => '--CALC--',
		legend4 => '--CALC--',
		legendi => 'In: ',
		legendo => 'Out:',
		kmg => ',k,M,G,T,P',
		kilo => 1000,
		);
	my %defoptions = (
		'indexgraph' => 'daily.s',
		'graph daily.s' => '-1250m   now    300',
		'graphsize daily.s' => '250 100',
		'graphsize' => '400 100',
		'graph daily' => '-2000m   now    300',
		'graph weekly' => '-12000m  now   1800',
		'graph monthly' => '-800h    now   7200',
		'graph yearly' => '-400d    now  86400',
		'logarithmic' => 'no',
		);
	%config = (
		writeexpires => 'No',
		background => '#ffffff',
		interval => 5,
		icondir => '',
		columns => 1,
		);
	%{$options{_}} = %defoptions;
	%{$targets{_}} = %defaults;
	%{$targets{'$'}} = (); # prepend and append 'targets' are empty by default
	%{$targets{'^'}} = ();
	foreach (@lines) {
		if (/^([\d\w]+)\[(\S*)\] *: *(.*)$/s) {
			# a target config line
			($tar, $opt, $val) = (lc($2), lc($1), $3);
			$val = '' if !defined $val; # get around undef values
			if (!exists $targets{$tar}) {
				# first occurance of a target, copy defaults
				# (don't need to check for '_' as this exists in any case)
				push @sorted, $tar;
				foreach my $k (keys %{$targets{_}}) {
					$targets{$tar}{$k} = build_value($k, $targets{_}{$k});
				}
				%{$options{$tar}} = %{$options{_}};
				# copy options from ^ and $ (thx to Mike Fisher)
				map {$options{$tar}{$_} = 1}
					(keys %{$options{'^'}}, keys %{$options{'$'}});
				# set a default title if none given
				# (shouldn't happen as mrtg requires a title)
				$targets{$tar}{'title'} = $tar;
			}
			if ($tar eq '_' && $val eq '') {
				# a line "Command[_]:", resets default
				if ($defaults{$opt}) {
					# there is a default for this, set it
					$targets{'_'}{$opt} = $defaults{$opt};
				} else {
					# no default, delete from _
					delete $targets{'_'}{$opt};
				}
			} elsif ($opt eq 'options') {
				# "Options[...]: " - add values to a set of options
				# not sure about this: mrtg allows only one "Options" line,
				# so the defaults should probably be replaced not merged
				$val = lc($val);
				map {$options{$tar}{$_} = 1} split(/[,\s]+/, $val);
			} elsif ($tar eq '$' || $tar eq '^') {
				$targets{$tar}{$opt} = $val;
			} else {
				# "Command[...]: ..."
				$targets{$tar}{$opt} = build_value($opt, $val);
			}
			next;
		} elsif (/^([\d\w]+) *: *(.*)$/s) {
			# global option
			($tar, $opt, $val) = (undef, lc($1), $2);
			$config{$opt} = $val;
			next;
		}
		$_ =~ s/</&gt;/g;
		print STDERR scalar(localtime())," MRTG/RRD 14all.cgi: unknown field in mrtg.conf '$_'\n";
	}
	foreach $tar (keys %targets) {
		next if $tar eq '_';
		# we need to replace '&nbsp;' in the legends as we print them via rrdtool
		foreach $opt (qw/legend1 legend2 legend3 legend4 legend5 legendi legendo ylegend shortlegend/) {
			if (exists $targets{$tar}{$opt}) {
				$targets{$tar}{$opt} =~ s'&nbsp;' ';   #'
				$targets{$tar}{$opt} =~ tr/\n/ /;
			}
		}
		# add settings from userrdtool[...] to options
		if (exists $targets{$tar}{'userrdtool'}) {
			foreach my $line (split(/\n/, $targets{$tar}{'userrdtool'})) {
				if (index($line, ':') > 0) {
					# line contains a ':'
					($opt, $val) = ($line =~ m/^([^,]+) *: *(.*)$/);
					$options{$tar}{$opt} = $val;
				} else {
					# no ':' just notice it's there
					$options{$tar}{$line} = 1;
				}
			}
		}
	}
	# add settings from userrdtool to config
	if (exists $config{'userrdtool'}) {
		foreach my $line (split(/\n/, $config{'userrdtool'})) {
			if (index($line, ':') > 0) {
				# line contains a ':'
				($opt, $val) = ($line =~ m/^([^:]+) *: *(.*)$/);
				$config{$opt} = $val;
			} else {
				# no ':' just notice it's there
				$config{$line} = 1;
			}
		}
	}
}

sub print_error(@)
{
	print $q->header, $q->start_html(
		-title => 'MRTG/RRD index.cgi - Skript error',
		@author,
		-bgcolor => "#ffffff"),
		$q->h1('Skript Error'),
		@_, $q->end_html;
	exit 0;
}

sub intmax(@)
{
	my (@p) = @_;
	my $max = 0;
	foreach my $n (@p) {
		$max = int($n) if defined $n and int($n) > $max;
	}
	$max;
}

sub yesorno($)
{
	my $opt = shift;
	if (!defined $opt
		or $opt =~ /^\s*(no?)|(false)|(0)\s*$/i) {
			return 0;
	}
	return 1;
}

sub get_graph_params($$)
{
	my ($tar, $graph) = @_;
	my ($start, $end, $maxage, $xs, $ys);
	if ($options{$tar}{"graph $graph"}) {
		($start, $end, $maxage) = split / +/, $options{$tar}{"graph $graph"};
	} elsif ($options{_}{"graph $graph"}) {
		($start, $end, $maxage) = split / +/, $options{_}{"graph $graph"};
	}
	if ($options{$tar}{"graphsize $graph"}) {
		($xs, $ys) = split / +/, $options{$tar}{"graphsize $graph"};
	} elsif ($options{_}{"graphsize $graph"}) {
		($xs, $ys) = split / +/, $options{_}{"graphsize $graph"};
	} elsif ($options{_}{"graphsize"}) {
		($xs, $ys) = split / +/, $options{_}{"graphsize"};
	}
	($start, $end, $maxage, $xs, $ys);
}
