/*
 * $Id: route_util.c,v 1.6 1999/04/27 01:14:10 masaki Exp $
 */

#include <mrt.h>

#ifdef notdef
Route *New_Route (u_char *dest, int bitlen, void *attr)
{
   Route *tmp = New (Route);
   
   tmp->prefix = New_Prefix (AF_INET, dest, bitlen);
   tmp->attr = attr;
   return (tmp);
}
#endif

char *
proto2string (int proto)
{
    static char *string;

    switch (proto) {
    case PROTO_STATIC:
	string = "static";
	break;
    case PROTO_CONNECTED:
	/* string = "direct"; */
	string = "connected";
	break;
    case PROTO_KERNEL:
	string = "kernel";
	break;
    case PROTO_RIP:
	string = "rip";
	break;
    case PROTO_BGP:
	string = "bgp";
	break;
    case PROTO_RIPNG:
	string = "ripng";
	break;
    case PROTO_OSPF:
	string = "ospf";
	break;
    default:
	string = "unknown";
	break;
    }
    return (string);
}


char *s_origins[] = {"IGP", "EGP", "INCOMPLETE", "AGGREGATE"};
char c_origins[] = {'i', 'e', '?', 'a'};
const char *origin2string (int origin) { return (s_origins[origin]); }
const int origin2char (int origin) { return (c_origins[origin]); }


static char *
s_bgp_attr_type[] = {
    "INVALID",
    "ORIGIN",
    "ASPATH", /* AS_PATH in RFC */
    "NEXT_HOP",
    "MULTI_EXIT_DISC",
    "LOCAL_PREF",
    "ATOMIC_AGGREGATE",
    "AGGREGATOR",
    "COMMUNITY",
    "ORIGINATOR_ID",
    "CLUSTER_LIST",
    "DPA",
    "ADVERTISER",
    "RCID_PATH",
    "MPREACHNLRI",
    "MPUNRNLRI",
};


char *
bgptype2string (int type)
{
    if (type >= 0 && type <= PA4_TYPE_KNOWN_MAX)
	return (s_bgp_attr_type[type]);
    return (s_bgp_attr_type[0]);
}


int
string2bgptype (char **str)
{
    int i;

    for (i = 0; i <= PA4_TYPE_KNOWN_MAX; i++) {
	int len = strlen (s_bgp_attr_type[i]);
	if (strncasecmp (s_bgp_attr_type[i], *str, len) == 0) {
	    *str += len;
	    return (i);
	}
    }
    return (-1);
}

