/*
 * $Id: compat.c,v 1.2 1998/09/15 17:09:39 masaki Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>

#include <config.h>

#ifndef HAVE_MEMMOVE
char *
memmove (char *dest, const char *src, size_t n)
{

    if (n <= 0 || dest == src)
	return (dest);
    if (dest > src && dest < src + n) {
	/* copy from backward */
	while (n--)
	    ((char *)dest)[n] = ((char *)src)[n];
    }
    else {
	register int i;
	for (i = 0; i < n; i++)
	    ((char *)dest)[i] = ((char *)src)[i];
    }
    return (dest);
}
#endif /* HAVE_MEMMOVE */

