/*
 * $Id: ripng.h,v 1.9 1998/12/21 07:07:04 masaki Exp $
 */

#ifndef _RIPNG_H
#define _RIPNG_H


#include <config.h>
#ifdef HAVE_IPV6
#include <linked_list.h>
#include <trace.h>
#include <timer.h>
#include <schedule.h>
#include <hash.h>

#include <mrt.h>
#include <proto.h>
#include <interface.h>
#include <rib.h>

#define RIPNG_DEFAULT_PORT	521
#define RIPNG_IPV6_PRIORITY	(7<<24)

#define RIPNG_MIN_BUFSIZE ((INTERFACE_MASTER->max_mtu > 8 * 1024) ? \
                            INTERFACE_MASTER->max_mtu : 8 * 1024)

#define RIPNG_REQUEST     1
#define RIPNG_RESPONSE    2

#define RIPNG_VERSION	1

void ripng_init (void);
void ripng_interface (rip_interface_t *rip_interface, int on);
void ripng_send_request (rip_interface_t *rip_interface, 
			 LINKED_LIST * ll_prefixes);
void ripng_send_routes (rip_interface_t * rip_interface, 
			struct sockaddr_in6 *host, int change);
int ripng_init_listen (interface_t *interface);
void ripng_receive_update (rip_interface_t *rip_interface);

extern rip_t *RIPNG;

#endif /* HAVE_IPV6 */
#endif /* _RIPNG_H */
