/*
 * $Id: rip.h,v 1.12 1999/04/27 01:12:54 masaki Exp $
 */

#ifndef _RIP_H
#define _RIP_H

#include <config.h>
#include <linked_list.h>
#include <trace.h>
#include <timer.h>
#include <schedule.h>
#include <hash.h>

#include <mrt.h>
#include <proto.h>
#include <interface.h>
#include <rib.h>

#define RIP_DEFAULT_PORT	520
#define RIP_MAX_PDU		512

#define RIP_REQUEST	1
#define RIP_RESPONSE	2

/* #define RIP_VERSION  1 */
#define RIP_VERSION     2       /* support RIP-2 only (no compatible mode) */

#undef RIP_POISONED_REVERSE	/* define if poisoned reverse */

#if 0				/* test */
#define RIP_TIMEOUT_INTERVAL	60
#define RIP_GARBAGE_INTERVAL	40
#define RIP_UPDATE_INTERVAL	15
#else
#define RIP_TIMEOUT_INTERVAL	180
#define RIP_GARBAGE_INTERVAL	120	/* after timeout */
#define RIP_UPDATE_INTERVAL	30
#endif
#define RIP_START_DELAY		5	/* delay after enabled */
#define RIP_TABLE_HASH_SIZE	1023	/* hash size of the routing table */
#define RIP_METRIC_INFINITY	16

/* These values come from gated */
#define RIP_FLASH_DELAY_MIN 1
#define RIP_FLASH_DELAY_MAX 5

typedef struct _rip_interface_t {
    interface_t *interface;
    int dlist_in;    /* list num for input filtering */
    int dlist_out;   /* list num for output filtering */
    int metric_in;              /* input metric */
    int metric_out;             /* output metric */
    int default_pref;
    int sockfd;
} rip_interface_t;

typedef struct _dlist_t {
    int num;
    int out;  /* 0 -- in, 1 -- out */
    interface_t *interface;
} dlist_t;

typedef struct _rip_t {
    int proto;			/* PROTO_RIP or PROTO_RIPNG */
    inteface_bitset_t interface_mask;	/* mask of interfaces ripng is configed for */
    HASH_TABLE *hash;		/* hash of prefixes */
    trace_t *trace;

    /* rib_update_route_t update_call_fn; */
    u_long redistribute_mask;
    schedule_t *schedule;
    mtimer_t *timer;		/* timer used for sending update */
    mtimer_t *age;		/* aging routes */
    mtimer_t *flash;		/* flash update */

    LINKED_LIST *ll_networks;	/* prefix */
    LINKED_LIST *ll_networks2;	/* interface name */
    LINKED_LIST *ll_dlists;	/* distribute-list */
    LINKED_LIST *ll_rip_interfaces;	/* enabled rip interface */
    rip_interface_t *rip_interfaces[MAX_INTERFACES];
    int sockfd;
    int port; /* host byte order */

    int flash_update_waiting;
} rip_t;

typedef struct _rip_attr_t {
    int type;
    u_long ref_count;
    nexthop_t *nexthop;
    gateway_t *gateway;
    u_long tag;

    int metric;
    int pref;
    time_t ctime;		/* time created */
    time_t utime;		/* time updated */
    time_t dtime;		/* time started deletion process */
} rip_attr_t;

typedef struct _rip_route_t {
    u_long flags;
    prefix_t *prefix;
    rip_attr_t *active;
    rip_attr_t *current;
    LINKED_LIST *received;
    LINKED_LIST *imported;
} rip_route_t;

/* route flags */
#define RT_RIP_CHANGE	0x1
#define RT_RIP_DELETE	0x2

extern rip_t *RIP2;
extern rip_t *RIPNG;

/* user settable attributes */
enum RIP_ATTR {
    RIP_NULL = 0,
    RIP_TRACE_STRUCT,
    RIP_RT_UPDATE_FN,		/* function to call when ripng routes change */
    RIP_USE_PORTSERVER		/* use portserver library for listening */
};


/* public functions */

int rip_init (int proto, trace_t * trace);
void rip_start (int proto, int port);
void rip_stop (int proto);
int rip_policy (rip_t * rip, prefix_t * prefix, rip_attr_t * attr,
		rip_interface_t * out);
void rip_set (int proto, int first,...);
void rip_interface_recheck (rip_t *rip);
void rip_distribute_list_recheck (rip_t *rip);
rip_attr_t *rip_new_attr (rip_t * rip, int metric);
void rip_del_attr (rip_attr_t * attr);
void rip_process_update (rip_t * rip, LINKED_LIST * ll_prefixes,
			LINKED_LIST * ll_attr);
void rip_schedule_receive_update (rip_t * rip);
void rip_update_route (prefix_t * prefix, generic_attr_t * new,
		      generic_attr_t * old, int pref);
int rip_show (int proto, uii_connection_t * uii);
int rip_show_routing_table (int proto, uii_connection_t * uii, char *ifname);

void rip2_redistribute_request (int from, int on);
void ripng_redistribute_request (int from, int on);

/* from rip2.c */
void rip2_interface (rip_interface_t *rip_interface, int on);
void rip2_send_request (rip_interface_t *rip_interface, 
			LINKED_LIST * ll_prefixes);
void rip2_send_routes (rip_interface_t * rip_interface, 
		       struct sockaddr_in *host, int change);
int rip2_init_listen (prefix_t *prefix);
void rip2_receive_update (rip_interface_t *rip_interface);

extern rip_t *RIP;

#ifdef HAVE_IPV6
#include <ripng.h>
#endif /* HAVE_IPV6 */

#endif /* _RIP_H */
