/*
 * $Id: protoconf.h,v 1.3 1999/04/27 01:12:52 masaki Exp $
 */

#ifndef _CONFIG_MRTD_H
#define _CONFIG_MRTD_H

#include <mrt.h>

typedef struct _config_mrtd_t {
    int line;			/* when parsing file, current lineno */
/* I'm not sure the following are used */
    int sockfd;			/* socket if being configured by user */
    /* int state; */		/* router, interface, etc */
    int instance;		/* protocol, or interface number */
    int negate;			/* command prefeced by a "no" */
    route_map_t *route_map;
    interface_t *interface;	/* umm, not interface number ... */
    LINKED_LIST *ll_interfaces;
    LINKED_LIST *ll_static_routes;
    time_t dump_route_time;
    time_t dump_route_last;
    char *dump_route_form;
    time_t dump_update_time;
    time_t dump_update_last;
    char *dump_update_form;
    int protocol;
} config_mrtd_t;

typedef struct _static_route_t {
    prefix_t *prefix;
    prefix_t *nexthop;
    interface_t *interface;
    int pref;
} static_route_t;

extern config_mrtd_t *CONFIG_MRTD;       /* from config.c */
extern int BGPSIM_TRANSPARENT;

void check_passwd ();
int show_rib_routes ();
int show_rib_status ();
int show_rip_routing_table ();
#ifdef HAVE_IPV6
void show_ripng ();
int show_ripng_routing_table ();
#endif /* HAVE_IPV6 */

int show_threads ();
int show_view ();
int process_bgp_update ();

int init_mrtd_config (trace_t * trace);
void config_create_default ();

int rip_debug (uii_connection_t * uii);
int bgp_debug (uii_connection_t * uii);
#ifdef notdef
#ifdef HAVE_IPV6
int ripng_debug (uii_connection_t * uii);
#endif /* HAVE_IPV6 */
#endif

int config_router_network_prefix (uii_connection_t * uii, prefix_t *prefix);
int config_router_network_name (uii_connection_t * uii, char *name);
int config_router_network_interface (uii_connection_t * uii, char *name);
int config_redistribute (uii_connection_t * uii, char *proto);
int no_config_redistribute (uii_connection_t * uii, char *proto_string);

void config_bgp_init (void);
void config_rtmap_init (void);
void config_rip_init (void);
int string2proto (char *proto_string);

int load_rib_from_disk (char *filename);
int load_f_bgp_routes (char *filename, int this_family_only);

#endif /* _CONFIG_MRTD_H */

