/*
 * $Id: interface.h,v 1.10 1999/04/29 18:39:42 quichem Exp $
 */

#ifndef _INTERFACE_H
#define _INTERFACE_H

/* Some of this code taken from Berkely routed software */

#include <mrt.h>
#include <trace.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>

#ifdef SOLARIS
#include <sys/sockio.h>
#endif

typedef struct _ll_addr_t {
    prefix_t *prefix;		/* interface addresess */
    prefix_t *broadcast;	/* destination or broadcast address
				   broadcast address is defined in case of v4
				   prefixlen will be ignored */
} ll_addr_t;

#define IFF_TUNNEL  0x80000000  /* tunnel interface (special treatment
                                   when adding a route into the kernel) */
#define MAX_INTERFACES 256
typedef struct _inteface_bitset_t {
        bitx_mask_t bits[(MAX_INTERFACES+BITX_NBITS-1)/BITX_NBITS];
} inteface_bitset_t;

typedef struct _interface_t {
#ifdef notdef
    u_long bit;			/* each interface assigned a unique bit */
#endif
    u_long flags;		/* interface flags (from the ioctl) */
    int mtu;			/* interface mtu (from the ioctl) */
    char name[IFNAMSIZ + 1];
    int index;			/* index number */

#ifdef notdef
/* the followings are RIP and RIPng deppendent */
    int dlist_in[PROTO_MAX];	/* list num for input filtering */
    int dlist_out[PROTO_MAX];	/* list num for output filtering */
    int metric_in;		/* input metric */
    int metric_out;		/* output metric */
    int default_pref;
#ifdef HAVE_IPV6
    int default_pref6;
#endif /* HAVE_IPV6 */
#endif /* notdef */

    LINKED_LIST *ll_addr;	/* address list */
    ll_addr_t *primary;		/* primary address for ipv4 */
#ifdef HAVE_IPV6
    ll_addr_t *primary6;	/* primary address for ipv6 (global) */
    ll_addr_t *link_local;	/* ipv6 link local address */
#endif /* HAVE_IPV6 */

} interface_t;


typedef struct _interface_master_t {
    int number;		/* number of interfaces */
    interface_t *default_interface;
#ifdef HAVE_IPV6
    interface_t *default_interface6;
#endif				/* HAVE_IPV6 */
    trace_t *trace;
    LINKED_LIST *ll_interfaces;	/* IPv4 & v6 Interfaces */
    int max_mtu;		/* maximum MTU */
    interface_t *index2if[MAX_INTERFACES];
    int sockfd;			/* general purpose socket (v4) */
    int sockfd6;		/* general purpose socket (v6) */
    pthread_mutex_t mutex_lock;
} interface_master_t;

extern interface_master_t *INTERFACE_MASTER;

/* public functions */
interface_t *new_interface (char *name, u_long flags, int mtu, int index);
interface_t *add_addr_to_interface (interface_t * interface, int family,
				    void *addr, int len, void *broadcast);
interface_t *update_addr_of_interface (int cmd,
                          interface_t * interface, int family,
                          void *addr, int bitlen, void *broadcast);
int read_interfaces ();

interface_t *find_interface (prefix_t * prefix);
interface_t *find_interface_flags (prefix_t * prefix, u_long flags);
interface_t *find_interface_byname (char *name);
LINKED_LIST *find_interface_byname_all (char *name);
interface_t *find_interface_byindex (int index);
interface_t *find_interface_local (prefix_t * prefix);
LINKED_LIST *find_network (prefix_t * prefix);
interface_t *local_interface (int familly, void *cp);
int is_prefix_on (prefix_t *prefix, interface_t *interface);
int init_interfaces (trace_t * ltrace);

int show_interfaces (uii_connection_t *uii);
int mask2len (void *mask, int bytes);
u_char *len2mask (int bitlen, void *mask, int bytes);

void kernel_update_route (prefix_t *dest, 
			  generic_attr_t *new_attr, generic_attr_t *old_attr, int pref);
int sys_kernel_update_route (prefix_t *dest,
                         prefix_t *next_hop, prefix_t *old_hop, 
			 int index, int oldindex);
int kernel_init (void);
void kernel_read_rt_table (int seconds);
int sys_kernel_read_rt_table (void);
int add_kernel_route (int family, void *dest, void *nhop, int masklen, 
		      int index);
int update_kernel_route (int cmd, int family, void *dest, void *nhop, 
			 int masklen, int index, int proto);
char *print_iflags (char *tmpx, int len, u_long flags);
void add_interfaces_to_rib (void);

#endif /* INTERFACE_H */
