/*
 * $Id: defs.h,v 1.3 1999/04/27 01:12:46 masaki Exp $
 */

#ifndef _DEFS_H
#define _DEFS_H

#define MAXLINE		1024

#define BIT_SET(f, b)   ((f) |= b)
#define BIT_RESET(f, b) ((f) &= ~(b))
#define BIT_FLIP(f, b)  ((f) ^= (b))
#define BIT_TEST(f, b)  ((f) & (b))
#define BIT_MATCH(f, b) (((f) & (b)) == (b))
#define BIT_COMPARE(f, b1, b2)  (((f) & (b1)) == b2)
#define BIT_MASK_MATCH(f, g, b) (!(((f) ^ (g)) & (b)))

typedef unsigned long bitx_mask_t;
#define BITX_NBITS (sizeof (bitx_mask_t) * 8)

#define BITX_SET(p, n) ((p)->bits[(n)/BITX_NBITS] |= \
                            ((unsigned)1 << ((n) % BITX_NBITS)))
#define BITX_RESET(p, n) ((p)->bits[(n)/BITX_NBITS] &= \
                            ~((unsigned)1 << ((n) % BITX_NBITS)))
#define BITX_TEST(p, n) ((p)->bits[(n)/BITX_NBITS] & \
                            ((unsigned)1 << ((n) % BITX_NBITS)))

#ifndef byte
#define byte u_char
#endif

#if defined(_XOPEN_SOURCE) && (_XOPEN_SOURCE_EXTENDED - 1 == 0)
typedef unsigned char	u_char;
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned long	u_long;
#endif /* defined(_XOPEN_SOURCE) && (_XOPEN_SOURCE_EXTENDED - 1 == 0) */


#endif /* _DEFS_H */

