/*
 LiquidClient (C)QPL Daniel M. Duley 2001-2002. All rights reserved.
 */

#ifndef __LIQUID_CLIENT_H
#define __LIQUID_CLIENT_H
#include <qvariant.h>
#include <qtimer.h>
#include "client.h"
#include "kwinbutton.h"
class QLabel;
class QSpacerItem;


namespace KWinInternal {

class FrameSet
{
public:
    FrameSet(const QString &embed_name, const QColor &activeBtnColor,
             const QColor &inactiveBtnColor, const QColor &activeBackground,
             const QColor &inactiveBackground);
    ~FrameSet();
    QPixmap* frame(bool active, int i)
    {return(i >= 0 && i < 5 ? active ? activeFrames[i] : inactiveFrames[i] : 0);}
    QPixmap* normalFrame(bool active){return(active ? activeFrames[2] : inactiveFrames[2]);}
    QPixmap* sunkenFrame(bool active){return(active ? activeFrames[0] : inactiveFrames[0]);}
protected:
    QPixmap *activeFrames[5];
    QPixmap *inactiveFrames[5];
};

class FrameToolButton : public KWinInternal::KWinToolButton
{
    Q_OBJECT
public:
    FrameToolButton(FrameSet *frameSet, bool isActive,
                    const unsigned char *bitmap,
                    const unsigned char *sunken_bitmap=0,
                    QWidget *parent=0,
                    const char *name=0, const QString &tip=0,
                    bool sticky=false, bool max=false);
    ~FrameToolButton();
    void setActiveButton(bool on);
    void reset(FrameSet *frameSet, bool active);
protected slots:
    void slotFrameTimer();
protected:
    void paintEvent(QPaintEvent *ev);

    QTimer timer;
    int currentFrame;
    FrameSet *frames;
    QBitmap *mainBmp, *pressedBmp;
    QPixmap *buffer;
    bool active, ascending;
    bool isSticky, isMax;
};

class MenuToolButton : public KWinInternal::KWinToolButton
{
public:
    MenuToolButton(QWidget *parent=0, const char* name=0, const QString &tip=0)
        : KWinToolButton(parent, name, tip)
        {setBackgroundMode(NoBackground); menuPix = NULL;}
    MenuToolButton::~MenuToolButton(){;}
    void setPixmap(QPixmap *pix){menuPix=pix; repaint(false);}
protected:
    void paintEvent(QPaintEvent *ev);

    QPixmap *menuPix;
};


class LiquidClient : public KWinInternal::Client
{
    Q_OBJECT
public:
    LiquidClient( Workspace *ws, WId w, QWidget *parent=0, const char *name=0 );
    ~LiquidClient();
protected:
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );

    void mouseDoubleClickEvent( QMouseEvent * );
    void init();
    void captionChange( const QString& name );
    void iconChange();
    void maximizeChange( bool );
    void stickyChange( bool );
    void activeChange( bool );

private slots:
    void menuButtonPressed();
    void maxButtonClicked( int );
    void slotReset();

private:
    MenuToolButton* menuButton;
    FrameToolButton* button[4];
    QSpacerItem *titlebar;
    QPixmap *menuTmpPix; // MyToolButton takes pointers
    QPixmap *tbBuffer;
    int bn;
};

class LiquidToolClient : public Client
{
    Q_OBJECT
public:
    LiquidToolClient( Workspace *ws, WId w, QWidget *parent=0, const char *name=0 );
    ~LiquidToolClient();
protected:
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );

    void mouseDoubleClickEvent( QMouseEvent * );
    void init();
    void captionChange( const QString& name );
    void activeChange( bool );

private slots:
    void slotReset();
private:
    FrameToolButton *closeBtn;
    QSpacerItem* titlebar;
};

/*
  Like QToolButton, but provides a clicked(int) signals that
  has the last pressed mouse button as argument
 */
class FrameThreeButtonButton: public FrameToolButton
{
    Q_OBJECT
public:
    FrameThreeButtonButton(FrameSet *frameSet, bool isActive,
                           const unsigned char *bitmap,
                           const unsigned char *sunken_bitmap=0,
                           QWidget *parent=0,
                           const char *name=0, const QString &tip=0,
                           bool sticky=false, bool max=false)
    : FrameToolButton(frameSet, isActive, bitmap, sunken_bitmap,
                      parent, name, tip, sticky, max)
    {
	connect( this, SIGNAL( clicked() ), this, SLOT( handleClicked() ) );
    }
    ~FrameThreeButtonButton () {}

signals:
    void clicked( int );

protected:
    void mousePressEvent( QMouseEvent* e )
    {
	last_button = e->button();
	QMouseEvent me ( e->type(), e->pos(), e->globalPos(), LeftButton, e->state() );
	FrameToolButton::mousePressEvent( &me );
    }

    void mouseReleaseEvent( QMouseEvent* e )
    {
	QMouseEvent me ( e->type(), e->pos(), e->globalPos(), LeftButton, e->state() );
	FrameToolButton::mouseReleaseEvent( &me );
    }

private slots:
    void handleClicked()
    {
	emit clicked( last_button );
    }

private:
    int last_button;

};

};

#endif
