/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>

#include "sqliteInt.h"
#include "parse.h"
#line 56 "parse.y"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 249
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Select* yy43;
  TriggerStep* yy75;
  struct LimitVal yy84;
  struct LikeOp yy86;
  Expr * yy158;
  Token yy178;
  struct {int value; int mask;} yy207;
  ExprList* yy242;
  int yy316;
  IdList* yy352;
  struct TrigEvent yy354;
  SrcList* yy419;
  Expr* yy450;
  int yy497;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 587
#define YYNRULE 312
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy497
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   289,  900,  121,  586,  205,  169,    2,  435,   61,   61,
 /*    10 */    61,   61,  435,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  230,  198,  299,  420,  426,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  230,
 /*    40 */    67,  447,   69,  151,  230,   60,   59,  294,  430,  431,
 /*    50 */   427,  427,   62,   62,   61,   61,   61,   61,  411,   63,
 /*    60 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  230,
 /*    70 */   289,  487,  515,  435,  570,  415,   80,   67,  435,   69,
 /*    80 */   151,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*    90 */    66,  230,  569,  568,  248,  386,  420,  426,    2,  572,
 /*   100 */    58,  115,  238,  340,  243,  341,  173,  417,  417,  417,
 /*   110 */   570,  387,  384,  249,  289,   60,   59,  294,  430,  431,
 /*   120 */   427,  427,   62,   62,   61,   61,   61,   61,  569,   63,
 /*   130 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  230,
 /*   140 */   420,  426,   92,   64,   64,   65,   65,   65,   66,  230,
 /*   150 */   245,  392,   56,  171,  566,  207,  406,  443,  208,   60,
 /*   160 */    59,  294,  430,  431,  427,  427,   62,   62,   61,   61,
 /*   170 */    61,   61,  205,   63,   63,   63,   63,   64,   64,   65,
 /*   180 */    65,   65,   66,  230,  289,  368,  522,  411,  522,  111,
 /*   190 */   378,  207,  447,  467,  223,  403,   21,  532,   21,  172,
 /*   200 */   157,  317,   66,  230,  336,  404,  520,  443,  208,  486,
 /*   210 */   420,  426,  146,  147,  517,  488,  489,  393,  394,  148,
 /*   220 */   531,  224,  487,  410,   41,  407,  415,  567,  289,   60,
 /*   230 */    59,  294,  430,  431,  427,  427,   62,   62,   61,   61,
 /*   240 */    61,   61,  476,   63,   63,   63,   63,   64,   64,   65,
 /*   250 */    65,   65,   66,  230,  420,  426,  491,  492,  417,  417,
 /*   260 */   417,  155,  549,  331,  211,   65,   65,   65,   66,  230,
 /*   270 */   546,  492,  289,   60,   59,  294,  430,  431,  427,  427,
 /*   280 */    62,   62,   61,   61,   61,   61,  467,   63,   63,   63,
 /*   290 */    63,   64,   64,   65,   65,   65,   66,  230,  420,  426,
 /*   300 */   548,  299,  178,  297,  522,  342,  345,  346,  472,   67,
 /*   310 */   460,   69,  151,  577,   21,  338,  347,   60,   59,  294,
 /*   320 */   430,  431,  427,  427,   62,   62,   61,   61,   61,   61,
 /*   330 */   530,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   340 */    66,  230,  409,  523,   76,  289,  408,  478,  452,  482,
 /*   350 */   392,  369,  266,  265,  283,  149,  405,  445,  521,  165,
 /*   360 */   453,  317,  205,   67,  517,   69,  151,  529,  503,  152,
 /*   370 */   248,  420,  426,  454,  528,  493,  161,  115,  238,  340,
 /*   380 */   243,  341,  173,  410,   35,  494,  580,  288,   79,  249,
 /*   390 */    60,   59,  294,  430,  431,  427,  427,   62,   62,   61,
 /*   400 */    61,   61,   61,  411,   63,   63,   63,   63,   64,   64,
 /*   410 */    65,   65,   65,   66,  230,  289,  393,  394,  178,  485,
 /*   420 */   508,  342,  345,  346,  178,  296,  317,  342,  345,  346,
 /*   430 */   366,  317,  347,   20,  317,  141,  317,  457,  347,  150,
 /*   440 */   509,  420,  426,   22,  295,  438,  439,  435,  410,   35,
 /*   450 */   328,  260,  472,  410,   28,  232,  410,   35,  410,   36,
 /*   460 */    60,   59,  294,  430,  431,  427,  427,   62,   62,   61,
 /*   470 */    61,   61,   61,  411,   63,   63,   63,   63,   64,   64,
 /*   480 */    65,   65,   65,   66,  230,  289,  436,  481,   23,  502,
 /*   490 */   298,  234,  380,  301,  317,  217,  317,  476,  333,  317,
 /*   500 */   392,  317,  457,  337,  168,  157,  421,  422,  207,  231,
 /*   510 */   457,  420,  426,  435,  313,  388,  410,   35,  410,   49,
 /*   520 */   204,  410,   41,  410,   49,  410,    3,  197,  424,  425,
 /*   530 */    60,   59,  294,  430,  431,  427,  427,   62,   62,   61,
 /*   540 */    61,   61,   61,  382,   63,   63,   63,   63,   64,   64,
 /*   550 */    65,   65,   65,   66,  230,  289,  443,  423,  357,  252,
 /*   560 */   434,  411,  210,  292,  308,  350,  393,  394,  448,  309,
 /*   570 */   456,  322,  438,  439,  320,    1,  433,  433,   19,  392,
 /*   580 */   541,  420,  426,  191,  540,  375,  584,  891,  543,  891,
 /*   590 */   584,  890,  174,  890,  472,  392,  358,  445,  323,  165,
 /*   600 */    60,   59,  294,  430,  431,  427,  427,   62,   62,   61,
 /*   610 */    61,   61,   61,  383,   63,   63,   63,   63,   64,   64,
 /*   620 */    65,   65,   65,   66,  230,  289,  370,  581,    9,  452,
 /*   630 */    91,  581,   10,  236,  409,  207,  392,  359,  408,  392,
 /*   640 */   156,  453,  169,  362,  435,  393,  394,  320,  291,  433,
 /*   650 */   433,  420,  426,  249,  454,  320,  327,  433,  433,  260,
 /*   660 */   462,  393,  394,  515,  515,  545,  515,  463,  270,  289,
 /*   670 */    60,   59,  294,  430,  431,  427,  427,   62,   62,   61,
 /*   680 */    61,   61,   61,   82,   63,   63,   63,   63,   64,   64,
 /*   690 */    65,   65,   65,   66,  230,  420,  426,  480,  302,  216,
 /*   700 */   261,  303,  393,  394,  822,  393,  394,  273,  515,  271,
 /*   710 */   435,  515,  334,  289,   60,   59,  294,  430,  431,  427,
 /*   720 */   427,   62,   62,   61,   61,   61,   61,  233,   63,   63,
 /*   730 */    63,   63,   64,   64,   65,   65,   65,   66,  230,  420,
 /*   740 */   426,  247,  247,  304,  247,  318,  306,  587,  387,  384,
 /*   750 */   395,  396,  397,  320,  219,  433,  433,  289,   60,   70,
 /*   760 */   294,  430,  431,  427,  427,   62,   62,   61,   61,   61,
 /*   770 */    61,  317,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   780 */    65,   66,  230,  420,  426,  476,  247,  391,  272,  247,
 /*   790 */   539,  356,  539,  410,   29,  175,  176,  177,  162,  260,
 /*   800 */   260,  289,    5,   59,  294,  430,  431,  427,  427,   62,
 /*   810 */    62,   61,   61,   61,   61,  377,   63,   63,   63,   63,
 /*   820 */    64,   64,   65,   65,   65,   66,  230,  420,  426,  392,
 /*   830 */   311,  120,  392,  319,  205,  260,  366,  465,  254,  189,
 /*   840 */   556,  558,  260,   75,  260,   77,  307,  376,  294,  430,
 /*   850 */   431,  427,  427,   62,   62,   61,   61,   61,   61,  260,
 /*   860 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   870 */   230,   72,  324,  411,    4,  260,  559,  258,  293,  256,
 /*   880 */   174,  125,  317,  560,  317,  274,  321,   72,  324,  193,
 /*   890 */     4,  153,  621,  180,  293,  393,  394,  367,  393,  394,
 /*   900 */   374,  218,  321,  326,  410,   24,  410,   33,  183,  317,
 /*   910 */   428,  206,  441,  441,  447,  317,  276,  317,   55,  326,
 /*   920 */   363,  468,  239,  411,  469,  411,  455,  411,   13,  144,
 /*   930 */   447,  410,   53,  240,   74,   73,  291,  410,   52,  410,
 /*   940 */    96,  116,  411,   72,  315,  316,  582,  474,  415,  170,
 /*   950 */    74,   73,  479,  317,  507,  506,  317,  500,  416,   72,
 /*   960 */   315,  316,   72,  324,  415,    4,  205,  317,  329,  293,
 /*   970 */   317,  458,  483,  444,   13,  410,   94,  321,  410,   99,
 /*   980 */   417,  417,  417,  418,  419,   12,  583,  466,  317,  410,
 /*   990 */   100,  471,  410,  110,  326,  475,  417,  417,  417,  418,
 /*  1000 */   419,   12,  497,  498,  512,  447,  125,  159,  244,  317,
 /*  1010 */   410,  112,  220,  221,  222,  102,  537,  538,  317,  251,
 /*  1020 */   317,  125,  317,  504,  505,   74,   73,  349,  202,  125,
 /*  1030 */   278,  410,   17,  510,   72,  315,  316,  279,  524,  415,
 /*  1040 */   410,   97,  410,   34,  410,   95,  317,  511,  544,  200,
 /*  1050 */   125,  548,  552,  253,  170,  317,  199,  255,  317,  201,
 /*  1060 */   553,  257,   89,  317,  259,  563,  317,   89,  410,   25,
 /*  1070 */   317,  417,  417,  417,  418,  419,   12,  410,   54,  186,
 /*  1080 */   410,  113,  354,  317,  264,  410,  114,  317,  410,   26,
 /*  1090 */   361,  364,  410,   37,  579,  365,  287,  317,  267,  317,
 /*  1100 */   143,  317,  373,  275,  265,  410,   38,  268,  290,  410,
 /*  1110 */    27,  317,  269,  205,  555,  565,  317,  277,  317,  410,
 /*  1120 */    39,  410,   40,  410,   42,  317,  280,  317,  281,  317,
 /*  1130 */   576,  317,  225,  410,   43,  401,  503,  379,  410,   44,
 /*  1140 */   410,   30,  317,  325,  440,  317,  461,  410,   31,  410,
 /*  1150 */    45,  410,   46,  410,   47,  442,  317,  551,  317,  464,
 /*  1160 */   317,  241,  513,  516,  410,   48,  344,  410,   32,  562,
 /*  1170 */   160,  390,  398,  399,  400,    8,  314,  412,  410,   11,
 /*  1180 */   410,   50,  410,   51,   82,  332,  226,   81,  330,  227,
 /*  1190 */    57,  406,  414,  228,   78,  167,  229,  209,   83,  413,
 /*  1200 */   459,  122,  335,  339,  500,  490,  235,  495,  242,  473,
 /*  1210 */   237,  300,  477,  499,  496,  501,  103,  284,  246,  514,
 /*  1220 */   518,  519,  525,  526,  527,  351,  533,  181,  285,  182,
 /*  1230 */   184,  214,  353,  185,  535,  187,  215,  355,   86,  118,
 /*  1240 */   360,  547,  190,  129,  139,  371,  262,  372,  130,  536,
 /*  1250 */   554,  310,  131,  132,  573,   90,  133,  135,   93,  138,
 /*  1260 */   578,  574,  575,  109,  213,  561,  101,  119,  389,   18,
 /*  1270 */    98,  402,  622,  623,  163,  164,  429,  312,  432,   71,
 /*  1280 */   449,  437,  446,  140,  154,  166,  450,    6,  451,  470,
 /*  1290 */     7,  123,   14,   13,  124,  158,  484,  212,   84,  343,
 /*  1300 */   104,  348,  250,  105,   85,  117,  106,  240,  179,  352,
 /*  1310 */   142,  534,  126,  305,  170,  263,  188,  107,  286,  550,
 /*  1320 */   127,  128,   15,  542,  192,   87,  194,   88,  195,  557,
 /*  1330 */   196,  136,  137,  134,   16,  108,  571,  282,  381,  564,
 /*  1340 */   203,  145,  385,  901,  585,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  140,  141,  142,  111,   21,  145,   23,   70,   71,
 /*    10 */    72,   73,   23,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,   85,  156,   16,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    40 */   217,   59,  219,  220,   85,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  190,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    70 */    16,   89,  148,   89,  148,   93,   22,  217,   89,  219,
 /*    80 */   220,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,   85,  166,  167,   85,  142,   42,   43,  145,  239,
 /*   100 */    46,   92,   93,   94,   95,   96,   97,  125,  126,  127,
 /*   110 */   148,    1,    2,  104,   16,   61,   62,   63,   64,   65,
 /*   120 */    66,   67,   68,   69,   70,   71,   72,   73,  166,   75,
 /*   130 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   140 */    42,   43,   44,   79,   80,   81,   82,   83,   84,   85,
 /*   150 */   226,   23,   19,  156,  228,  229,   23,   79,   80,   61,
 /*   160 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   170 */    72,   73,  111,   75,   76,   77,   78,   79,   80,   81,
 /*   180 */    82,   83,   84,   85,   16,  124,  148,  190,  148,   21,
 /*   190 */   228,  229,   59,   22,  154,  157,  158,  157,  158,  202,
 /*   200 */   203,  148,   84,   85,  207,  168,  169,   79,   80,  170,
 /*   210 */    42,   43,   79,   80,  177,  170,  161,   89,   90,  181,
 /*   220 */   182,  191,   89,  170,  171,  170,   93,   99,   16,   61,
 /*   230 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   240 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   250 */    82,   83,   84,   85,   42,   43,  186,  187,  125,  126,
 /*   260 */   127,   90,   11,  210,  211,   81,   82,   83,   84,   85,
 /*   270 */   186,  187,   16,   61,   62,   63,   64,   65,   66,   67,
 /*   280 */    68,   69,   70,   71,   72,   73,  115,   75,   76,   77,
 /*   290 */    78,   79,   80,   81,   82,   83,   84,   85,   42,   43,
 /*   300 */    49,   16,   91,  209,  148,   94,   95,   96,  162,  217,
 /*   310 */   218,  219,  220,  157,  158,   81,  105,   61,   62,   63,
 /*   320 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   330 */   182,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   340 */    84,   85,  108,  182,  132,   16,  112,  201,   12,   20,
 /*   350 */    23,  100,  101,  102,  159,   22,  169,  162,  163,  164,
 /*   360 */    24,  148,  111,  217,  177,  219,  220,  177,  178,  156,
 /*   370 */    85,   42,   43,   37,  184,   39,   91,   92,   93,   94,
 /*   380 */    95,   96,   97,  170,  171,   49,  245,  246,  132,  104,
 /*   390 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   400 */    71,   72,   73,  190,   75,   76,   77,   78,   79,   80,
 /*   410 */    81,   82,   83,   84,   85,   16,   89,   90,   91,   20,
 /*   420 */    30,   94,   95,   96,   91,  212,  148,   94,   95,   96,
 /*   430 */   148,  148,  105,   19,  148,   21,  148,  224,  105,  156,
 /*   440 */    50,   42,   43,   19,  165,  166,  167,   23,  170,  171,
 /*   450 */   187,  148,  162,  170,  171,  148,  170,  171,  170,  171,
 /*   460 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   470 */    71,   72,   73,  190,   75,   76,   77,   78,   79,   80,
 /*   480 */    81,   82,   83,   84,   85,   16,   20,   20,   22,   20,
 /*   490 */   212,  201,  189,  103,  148,  213,  148,  148,  212,  148,
 /*   500 */    23,  148,  224,  148,  202,  203,   42,   43,  229,  221,
 /*   510 */   224,   42,   43,   89,  143,  144,  170,  171,  170,  171,
 /*   520 */   149,  170,  171,  170,  171,  170,  171,  156,   64,   65,
 /*   530 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   540 */    71,   72,   73,  240,   75,   76,   77,   78,   79,   80,
 /*   550 */    81,   82,   83,   84,   85,   16,   79,   93,  209,   20,
 /*   560 */    20,  190,  211,  151,  216,   16,   89,   90,   20,  216,
 /*   570 */   224,  165,  166,  167,  107,   19,  109,  110,   19,   23,
 /*   580 */    25,   42,   43,   22,   29,  214,   19,   20,   18,   22,
 /*   590 */    19,   20,   43,   22,  162,   23,   41,  162,  163,  164,
 /*   600 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   610 */    71,   72,   73,  242,   75,   76,   77,   78,   79,   80,
 /*   620 */    81,   82,   83,   84,   85,   16,   56,   60,   69,   12,
 /*   630 */    21,   60,   19,  201,  108,  229,   23,  225,  112,   23,
 /*   640 */   148,   24,   21,  231,   23,   89,   90,  107,   99,  109,
 /*   650 */   110,   42,   43,  104,   37,  107,   39,  109,  110,  148,
 /*   660 */    27,   89,   90,  148,  148,   95,  148,   34,   14,   16,
 /*   670 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   680 */    71,   72,   73,  122,   75,   76,   77,   78,   79,   80,
 /*   690 */    81,   82,   83,   84,   85,   42,   43,   81,  183,  183,
 /*   700 */   189,  183,   89,   90,  134,   89,   90,   53,  148,   55,
 /*   710 */    89,  148,  148,   16,   61,   62,   63,   64,   65,   66,
 /*   720 */    67,   68,   69,   70,   71,   72,   73,  148,   75,   76,
 /*   730 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   42,
 /*   740 */    43,  226,  226,  183,  226,  148,  183,    0,    1,    2,
 /*   750 */     7,    8,    9,  107,  146,  109,  110,   16,   61,   62,
 /*   760 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   770 */    73,  148,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   780 */    83,   84,   85,   42,   43,  148,  226,  148,  134,  226,
 /*   790 */   100,  101,  102,  170,  171,  100,  101,  102,   19,  148,
 /*   800 */   148,   16,  192,   62,   63,   64,   65,   66,   67,   68,
 /*   810 */    69,   70,   71,   72,   73,   92,   75,   76,   77,   78,
 /*   820 */    79,   80,   81,   82,   83,   84,   85,   42,   43,   23,
 /*   830 */   243,  244,   23,   16,  111,  148,  148,   22,   14,  156,
 /*   840 */   189,  189,  148,  131,  148,  133,  209,  124,   63,   64,
 /*   850 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  148,
 /*   860 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   870 */    85,   16,   17,  190,   19,  148,  189,   53,   23,   55,
 /*   880 */    43,   22,  148,  189,  148,  189,   31,   16,   17,  156,
 /*   890 */    19,  156,  113,  156,   23,   89,   90,  214,   89,   90,
 /*   900 */   189,  213,   31,   48,  170,  171,  170,  171,  156,  148,
 /*   910 */    93,  193,  125,  126,   59,  148,  189,  148,  200,   48,
 /*   920 */   237,  115,   93,  190,  115,  190,   20,  190,   22,  114,
 /*   930 */    59,  170,  171,  104,   79,   80,   99,  170,  171,  170,
 /*   940 */   171,  148,  190,   88,   89,   90,   20,   20,   93,   22,
 /*   950 */    79,   80,   81,  148,   92,   93,  148,   98,  148,   88,
 /*   960 */    89,   90,   16,   17,   93,   19,  111,  148,  148,   23,
 /*   970 */   148,  148,   20,  162,   22,  170,  171,   31,  170,  171,
 /*   980 */   125,  126,  127,  128,  129,  130,   60,  204,  148,  170,
 /*   990 */   171,  148,  170,  171,   48,  148,  125,  126,  127,  128,
 /*  1000 */   129,  130,    7,    8,   20,   59,   22,    5,  148,  148,
 /*  1010 */   170,  171,   10,   11,   12,   13,   51,   52,  148,   20,
 /*  1020 */   148,   22,  148,  148,  179,   79,   80,   20,   26,   22,
 /*  1030 */    28,  170,  171,  179,   88,   89,   90,   35,  148,   93,
 /*  1040 */   170,  171,  170,  171,  170,  171,  148,  179,   20,   47,
 /*  1050 */    22,   49,   20,  148,   22,  148,   54,  148,  148,   57,
 /*  1060 */    20,  148,   22,  148,  148,   20,  148,   22,  170,  171,
 /*  1070 */   148,  125,  126,  127,  128,  129,  130,  170,  171,  233,
 /*  1080 */   170,  171,  234,  148,  148,  170,  171,  148,  170,  171,
 /*  1090 */   148,  148,  170,  171,   20,  148,   22,  148,  148,  148,
 /*  1100 */   192,  148,  100,  101,  102,  170,  171,  148,  106,  170,
 /*  1110 */   171,  148,  148,  111,  148,  148,  148,  148,  148,  170,
 /*  1120 */   171,  170,  171,  170,  171,  148,  148,  148,  148,  148,
 /*  1130 */   148,  148,  194,  170,  171,  150,  178,  135,  170,  171,
 /*  1140 */   170,  171,  148,  223,  230,  148,  173,  170,  171,  170,
 /*  1150 */   171,  170,  171,  170,  171,  230,  148,  195,  148,  173,
 /*  1160 */   148,  173,  173,  173,  170,  171,  174,  170,  171,  195,
 /*  1170 */     6,  147,  147,  147,  147,   22,  155,  190,  170,  171,
 /*  1180 */   170,  171,  170,  171,  122,  119,  195,  120,  117,  196,
 /*  1190 */   121,   23,  161,  197,  131,  113,  198,  222,   99,  199,
 /*  1200 */   153,  153,  116,   99,   98,  172,  205,  172,  172,  206,
 /*  1210 */   205,   40,  206,  174,  180,  172,   19,  175,   85,  161,
 /*  1220 */   161,  180,  172,  172,  172,   15,  153,  152,  175,  152,
 /*  1230 */   152,  227,  153,  153,  153,  152,  227,   38,  131,   61,
 /*  1240 */   153,  185,  185,   19,  215,  153,  235,   15,  188,  236,
 /*  1250 */   195,  153,  188,  188,   33,  238,  188,  185,  238,  215,
 /*  1260 */   138,  153,  153,  241,  176,  195,  176,  244,    1,  232,
 /*  1270 */   160,   20,  113,  113,  113,  113,   93,  247,  108,   19,
 /*  1280 */    11,   20,   20,   19,   19,   22,   20,  118,   20,  115,
 /*  1290 */   118,   19,   22,   22,   20,  113,   20,   44,   19,   44,
 /*  1300 */    19,   44,   20,   19,   19,   32,   19,  104,   97,   16,
 /*  1310 */    21,   17,   99,   36,   22,  134,   99,   19,    5,    1,
 /*  1320 */    45,  103,   19,   45,  123,   69,  114,   69,   14,   17,
 /*  1330 */   116,  103,  123,  114,   19,   14,   20,  137,   58,  124,
 /*  1340 */   136,   19,    3,  248,    4,
};
#define YY_SHIFT_USE_DFLT (-108)
#define YY_SHIFT_MAX 385
static const short yy_shift_ofst[] = {
 /*     0 */   110,  855, 1002,  -16,  855,  946,  946,  946,  327,  128,
 /*    10 */  -107,   98,  946,  946,  946,  946,  946,  -46,  251,  477,
 /*    20 */   572,  -11,   78,   78,   54,  168,  212,  256,  329,  399,
 /*    30 */   469,  539,  609,  653,  697,  653,  653,  653,  653,  653,
 /*    40 */   653,  653,  653,  653,  653,  653,  653,  653,  653,  653,
 /*    50 */   653,  653,  741,  785,  785,  871,  946,  946,  946,  946,
 /*    60 */   946,  946,  946,  946,  946,  946,  946,  946,  946,  946,
 /*    70 */   946,  946,  946,  946,  946,  946,  946,  946,  946,  946,
 /*    80 */   946,  946,  946,  946,  946,  946,  946,  946,  946,  946,
 /*    90 */   946,  946,  946,  946,  -62,  -62,    6,    6,  285,   64,
 /*   100 */   184,  549,  570,  572,  572,  572,  572,  572,  572,  572,
 /*   110 */   118,  -11,  -41, -108, -108,  133,    9,  336,  336,  567,
 /*   120 */   571,  747,  621,  572,  621,  572,  572,  572,  572,  572,
 /*   130 */   572,  572,  572,  572,  572,  572,  572,  572,  723,   61,
 /*   140 */  -107, -107, -107, -108, -108, -108,  -18,  -18,  333,  211,
 /*   150 */   467,  556,  540,  548,  617,  806,  809,  613,  616,  743,
 /*   160 */   572,  572,  234,  572,  572,  424,  572,  572,  171,  572,
 /*   170 */   572,  646,  171,  572,  572,  390,  390,  390,  572,  572,
 /*   180 */   646,  572,  572,  646,  572,  555,  690,  572,  572,  646,
 /*   190 */   572,  572,  572,  646,  572,  572,  572,  646,  646,  572,
 /*   200 */   572,  572,  572,  572,  414,  526,  815,  787,  787,  712,
 /*   210 */   633,  633,  633,  837,  633,  633,  859,  561,  561, 1164,
 /*   220 */  1164, 1164, 1164, 1153, -107, 1062, 1066, 1067, 1071, 1069,
 /*   230 */  1168, 1063, 1082, 1082, 1099, 1086, 1099, 1086, 1104, 1104,
 /*   240 */  1171, 1104, 1106, 1104, 1197, 1133, 1168, 1133, 1168, 1171,
 /*   250 */  1104, 1104, 1104, 1197, 1210, 1082, 1210, 1082, 1210, 1082,
 /*   260 */  1082, 1199, 1107, 1210, 1082, 1178, 1178, 1224, 1062, 1082,
 /*   270 */  1232, 1232, 1232, 1232, 1062, 1178, 1224, 1082, 1221, 1221,
 /*   280 */  1082, 1082, 1122, -108, -108, -108, -108, -108, -108,  464,
 /*   290 */   654,  695,  824,  779,  817,  466,  906,  927,  952,  829,
 /*   300 */   995,  862,  984,  999, 1007,  965, 1028, 1032, 1040, 1045,
 /*   310 */   559, 1074,  926, 1267, 1251, 1159, 1160, 1161, 1162, 1183,
 /*   320 */  1170, 1260, 1261, 1262, 1264, 1269, 1265, 1266, 1263, 1268,
 /*   330 */  1169, 1270, 1172, 1271, 1174, 1272, 1274, 1182, 1276, 1273,
 /*   340 */  1253, 1279, 1255, 1281, 1282, 1284, 1285, 1257, 1287, 1211,
 /*   350 */  1203, 1293, 1294, 1289, 1213, 1277, 1275, 1292, 1278, 1181,
 /*   360 */  1217, 1298, 1313, 1318, 1218, 1256, 1258, 1201, 1303, 1212,
 /*   370 */  1314, 1214, 1312, 1219, 1228, 1209, 1315, 1215, 1316, 1321,
 /*   380 */  1280, 1204, 1200, 1322, 1339, 1340,
};
#define YY_REDUCE_USE_DFLT (-178)
#define YY_REDUCE_MAX 288
static const short yy_reduce_ofst[] = {
 /*     0 */  -139,  213,  371,  146,  283,  278,   53,  286,   38,  -74,
 /*    10 */    -3, -140,  288,  346,  351,  348,  353,   92,  683,  -38,
 /*    20 */    40,  195,  279,  406, -177, -177, -177, -177, -177, -177,
 /*    30 */  -177, -177, -177, -177, -177, -177, -177, -177, -177, -177,
 /*    40 */  -177, -177, -177, -177, -177, -177, -177, -177, -177, -177,
 /*    50 */  -177, -177, -177, -177, -177,  355,  623,  734,  736,  761,
 /*    60 */   767,  769,  805,  808,  819,  822,  840,  861,  870,  872,
 /*    70 */   874,  898,  907,  910,  915,  918,  922,  935,  939,  949,
 /*    80 */   951,  953,  963,  968,  970,  977,  979,  981,  983,  994,
 /*    90 */   997, 1008, 1010, 1012, -177, -177, -177, -177,   37, -177,
 /*   100 */  -177,  190,  412,  515,  516,  518,  560,  563,  303,  156,
 /*   110 */  -177,  435, -177, -177, -177,   55,  187,   70,   84,  141,
 /*   120 */   141,  -47,  290,   94,  432,  -76,  511,  349,  282,  637,
 /*   130 */   651,  652,  687,  694,  696,  711,  688,  727, -132,  733,
 /*   140 */   735,  737,  752,  718,  302,  587,   39,   45,  148,  161,
 /*   150 */    30,  307,   30,   30,  263,  492,  564,  579,  597,  608,
 /*   160 */   639,  793,  610,  597,  810,  811,  820,  823,  783,  843,
 /*   170 */   847,   30,  783,  860,  875,  845,  854,  868,  890,  905,
 /*   180 */    30,  909,  913,   30,  916,  846,  848,  936,  942,   30,
 /*   190 */   943,  947,  950,   30,  959,  964,  966,   30,   30,  967,
 /*   200 */   969,  978,  980,  982,  985,  908,  938,  914,  925,  920,
 /*   210 */   973,  986,  988,  958,  989,  990,  992,  962,  974, 1024,
 /*   220 */  1025, 1026, 1027, 1021,  987,  991,  993,  996,  998, 1000,
 /*   230 */  1031,  975, 1047, 1048, 1001, 1003, 1005, 1006, 1033, 1035,
 /*   240 */  1034, 1036, 1039, 1043, 1042, 1004, 1058, 1009, 1059, 1041,
 /*   250 */  1050, 1051, 1052, 1053, 1075, 1073, 1077, 1079, 1078, 1080,
 /*   260 */  1081, 1011, 1013, 1083, 1087, 1056, 1057, 1029, 1055, 1092,
 /*   270 */  1060, 1064, 1065, 1068, 1070, 1072, 1044, 1098, 1017, 1020,
 /*   280 */  1108, 1109, 1022, 1110, 1088, 1090, 1037, 1023, 1030,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   593,  819,  899,  708,  899,  819,  899,  819,  899,  844,
 /*    10 */   712,  873,  815,  819,  899,  899,  899,  790,  899,  844,
 /*    20 */   899,  624,  844,  844,  741,  899,  899,  899,  899,  899,
 /*    30 */   899,  899,  899,  742,  899,  818,  814,  810,  812,  811,
 /*    40 */   743,  732,  739,  746,  724,  858,  748,  749,  755,  756,
 /*    50 */   874,  877,  778,  777,  796,  899,  899,  899,  899,  899,
 /*    60 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*    70 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*    80 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*    90 */   899,  899,  899,  899,  780,  801,  779,  789,  617,  781,
 /*   100 */   782,  677,  612,  899,  899,  899,  899,  899,  899,  899,
 /*   110 */   783,  899,  784,  797,  798,  899,  899,  899,  899,  899,
 /*   120 */   899,  593,  708,  899,  708,  899,  899,  899,  899,  899,
 /*   130 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   140 */   899,  899,  899,  702,  712,  892,  899,  899,  668,  899,
 /*   150 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  600,
 /*   160 */   598,  899,  700,  899,  899,  626,  899,  899,  710,  899,
 /*   170 */   899,  715,  716,  899,  899,  899,  899,  899,  899,  899,
 /*   180 */   614,  899,  899,  689,  899,  850,  899,  899,  899,  865,
 /*   190 */   899,  899,  899,  863,  899,  899,  899,  691,  751,  831,
 /*   200 */   899,  878,  880,  899,  899,  700,  709,  899,  899,  813,
 /*   210 */   735,  735,  735,  647,  735,  735,  650,  745,  745,  597,
 /*   220 */   597,  597,  597,  667,  899,  745,  736,  738,  728,  740,
 /*   230 */   899,  899,  717,  717,  725,  727,  725,  727,  679,  679,
 /*   240 */   664,  679,  650,  679,  823,  828,  899,  828,  899,  664,
 /*   250 */   679,  679,  679,  823,  609,  717,  609,  717,  609,  717,
 /*   260 */   717,  854,  857,  609,  717,  681,  681,  757,  745,  717,
 /*   270 */   688,  688,  688,  688,  745,  681,  757,  717,  876,  876,
 /*   280 */   717,  717,  885,  634,  652,  652,  860,  892,  897,  899,
 /*   290 */   899,  899,  899,  764,  899,  899,  899,  899,  899,  899,
 /*   300 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   310 */   837,  899,  899,  899,  899,  769,  765,  899,  766,  899,
 /*   320 */   694,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   330 */   899,  729,  899,  737,  899,  899,  899,  899,  899,  899,
 /*   340 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   350 */   899,  899,  899,  899,  899,  899,  852,  853,  899,  899,
 /*   360 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   370 */   899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
 /*   380 */   884,  899,  899,  887,  594,  899,  588,  591,  590,  592,
 /*   390 */   596,  599,  621,  622,  623,  601,  602,  603,  604,  605,
 /*   400 */   606,  607,  613,  615,  633,  635,  619,  637,  698,  699,
 /*   410 */   761,  692,  693,  697,  772,  763,  767,  768,  770,  771,
 /*   420 */   785,  786,  788,  794,  800,  803,  787,  792,  793,  795,
 /*   430 */   799,  802,  695,  696,  806,  620,  627,  628,  631,  632,
 /*   440 */   840,  842,  841,  843,  630,  629,  773,  776,  808,  809,
 /*   450 */   866,  867,  868,  869,  870,  804,  816,  817,  718,  807,
 /*   460 */   791,  730,  733,  734,  731,  701,  711,  720,  721,  722,
 /*   470 */   723,  706,  707,  713,  726,  759,  760,  714,  703,  704,
 /*   480 */   705,  805,  762,  774,  775,  638,  639,  769,  640,  641,
 /*   490 */   642,  680,  683,  684,  685,  643,  662,  665,  666,  644,
 /*   500 */   651,  645,  646,  653,  654,  655,  658,  659,  660,  661,
 /*   510 */   656,  657,  824,  825,  829,  827,  826,  648,  649,  663,
 /*   520 */   636,  625,  618,  669,  672,  673,  674,  675,  676,  678,
 /*   530 */   670,  671,  616,  608,  610,  719,  846,  855,  856,  851,
 /*   540 */   847,  848,  849,  611,  820,  821,  682,  753,  754,  845,
 /*   550 */   859,  861,  758,  862,  864,  889,  686,  687,  690,  830,
 /*   560 */   871,  744,  747,  750,  752,  832,  833,  834,  835,  838,
 /*   570 */   839,  836,  872,  875,  879,  881,  882,  883,  886,  888,
 /*   580 */   893,  894,  895,  898,  896,  595,  589,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "COLLATE",       "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "collate",     
  "nmnum",         "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",  "create_vtab",   "vtabarglist", 
  "vtabarg",       "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY exprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE id",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= exprlist COMMA expritem",
 /* 230 */ "exprlist ::= expritem",
 /* 231 */ "expritem ::= expr",
 /* 232 */ "expritem ::=",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "collate ::=",
 /* 242 */ "collate ::= COLLATE id",
 /* 243 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 244 */ "cmd ::= VACUUM",
 /* 245 */ "cmd ::= VACUUM nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "nmnum ::= plus_num",
 /* 252 */ "nmnum ::= nm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER|FLOAT",
 /* 256 */ "plus_opt ::= PLUS",
 /* 257 */ "plus_opt ::=",
 /* 258 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 259 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 260 */ "trigger_time ::= BEFORE",
 /* 261 */ "trigger_time ::= AFTER",
 /* 262 */ "trigger_time ::= INSTEAD OF",
 /* 263 */ "trigger_time ::=",
 /* 264 */ "trigger_event ::= DELETE|INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 273 */ "trigger_cmd_list ::=",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY expr",
 /* 288 */ "database_kw_opt ::= DATABASE",
 /* 289 */ "database_kw_opt ::=",
 /* 290 */ "cmd ::= DETACH database_kw_opt expr",
 /* 291 */ "cmd ::= REINDEX",
 /* 292 */ "cmd ::= REINDEX nm dbnm",
 /* 293 */ "cmd ::= ANALYZE",
 /* 294 */ "cmd ::= ANALYZE nm dbnm",
 /* 295 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 296 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 297 */ "add_column_fullname ::= fullname",
 /* 298 */ "kwcolumn_opt ::=",
 /* 299 */ "kwcolumn_opt ::= COLUMNKW",
 /* 300 */ "cmd ::= create_vtab",
 /* 301 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 302 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 303 */ "vtabarglist ::= vtabarg",
 /* 304 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 305 */ "vtabarg ::=",
 /* 306 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 307 */ "vtabargtoken ::= ANY",
 /* 308 */ "vtabargtoken ::= lp anylist RP",
 /* 309 */ "lp ::= LP",
 /* 310 */ "anylist ::=",
 /* 311 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 375 "parse.y"
{sqlite3SelectDelete((yypminor->yy43));}
#line 1257 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 218:
    case 221:
    case 223:
    case 224:
    case 236:
#line 616 "parse.y"
{sqlite3ExprDelete((yypminor->yy450));}
#line 1272 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 212:
    case 213:
    case 216:
    case 222:
#line 856 "parse.y"
{sqlite3ExprListDelete((yypminor->yy242));}
#line 1287 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 488 "parse.y"
{sqlite3SrcListDelete((yypminor->yy419));}
#line 1295 "parse.c"
      break;
    case 199:
#line 546 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy84).pLimit);
  sqlite3ExprDelete((yypminor->yy84).pOffset);
}
#line 1303 "parse.c"
      break;
    case 206:
    case 209:
    case 215:
#line 505 "parse.y"
{sqlite3IdListDelete((yypminor->yy352));}
#line 1310 "parse.c"
      break;
    case 232:
    case 237:
#line 957 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy75));}
#line 1316 "parse.c"
      break;
    case 234:
#line 941 "parse.y"
{sqlite3IdListDelete((yypminor->yy354).b);}
#line 1321 "parse.c"
      break;
    case 239:
#line 1025 "parse.y"
{sqlite3ExprDelete((yypminor->yy158));}
#line 1326 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1495 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 169, 2 },
  { 169, 4 },
  { 169, 3 },
  { 169, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 8 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 4 },
  { 210, 2 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 213, 5 },
  { 213, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 219, 1 },
  { 219, 2 },
  { 171, 5 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 144, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 227, 0 },
  { 227, 2 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 228, 1 },
  { 228, 1 },
  { 166, 2 },
  { 167, 2 },
  { 230, 1 },
  { 229, 1 },
  { 229, 0 },
  { 144, 5 },
  { 231, 11 },
  { 233, 1 },
  { 233, 1 },
  { 233, 2 },
  { 233, 0 },
  { 234, 1 },
  { 234, 1 },
  { 234, 3 },
  { 235, 0 },
  { 235, 3 },
  { 235, 3 },
  { 236, 0 },
  { 236, 2 },
  { 232, 3 },
  { 232, 0 },
  { 237, 6 },
  { 237, 8 },
  { 237, 5 },
  { 237, 4 },
  { 237, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 4 },
  { 144, 6 },
  { 239, 0 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 240, 1 },
  { 241, 0 },
  { 241, 1 },
  { 144, 1 },
  { 144, 4 },
  { 242, 7 },
  { 243, 1 },
  { 243, 3 },
  { 244, 0 },
  { 244, 2 },
  { 245, 1 },
  { 245, 3 },
  { 246, 1 },
  { 247, 0 },
  { 247, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1890 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1895 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1900 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1905 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy316);}
#line 1910 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy316 = TK_DEFERRED;}
#line 1915 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy316 = yymsp[0].major;}
#line 1924 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1930 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1935 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178,yymsp[-4].minor.yy316,0,0,yymsp[-2].minor.yy316);
}
#line 1942 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "parse.y"
{yygotominor.yy316 = 0;}
#line 1957 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "parse.y"
{yygotominor.yy316 = 1;}
#line 1969 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy0,0);
}
#line 1976 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy43);
  sqlite3SelectDelete(yymsp[0].minor.yy43);
}
#line 1984 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy178.z = yymsp[-2].minor.yy178.z;
  yygotominor.yy178.n = (pParse->sLastToken.z-yymsp[-2].minor.yy178.z) + pParse->sLastToken.n;
}
#line 1992 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy178);
  yygotominor.yy178 = yymsp[0].minor.yy178;
}
#line 2000 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 255:
#line 168 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy0;}
#line 2010 "parse.c"
        break;
      case 38:
#line 229 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy178);}
#line 2015 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 240:
      case 242:
      case 251:
      case 252:
      case 253:
      case 254:
#line 230 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy178;}
#line 2030 "parse.c"
        break;
      case 40:
#line 231 "parse.y"
{
  yygotominor.yy178.z = yymsp[-3].minor.yy178.z;
  yygotominor.yy178.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy178.z;
}
#line 2038 "parse.c"
        break;
      case 41:
#line 235 "parse.y"
{
  yygotominor.yy178.z = yymsp[-5].minor.yy178.z;
  yygotominor.yy178.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy178.z;
}
#line 2046 "parse.c"
        break;
      case 43:
#line 241 "parse.y"
{yygotominor.yy178.z=yymsp[-1].minor.yy178.z; yygotominor.yy178.n=yymsp[0].minor.yy178.n+(yymsp[0].minor.yy178.z-yymsp[-1].minor.yy178.z);}
#line 2051 "parse.c"
        break;
      case 44:
#line 243 "parse.y"
{ yygotominor.yy316 = atoi((char*)yymsp[0].minor.yy178.z); }
#line 2056 "parse.c"
        break;
      case 45:
#line 244 "parse.y"
{ yygotominor.yy316 = -atoi((char*)yymsp[0].minor.yy178.z); }
#line 2061 "parse.c"
        break;
      case 50:
      case 52:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy450);}
#line 2067 "parse.c"
        break;
      case 51:
#line 254 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy450);}
#line 2072 "parse.c"
        break;
      case 53:
#line 256 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2080 "parse.c"
        break;
      case 54:
#line 260 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy178);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2088 "parse.c"
        break;
      case 56:
#line 269 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy316);}
#line 2093 "parse.c"
        break;
      case 57:
#line 271 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy316,yymsp[0].minor.yy316,yymsp[-2].minor.yy316);}
#line 2098 "parse.c"
        break;
      case 58:
#line 272 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy316,0,0,0,0);}
#line 2103 "parse.c"
        break;
      case 59:
#line 273 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy450);}
#line 2108 "parse.c"
        break;
      case 60:
#line 275 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy178,yymsp[-1].minor.yy242,yymsp[0].minor.yy316);}
#line 2113 "parse.c"
        break;
      case 61:
#line 276 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy316);}
#line 2118 "parse.c"
        break;
      case 62:
#line 277 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy178.z, yymsp[0].minor.yy178.n);}
#line 2123 "parse.c"
        break;
      case 65:
#line 290 "parse.y"
{ yygotominor.yy316 = OE_Restrict * 0x010101; }
#line 2128 "parse.c"
        break;
      case 66:
#line 291 "parse.y"
{ yygotominor.yy316 = (yymsp[-1].minor.yy316 & yymsp[0].minor.yy207.mask) | yymsp[0].minor.yy207.value; }
#line 2133 "parse.c"
        break;
      case 67:
#line 293 "parse.y"
{ yygotominor.yy207.value = 0;     yygotominor.yy207.mask = 0x000000; }
#line 2138 "parse.c"
        break;
      case 68:
#line 294 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316;     yygotominor.yy207.mask = 0x0000ff; }
#line 2143 "parse.c"
        break;
      case 69:
#line 295 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<8;  yygotominor.yy207.mask = 0x00ff00; }
#line 2148 "parse.c"
        break;
      case 70:
#line 296 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<16; yygotominor.yy207.mask = 0xff0000; }
#line 2153 "parse.c"
        break;
      case 71:
#line 298 "parse.y"
{ yygotominor.yy316 = OE_SetNull; }
#line 2158 "parse.c"
        break;
      case 72:
#line 299 "parse.y"
{ yygotominor.yy316 = OE_SetDflt; }
#line 2163 "parse.c"
        break;
      case 73:
#line 300 "parse.y"
{ yygotominor.yy316 = OE_Cascade; }
#line 2168 "parse.c"
        break;
      case 74:
#line 301 "parse.y"
{ yygotominor.yy316 = OE_Restrict; }
#line 2173 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 303 "parse.y"
{yygotominor.yy316 = yymsp[0].minor.yy316;}
#line 2184 "parse.c"
        break;
      case 80:
#line 313 "parse.y"
{yygotominor.yy178.n = 0; yygotominor.yy178.z = 0;}
#line 2189 "parse.c"
        break;
      case 81:
#line 314 "parse.y"
{yygotominor.yy178 = yymsp[-1].minor.yy0;}
#line 2194 "parse.c"
        break;
      case 86:
#line 320 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy242,yymsp[0].minor.yy316,yymsp[-2].minor.yy316,0);}
#line 2199 "parse.c"
        break;
      case 87:
#line 322 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy242,yymsp[0].minor.yy316,0,0,0,0);}
#line 2204 "parse.c"
        break;
      case 88:
#line 323 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy450);}
#line 2209 "parse.c"
        break;
      case 89:
#line 325 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy242, &yymsp[-3].minor.yy178, yymsp[-2].minor.yy242, yymsp[-1].minor.yy316);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy316);
}
#line 2217 "parse.c"
        break;
      case 92:
      case 94:
#line 339 "parse.y"
{yygotominor.yy316 = OE_Default;}
#line 2223 "parse.c"
        break;
      case 97:
#line 344 "parse.y"
{yygotominor.yy316 = OE_Ignore;}
#line 2228 "parse.c"
        break;
      case 98:
      case 167:
#line 345 "parse.y"
{yygotominor.yy316 = OE_Replace;}
#line 2234 "parse.c"
        break;
      case 99:
#line 349 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 0, yymsp[-1].minor.yy316);
}
#line 2241 "parse.c"
        break;
      case 102:
#line 359 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy178, &yymsp[-2].minor.yy178, yymsp[0].minor.yy43, yymsp[-6].minor.yy316, yymsp[-4].minor.yy316);
}
#line 2248 "parse.c"
        break;
      case 103:
#line 362 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 1, yymsp[-1].minor.yy316);
}
#line 2255 "parse.c"
        break;
      case 104:
#line 369 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy43, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy43);
}
#line 2263 "parse.c"
        break;
      case 105:
      case 128:
#line 379 "parse.y"
{yygotominor.yy43 = yymsp[0].minor.yy43;}
#line 2269 "parse.c"
        break;
      case 106:
#line 381 "parse.y"
{
  if( yymsp[0].minor.yy43 ){
    yymsp[0].minor.yy43->op = yymsp[-1].minor.yy316;
    yymsp[0].minor.yy43->pPrior = yymsp[-2].minor.yy43;
  }
  yygotominor.yy43 = yymsp[0].minor.yy43;
}
#line 2280 "parse.c"
        break;
      case 108:
#line 390 "parse.y"
{yygotominor.yy316 = TK_ALL;}
#line 2285 "parse.c"
        break;
      case 110:
#line 394 "parse.y"
{
  yygotominor.yy43 = sqlite3SelectNew(yymsp[-6].minor.yy242,yymsp[-5].minor.yy419,yymsp[-4].minor.yy450,yymsp[-3].minor.yy242,yymsp[-2].minor.yy450,yymsp[-1].minor.yy242,yymsp[-7].minor.yy316,yymsp[0].minor.yy84.pLimit,yymsp[0].minor.yy84.pOffset);
}
#line 2292 "parse.c"
        break;
      case 114:
      case 237:
#line 415 "parse.y"
{yygotominor.yy242 = yymsp[-1].minor.yy242;}
#line 2298 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 236:
#line 416 "parse.y"
{yygotominor.yy242 = 0;}
#line 2306 "parse.c"
        break;
      case 116:
#line 417 "parse.y"
{
   yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-2].minor.yy242,yymsp[-1].minor.yy450,yymsp[0].minor.yy178.n?&yymsp[0].minor.yy178:0);
}
#line 2313 "parse.c"
        break;
      case 117:
#line 420 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-1].minor.yy242, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2320 "parse.c"
        break;
      case 118:
#line 423 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-3].minor.yy242, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2329 "parse.c"
        break;
      case 121:
#line 435 "parse.y"
{yygotominor.yy178.n = 0;}
#line 2334 "parse.c"
        break;
      case 122:
#line 447 "parse.y"
{yygotominor.yy419 = sqliteMalloc(sizeof(*yygotominor.yy419));}
#line 2339 "parse.c"
        break;
      case 123:
#line 448 "parse.y"
{
  yygotominor.yy419 = yymsp[0].minor.yy419;
  sqlite3SrcListShiftJoinType(yygotominor.yy419);
}
#line 2347 "parse.c"
        break;
      case 124:
#line 456 "parse.y"
{
   yygotominor.yy419 = yymsp[-1].minor.yy419;
   if( yygotominor.yy419 && yygotominor.yy419->nSrc>0 ) yygotominor.yy419->a[yygotominor.yy419->nSrc-1].jointype = yymsp[0].minor.yy316;
}
#line 2355 "parse.c"
        break;
      case 125:
#line 460 "parse.y"
{yygotominor.yy419 = 0;}
#line 2360 "parse.c"
        break;
      case 126:
#line 461 "parse.y"
{
  yygotominor.yy419 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy419,&yymsp[-4].minor.yy178,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,0,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
}
#line 2367 "parse.c"
        break;
      case 127:
#line 466 "parse.y"
{
    yygotominor.yy419 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy419,0,0,&yymsp[-2].minor.yy178,yymsp[-4].minor.yy43,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
  }
#line 2374 "parse.c"
        break;
      case 129:
#line 477 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy419);
     yygotominor.yy43 = sqlite3SelectNew(0,yymsp[0].minor.yy419,0,0,0,0,0,0,0);
  }
#line 2382 "parse.c"
        break;
      case 130:
#line 484 "parse.y"
{yygotominor.yy178.z=0; yygotominor.yy178.n=0;}
#line 2387 "parse.c"
        break;
      case 132:
#line 489 "parse.y"
{yygotominor.yy419 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178);}
#line 2392 "parse.c"
        break;
      case 133:
#line 493 "parse.y"
{ yygotominor.yy316 = JT_INNER; }
#line 2397 "parse.c"
        break;
      case 134:
#line 494 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2402 "parse.c"
        break;
      case 135:
#line 495 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy178,0); }
#line 2407 "parse.c"
        break;
      case 136:
#line 497 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy178,&yymsp[-1].minor.yy178); }
#line 2412 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 225:
      case 227:
      case 231:
#line 501 "parse.y"
{yygotominor.yy450 = yymsp[0].minor.yy450;}
#line 2425 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 226:
      case 228:
      case 232:
#line 502 "parse.y"
{yygotominor.yy450 = 0;}
#line 2436 "parse.c"
        break;
      case 139:
      case 171:
#line 506 "parse.y"
{yygotominor.yy352 = yymsp[-1].minor.yy352;}
#line 2442 "parse.c"
        break;
      case 140:
      case 170:
#line 507 "parse.y"
{yygotominor.yy352 = 0;}
#line 2448 "parse.c"
        break;
      case 142:
      case 150:
#line 518 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2454 "parse.c"
        break;
      case 143:
#line 519 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-3].minor.yy242,yymsp[-1].minor.yy450,0);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2462 "parse.c"
        break;
      case 144:
#line 523 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[-1].minor.yy450,0);
  if( yygotominor.yy242 && yygotominor.yy242->a ) yygotominor.yy242->a[0].sortOrder = yymsp[0].minor.yy316;
}
#line 2470 "parse.c"
        break;
      case 146:
      case 148:
#line 531 "parse.y"
{yygotominor.yy316 = SQLITE_SO_ASC;}
#line 2476 "parse.c"
        break;
      case 147:
#line 532 "parse.y"
{yygotominor.yy316 = SQLITE_SO_DESC;}
#line 2481 "parse.c"
        break;
      case 153:
#line 550 "parse.y"
{yygotominor.yy84.pLimit = 0; yygotominor.yy84.pOffset = 0;}
#line 2486 "parse.c"
        break;
      case 154:
#line 551 "parse.y"
{yygotominor.yy84.pLimit = yymsp[0].minor.yy450; yygotominor.yy84.pOffset = 0;}
#line 2491 "parse.c"
        break;
      case 155:
#line 553 "parse.y"
{yygotominor.yy84.pLimit = yymsp[-2].minor.yy450; yygotominor.yy84.pOffset = yymsp[0].minor.yy450;}
#line 2496 "parse.c"
        break;
      case 156:
#line 555 "parse.y"
{yygotominor.yy84.pOffset = yymsp[-2].minor.yy450; yygotominor.yy84.pLimit = yymsp[0].minor.yy450;}
#line 2501 "parse.c"
        break;
      case 157:
#line 559 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy419,yymsp[0].minor.yy450);}
#line 2506 "parse.c"
        break;
      case 160:
#line 570 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy419,yymsp[-1].minor.yy242,yymsp[0].minor.yy450,yymsp[-4].minor.yy316);}
#line 2511 "parse.c"
        break;
      case 161:
#line 576 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242,yymsp[0].minor.yy450,&yymsp[-2].minor.yy178);}
#line 2516 "parse.c"
        break;
      case 162:
#line 577 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[0].minor.yy450,&yymsp[-2].minor.yy178);}
#line 2521 "parse.c"
        break;
      case 163:
#line 583 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy419, yymsp[-1].minor.yy242, 0, yymsp[-4].minor.yy352, yymsp[-7].minor.yy316);}
#line 2526 "parse.c"
        break;
      case 164:
#line 585 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy419, 0, yymsp[0].minor.yy43, yymsp[-1].minor.yy352, yymsp[-4].minor.yy316);}
#line 2531 "parse.c"
        break;
      case 165:
#line 587 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy419, 0, 0, yymsp[-2].minor.yy352, yymsp[-5].minor.yy316);}
#line 2536 "parse.c"
        break;
      case 168:
      case 229:
#line 597 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-2].minor.yy242,yymsp[0].minor.yy450,0);}
#line 2542 "parse.c"
        break;
      case 169:
      case 230:
#line 598 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[0].minor.yy450,0);}
#line 2548 "parse.c"
        break;
      case 172:
#line 607 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(yymsp[-2].minor.yy352,&yymsp[0].minor.yy178);}
#line 2553 "parse.c"
        break;
      case 173:
#line 608 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(0,&yymsp[0].minor.yy178);}
#line 2558 "parse.c"
        break;
      case 175:
#line 619 "parse.y"
{yygotominor.yy450 = yymsp[-1].minor.yy450; sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2563 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 620 "parse.y"
{yygotominor.yy450 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2570 "parse.c"
        break;
      case 177:
      case 178:
#line 621 "parse.y"
{yygotominor.yy450 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2576 "parse.c"
        break;
      case 179:
#line 623 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy178);
  yygotominor.yy450 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2585 "parse.c"
        break;
      case 180:
#line 628 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy178);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy178);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy450 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2596 "parse.c"
        break;
      case 183:
#line 637 "parse.y"
{yygotominor.yy450 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2601 "parse.c"
        break;
      case 184:
#line 638 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy450 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2610 "parse.c"
        break;
      case 185:
#line 643 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy450, &yymsp[0].minor.yy178);
}
#line 2617 "parse.c"
        break;
      case 186:
#line 647 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy450, 0, &yymsp[-1].minor.yy178);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2625 "parse.c"
        break;
      case 187:
#line 652 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprFunction(yymsp[-1].minor.yy242, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy316 && yygotominor.yy450 ){
    yygotominor.yy450->flags |= EP_Distinct;
  }
}
#line 2636 "parse.c"
        break;
      case 188:
#line 659 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2644 "parse.c"
        break;
      case 189:
#line 663 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy450 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->op = TK_CONST_FUNC;  
    yygotominor.yy450->span = yymsp[0].minor.yy0;
  }
}
#line 2657 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 672 "parse.y"
{yygotominor.yy450 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy450, yymsp[0].minor.yy450, 0);}
#line 2669 "parse.c"
        break;
      case 198:
      case 200:
#line 682 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 0;}
#line 2675 "parse.c"
        break;
      case 199:
      case 201:
#line 683 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 1;}
#line 2681 "parse.c"
        break;
      case 204:
#line 690 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy450, 0);
  if( yymsp[0].minor.yy450 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy450, 0);
  }
  yygotominor.yy450 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy86.eOperator);
  if( yymsp[-2].minor.yy86.not ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy450->span, &yymsp[-1].minor.yy450->span);
  if( yygotominor.yy450 ) yygotominor.yy450->flags |= EP_InfixFunc;
}
#line 2697 "parse.c"
        break;
      case 205:
#line 703 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2705 "parse.c"
        break;
      case 206:
#line 707 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2713 "parse.c"
        break;
      case 207:
#line 711 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2721 "parse.c"
        break;
      case 208:
#line 715 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2729 "parse.c"
        break;
      case 209:
#line 719 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2737 "parse.c"
        break;
      case 210:
#line 723 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2745 "parse.c"
        break;
      case 211:
#line 727 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2753 "parse.c"
        break;
      case 214:
#line 734 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy450, 0);
  yygotominor.yy450 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy450, 0, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy450->span);
}
#line 2769 "parse.c"
        break;
      case 217:
#line 750 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pList = yymsp[-1].minor.yy242;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy242);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2783 "parse.c"
        break;
      case 218:
#line 760 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2796 "parse.c"
        break;
      case 219:
#line 769 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2810 "parse.c"
        break;
      case 220:
#line 779 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178);
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,yymsp[0].minor.yy178.z?&yymsp[0].minor.yy178:&yymsp[-1].minor.yy178);
  }
#line 2825 "parse.c"
        break;
      case 221:
#line 790 "parse.y"
{
    Expr *p = yygotominor.yy450 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy43;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
  }
#line 2838 "parse.c"
        break;
      case 222:
#line 802 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = yymsp[-2].minor.yy242;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy242);
  }
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2851 "parse.c"
        break;
      case 223:
#line 813 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 2859 "parse.c"
        break;
      case 224:
#line 817 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 2867 "parse.c"
        break;
      case 233:
#line 844 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy178, &yymsp[-5].minor.yy178, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy178,0), yymsp[-1].minor.yy242, yymsp[-9].minor.yy316,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy316);
}
#line 2875 "parse.c"
        break;
      case 234:
      case 282:
#line 850 "parse.y"
{yygotominor.yy316 = OE_Abort;}
#line 2881 "parse.c"
        break;
      case 235:
#line 851 "parse.y"
{yygotominor.yy316 = OE_None;}
#line 2886 "parse.c"
        break;
      case 238:
#line 861 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy178.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy178.z, yymsp[-1].minor.yy178.n);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242, p, &yymsp[-2].minor.yy178);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2899 "parse.c"
        break;
      case 239:
#line 870 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy178.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy178.z, yymsp[-1].minor.yy178.n);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy178);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2912 "parse.c"
        break;
      case 241:
#line 882 "parse.y"
{yygotominor.yy178.z = 0; yygotominor.yy178.n = 0;}
#line 2917 "parse.c"
        break;
      case 243:
#line 888 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy419, yymsp[-1].minor.yy316);}
#line 2922 "parse.c"
        break;
      case 244:
      case 245:
#line 893 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2928 "parse.c"
        break;
      case 246:
#line 900 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy178,0);}
#line 2933 "parse.c"
        break;
      case 247:
#line 901 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy0,0);}
#line 2938 "parse.c"
        break;
      case 248:
#line 902 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy178,1);
}
#line 2945 "parse.c"
        break;
      case 249:
#line 905 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy178,&yymsp[-3].minor.yy178,&yymsp[-1].minor.yy178,0);}
#line 2950 "parse.c"
        break;
      case 250:
#line 906 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178,0,0);}
#line 2955 "parse.c"
        break;
      case 258:
#line 920 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy178.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy178.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy75, &all);
}
#line 2965 "parse.c"
        break;
      case 259:
#line 929 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy178, &yymsp[-6].minor.yy178, yymsp[-5].minor.yy316, yymsp[-4].minor.yy354.a, yymsp[-4].minor.yy354.b, yymsp[-2].minor.yy419, yymsp[-1].minor.yy316, yymsp[0].minor.yy450, yymsp[-10].minor.yy316, yymsp[-8].minor.yy316);
  yygotominor.yy178 = (yymsp[-6].minor.yy178.n==0?yymsp[-7].minor.yy178:yymsp[-6].minor.yy178);
}
#line 2973 "parse.c"
        break;
      case 260:
      case 263:
#line 935 "parse.y"
{ yygotominor.yy316 = TK_BEFORE; }
#line 2979 "parse.c"
        break;
      case 261:
#line 936 "parse.y"
{ yygotominor.yy316 = TK_AFTER;  }
#line 2984 "parse.c"
        break;
      case 262:
#line 937 "parse.y"
{ yygotominor.yy316 = TK_INSTEAD;}
#line 2989 "parse.c"
        break;
      case 264:
      case 265:
#line 942 "parse.y"
{yygotominor.yy354.a = yymsp[0].major; yygotominor.yy354.b = 0;}
#line 2995 "parse.c"
        break;
      case 266:
#line 944 "parse.y"
{yygotominor.yy354.a = TK_UPDATE; yygotominor.yy354.b = yymsp[0].minor.yy352;}
#line 3000 "parse.c"
        break;
      case 267:
      case 268:
#line 947 "parse.y"
{ yygotominor.yy316 = TK_ROW; }
#line 3006 "parse.c"
        break;
      case 269:
#line 949 "parse.y"
{ yygotominor.yy316 = TK_STATEMENT; }
#line 3011 "parse.c"
        break;
      case 270:
#line 953 "parse.y"
{ yygotominor.yy450 = 0; }
#line 3016 "parse.c"
        break;
      case 271:
#line 954 "parse.y"
{ yygotominor.yy450 = yymsp[0].minor.yy450; }
#line 3021 "parse.c"
        break;
      case 272:
#line 958 "parse.y"
{
  if( yymsp[-2].minor.yy75 ){
    yymsp[-2].minor.yy75->pLast->pNext = yymsp[-1].minor.yy75;
  }else{
    yymsp[-2].minor.yy75 = yymsp[-1].minor.yy75;
  }
  yymsp[-2].minor.yy75->pLast = yymsp[-1].minor.yy75;
  yygotominor.yy75 = yymsp[-2].minor.yy75;
}
#line 3034 "parse.c"
        break;
      case 273:
#line 967 "parse.y"
{ yygotominor.yy75 = 0; }
#line 3039 "parse.c"
        break;
      case 274:
#line 973 "parse.y"
{ yygotominor.yy75 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy178, yymsp[-1].minor.yy242, yymsp[0].minor.yy450, yymsp[-4].minor.yy316); }
#line 3044 "parse.c"
        break;
      case 275:
#line 978 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy178, yymsp[-4].minor.yy352, yymsp[-1].minor.yy242, 0, yymsp[-7].minor.yy316);}
#line 3049 "parse.c"
        break;
      case 276:
#line 981 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy178, yymsp[-1].minor.yy352, 0, yymsp[0].minor.yy43, yymsp[-4].minor.yy316);}
#line 3054 "parse.c"
        break;
      case 277:
#line 985 "parse.y"
{yygotominor.yy75 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy178, yymsp[0].minor.yy450);}
#line 3059 "parse.c"
        break;
      case 278:
#line 988 "parse.y"
{yygotominor.yy75 = sqlite3TriggerSelectStep(yymsp[0].minor.yy43); }
#line 3064 "parse.c"
        break;
      case 279:
#line 991 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy450 ){
    yygotominor.yy450->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3075 "parse.c"
        break;
      case 280:
#line 998 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy178); 
  if( yygotominor.yy450 ) {
    yygotominor.yy450->iColumn = yymsp[-3].minor.yy316;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3086 "parse.c"
        break;
      case 281:
#line 1008 "parse.y"
{yygotominor.yy316 = OE_Rollback;}
#line 3091 "parse.c"
        break;
      case 283:
#line 1010 "parse.y"
{yygotominor.yy316 = OE_Fail;}
#line 3096 "parse.c"
        break;
      case 284:
#line 1015 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy419,yymsp[-1].minor.yy316);
}
#line 3103 "parse.c"
        break;
      case 285:
#line 1021 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, yymsp[0].minor.yy158);
}
#line 3110 "parse.c"
        break;
      case 286:
#line 1026 "parse.y"
{ yygotominor.yy158 = 0; }
#line 3115 "parse.c"
        break;
      case 287:
#line 1027 "parse.y"
{ yygotominor.yy158 = yymsp[0].minor.yy450; }
#line 3120 "parse.c"
        break;
      case 290:
#line 1033 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy450);
}
#line 3127 "parse.c"
        break;
      case 291:
#line 1039 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3132 "parse.c"
        break;
      case 292:
#line 1040 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy178, &yymsp[0].minor.yy178);}
#line 3137 "parse.c"
        break;
      case 293:
#line 1045 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3142 "parse.c"
        break;
      case 294:
#line 1046 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy178, &yymsp[0].minor.yy178);}
#line 3147 "parse.c"
        break;
      case 295:
#line 1051 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy419,&yymsp[0].minor.yy178);
}
#line 3154 "parse.c"
        break;
      case 296:
#line 1054 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy178);
}
#line 3161 "parse.c"
        break;
      case 297:
#line 1057 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy419);
}
#line 3168 "parse.c"
        break;
      case 300:
#line 1066 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3173 "parse.c"
        break;
      case 301:
#line 1067 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3178 "parse.c"
        break;
      case 302:
#line 1068 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy178, &yymsp[-2].minor.yy178, &yymsp[0].minor.yy178);
}
#line 3185 "parse.c"
        break;
      case 305:
#line 1073 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3190 "parse.c"
        break;
      case 307:
      case 308:
      case 309:
      case 311:
#line 1075 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3198 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3266 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
