/*
 * Copyright (C), 2000-2006 by the monit project group.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <config.h>

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "protocol.h"

/**
 *  Simple MySQL test.
 *
 *  In the case that the anonymous login is possible,
 *  we will perform MySQL ping. If authentication failed
 *  we suppose the anonymous login is denied and we will
 *  return success, because the server at least performed
 *  authentication => it seems it works.
 *
 *  @author Martin Pala, <martinp@tildeslash.com>
 *
 *  @version \$Id: mysql.c,v 1.9 2006/04/27 20:16:03 martinp Exp $
 *
 *  @file
 */
int check_mysql(Socket_T s) {

  unsigned char buf[STRLEN];

  unsigned char requestLogin[10] = {
    0x06,                                 /** Packet Length */
    0x00,
    0x00,

    0x01,                                 /** Packet Number */

    0x00,                                         /** Flags */

    0x00,                                    /** Max Packet */
    0x00,
    0x00,

    0x00,                                       /** Username*/

    0x00                                        /** Password*/
  };

  unsigned char requestPing[5] = {
    0x01,                                 /** Packet Length */
    0x00,
    0x00,

    0x00,                                 /** Packet Number */

    0x0E                                   /** Command Ping */
  };

  unsigned char responsePing[5] = {
    0x03,                                 /** Packet Length */
    0x00,
    0x00,

    0x01,                                 /** Packet Number */

    0x00                               /** Response Code OK */

                                        /** Padding Ignored */
  };

  unsigned char requestQuit[5] = {
    0x01,                                 /** Packet Length */
    0x00,
    0x00,

    0x00,                                 /** Packet Number */

    0x01                                   /** Command Quit */
  };

  ASSERT(s);

  if(!socket_readln(s, (char *)buf, sizeof(buf))) {
    LogError("MYSQL: error receiving greeting -- %s\n", STRERROR);
    return FALSE;
  }

  if(socket_write(s, requestLogin, sizeof(requestLogin)) < 0) {
    LogError("MYSQL: error sending login -- %s\n", STRERROR);
    return FALSE;
  }

  /* read just first few bytes  which contains enough information */
  if(socket_read(s, buf, 7) <= 6) {
    LogError("MYSQL: error receiving login response -- %s\n", STRERROR);
    return FALSE;
  }

  /* Compare Packet Number: */
  if(buf[3] != 0x02) {
    LogError("MYSQL: invalid response packet number\n");
    return FALSE;
  }

  /* Compare Response Code: */

  /* If OK, we are loged in and will perform MySQL ping */
  if(buf[4] == 0x00) {
    if(socket_write(s, (unsigned char *)requestPing, sizeof(requestPing)) < 0) {
      LogError("MYSQL: error sending ping -- %s\n", STRERROR);
      return FALSE;
    }

    if(socket_read(s, buf, sizeof(responsePing)) <= 0) {
      LogError("MYSQL: error receiving ping response -- %s\n", STRERROR);
      return FALSE;
    }

    if(memcmp((unsigned char *)buf,
  	      (unsigned char *)responsePing, sizeof(responsePing))) {
      LogError("MYSQL: ping failed\n");
      return FALSE;
    }

    if(socket_write(s, (unsigned char *)requestQuit, sizeof(requestQuit)) < 0) {
      LogError("MYSQL: error sending quit -- %s\n", STRERROR);
      return FALSE;
    }

    return TRUE;
  }
  /* If Authentication Failed, return success immediately */
  else if((buf[4] == 0xFF) && (buf[5] == 0x15 && buf[6] == 0x04)) {
    return TRUE;
  }

  LogError("MYSQL: login failed\n");

  return FALSE;
}

