/*
 * Copyright (C), 2000-2006 by the monit project group.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <config.h>

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "protocol.h"

/**
*  Check the server for greeting code 220 and then send QUIT and
 *  check for code 221. If alive return TRUE, else, return FALSE.
 *
 *  @author Jan-Henrik Haukeland, <hauk@tildeslash.com>
 *  @author Michael Amster, <mamster@webeasy.com>
 *
 *  @version \$Id: smtp.c,v 1.27 2006/04/27 20:16:03 martinp Exp $
 *
 *  @file
 */
int check_smtp(Socket_T s) {
  
  int status;
  char buf[STRLEN];
  
  ASSERT(s);
  
  if(!socket_readln(s, buf, sizeof(buf))) {
    LogError("SMTP: error receiving data -- %s\n", STRERROR);
    return FALSE;
  }
  
  Util_chomp(buf);
  
  sscanf(buf, "%d%*s", &status);
  if(status != 220) {
    LogError("SMTP error: %s\n", buf);
    return FALSE;
  }
  
  /* Terminate the session */
  if(socket_print(s, "QUIT\r\n") < 0) {
    LogError("SMTP: error sending data -- %s\n", STRERROR);
    return FALSE;
  }
  
  /* Check the reply */
  if(!socket_readln(s, buf, sizeof(buf))) {
    LogError("SMTP: error receiving data -- %s\n", STRERROR);
    return FALSE;
  }
  
  Util_chomp(buf);
  
  sscanf(buf, "%d%*s", &status);
  if(status != 221) {
    LogError("SMTP error: %s\n", buf);
    return FALSE;
  }
  
  return TRUE;
  
}

