/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_countries.c,v 1.16 2003/01/06 11:19:21 ostborn Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"
/* calculating the box
**
** +------------------------------+
** |+----------------------------+|
** ||                            ||
** ||#                           ||
** ||##  #    (1)                ||
** ||## ##                       ||
** ||#####                       ||
** ||#####                       ||
** |+----------------------------+|
** +------------------------------+
**
*/


#define IM_CELLSPACING	  4
#define IM_CIRCLE_X	200
#define IM_CIRCLE_Y	130
#define IM_TEXT_LEN	 32
#define IM_CIRCLE_DROP_Y 10

/* gdSmallFont */
#define IM_FONT_HEIGHT	 13
#define IM_FONT_WIDTH	  6

#define IM_TEXT_BOX	IM_TEXT_LEN * IM_FONT_WIDTH

#define IM_BOX1_X1	IM_CELLSPACING * 2
#define IM_BOX1_Y1	IM_CELLSPACING * 2
#define IM_BOX1_X2	IM_BOX1_X1 + IM_CIRCLE_X + 2 * IM_CELLSPACING + IM_TEXT_BOX
#define IM_BOX1_Y2	IM_BOX1_Y1 + IM_CIRCLE_Y + 2 * IM_CELLSPACING + 2 * IM_CIRCLE_DROP_Y

#define IM_WIDTH	IM_BOX1_X2 + IM_CELLSPACING * 2
#define IM_HEIGHT	IM_BOX1_Y2 + IM_CELLSPACING * 2

#define IM_FILENAME	"countries_"
#define IM_FILEEXT	".png"

#ifndef PI
#define PI 3.14159265358979323846
#endif

int mlist_sum_count(mlist *l) {
	int c = 0;
	if (!l) return 0;

	for (; l && l->data; l = l->next) {
		c += mdata_get_count(l->data);
	}

	return c;
}

int mhash_sum_count(mhash *h) {
	int i, c = 0;
	if (!h) return 0;

	for ( i = 0; i < h->size; i++) {
		c += mlist_sum_count(h->data[i]->list);
	}

	return c;
}

char *create_pic_countries(mconfig *ext_conf, mstate *state, const char *subpath) {
#ifdef HAVE_LIBGD
	int i = 0, j = 0;
	gdImage *im, *im_rest;
	FILE *f;
	char filename[255];
	rgb_tripple rgb;
	config_output *conf = ext_conf->plugin_conf;
	mlist *l = mlist_init(), *list_handle;
	mstate_web *staweb = state->ext;

	static char href[255] = "";

	int col_border, col_backgnd, col_trans,
		col_border_sh, last_col = 0;
	int col[8];
	int y2, y1 = IM_BOX1_Y1 + IM_CIRCLE_DROP_Y, y1_tb = y1;
	int x2, x1 = IM_BOX1_X1, x1_tb = x1 + IM_CIRCLE_X + 3 * IM_CELLSPACING + IM_CIRCLE_DROP_Y;
	int box1_ym = y1 + (IM_CIRCLE_Y / 2) + IM_CELLSPACING;
	int box1_xm = x1 + (IM_CIRCLE_X / 2) + IM_CELLSPACING;

	int start = 0, end;

	im = gdImageCreate( IM_WIDTH + 1,IM_HEIGHT + 1 );

	col_border	= gdImageColorAllocate(im, 0x00, 0x00, 0x00);

	html3torgb3(conf->col_shadow, &rgb);
	col_border_sh	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_backgnd, &rgb);
	col_backgnd	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	col_trans	= gdImageColorAllocate(im, 0xef, 0xef, 0xef);
	gdImageColorTransparent(im, col_trans);



	col[0]	= gdImageColorAllocate(im, 0x00, 0x00, 0xff);
	col[1]	= gdImageColorAllocate(im, 0x00, 0xff, 0xff);
	col[2]	= gdImageColorAllocate(im, 0xff, 0x00, 0xff);
	col[3]	= gdImageColorAllocate(im, 0xff, 0xff, 0xff);
	col[4]	= gdImageColorAllocate(im, 0x80, 0xff, 0x00);
	col[5]	= gdImageColorAllocate(im, 0xff, 0xff, 0x00);
	col[6]	= gdImageColorAllocate(im, 0xff, 0x00, 0x00);
	col[7]	= gdImageColorAllocate(im, 0x80, 0x80, 0xff);


/* background */
	gdImageFilledRectangle(im, 0, 0, IM_WIDTH-1, IM_HEIGHT-1, col_backgnd);
/* surrounding border */
	gdImageRectangle( im, 1, 1, IM_WIDTH-1, IM_HEIGHT-1, col_border );
	gdImageRectangle( im, 0, 0, IM_WIDTH, IM_HEIGHT, col_border_sh );

/* border for BOX1 */
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING,
		IM_BOX1_Y1 - IM_CELLSPACING,
		IM_BOX1_X2 + IM_CELLSPACING,
		IM_BOX1_Y2 + IM_CELLSPACING,
		col_border);
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING + 1,
		IM_BOX1_Y1 - IM_CELLSPACING + 1,
		IM_BOX1_X2 + IM_CELLSPACING + 1,
		IM_BOX1_Y2 + IM_CELLSPACING + 1,
		col_border_sh);

	i = mhash_sum_count(staweb->country_hash);

	mhash_unfold_sorted_limited(staweb->country_hash, l, 50);

	list_handle = l;

	x1 = box1_xm + IM_CIRCLE_X / 4;
	y1 = box1_ym;

	x2 = box1_xm + IM_CIRCLE_X / 2;
	y2 = box1_ym;

	gdImageLine(im, box1_xm, box1_ym, x2, y2, col_border);
	gdImageLine(im, box1_xm + IM_CIRCLE_X / 2, box1_ym, box1_xm + IM_CIRCLE_X / 2, box1_ym + IM_CIRCLE_DROP_Y, col_border);
	gdImageLine(im, box1_xm - IM_CIRCLE_X / 2, box1_ym, box1_xm - IM_CIRCLE_X / 2, box1_ym + IM_CIRCLE_DROP_Y, col_border);

	for (; l; l = l->next) {
		mdata *data = l->data;
		double percent;
		int x3, y3;
		char numstr[20];
		char str[IM_TEXT_LEN];

		if (!data) continue;

		percent = (double)mdata_get_count(data) / i;

		end = (360 * percent) + start;

		if ((y1_tb + IM_FONT_HEIGHT) > (IM_BOX1_Y2 - IM_CELLSPACING)) {
			break;
		}

		x2 = cos(2 * PI * end / 360) * ((IM_CIRCLE_X - 2) / 2) + box1_xm;
		y2 = sin(2 * PI * end / 360) * ((IM_CIRCLE_Y - 2) / 2) + box1_ym;

		x3 = cos(2 * PI * end / 360) * ((IM_CIRCLE_X - 2) / 4) + box1_xm;
		y3 = sin(2 * PI * end / 360) * ((IM_CIRCLE_Y - 2) / 4) + box1_ym;


		gdImageLine(im, box1_xm, box1_ym, x2, y2, col_border);
		if (start < 180) {
			if (end < 180) {
				gdImageArc(im, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
				gdImageLine(im, x2, y2, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
				gdImageFill(im, (x3 + x1) / 2, (y3 + y1) / 2, col[j]);
				gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
			} else {
				gdImageArc(im, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, IM_CIRCLE_X, IM_CIRCLE_Y, start, 180, col_border);
				gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, 180, end, col_border);
				if (end - start < 180) {
					gdImageFill(im, (x3 + x1) / 2, (y3 + y1) / 2, col[j]);
				} else {
					gdImageFill(im, 2 * box1_xm - ((x3 + x1) / 2), 2 * box1_ym - ((y3 + y1) / 2), col[j]);
				}
				gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
			}

		} else {
			gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
			gdImageFill(im, (x3 + x1) / 2, (y3 + y1) / 2, col[j]);
		}

		sprintf(numstr, "%%2i%%%% %%.%is", IM_TEXT_LEN-5);
		sprintf(str, numstr, (int)(percent * 100), data->key);

		gdImageString(im, gdFontSmall, x1_tb+1, y1_tb+1, str, col_border_sh);
		gdImageString(im, gdFontSmall, x1_tb, y1_tb, str, col[j]);

		y1_tb += IM_FONT_HEIGHT + 2;

		last_col = col[j];

		if (++j >= sizeof(col) / sizeof(int)) {
			j = 1;
		}

		x1 = x3;
		y1 = y3;

		start = end;
	}

	/* draw the rest as one great piece of the pie */
	if (l && l->data){
		int x3, y3, x4, y4;

		if (x2 > box1_xm) {
			int x5;

			x5 = box1_xm - IM_CIRCLE_DROP_Y * (box1_xm - x2) / (box1_ym - y2);

			gdImageLine(im, x2, y2, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
			gdImageLine(im, x5, box1_ym, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
		}

		box1_ym -= IM_CIRCLE_DROP_Y;
		box1_xm += IM_CIRCLE_DROP_Y;
		y2 -= IM_CIRCLE_DROP_Y;
		x2 += IM_CIRCLE_DROP_Y;

		y4 = y2;
		x4 = x2;

		end = 360;

		im_rest = gdImageCreate( IM_WIDTH + 1,IM_HEIGHT + 1 );
	/* background */
		gdImagePaletteCopy(im_rest, im);
		gdImageColorTransparent(im_rest, col_trans);
		gdImageFilledRectangle(im_rest, 0, 0, IM_WIDTH-1, IM_HEIGHT-1, col_trans);

		if (x4 > box1_xm) {
			gdImageLine(im_rest, box1_xm, box1_ym, x4, y4, col_border);
			gdImageLine(im_rest, box1_xm, box1_ym, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, col_border);
		} else {
			gdImageLine(im_rest, x4, y4, x4, y4 + IM_CIRCLE_DROP_Y, col_border);
			gdImageLine(im_rest, x4, y4 + IM_CIRCLE_DROP_Y, box1_xm, box1_ym+ IM_CIRCLE_DROP_Y, col_border);
		}

		x2 = cos(2 * PI * end / 360) * ((IM_CIRCLE_X - 2) / 2) + box1_xm;
		y2 = sin(2 * PI * end / 360) * ((IM_CIRCLE_Y - 2) / 2) + box1_ym;

		x3 = cos(2 * PI * end / 360) * ((IM_CIRCLE_X - 2) / 4) + box1_xm;
		y3 = sin(2 * PI * end / 360) * ((IM_CIRCLE_Y - 2) / 4) + box1_ym;

		gdImageLine(im_rest, x2, y2, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
		gdImageLine(im_rest, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
		gdImageArc(im_rest, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);

		gdImageFill(im_rest, (x3 + x1) / 2, (y3 + y1) / 2, col[j]);
		gdImageLine(im_rest, box1_xm, box1_ym, x2, y2, col_border);

		if (x4 <= box1_xm) {
			gdImageLine(im_rest, box1_xm, box1_ym, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, col_border);
			gdImageLine(im_rest, box1_xm, box1_ym, x4, y4, col_border);
		}

		gdImageCopy(im, im_rest, 0, 0, 0, 0, IM_WIDTH, IM_HEIGHT);

		gdImageDestroy(im_rest);
	}

	mlist_free(list_handle);

	sprintf(filename, "%s%s%s/%s%04d%02d%s",
		conf->outputdir ? conf->outputdir : ".",
		subpath ? "/" : "",
		subpath ? subpath : "",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);

	if ((f = fopen (filename, "wb"))) {
		gdImagePng(im, f);

		fclose(f);
	}

	gdImageDestroy(im);

	sprintf(href, "<center><img src=\"%s%04d%02d%s\" alt=\"%s\" width=\"%d\" height=\"%d\" /></center>\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Hourly usage"), IM_WIDTH+1, IM_HEIGHT+1);

	return href;
#else
	return NULL;
#endif
}

