/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.24 2003/04/18 18:34:38 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <pcre.h>

#include "mio.h"
#include "mconfig.h"
#include "mrecord.h"
#include "mlist.h"

#define M_CLF_MAX_FIELDS	20
#define UA_CACHE_SIZE 12


typedef struct {
	char *key;
	char *ua_os;
	time_t timestamp;
} ua_cache;


typedef struct {
	mlist	*match_useragent;
	mfile	inputfile;
	buffer	*buf;
	
	char	*inputfilename;

	char	*format;
	
	mlist	*record_list;

	pcre		*match_clf;
	pcre_extra	*match_clf_extra;
	pcre		*match_clf_extended;
	pcre_extra	*match_clf_extended_extra;
	pcre		*match_clf_squid;
	pcre_extra	*match_clf_squid_extra;
#ifdef USE_REGEX_VERSIONS
	pcre		*match_timestamp;
	pcre_extra	*match_timestamp_extra;
	pcre		*match_url;
	pcre_extra	*match_url_extra;
	pcre		*match_referrer;
	pcre_extra	*match_referrer_extra;
#endif
	int	trans_fields[M_CLF_MAX_FIELDS];
	
	ua_cache ua_cache[UA_CACHE_SIZE];
} config_input;

#define M_CLF_FIELD_UNSET		0
#define M_CLF_FIELD_TIMESTAMP		1
#define M_CLF_FIELD_USERNAME		2
#define M_CLF_FIELD_SERVER_IP		3
#define M_CLF_FIELD_SERVER_PORT		4
#define M_CLF_FIELD_REQUEST		5
#define M_CLF_FIELD_STATUS		6
#define M_CLF_FIELD_AUTH_USERNAME	7
#define M_CLF_FIELD_BYTES_SEND		8
#define M_CLF_FIELD_REQ_HOST		9
#define M_CLF_FIELD_USER_AGENT		10
#define M_CLF_FIELD_REFERRER		11
#define M_CLF_FIELD_DURATION		12
#define M_CLF_FIELD_REMOTE_IP		13
#define M_CLF_FIELD_CONNECTION_STATUS   14

int mplugins_input_clf_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
