#!/usr/bin/perl -w

# convert configfile from older version of modlogan (prior 0.5.5) to the new
# pcre matching/grouping rules
#
# usage:
# $ ./convert_to_055.pl < modlogan.conf > modlogan.conf.new
# $ mv modlogan.conf.new modlogan.conf
# 

use strict;

sub t {
	my ($s) = @_;
	
	$s =~ s/\./\\./g;
	
	if ($s =~ /^\*/) {
		$s =~ s/^\*//;
	} else {
		$s = "^".$s;
	}
	
	if ($s =~ /\*$/) {
		$s =~ s/\*//;
	} else {
		$s .= "\$";
	}
	
	$s = "\"".$s."\"";
	
	return $s;
}

while (<>) {
	if ((/^grou/ && !(/^grouping/))|| /^hid/ || /^match/ || /^pagetype/) {
		
		if (/^(group.*)=(.+),(.+)$/) {
			print "# S ".$1." = ".$2.",".$3."\n";
			print $1." = ".(t($2)).",".$3."\n";
		} elsif (/^((hid|match|pagetype).*)=(.+)$/) {
			print "# M ".$1." =".$3."\n";
			print $1." = ".(t($3))."\n";
		} else {
			print "# N ".$_;
		}
	} else {
		print $_;
	}
}