/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_hour.c,v 1.9 2003/07/29 12:38:37 miham Exp $
*/
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"

#define IM_FILENAME "hourly_usage_"
#define IM_FILEEXT  ".png"

char *create_pic_24_hour(mconfig *ext_conf, mstate *state) {
#ifdef HAVE_LIBGD
	char filename[255];
	config_output *conf = ext_conf->plugin_conf;
	mstate_web *staweb = state->ext;
	int i;

	static char href[255] = "";

	mgraph * graph = malloc(sizeof(mgraph));
	memset(graph, 0, sizeof(mgraph));

	graph->name = malloc(strlen(_("Hourly usage for %1$s %2$04d")) + 
											 strlen(get_month_string(state->month,0)) - 5 );
	sprintf(graph->name, _("Hourly usage for %1$s %2$04d"),
		get_month_string(state->month,0),
		state->year
		);

	graph->max_x = 24;
	graph->max_z = 3;
	graph->filename = NULL;
	graph->height = 0;
	graph->width  = 0;

	graph->pairs = malloc(sizeof(mgraph_array *) * graph->max_z);
	for (i = 0; i < graph->max_z; i++) {
		graph->pairs[i] = malloc(sizeof(mgraph_array));
		graph->pairs[i]->values = malloc(sizeof(double) * graph->max_x);
	}

	graph->pair_names = malloc(sizeof(mgraph_array *) * graph->max_x);
	for (i = 0; i < graph->max_x; i++) {
		graph->pairs[0]->values[i] = staweb->hours[i].hits;
		graph->pairs[1]->values[i] = staweb->hours[i].files;
		graph->pairs[2]->values[i] = staweb->hours[i].pages;

		graph->pair_names[i] = malloc(3);
		sprintf(graph->pair_names[i], "%02d", i);
	}

	graph->pairs[0]->name = _("Hits");
	graph->pairs[0]->color = conf->col_hits;
	graph->pairs[1]->name = _("Files");
	graph->pairs[1]->color = conf->col_files;
	graph->pairs[2]->name = _("Pages");
	graph->pairs[2]->color = conf->col_pages;

	sprintf(filename, "%s/%s%04d%02d%s",
		conf->outputdir,
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);

	graph->filename = filename;

	create_bars(ext_conf, graph);

	sprintf(href, "<img src=\"%s%04d%02d%s\" alt=\"%s\" width=\"%d\" height=\"%d\">\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Hourly usage"), graph->width, graph->height);

	for (i = 0; i < graph->max_z; i++) {
		free(graph->pairs[i]->values);
		free(graph->pairs[i]);
	}

	for (i = 0; i < graph->max_x; i++) {
		free(graph->pair_names[i]);
	}

	free(graph->pair_names);
	free(graph->pairs);
	free(graph->name);
	free(graph);

	return href;
#else
	return NULL;
#endif
}

