/* 
**  origin.c -- Apache layout module
**  $Revision: 1.12 $
*/

#include "mod_layout.h"

LAYOUT_EXPORT(int) layout_origin(request_rec *r, layout_conf *cfg, layout_request *info) {
	int status = OK;
	request_rec *subr;
	const char *type = NULL;

#ifdef DEBUG
		printf("Calling Origin\n");
#endif
	subr = (request_rec *) ap_sub_req_method_uri((char *) r->method, r->uri, r);

	if(isOn(cfg->async_post) && info->length)  {
		reset_fd(r, info->length);
	}

	subr->assbackwards = 0;
	subr->args = r->args;
	ap_bsetflag(subr->connection->client, B_CHUNK, 0);
	status = ap_run_sub_req(subr);

	table_cat(subr->headers_out, r->headers_out, "Set-Cookie");
	table_cat(subr->headers_out, r->headers_out, "Location");
	table_cat(subr->headers_out, r->headers_out, "WWW-Authenticate");
	table_cat(subr->headers_out, r->headers_out, "Pragma");
	table_cat(subr->notes, r->notes, NULL);
	type = ap_table_get(subr->headers_out, "Content-Type");
	if(type)
		info->type = ap_pstrdup(r->pool, type);
#ifdef DEBUG
	printf("Found type for Origin  %s\n", type);
#endif

	r->status_line = ap_pstrdup(r->pool, subr->status_line);
	r->status = subr->status;
	ap_destroy_sub_req(subr);

#ifdef DEBUG
	printf("Status from origin was %d\n", status);
#endif

	return status;
}
