<?php

$block_name = _("Notes Summary");

/**
 * Implementation of Horde_Block api to show notes summary.
 *
 * $Horde: mnemo/lib/Block/summary.php,v 1.22.8.1 2005/05/10 04:32:34 chuck Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_Mnemo_summary extends Horde_Block {

    var $_app = 'mnemo';

    function _title()
    {
        global $registry;
        require_once dirname(__FILE__) . '/../Mnemo.php';

        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->get('name')) . $registry->get('name') . '</a> :: ';
        $html .= Horde::link(Horde::applicationUrl('memo.php?actionID=add_memo', true), _("New Note")) . Horde::img('mnemo.png', _("New Note"), '', Horde::url($registry->getImageDir(), true, -1)) . ' ' . _("New Note") . '</a>';

        return $html;
    }

    function _params()
    {
        require_once dirname(__FILE__) . '/../base.php';
        require_once 'Horde/Prefs/CategoryManager.php';
        $cManager = &new Prefs_CategoryManager();
        $categories = array();
        foreach ($cManager->get() as $c) {
            $categories[$c] = $c;
        }

        return array('show_actions' => array('type' => 'checkbox',
                                             'name' => _("Show action buttons?"),
                                             'default' => 1),
                     'show_notepad' => array('type' => 'checkbox',
                                             'name' => _("Show notepad name?"),
                                             'default' => 1),
                     'show_categories' => array('type' => 'multienum',
                                                'name' => _("Show notes from these categories"),
                                                'default' => array(),
                                                'values' => $categories)
               );
    }

    function _content()
    {
        require_once dirname(__FILE__) . '/../base.php';
        global $registry, $prefs, $conf;

        if (!isset($conf['storage']['driver']) ||
            !isset($conf['storage']['params'])) {
            return PEAR::raiseError('Not configured');
        }

        require_once 'Horde/Prefs/CategoryManager.php';
        $cManager = &new Prefs_CategoryManager();
        $colors = $cManager->colors();
        $fgcolors = $cManager->fgColors();

        if (!empty($this->_params['show_notepad'])) {
            $shares = &Horde_Share::singleton('mnemo');
        }

        $html = '<table cellspacing="1" width="100%" class="item">';
        $memos = Mnemo::listMemos($prefs->getValue('sortby'),
                                  $prefs->getValue('sortdir'));
        foreach ($memos as $id => $memo) {
            if (!empty($this->_params['show_categories']) &&
                !in_array($memo['category'], $this->_params['show_categories'])) {
                continue;
            }

            $html .= '<tr class="text">';

            if (!empty($this->_params['show_actions'])) {
                $editurl = Util::addParameter('memo.php', 'memo', $memo['memo_id']);
                $editurl = Util::addParameter($editurl, 'memolist', $memo['memolist_id']);
                $html .= '<td width="1%">' . Horde::link(Horde::applicationUrl(Util::addParameter($editurl, 'actionID', 'modify_memo')), _("Edit Note"), 'widget') . Horde::img('edit.png', _("Edit Note"), '', $registry->getImageDir('horde')) . '</a></td>';
            }

            if (!empty($this->_params['show_notepad'])) {
                $owner = $memo['memolist_id'];
                $share = $shares->getShare($owner);
                if (!is_a($share, 'PEAR_Error')) {
                    $owner = $share->get('name');
                }
                $html .= '<td align="center" class="nowrap">';
                $html .= $owner . '</td>';
            }

            $html .= '<td>';
            $viewurl = Util::addParameter('view.php', 'memo', $memo['memo_id']);
            $viewurl = Util::addParameter($viewurl, 'memolist', $memo['memolist_id']);
            $html .= Horde::link(Horde::applicationUrl($viewurl, true), $memo['desc']) . htmlspecialchars($memo['desc']) . '</a></td>';

            $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : $colors['_default_'];
            $fgcolor = isset($fgcolors[$memo['category']]) ? $fgcolors[$memo['category']] : $fgcolors['_default_'];
            $html .= '<td width="1%" nowrap="nowrap" style="background-color:' .
                $color . ';color:' . $fgcolor . ';">&nbsp;' .
                htmlspecialchars($memo['category'] ? $memo['category'] : _("Unfiled")) .
                "&nbsp;</td></tr>\n";
        }
        if (!count($memos)) {
            $html .= '<tr><td><i>' . _("No notes to display") . '</i></td></tr>';
        }
        $html .= '</table>';

        return $html;
    }

}
