/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2001 by The Mico Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  For more information, visit the MICO Home Page at
 *  http://www.mico.org/
 */

#ifndef __DB_H__
#define __DB_H__

#include "parsenode.h"


class DB
{
private:
  CORBA::Container_var _con;
  
  typedef map<string, string, less<string> > RepoidFnameMap;
  RepoidFnameMap _repoid_fname_map;

  string _toplevel_fname;

  typedef vector<vector<string> > VecVecString;
  
  VecVecString    _current_scope;
  vector<string>  _current_prefix;
  vector<string>  _version_name;
  vector<string>  _version;
  vector<string>  _id_name;
  vector<string>  _id;
  vector<string>  _prefix_name;
  vector<string>  _prefix;

public:
  DB();
  ~DB();

  string gen_pseudo_repoid( CORBA::IDLType_ptr t );
  void register_anonym_type( ParseNode* node, CORBA::IDLType_ptr t );
  void register_repoid( ParseNode* node, string &id );
  void register_repoid( string &id, string &fname );

  bool repoid_defined( string& id );
  string get_fname_for_repoid( string& id );
  string get_toplevel_fname ();
  void set_toplevel_fname (const char *);

  void enter_scope( string& name );
  void leave_scope();
  void enter_include_file();
  void leave_include_file();
  void switch_prefix( string& name );
  string get_current_scope();
  string get_current_prefix();
  string get_prefix(const char *);
  void set_prefix( string& name, string& prefix );
  void set_repo_version( string& name, string& version );
  void set_repo_id( string& name, string& id );
  void set_repoids( CORBA::Repository_ptr repo );

  void add_forward_dcl( const char* scoped_name );
  void remove_forward_dcl( const char* scoped_name );
  bool is_in_forward_dcl( const char* scoped_name );
  set<string, less<string> > _forward_dcl;
};


#endif
