/*
 *  Mico --- a free CORBA implementation
 *  Copyright Frank Pilhofer
 *
 *  This file is part of MicoCCM, written by Frank Pilhofer.
 *  The MICO CORBA Component Project was sponsored by Alcatel.
 */

#include <CORBA.h>
#include <stdio.h>
#include <unistd.h>
#include <mico/ir_creator.h>
#include <mico/util.h>
#include <mico/os-misc.h>
#include "parser.h"
#include "idlparser.h"
#include "params.h"
#include "db.h"
#include "codegen.h"
#include "codegen-c++-util.h"

#ifndef CPP
#define CPP "mico-cpp"
#endif

static const char *copyright[] = {
  "/*",
  " *  MICO --- a free CORBA implementation",
  " *",
  " *  MicoCCM written by Frank Pilhofer, sponsored by Alcatel",
  " *"
  " *  This file was automatically generated. DO NOT EDIT!",
  " */"
};

static const int copyright_size = sizeof( copyright ) / sizeof( char * );

/*
 * ----------------------------------------------------------------------
 */

class CCMCodeGenCpp : virtual public CodeGenCPPUtil
{
public:
  enum ComponentType {
    ServiceComponent,
    SessionComponent,
    ProcessComponent,
    EntityComponent
  };

  CCMCodeGenCpp (DB &db, IDLParam & params, CORBA::Container_ptr con,
		 ComponentType type, bool standalone);
  void emit (string &fnbase);

private:
  void emit_user_decl ();
  void emit_user_stub ();
  void emit_glue_code ();

  void emitComponentDecl (CORBA::ComponentIR::ComponentDef_ptr);
  void emitHomeDecl      (CORBA::ComponentIR::HomeDef_ptr);

  void emitComponentStub (CORBA::ComponentIR::ComponentDef_ptr);
  void emitHomeStub      (CORBA::ComponentIR::HomeDef_ptr);

  void emitComponentGlueDecl (CORBA::ComponentIR::ComponentDef_ptr);
  void emitHomeGlueDecl      (CORBA::ComponentIR::HomeDef_ptr);
  void emitComponentGlueImpl (CORBA::ComponentIR::ComponentDef_ptr);
  void emitHomeGlueImpl      (CORBA::ComponentIR::HomeDef_ptr);

  void emitInterfaceGlueDecl (CORBA::InterfaceDef_ptr,
			      CORBA::ComponentIR::ComponentDef_ptr,
			      const char *);
  void emitInterfaceGlueImpl (CORBA::InterfaceDef_ptr,
			      CORBA::ComponentIR::ComponentDef_ptr,
			      const char *);

private:
  bool _standalone;
  ComponentType _type;
};

/*
 * ----------------------------------------------------------------------
 */

CCMCodeGenCpp::CCMCodeGenCpp (DB & db, IDLParam & params,
			      CORBA::Container_ptr con,
			      ComponentType type,
			      bool standalone)
  : CodeGen (con), CodeGenCPPUtil (db, params, con)
{
  _type = type;
  _standalone = standalone;
  assert (_type == ServiceComponent ||
	  _type == SessionComponent);
}

void
CCMCodeGenCpp::emit (string & fn)
{
  string fnbase = fn;

  for( string::size_type i = 0; i < fnbase.length(); i++ ) {
    fnbase[ i ] = isalnum( fnbase[ i ] ) ? toupper( fnbase[ i ] ) : '_';
  }

  string fnHeader = fn + "_ccm." + _params.hh_suffix;
  string fnStub   = fn + "_ccm." + _params.cpp_suffix;

  ofstream header (fnHeader.c_str());

  for( int i0 = 0; i0 < copyright_size; i0++ )
    header << copyright[ i0 ] << endl;
  
  header << endl;
  header << "#include ";
  header << ( _params.relative_paths ? "<" : "\"" );
  header << fn << "." << _params.hh_suffix;
  header << ( _params.relative_paths ? ">" : "\"" );
  header << endl;
  header << endl;
  header << "#ifndef __" << fnbase << "_CCM_H__" << endl;
  header << "#define __" << fnbase << "_CCM_H__" << endl;
  header << endl;
  header << endl;

  o.start_output (header);
  emit_user_decl ();
  o.stop_output ();

  header << "#endif" << endl << endl;
  
  ofstream impl (fnStub.c_str());

  for( int i1 = 0; i1 < copyright_size; i1++ )
    impl << copyright[ i1 ] << endl;

  impl << endl;
  impl << "#include <mico/CCMContainer.h>" << endl;
  impl << "#include ";
  impl << ( _params.relative_paths ? "<" : "\"" );
  impl << fn << "_ccm." << _params.hh_suffix;
  impl << ( _params.relative_paths ? ">" : "\"" );
  impl << endl;
  impl << endl;

  o.start_output (impl);
  emit_user_stub ();
  emit_glue_code ();
  o.stop_output ();
}

/*
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emit_user_decl ()
{
  _current_scope = CORBA::Container::_duplicate( _container );

  /*
   * First pass. Emit CCM_<component_name> base classes for components
   * and homes.
   */
  
  for (CORBA::ULong i=0; i<_idl_objs.length(); i++) {
    if (_idl_objs[i]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Component:
      {
	CORBA::ComponentIR::ComponentDef_var v =
	  CORBA::ComponentIR::ComponentDef::_narrow (obj);
	CORBA::Container_var new_scope = v->defined_in();
	enter_scope (new_scope, "CCM_");
	emitComponentDecl (v);
	break;
      }

    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	CORBA::Container_var new_scope = v->defined_in();
	enter_scope (new_scope, "CCM_");
	emitHomeDecl (v);
	break;
      }
    }
  }

  // Close open modules
  enter_scope (_container, "CCM_");

  /*
   * Second pass. Emit prototypes for user-provided entry points
   */

  o << endl
    << "/*" << endl
    << " * These entry points must be provided by the user" << endl
    << " */" << endl
    << endl;
  o << endl
    << "extern \"C\" " << BL_OPEN;

  for (CORBA::ULong i=0; i<_idl_objs.length(); i++) {
    if (_idl_objs[i]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	CORBA::String_var an = v->absolute_name ();
	string abs_name = an.in() + 2;
	string flat_name = abs_name;
	CORBA::ULong idx;

	while ((idx = flat_name.find ("::")) != (CORBA::ULong) -1) {
	  flat_name.replace (idx, 2, "_");
	}

	o << "CCM_" << abs_name << "_ptr create_" << flat_name << " ();" << endl;
	break;
      }
    }
  }

  o << BL_CLOSE << endl << endl;
}

void
CCMCodeGenCpp::emit_user_stub ()
{
  for (CORBA::ULong i=0; i<_idl_objs.length(); i++) {
    if (_idl_objs[i]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Component:
      {
	CORBA::ComponentIR::ComponentDef_var v =
	  CORBA::ComponentIR::ComponentDef::_narrow (obj);
	CORBA::Container_var new_scope = v->defined_in();
	emitComponentStub (v);
	break;
      }

    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	CORBA::Container_var new_scope = v->defined_in();
	emitHomeStub (v);
	break;
      }
    }
  }
}

void
CCMCodeGenCpp::emit_glue_code ()
{

  /*
   * First pass: emit decls for glue code classes
   */

  o << "namespace MICO_CCM_impls " << BL_OPEN << endl;

  for (CORBA::ULong i=0; i<_idl_objs.length(); i++) {
    if (_idl_objs[i]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Component:
      {
	CORBA::ComponentIR::ComponentDef_var v =
	  CORBA::ComponentIR::ComponentDef::_narrow (obj);
	emitComponentGlueDecl (v);
	break;
      }

    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	emitHomeGlueDecl (v);
	break;
      }
    }
  }

  o << "// end of namespace MICO_CCM_impls" << endl;
  o << BL_CLOSE << endl;

  /*
   * Second pass: emit glue code implementations
   */

  for (CORBA::ULong i=0; i<_idl_objs.length(); i++) {
    if (_idl_objs[i]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Component:
      {
	CORBA::ComponentIR::ComponentDef_var v =
	  CORBA::ComponentIR::ComponentDef::_narrow (obj);
	emitComponentGlueImpl (v);
	break;
      }

    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	emitHomeGlueImpl (v);
	break;
      }
    }
  }

  /*
   * Third pass. Emit entry points
   */

  o << endl
    << "/*" << endl
    << " * Glue entry points for the container" << endl
    << " */" << endl
    << endl;

  for (CORBA::ULong i1=0; i1<_idl_objs.length(); i1++) {
    if (_idl_objs[i1]->iface_as_forward) {
      continue;
    }
    
    if (check_for_included_defn (_idl_objs[i1]->obj)) {
      continue;
    }

    CORBA::IRObject_ptr obj = _idl_objs[i1]->obj;

    switch (obj->def_kind()) {
    case CORBA::dk_Home:
      {
	CORBA::ComponentIR::HomeDef_var v =
	  CORBA::ComponentIR::HomeDef::_narrow (obj);
	CORBA::String_var an = v->absolute_name ();
	string abs_name = an.in() + 2;
	string flat_name = abs_name;
	CORBA::ULong idx;

	while ((idx = flat_name.find ("::")) != (CORBA::ULong) -1) {
	  flat_name.replace (idx, 2, "_");
	}

	CORBA::ComponentIR::ComponentDef_var comp = v->managed_component ();

	an = comp->absolute_name ();
	string comp_abs_name = an.in() + 2;
	string comp_flat_name = comp_abs_name;

	while ((idx = comp_flat_name.find ("::")) != (CORBA::ULong) -1) {
	  comp_flat_name.replace (idx, 2, "_");
	}

	CORBA::String_var home_short_name = v->name ();
	CORBA::String_var home_absolute_name = v->absolute_name ();
	CORBA::String_var home_id = v->id ();

	CORBA::String_var comp_short_name = comp->name ();
	CORBA::String_var comp_absolute_name = comp->absolute_name ();
	CORBA::String_var comp_id = comp->id ();

	o << "extern \"C\" " << BL_OPEN;
	o << "MICO::CCM::ContainerBase *" << endl;
	o << "deploy_" << flat_name << " (CORBA::ORB_ptr _orb)" << endl
	  << BL_OPEN;
	if (_type == ServiceComponent) {
	  o << "MICO::CCM::ServiceContainer * _container =" << endl
	    << "  new MICO::CCM::ServiceContainer (_orb);" << endl << endl;
	  o << "MICO::CCM::ServiceContainer::ComponentInfo info;" << endl;
	}
	else if (_type == SessionComponent) {
	  o << "MICO::CCM::SessionContainer * _container =" << endl
	    << "  new MICO::CCM::SessionContainer (_orb);" << endl << endl;
	  o << "MICO::CCM::SessionContainer::ComponentInfo info;" << endl;
	}

	o << endl;
	o << "info.home_short_name = \"" << home_short_name << "\";" << endl;
	o << "info.home_absolute_name = \"" << home_absolute_name << "\";" << endl;
	o << "info.home_id = \"" << home_id << "\";" << endl;
	o << "info.component_short_name = \"" << comp_short_name << "\";" << endl;
	o << "info.component_absolute_name = \"" << comp_absolute_name << "\";" << endl;
	o << "info.component_id = \"" << comp_id << "\";" << endl;
	o << endl;
	
	o << "CCM_" << abs_name << "_ptr _hi = create_" << flat_name << " ();"
	  << endl;

	o << "info.home_skel = new MICO_CCM_impls::"
	  << flat_name << "_impl (_hi, _container);" << endl;

	if (_type == ServiceComponent) {
	  o << "CCM_" << comp_abs_name << "_ptr _ci = _hi->create ();"
	    << endl;
	  o << "info.comp_skel = new MICO_CCM_impls::"
	    << comp_flat_name << "_impl (_ci, _container);" << endl;
	}

	o << endl;
	o << "_container->load (info);" << endl;
	o << "return _container;" << endl;
	o << BL_CLOSE << BL_CLOSE << endl;
	break;
      }
    }
  }

  /*
   * Fourth pass. Emit main method if standalone
   */

  if (_standalone) {
    o << endl
      << "/*"
      << " * Default main for standalone program" << endl
      << " */" << endl
      << endl;

    o << "int" << endl;
    o << "main (int argc, char * argv[])" << endl;
    o << BL_OPEN;
    o << "CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);" << endl;
    o << endl;
    o << "MICO::CCM::ContainerBase * c;" << endl;
    o << endl;

    for (CORBA::ULong i2=0; i2<_idl_objs.length(); i2++) {
      if (_idl_objs[i2]->iface_as_forward) {
	continue;
      }
      
      if (check_for_included_defn (_idl_objs[i2]->obj)) {
	continue;
      }
      
      CORBA::IRObject_ptr obj = _idl_objs[i2]->obj;
      
      switch (obj->def_kind()) {
      case CORBA::dk_Home:
	{
	  CORBA::ComponentIR::HomeDef_var v =
	    CORBA::ComponentIR::HomeDef::_narrow (obj);
	  CORBA::String_var an = v->absolute_name ();
	  string abs_name = an.in() + 2;
	  string flat_name = abs_name;
	  CORBA::ULong idx;
	  
	  while ((idx = flat_name.find ("::")) != (CORBA::ULong) -1) {
	    flat_name.replace (idx, 2, "_");
	  }

	  o << "c = deploy_" << flat_name << " (orb);" << endl;
	  o << "c->activate ();";
	  o << endl;
	}
      }
    }

    o << endl;
    o << "orb->run ();" << endl;
    o << "return 0;" << endl;
    o << BL_CLOSE << endl;
  }
}

/*
 * ----------------------------------------------------------------------
 *
 * This code produces an abstract base class for the component that the
 * user must inherit from and implement. The base class is roughly
 * equivalent to
 *
 * local interface CCM_<component_name> : Components::SessionComponent {
 *   <methods>
 * };
 *
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emitComponentDecl (CORBA::ComponentIR::ComponentDef_ptr comp)
{
  CORBA::String_var n = comp->name();
  CORBA::String_var a = comp->absolute_name();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);

  string prefix;
  CORBA::Container_var def_in = comp->defined_in ();
  if (def_in->def_kind() == CORBA::dk_Repository) {
    prefix = "CCM_";
  }
  else {
    prefix = "";
  }

  o << "/*" << endl
    << " * Base class for component " << absName << endl
    << " *" << endl
    << " * This class must be implemented by the user" << endl
    << " */" << endl << endl;

  o << "class " << prefix << className << ";" << endl;
  o << "typedef " << prefix << className << " *"
    << prefix << className << "_ptr;" << endl;
  o << "typedef ObjVar<" << prefix << className << "> "
    << prefix << className << "_var;" << endl;
  o << "typedef ObjOut<" << prefix << className << "> "
    << prefix << className << "_out;" << endl
    << endl;

  CORBA::ComponentIR::ComponentDef_var base = comp->base_component ();
  CORBA::InterfaceDefSeq_var supported = comp->supported_interfaces ();

  o << "class " << prefix << className << " :" << indent << endl;

  if (CORBA::is_nil (base)) {
    o << "virtual public Components::SessionComponent";
  }
  else {
    CORBA::String_var base_name = base->absolute_name ();
    string absBaseName = (const char *) ID (base_name);
    absBaseName = absBaseName.substr (2);
    o << "virtual public CCM_" << absBaseName;
  }

  for (CORBA::ULong i0=0; i0<supported->length(); i0++) {
    o << "," << endl;
    CORBA::String_var base_name = supported[i0]->absolute_name ();
    string absBaseName = (const char *) ID (base_name);
    absBaseName = absBaseName.substr (2);
    o << "virtual public " << absBaseName;
  }

  o << exdent << endl << BL_OPEN;
  o << "public:" << indent << endl;

  o << "virtual ~" << prefix << className << "();" << endl;
  o << endl;

  o << "static " << prefix << className << "_ptr "
    << "_narrow (CORBA::Object_ptr obj);" << endl;
  o << "static " << prefix << className << "_ptr "
    << "_duplicate (" << prefix << className << "_ptr _obj)" << endl;
  o << BL_OPEN
    << "CORBA::Object::_duplicate (_obj);" << endl
    << "return _obj;" << endl
    << BL_CLOSE << endl;

  o << "static " << prefix << className << "_ptr "
    << "_nil()" << endl;
  o << BL_OPEN
    << "return 0;" << endl
    << BL_CLOSE << endl;

  o << "virtual void * _narrow_helper (const char *);" << endl;
  o << endl;

  /*
   * Generate variables to hold receptacles
   */

  CORBA::ContainedSeq_var c;

  o << "/*" << endl
    << " * Variables to hold receptacles" << endl
    << " */" << endl << endl;
  
  o << exdent << "protected:" << indent << endl;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));

    CORBA::IDLType_var type_id = attr->interface_type();
    CORBA::String_var n = attr->name();

    if (!attr->is_multiple()) {
      emit_type_for_variable (type_id, automatic);
      o << " _for_" << n << ";" << endl;
    }
    else {
      o << n << "Connections _for_" << n << ";" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }

  o << "/*" << endl
    << " * Implementations of receptacle hooks." << endl
    << " */" << endl << endl;

  o << exdent << "public:" << indent << endl;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j2=0; j2<c->length(); j2++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j2]);
    assert (!CORBA::is_nil(attr));

    CORBA::IDLType_var type_id = attr->interface_type();
    CORBA::String_var n = attr->name();

    if (!attr->is_multiple()) {
      o << "virtual void _set_connection_" << n.in() << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value);" << endl;

      o << "virtual ";
      emit_type_for_result (type_id);
      o << " _get_connection_" << n.in() << " ();" << endl;
    }
    else {
      o << "virtual void _set_connection_" << n.in() << " (";
      o << "const " << n.in() << "Connections & conxs);" << endl;

      o << "virtual " << n << "Connections *"
	<< " _get_connection_" << n.in() << " ();" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }

  // Supply default implementations for the SessionComponent interface

  o << "/*" << endl
    << " * Methods from the SessionComponent interface. Empty default" << endl
    << " * impls are provided, so that they can be overloaded when" << endl
    << " * necessary." << endl
    << " */" << endl << endl;

  o << exdent << "public:" << indent << endl;

  o << "virtual void set_session_context (Components::SessionContext_ptr);" << endl
    << "virtual void ccm_activate ();" << endl
    << "virtual void ccm_passivate ();" << endl
    << "virtual void ccm_remove ();" << endl
    << endl;

  o << "/*" << endl
    << " * Attribute accessors and mutators." << endl
    << " */" << endl << endl;

  c = comp->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j3]);
    assert (!CORBA::is_nil(attr));

    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();

    o << "virtual ";
    emit_type_for_result (type_id);
    o << " " << ID(n.in()) << " () = 0;" << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "virtual void " << ID(n.in()) << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " value) = 0;" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }

  o << "/*" << endl
    << " * Hooks to provide facet references. These are abstract and" << endl
    << " * must be implemented by the user." << endl
    << " */" << endl << endl;

  // Emit facets

  c = comp->contents (CORBA::dk_Provides, 1);

  for (CORBA::ULong j4=0; j4<c->length(); j4++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j4]);
    assert (!CORBA::is_nil(attr));

    CORBA::IDLType_var type_id = attr->interface_type();
    CORBA::String_var n = attr->name();

    o << "virtual ";
    emit_type_for_result( type_id );
    o << " _get_facet_" << n.in() << " () = 0;" << endl;
  }

  o << "/*" << endl
    << " * Epilogue. Nothing interesting here." << endl
    << " */" << endl;
  
  // Generate epilogue
  o << exdent << "protected:" << indent << endl;
  o << prefix << className << "() {};" << exdent << endl;
  o << "private:" << indent << endl;
  o << prefix << className << " (const " << className << "&);" << endl;
  o << "void operator= (const " << prefix << className << "&);" << exdent << endl;
  o << BL_CLOSE_SEMI << endl << endl;
}

void
CCMCodeGenCpp::emitHomeDecl (CORBA::ComponentIR::HomeDef_ptr home)
{
  CORBA::String_var n = home->name();
  CORBA::String_var a = home->absolute_name();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);

  string prefix;
  CORBA::Container_var def_in = home->defined_in ();
  if (def_in->def_kind() == CORBA::dk_Repository) {
    prefix = "CCM_";
  }
  else {
    prefix = "";
  }

  o << "/*" << endl
    << " * Base class for home " << absName << endl
    << " *" << endl
    << " * This class must be implemented by the user" << endl
    << " */" << endl << endl;

  o << "class " << prefix << className << ";" << endl;
  o << "typedef " << prefix << className << " *"
    << prefix << className << "_ptr;" << endl;
  o << "typedef ObjVar<" << prefix << className << "> "
    << prefix << className << "_var;" << endl;
  o << "typedef ObjOut<" << prefix << className << "> "
    << prefix << className << "_out;" << endl
    << endl;

  CORBA::ComponentIR::HomeDef_var base = home->base_home ();
  CORBA::ComponentIR::ComponentDef_var managed = home->managed_component ();
  CORBA::ValueDef_var key = home->primary_key ();

  CORBA::String_var mn = managed->absolute_name ();
  string managedAbsName = (const char *) ID(mn.in());
  managedAbsName = managedAbsName.substr (2);

  if (!CORBA::is_nil (key) && _type == ServiceComponent) {
    cerr << "Error: Home " << absName << " for Service Component "
	 << managedAbsName << " must be keyless." << endl;
    exit (1);
  }
  else if (!CORBA::is_nil (key) && _type == SessionComponent) {
    cerr << "Error: Home " << absName << " for Session Component "
	 << managedAbsName << " must be keyless." << endl;
    exit (1);
  }

  o << "class " << prefix << className << " :" << indent << endl;
  o << "virtual public CORBA::LocalObject";
  o << exdent << endl << BL_OPEN;
  o << "public:" << indent << endl;

  o << "virtual ~" << prefix << className << "();" << endl;
  o << endl;

  o << "static " << prefix << className << "_ptr "
    << "_narrow (CORBA::Object_ptr obj);" << endl;
  o << "static " << prefix << className << "_ptr "
    << "_duplicate (" << prefix << className << "_ptr _obj)" << endl;
  o << BL_OPEN
    << "CORBA::Object::_duplicate (_obj);" << endl
    << "return _obj;" << endl
    << BL_CLOSE << endl;

  o << "static " << prefix << className << "_ptr "
    << "_nil()" << endl;
  o << BL_OPEN
    << "return 0;" << endl
    << BL_CLOSE << endl;

  o << "virtual void * _narrow_helper (const char *);" << endl;
  o << endl;

  // Implicit operations

  if (CORBA::is_nil (key)) {
    o << "virtual CCM_" << managedAbsName << "_ptr create () = 0;" << endl;
  }
  else {
    o << "virtual CCM_" << managedAbsName << "_ptr create (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ") = 0;" << endl;
  }

  o << endl;

  // Generate prototypes

  CORBA::ContainedSeq_var c;

  // Emit factories

  c = home->contents (CORBA::dk_Factory, 1);

  if (c->length() > 0 && _type == ServiceComponent) {
    cerr << "Error: Home " << absName << " for Service Component "
	 << managedAbsName << " cannot have factories." << endl;
    exit (1);
  }

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j1]);
    CORBA::String_var n = op->name();

    o << "virtual CCM_" << managedAbsName << "_ptr " << ID(n.in()) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;

    for (k=0; k<p->length(); k++) {
      if (k != 0)
	o << ",";
      o << " ";
      emit_type_for_param (p[k].type_def, p[k].mode);
      o << " " << ID(p[k].name);
    }
    o << ") = 0;" << endl;
  }

  if (c->length()) {
    o << endl;
  }

  // Emit finders

  c = home->contents (CORBA::dk_Finder, 1);

  if (c->length() > 0 && _type == ServiceComponent) {
    cerr << "Error: Home " << absName << " for Service Component "
	 << managedAbsName << " cannot have finders." << endl;
    exit (1);
  }

  for (CORBA::ULong j2=0; j2<c->length(); j2++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j2]);
    CORBA::String_var n = op->name();

    o << "virtual CCM_" << managedAbsName << "_ptr " << ID(n.in()) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for (k=0; k<p->length(); k++) {
      if (k != 0)
	o << ",";
      o << " ";
      emit_type_for_param (p[k].type_def, p[k].mode );
      o << " " << ID(p[k].name);
    }
    o << ") = 0;" << endl;
  }

  if (c->length()) {
    o << endl;
  }

  // Emit attributes

  c = home->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j3]);
    assert (!CORBA::is_nil(attr));
    o << "virtual ";
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << " () = 0;" << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "virtual void " << ID( n.in() ) << " (";
      emit_type_for_param( type_id, CORBA::PARAM_IN );
      o << " value) = 0;" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }

  // Emit operations

  c = home->contents (CORBA::dk_Operation, 1);

  for (CORBA::ULong j4=0; j4<c->length(); j4++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j4]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::String_var n = op->name();
    o << "virtual ";
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for (k=0; k<p->length(); k++) {
      if (k != 0)
	o << ",";
      o << " ";
      emit_type_for_param (p[k].type_def, p[k].mode);
      o << " " << ID(p[k].name);
    }
    o << ") = 0;" << endl;
  }

  if (c->length()) {
    o << endl;
  }

  // Generate epilogue
  o << exdent << "protected:" << indent << endl;
  o << prefix << className << "() {};" << exdent << endl;
  o << "private:" << indent << endl;
  o << prefix << className << " (const " << className << "&);" << endl;
  o << "void operator= (const " << prefix << className << "&);" << exdent << endl;
  o << BL_CLOSE_SEMI << endl << endl;
}

/*
 * ----------------------------------------------------------------------
 *
 * This code implements some methods of the abstract CCM_<name> base
 * classes, mostly the virtual destructors and the _narrow stuff.
 *
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emitComponentStub (CORBA::ComponentIR::ComponentDef_ptr comp)
{
  CORBA::String_var n = comp->name();
  CORBA::String_var a = comp->absolute_name();
  CORBA::String_var id = comp->id ();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);

  string prefix;
  CORBA::Container_var def_in = comp->defined_in ();
  if (def_in->def_kind() == CORBA::dk_Repository) {
    prefix = "CCM_";
  }
  else {
    prefix = "";
  }

  CORBA::ComponentIR::ComponentDef_var base = comp->base_component ();
  CORBA::InterfaceDefSeq_var supported = comp->supported_interfaces ();

  o << endl;
  o << "/*" << endl
    << " * Base interface for component " << className << endl
    << " */" << endl << endl;

  // dtor
  o << "CCM_" << absName << "::~" << prefix << className << "()" << endl;
  o << "{" << endl;
  o << "}" << endl << endl;

  /*
   * _narrow_helper
   */

  o << "void *" << endl;
  o << "CCM_" << absName << "::_narrow_helper (const char *_repoid)"
    << endl;
  o << BL_OPEN;
  o << "if (strcmp (_repoid, \"CCM_" << id << "\") == 0)" << endl;
  o << indent << "return (void *) this;" << exdent << endl;

  o << "void * _p;" << endl;

  if (CORBA::is_nil (base)) {
    o << "if ((_p = Components::SessionComponent::_narrow_helper (_repoid)))"
      << endl;
    o << indent << "return _p;" << exdent << endl;
  }
  else {
    CORBA::String_var base_name = base->absolute_name ();
    string absBaseName = (const char *) ID (base_name);
    absBaseName = absBaseName.substr (2);
    o << "if ((_p = CCM_" << absBaseName << "::_narrow_helper (_repoid)))"
      << endl;
    o << indent << "return _p;" << exdent << endl;
  }

  for (CORBA::ULong i0=0; i0<supported->length(); i0++) {
    CORBA::String_var base_name = supported[i0]->absolute_name ();
    string absBaseName = (const char *) ID (base_name);
    absBaseName = absBaseName.substr (2);
    o << "if ((_p = " << absBaseName << "::_narrow_helper (_repoid)))"
      << endl;
    o << indent << "return _p;" << exdent << endl;
  }

  o << "return NULL;" << endl;
  o << BL_CLOSE << endl;

  /*
   * _narrow class method
   */

  o << "CCM_" << absName << "_ptr" << endl;
  o << "CCM_" << absName << "::_narrow (CORBA::Object_ptr _obj)" << endl;
  o << BL_OPEN;
  o << "if (!CORBA::is_nil (_obj)) " << BL_OPEN;
  o << "void *_p;" << endl;
  o << "if ((_p = _obj->_narrow_helper(\"CCM_" << id << "\")))" << endl;
  o << indent
    << "return _duplicate ((" << "CCM_" << absName << "_ptr) _p);"
    << exdent << endl;
  o << BL_CLOSE;
  o << "return _nil();" << endl;
  o << BL_CLOSE << endl;

  /*
   * Implementations of receptacle hooks.
   */

  CORBA::ContainedSeq_var c;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));

    CORBA::InterfaceDef_var type_id = attr->interface_type();
    CORBA::String_var in = type_id->absolute_name ();
    CORBA::String_var n = attr->name();

    if (!attr->is_multiple()) {
      o << "void" << endl;
      o << "CCM_" << absName << "::_set_connection_" << n << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "_for_" << n << " = " << ID(in.in()) << "::_duplicate (_value);"
	<< endl;
      o << BL_CLOSE << endl;

      emit_type_for_result (type_id);
      o << endl;
      o << "CCM_" << absName << "::_get_connection_" << n << " ()" << endl;
      o << BL_OPEN;
      o << "return " << ID(in.in()) << "::_duplicate (_for_" << n << ");"
	<< endl;
      o << BL_CLOSE << endl;
    }
    else {
      o << "void" << endl;
      o << "CCM_" << absName << "::_set_connection_" << n << " (";
      o << n << "Connections & _value)" << endl;
      o << BL_OPEN;
      o << "_for_" << n << " = _value;" << endl;
      o << BL_CLOSE << endl;

      o << absName << "::" << n << "Connections *" << endl;
      o << "CCM_" << absName << "::_get_connection_" << n << " ()" << endl;
      o << BL_OPEN;
      o << "return new " << n << "Connections (_for_" << n << ");" << endl;
      o << BL_CLOSE << endl;
    }
  }

  /*
   * Default implementations for the SessionComponent interface
   */

  o << "void" << endl;
  o << "CCM_" << absName << "::set_session_context (Components::SessionContext_ptr)" << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;

  o << "void" << endl;
  o << "CCM_" << absName << "::ccm_activate ()" << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;

  o << "void" << endl;
  o << "CCM_" << absName << "::ccm_passivate ()" << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;

  o << "void" << endl;
  o << "CCM_" << absName << "::ccm_remove ()" << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;
}

void
CCMCodeGenCpp::emitHomeStub (CORBA::ComponentIR::HomeDef_ptr home)
{
  CORBA::String_var n = home->name();
  CORBA::String_var a = home->absolute_name();
  CORBA::String_var id = home->id ();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);

  string prefix;
  CORBA::Container_var def_in = home->defined_in ();
  if (def_in->def_kind() == CORBA::dk_Repository) {
    prefix = "CCM_";
  }
  else {
    prefix = "";
  }

  o << endl;
  o << "/*" << endl
    << " * Base interface for home " << className << endl
    << " */" << endl << endl;

  // dtor
  o << "CCM_" << absName << "::~" << prefix << className << "()" << endl;
  o << "{" << endl;
  o << "}" << endl << endl;

  /*
   * _narrow_helper
   */

  o << "void *" << endl;
  o << "CCM_" << absName << "::_narrow_helper (const char *_repoid)"
    << endl;
  o << BL_OPEN;
  o << "if (strcmp (_repoid, \"CCM_" << id << "\") == 0)" << endl;
  o << indent << "return (void *) this;" << exdent << endl;
  o << "return CORBA::LocalObject::_narrow_helper (_repoid);" << endl;
  o << BL_CLOSE << endl;

  /*
   * _narrow class method
   */

  o << "CCM_" << absName << "_ptr" << endl;
  o << "CCM_" << absName << "::_narrow (CORBA::Object_ptr _obj)" << endl;
  o << BL_OPEN;
  o << "if (!CORBA::is_nil (_obj)) " << BL_OPEN;
  o << "void *_p;" << endl;
  o << "if ((_p = _obj->_narrow_helper(\"CCM_" << id << "\")))" << endl;
  o << indent
    << "return _duplicate ((" << "CCM_" << absName << "_ptr) _p);"
    << exdent << endl;
  o << BL_CLOSE;
  o << "return _nil();" << endl;
  o << BL_CLOSE << endl;
}

/*
 * ----------------------------------------------------------------------
 *
 * This code produces component glue code. It is a POA Servant, implements
 * the non-functional component methods (navigation and such) and forwards
 * the business methods to the component instance.
 *
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emitComponentGlueDecl (CORBA::ComponentIR::ComponentDef_ptr comp)
{
  CORBA::String_var n = comp->name();
  CORBA::String_var a = comp->absolute_name();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);
  string flatName = absName;
  CORBA::ULong idx;

  while ((idx = flatName.find ("::")) != (CORBA::ULong) -1) {
    flatName.replace (idx, 2, "_");
  }

  o << "/*" << endl
    << " * Glue class for component " << absName << endl
    << " */" << endl << endl;

  o << "class " << flatName << "_impl :";

  CORBA::ComponentIR::ComponentDef_var base = comp->base_component ();

  if (CORBA::is_nil (base)) {
    o << indent << indent << endl;
    o << "virtual public POA_" << absName << "," << endl;
    o << "virtual public PortableServer::RefCountServantBase";
    o << exdent << exdent << endl << BL_OPEN;
  }
  else {
    a = base->absolute_name ();
    string baseFlatName = (const char *) ID(a.in());
    baseFlatName = baseFlatName.substr (2);

    while ((idx = baseFlatName.find ("::")) != (CORBA::ULong) -1) {
      baseFlatName.replace (idx, 2, "_");
    }
    
    o << indent << indent << endl;
    o << "virtual public " << baseFlatName << "_impl";
    o << exdent << exdent << endl;
    o << BL_OPEN;
  }

  CORBA::ContainedSeq_var c;

  o << "private:" << indent << endl;
  o << "CCM_" << absName << " * _instance;" << endl;

  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer * _container;" << endl;
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer * _container;" << endl;
  }

  /*
   * Variables for receptacles
   */

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j0=0; j0<c->length(); j0++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j0]);
    CORBA::String_var n = attr->name ();
    assert (!CORBA::is_nil(attr));

    if (!attr->is_multiple()) {
      CORBA::IDLType_var type_id = attr->interface_type();
      emit_type_for_variable (type_id, automatic);
      o << " _for_recep_" << n << ";" << endl;
    }
    else {
      o << absName << "::" << n << "Connections _for_recep_" << n << ";" << endl;
      o << "CORBA::ULong _cookie_for_" << n << ";" << endl;
    }
  }

  o << exdent << endl;
  o << "public:" << indent << endl;
  o << flatName << "_impl (CCM_" << absName << " *, ";
  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer *";
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer *";
  }
  o << ");" << endl;
  o << "~" << flatName << "_impl ();" << endl;
  o << endl;

  /*
   * Prototypes
   */

  /*
   * Component Attributes
   */

  o << "/*" << endl
    << " * Component Attributes" << endl
    << " */" << endl << endl;

  c = comp->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << " ();" << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << ID( n.in() ) << " (";
      emit_type_for_param( type_id, CORBA::PARAM_IN );
      o << " _value);" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }
  else {
    o << "// none" << endl << endl;
  }

  /*
   * Supported Interfaces
   */

  o << "/*" << endl
    << " * Supported Interfaces" << endl
    << " */" << endl << endl;

  CORBA::InterfaceDefSeq_var ifs = comp->supported_interfaces ();

  for (CORBA::ULong j2=0; j2<ifs->length(); j2++) {
    CORBA::String_var sn = ifs[j2]->absolute_name ();

    o << "// " << sn << endl << endl;

    c = ifs[j2]->contents (CORBA::dk_Operation, 0);

    for (CORBA::ULong j3=0; j3<c->length(); j3++) {
      CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j3]);
      CORBA::IDLType_var type_id = op->result_def();
      CORBA::String_var n = op->name();
      emit_type_for_result( type_id );
      o << " " << ID( n.in() ) << "(";
      CORBA::ParDescriptionSeq_var p = op->params();
      CORBA::ULong k;
      for( k = 0; k < p->length(); k++ ) {
	if( k != 0 )
	  o << ",";
	o << " ";
	emit_type_for_param( p[ k ].type_def, p[ k ].mode );
	o << " " << ID(p[ k ].name);
      }
      o << ");" << endl;
    }

    if (c->length()) {
      o << endl;
    }

    c = ifs[j2]->contents (CORBA::dk_Attribute, 0);

    for (CORBA::ULong j4=0; j4<c->length(); j4++) {
      CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j4]);
      assert (!CORBA::is_nil(attr));
      CORBA::IDLType_var type_id = attr->type_def();
      CORBA::String_var n = attr->name();
      emit_type_for_result( type_id );
      o << " " << ID( n.in() ) << " ();" << endl;

      if( attr->mode() == CORBA::ATTR_NORMAL ) {
	o << "void " << ID( n.in() ) << " (";
	emit_type_for_param( type_id, CORBA::PARAM_IN );
	o << " _value);" << endl;
      }
    }

    if (c->length()) {
      o << endl;
    }
    else {
      o << "// none" << endl << endl;
    }
  }

  if (ifs->length() == 0) {
    o << "// none" << endl << endl;
  }

  /*
   * Equivalent IDL methods
   */

  o << "/*" << endl
    << " * Equivalent IDL methods" << endl
    << " */" << endl << endl;

  // Emit facets

  c = comp->contents (CORBA::dk_Provides, 1);

  if (c->length()) {
    o << "// facets" << endl << endl;
  }
  else {
    o << "// no facets" << endl << endl;
  }

  for (CORBA::ULong j5=0; j5<c->length(); j5++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j5]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->interface_type();
    CORBA::String_var n = attr->name();
    emit_type_for_result( type_id );
    o << " provide_" << n << " ();" << endl;
  }

  if (c->length()) {
    o << endl;
  }

  // Emit receptacles

  c = comp->contents (CORBA::dk_Uses, 1);

  if (c->length()) {
    o << "// receptacles" << endl << endl;
  }
  else {
    o << "// no receptacles" << endl << endl;
  }

  for (CORBA::ULong j6=0; j6<c->length(); j6++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j6]);
    assert (!CORBA::is_nil(attr));

    CORBA::IDLType_var type_id = attr->interface_type();
    CORBA::String_var n = attr->name();

    if (!attr->is_multiple()) {
      o << "void connect_" << n << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value);" << endl;

      emit_type_for_result (type_id);
      o << " disconnect_" << n << " ();" << endl;

      emit_type_for_result (type_id);
      o << " get_connection_" << n << " ();" << endl;
    }
    else {
      o << "Components::Cookie * connect_" << n << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value);" << endl;

      emit_type_for_result (type_id);
      o << " disconnect_" << n << " (const Components::Cookie & _value);"
	<< endl;
      o << absName << "Connections get_connections_" << n.in() << " ();"
	<< endl;
    }
  }

  if (c->length()) {
    o << endl;
  }

  /*
   * CCMObject interfaces
   */

  o << "/*" << endl
    << " * Inherited Navigation interface" << endl
    << " */" << endl << endl;

  o << "CORBA::Object_ptr provide_facet (const char *);" << endl
    << "Components::FacetDescriptions * describe_facets ();" << endl
    << "Components::Facets * provide_all_facets ();" << endl
    << "Components::Facets * provide_named_facets (const Components::NameList &);" << endl
    << "CORBA::Boolean same_component (CORBA::Object_ptr ref);" << endl
    << endl;

  o << "/*" << endl
    << " * Inherited Receptacles interface" << endl
    << " */" << endl << endl;

  o << "Components::Cookie * connect (const char *, CORBA::Object_ptr);" << endl
    << "void disconnect (const char * name, const Components::Cookie &);" << endl
    << "Components::ConnectionDescriptions * get_connections (const char *);" << endl
    << endl;

  o << "/*" << endl
    << " * Inherited CCMObject interface" << endl
    << " */" << endl << endl;

  o << "CORBA::Object_ptr get_component_def ();" << endl
    << "Components::CCMHome_ptr get_ccm_home ();" << endl
    << "void configuration_complete ();" << endl
    << "void remove ();" << endl
    << endl;

  o << "/*" << endl
    << " * Overload default implementation" << endl
    << " */" << endl
    << endl;

  o << "CORBA::Object_ptr _get_component ();" << endl;
  o << exdent << BL_CLOSE_SEMI << endl << endl;

  /*
   * Emit Glue code for local facets
   */

  c = comp->contents (CORBA::dk_Provides, 1);

  for (CORBA::ULong j7=0; j7<c->length(); j7++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j7]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var iface = attr->interface_type();
    CORBA::String_var n = attr->name();
    emitInterfaceGlueDecl (iface, comp, n);
  }
}

void
CCMCodeGenCpp::emitHomeGlueDecl (CORBA::ComponentIR::HomeDef_ptr home)
{
  CORBA::String_var n = home->name();
  CORBA::String_var a = home->absolute_name();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);
  string flatName = absName;
  CORBA::ULong idx;

  while ((idx = flatName.find ("::")) != (CORBA::ULong) -1) {
    flatName.replace (idx, 2, "_");
  }

  o << "/*" << endl
    << " * Glue class for home " << absName << endl
    << " */" << endl << endl;

  o << "class " << flatName << "_impl :";
  o << indent << indent << endl;
  o << "virtual public POA_" << absName << "," << endl;
  o << "virtual public PortableServer::RefCountServantBase";
  o << exdent << exdent << endl << BL_OPEN;

  o << "private:" << indent << endl;
  o << "CCM_" << absName << " * _instance;" << endl;

  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer * _container;" << endl;
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer * _container;" << endl;
  }

  o << exdent << endl;
  o << "public:" << indent << endl;
  o << flatName << "_impl (CCM_" << absName << " *, ";
  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer *";
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer *";
  }
  o << ");" << endl;
  o << "~" << flatName << "_impl ();" << endl;
  o << endl;

  o << "/*" << endl
    << " * Implicit operations" << endl
    << " */" << endl << endl;

  CORBA::ComponentIR::ComponentDef_var managed = home->managed_component();
  CORBA::ValueDef_var key = home->primary_key ();
  CORBA::ContainedSeq_var c;

  if (CORBA::is_nil (key)) {
    emit_type_for_result (managed);
    o << " create ();" << endl;
  }
  else {
    emit_type_for_result (managed);
    o << " create (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;

    emit_type_for_result (managed);
    o << " find_by_primary_key (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;
    
    o << "void remove (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;
  }

  o << endl;

  o << "/*" << endl
    << " * Explicit operations" << endl
    << " */" << endl << endl;

  // Emit factories

  c = home->contents (CORBA::dk_Factory, 1);

  if (c->length()) {
    o << "// factories" << endl << endl;
  }
  else {
    o << "// no factories" << endl << endl;
  }

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j1]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::String_var n = op->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for( k = 0; k < p->length(); k++ ) {
      if( k != 0 )
	o << ",";
      o << " ";
      emit_type_for_param( p[ k ].type_def, p[ k ].mode );
      o << " " << ID(p[ k ].name);
    }
    o << ");" << endl;
  }

  // Emit finder

  c = home->contents (CORBA::dk_Finder, 1);

  if (c->length()) {
    o << "// finders" << endl << endl;
  }
  else {
    o << "// no finders" << endl << endl;
  }

  for (CORBA::ULong j2=0; j2<c->length(); j2++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j2]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::String_var n = op->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for( k = 0; k < p->length(); k++ ) {
      if( k != 0 )
	o << ",";
      o << " ";
      emit_type_for_param( p[ k ].type_def, p[ k ].mode );
      o << " " << ID(p[ k ].name);
    }
    o << ");" << endl;
  }

  if (c->length()) {
    o << "// attributes" << endl << endl;
  }
  else {
    o << "// no attributes" << endl << endl;
  }

  c = home->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j3]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << " ();" << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << ID( n.in() ) << " (";
      emit_type_for_param( type_id, CORBA::PARAM_IN );
      o << " _value);" << endl;
    }
  }

  if (c->length()) {
    o << "// operations" << endl << endl;
  }
  else {
    o << "// no operations" << endl << endl;
  }

  c = home->contents (CORBA::dk_Operation, 1);

  for (CORBA::ULong j4=0; j4<c->length(); j4++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j4]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::String_var n = op->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for( k = 0; k < p->length(); k++ ) {
      if( k != 0 )
	o << ",";
      o << " ";
      emit_type_for_param( p[ k ].type_def, p[ k ].mode );
      o << " " << ID(p[ k ].name);
    }
    o << ");" << endl;
  }
  
  /*
   * CCMHome interfaces
   */

  o << "/*" << endl
    << " * Inherited CCMHome interface" << endl
    << " */" << endl << endl;

  o << "CORBA::Object_ptr get_component_def ();" << endl
    << "CORBA::Object_ptr get_home_def ();" << endl
    << "void remove_component (Components::CCMObject_ptr comp);" << endl
    << endl;

  if (CORBA::is_nil (key)) {
    o << "/*" << endl
      << " * Inherited KeylessCCMHome interface" << endl
      << " */" << endl << endl;

    o << "Components::CCMObject_ptr create_component ();" << endl
      << endl;
  }

  o << exdent << BL_CLOSE_SEMI << endl << endl;
};

/*
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emitComponentGlueImpl (CORBA::ComponentIR::ComponentDef_ptr comp)
{
  CORBA::String_var comp_name = comp->name();
  CORBA::String_var comp_abs = comp->absolute_name();
  string className = (const char *) ID(comp_name);
  string absName = (const char *) ID(comp_abs);
  absName = absName.substr (2);
  string flatName = absName;
  CORBA::ULong idx;

  while ((idx = flatName.find ("::")) != (CORBA::ULong) -1) {
    flatName.replace (idx, 2, "_");
  }

  o << "/*" << endl
    << " * Glue class for component " << absName << endl
    << " */" << endl << endl;

  CORBA::ComponentIR::ComponentDef_var base = comp->base_component ();
  CORBA::ContainedSeq_var c;

  o << "MICO_CCM_impls::" << endl
    << flatName << "_impl::" << flatName << "_impl "
    << "(CCM_" << absName << " * i, ";
  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer * c";
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer * c";
  }
  o << ")" << endl;
  o << indent << ": _instance (i), _container (c)";

  if (!CORBA::is_nil (base)) {
    CORBA::String_var a = base->absolute_name ();
    string baseFlatName = (const char *) ID(a.in());
    baseFlatName = baseFlatName.substr (2);

    while ((idx = baseFlatName.find ("::")) != (CORBA::ULong) -1) {
      baseFlatName.replace (idx, 2, "_");
    }

    o << ", " << baseFlatName << "_impl (i, c)";
  }

  o << exdent << endl;
  o << BL_OPEN;

  if (_type == ServiceComponent) {
    o << "Components::SessionContext_var _sc = " << endl
      << "  _container->get_session_context ();" << endl
      << "_instance->set_session_context (_sc.in());" << endl
      << "_instance->ccm_activate ();" << endl;
  }

  c = comp->contents (CORBA::dk_Uses, 1);
  for (CORBA::ULong j0=0; j0<c->length(); j0++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j0]);
    CORBA::String_var n = attr->name();

    if (attr->is_multiple()) {
      o << "_cookie_for_" << n << " = 0;" << endl;
    }
  }

  o << BL_CLOSE << endl;
    
  o << "MICO_CCM_impls::" << endl
    << flatName << "_impl::~" << flatName << "_impl ()" << endl;
  o << BL_OPEN;
  if (_type == ServiceComponent) {
    o << "_instance->ccm_passivate ();" << endl;
    o << "_instance->ccm_remove ();" << endl;
  }
  o << "delete _instance;" << endl;
  o << BL_CLOSE << endl;

  /*
   * Delegators
   */

  /*
   * Component Attributes
   */

  o << "/*" << endl
    << " * Component Attributes" << endl
    << " */" << endl << endl;

  c = comp->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();

    emit_type_for_result (type_id);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::" << ID(n.in()) << " ()" << endl;
    o << BL_OPEN;
    o << "return _instance->" << ID(n.in()) << " ();" << endl;
    o << BL_CLOSE << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::" << ID(n.in()) << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "_instance->" << ID(n.in()) << " (_value);" << endl;
      o << BL_CLOSE << endl;
    }
  }

  /*
   * Supported Interfaces
   */

  o << "/*" << endl
    << " * Supported Interfaces" << endl
    << " */" << endl << endl;

  CORBA::InterfaceDefSeq_var ifs = comp->supported_interfaces ();

  for (CORBA::ULong j2=0; j2<ifs->length(); j2++) {
    CORBA::String_var sn = ifs[j2]->absolute_name ();

    o << "// " << sn << endl << endl;

    c = ifs[j2]->contents (CORBA::dk_Operation, 0);

    for (CORBA::ULong j3=0; j3<c->length(); j3++) {
      CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j3]);
      CORBA::IDLType_var type_id = op->result_def();
      CORBA::ParDescriptionSeq_var p = op->params();
      CORBA::TypeCode_var rtc = type_id->type ();
      CORBA::String_var n = op->name();

      emit_type_for_result (type_id);
      o << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::" << ID(n.in()) << " (";

      for (CORBA::ULong k1=0; k1<p->length(); k1++) {
	if (k1 != 0)
	  o << ", ";
	emit_type_for_param (p[k1].type_def, p[k1].mode);
	o << " " << ID(p[k1].name);
      }
      o << ")" << endl;

      o << BL_OPEN;

      if (rtc->kind() != CORBA::tk_void) {
	o << "return ";
      }

      o << "_instance->" << ID(n.in()) << " (";
      for (CORBA::ULong k2=0; k2<p->length(); k2++) {
	if (k2 != 0)
	  o << ", ";
	o << ID(p[k2].name);
      }
      o << ");" << endl;

      o << BL_CLOSE << endl;
    }

    c = ifs[j2]->contents (CORBA::dk_Attribute, 0);

    for (CORBA::ULong j4=0; j4<c->length(); j4++) {
      CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j4]);
      assert (!CORBA::is_nil(attr));
      CORBA::IDLType_var type_id = attr->type_def();
      CORBA::String_var n = attr->name();
      
      emit_type_for_result (type_id);
      o << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::" << ID(n.in()) << " ()" << endl;
      o << BL_OPEN;
      o << "return _instance->" << ID(n.in()) << " ();" << endl;
      o << BL_CLOSE << endl;
      
      if( attr->mode() == CORBA::ATTR_NORMAL ) {
	o << "void " << endl;
	o << "MICO_CCM_impls::" << endl;
	o << flatName << "_impl::" << ID(n.in()) << " (";
	emit_type_for_param (type_id, CORBA::PARAM_IN);
	o << " _value)" << endl;
	o << BL_OPEN;
	o << "_instance->" << ID(n.in()) << " (_value);" << endl;
	o << BL_CLOSE << endl;
      }
    }
  }

  /*
   * Equivalent IDL methods
   */

  o << "/*" << endl
    << " * Equivalent IDL methods" << endl
    << " */" << endl << endl;

  // Emit facets

  c = comp->contents (CORBA::dk_Provides, 1);

  for (CORBA::ULong j5=0; j5<c->length(); j5++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j5]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var iface = attr->interface_type();
    CORBA::String_var n = attr->name();

    CORBA::String_var a = iface->absolute_name ();
    string ifaceAbsName = (const char *) ID(a);
    ifaceAbsName = ifaceAbsName.substr (2);

    emit_type_for_result (iface);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::provide_" << n << " ()" << endl;
    o << BL_OPEN;
    emit_type_for_variable (iface, manual);
    o << " _facet = _instance->_get_facet_" << n << " ();" << endl;
    o << "if (_facet->_is_a (\"IDL:omg.org/CORBA/LocalObject:1.0\")) "
      << BL_OPEN;
    o << "CORBA::LocalObject_var _local_ref ="
      << "  CORBA::LocalObject::_narrow (_facet);" << endl;
    o << "CORBA::Object_var _facet_ref =" << endl
      << "  _container->get_reference_for_facet (_local_ref);" << endl;
    o << "if (CORBA::is_nil (_facet_ref)) " << BL_OPEN;
    o << "PortableServer::ServantBase_var _facet_servant =" << endl
      << "  new " << flatName << "_" << n << "_impl (_facet);" << endl;
    o << "_facet_ref = _container->activate_facet (_local_ref, _facet_servant);" << endl;
    o << BL_CLOSE;
    o << "else " << BL_OPEN;
    o << "CORBA::release (_facet);" << endl;
    o << BL_CLOSE;
    o << "return " << ifaceAbsName << "::_narrow (_facet_ref);" << endl;
    o << BL_CLOSE;
    o << "return _facet;" << endl;
    o << BL_CLOSE << endl;
  }

  // Emit receptacles

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j6=0; j6<c->length(); j6++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j6]);
    assert (!CORBA::is_nil(attr));

    CORBA::InterfaceDef_var type_id = attr->interface_type();
    CORBA::String_var ain = type_id->absolute_name ();
    CORBA::String_var n = attr->name();
    string recep_abs_name = ain.in();
    recep_abs_name = recep_abs_name.substr (2);

    if (!attr->is_multiple()) {

      // connect

      o << "void" << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::connect_" << n << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "_for_recep_" << n << " = " << recep_abs_name << "::_duplicate (_value);"
	<< endl;
      o << "_instance->_set_connection_" << n << " (_value);" << endl;
      o << BL_CLOSE << endl;

      // disconnect

      emit_type_for_result (type_id);
      o << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::disconnect_" << n << " ()" << endl;
      o << BL_OPEN;
      o << recep_abs_name << "_var _res = "
	<< recep_abs_name << "::_duplicate (_for_recep_" << n << ");" << endl;
      o << "_for_recep_" << n << " = " << recep_abs_name << "::_nil ();" << endl;
      o << "_instance->_set_connection_" << n << " (" << recep_abs_name << "::_nil());"
	<< endl;
      o << "return _res._retn ();" << endl;
      o << BL_CLOSE << endl;

      // get_connection

      emit_type_for_result (type_id);
      o << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::get_connection_" << n << " ()" << endl;
      o << BL_OPEN;
      o << "return " << recep_abs_name << "::_duplicate (_for_recep_" << n << ");"
	<< endl;
      o << BL_CLOSE;
    }
    else {

      // connect

      o << "Components::Cookie *" << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::connect_" << n << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "Components::Cookie_var _ck = new Components::Cookie;" << endl;
      o << "_ck->CookieValue.replace (sizeof (CORBA::ULong), sizeof (CORBA::ULong), (CORBA::Octet *) &_cookie_for_" << n << ");" << endl;
      o << "_cookie_for_" << n << "++;";
      o << "CORBA::ULong _idx = _for_recep_" << n << ".length ();" << endl;
      o << "_for_recep_" << n << ".length (_idx + 1);" << endl;
      o << "_for_recep_" << n << "[_idx].ck = _ck;" << endl;
      o << "_for_recep_" << n << "[_idx].objref = "
	<< recep_abs_name << "::_duplicate (_value);" << endl;
      o << "_instance->_set_connection_" << n << " (_for_recep_" << n << ");"
	<< endl;
      o << "return _ck._retn();" << endl;
      o << BL_CLOSE << endl;

      // disconnect

      emit_type_for_result (type_id);
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::disconnect_" << n << " (";
      o << "const Components::Cookie & _value)" << endl;
      o << BL_OPEN;
      o << "CORBA::ULong _idx, _ck1, _ck2;" << endl;
      o << "if (_value.CookieValue.length() != sizeof (CORBA::ULong)) "
	<< BL_OPEN;
      o << "throw Components::InvalidConnection();" << endl;
      o << BL_CLOSE << endl;
      o << "_ck1 = * ((CORBA::ULong *) _value.CookieValue.get_buffer());"
	<< endl << endl;
      o << "for (_idx=0; _idx<_for_recep_" << n << ".length(); _idx++) "
	<< BL_OPEN;
      o << "_ck2 = * ((CORBA::ULong *) _for_recep_" << n << "[_idx].ck.CookieValue.get_buffer());" << endl;
      o << "if (_ck1 == _ck2) break;" << endl;
      o << BL_CLOSE << endl;
      o << "if (_idx == _for_recep_" << n << ".length()) " << BL_OPEN;
      o << "throw Components::InvalidConnection();" << endl;
      o << BL_CLOSE << endl;
      o << recep_abs_name << "_var _res = " << recep_abs_name
	<< "::_duplicate (_for_recep_" << n << "[_idx].objref);" << endl;
      o << endl;
      o << "for (;_idx<_for_recep_" << n << ".length()-1; _idx++) " << BL_OPEN;
      o << "_for_recep_" << n << "[_idx] = _for_recep_" << n << "[_idx+1];"
	<< endl;
      o << BL_CLOSE << endl;
      o << "_for_recep_" << n << ".length (_idx-1);" << endl;
      o << "_instance->_set_connection_" << n << " (_for_recep_" << n << ");"
	<< endl;
      o << "return _res._retn();" << endl;
      o << BL_CLOSE << endl;

      // get_connections

      o << absName << "::" << n << "Connections *" << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::get_connections_" << n << " ()" << endl;
      o << BL_OPEN;
      o << "return new " << absName << "::" << n
	<< "Connections (_for_recep_" << n << ");" << endl;
      o << BL_CLOSE << endl;
    }
  }

  /*
   * CCMObject interfaces
   */

  o << "/*" << endl
    << " * Inherited Navigation interface" << endl
    << " */" << endl << endl;

  // provide_facet

  o << "CORBA::Object_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::provide_facet (const char * _name)" << endl;
  o << BL_OPEN;
  
  c = comp->contents (CORBA::dk_Provides, 1);

  for (CORBA::ULong j10=0; j10<c->length(); j10++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j10]);
    assert (!CORBA::is_nil(attr));
    CORBA::String_var n = attr->name();

    o << "if (strcmp (_name, \"" << n << "\") == 0) " << BL_OPEN;
    o << "return provide_" << n << " ();" << endl;
    o << BL_CLOSE;
  }

  o << "throw Components::InvalidName();" << endl;
  o << "return CORBA::Object::_nil ();" << endl;
  o << BL_CLOSE << endl;

  // describe_facets

  o << "Components::FacetDescriptions *" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::describe_facets ()" << endl;
  o << BL_OPEN;
  o << "Components::FacetDescriptions_var _res = new Components::FacetDescriptions;" << endl;
  
  c = comp->contents (CORBA::dk_Provides, 1);

  o << "_res->length (" << c->length() << ");" << endl;

  for (CORBA::ULong j11=0; j11<c->length(); j11++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j11]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var facettype = attr->interface_type ();
    CORBA::String_var facetid = facettype->id ();
    CORBA::String_var n = attr->name();

    o << endl;
    o << "_res[" << j11 << "].InterfaceID = "
      << "CORBA::string_dup (\"" << facetid << "\");" << endl;
    o << "_res[" << j11 << "].Name = "
      << "CORBA::string_dup (\"" << n << "\");" << endl;
  }

  o << "return _res._retn();" << endl;
  o << BL_CLOSE << endl;

  // provide_all_facets

  o << "Components::Facets *" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::provide_all_facets ()" << endl;
  o << BL_OPEN;
  o << "Components::Facets_var _res = new Components::Facets;" << endl;
  
  c = comp->contents (CORBA::dk_Provides, 1);

  o << "_res->length (" << c->length() << ");" << endl;

  for (CORBA::ULong j12=0; j12<c->length(); j12++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j12]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var facettype = attr->interface_type ();
    CORBA::String_var facetid = facettype->id ();
    CORBA::String_var n = attr->name();

    o << endl;
    o << "_res[" << j12 << "].InterfaceID = "
      << "CORBA::string_dup (\"" << facetid << "\");" << endl;
    o << "_res[" << j12 << "].Name = "
      << "CORBA::string_dup (\"" << n << "\");" << endl;
    o << "_res[" << j12 << "].ref = "
      << "_instance->_get_facet_" << n << " ();" << endl;
  }

  o << "return _res._retn();" << endl;
  o << BL_CLOSE << endl;

  // provide_named_facets

  o << "Components::Facets *" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::provide_named_facets (const Components::NameList & _names)" << endl;
  o << BL_OPEN;
  o << "Components::Facets_var _res = new Components::Facets;" << endl;
  
  c = comp->contents (CORBA::dk_Provides, 1);

  o << "_res->length (_names.length());" << endl << endl;

  o << "for (CORBA::ULong _idx=0; _idx<_names.length(); _idx++) " << BL_OPEN;
  for (CORBA::ULong j12=0; j12<c->length(); j12++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j12]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var facettype = attr->interface_type ();
    CORBA::String_var facetid = facettype->id ();
    CORBA::String_var n = attr->name();

    o << "if (strcmp (_names[_idx].in(), \"" << n << "\") == 0) " << BL_OPEN;
    o << "_res[_idx].InterfaceID = "
      << "CORBA::string_dup (\"" << facetid << "\");" << endl;
    o << "_res[_idx].Name = "
      << "CORBA::string_dup (\"" << n << "\");" << endl;
    o << "_res[_idx].ref = "
      << "_instance->_get_facet_" << n << " ();" << endl;
    o << "continue;" << endl;
    o << BL_CLOSE << endl;
  }
  o << "throw Components::InvalidName();" << endl;
  o << BL_CLOSE << endl;

  o << "return _res._retn();" << endl;
  o << BL_CLOSE << endl;

  // same_component (TODO)

  o << "CORBA::Boolean" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::same_component (CORBA::Object_ptr _ref)" << endl;
  o << BL_OPEN;
  o << "return 0;" << endl;
  o << BL_CLOSE << endl;

  o << "/*" << endl
    << " * Inherited Receptacles interface" << endl
    << " */" << endl << endl;

  // connect

  o << "Components::Cookie *" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::connect (const char * _name, CORBA::Object_ptr _ref)" << endl;
  o << BL_OPEN;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j20=0; j20<c->length(); j20++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j20]);
    assert (!CORBA::is_nil(attr));

    CORBA::InterfaceDef_var type_id = attr->interface_type();
    CORBA::String_var ain = type_id->absolute_name ();
    CORBA::String_var n = attr->name();
    string recep_abs_name = ain.in();
    recep_abs_name = recep_abs_name.substr (2);

    o << "if (strcmp (_name, \"" << n << "\") == 0) " << BL_OPEN;
    o << recep_abs_name << "_var _tref = "
      << recep_abs_name << "::_narrow (_ref);";
    o << "if (CORBA::is_nil (_tref) && !CORBA::is_nil (_ref)) " << BL_OPEN;
    o << "throw Components::InvalidConnection();" << endl;
    o << BL_CLOSE;
    if (!attr->is_multiple()) {
      o << "connect_" << n << " (_tref);" << endl;
      o << "return new Components::Cookie;" << endl;
    }
    else {
      o << "return connect_" << n << " (_tref);" << endl;
    }
    o << BL_CLOSE << endl;
  }

  o << "throw Components::InvalidName();" << endl;
  o << "return new Components::Cookie;" << endl;
  o << BL_CLOSE << endl;

  // disconnect

  o << "void" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::disconnect (const char * _name, const Components::Cookie & _ck)" << endl;
  o << BL_OPEN;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j21=0; j21<c->length(); j21++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j21]);
    assert (!CORBA::is_nil(attr));

    CORBA::InterfaceDef_var type_id = attr->interface_type();
    CORBA::String_var ain = type_id->absolute_name ();
    CORBA::String_var n = attr->name();
    string recep_abs_name = ain.in();
    recep_abs_name = recep_abs_name.substr (2);

    o << "if (strcmp (_name, \"" << n << "\") == 0) " << BL_OPEN;
    o << recep_abs_name << "_var _dummy;" << endl;

    if (!attr->is_multiple()) {
      o << "_dummy = disconnect_" << n << " ();" << endl;
    }
    else {
      o << "_dummy = disconnect_" << n << " (_ck);" << endl;
    }

    o << "return;" << endl;
    o << BL_CLOSE << endl;
  }

  o << "throw Components::InvalidName();" << endl;
  o << BL_CLOSE << endl;

  // get_connections

  o << "Components::ConnectionDescriptions *" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::get_connections (const char * _name)" << endl;
  o << BL_OPEN;

  c = comp->contents (CORBA::dk_Uses, 1);

  for (CORBA::ULong j22=0; j22<c->length(); j22++) {
    CORBA::ComponentIR::UsesDef_var attr =
      CORBA::ComponentIR::UsesDef::_narrow(c[j22]);
    assert (!CORBA::is_nil(attr));

    CORBA::InterfaceDef_var type_id = attr->interface_type();
    CORBA::String_var ain = type_id->absolute_name ();
    CORBA::String_var n = attr->name();
    string recep_abs_name = ain.in();
    recep_abs_name = recep_abs_name.substr (2);

    o << "if (strcmp (_name, \"" << n << "\") == 0) " << BL_OPEN;
    o << "Components::ConnectionDescriptions_var _res = ";
    o << "new Components::ConnectionDescriptions;" << endl;

    if (!attr->is_multiple()) {
      o << "if (!CORBA::is_nil (_for_recep_" << n << ")) " << BL_OPEN;
      o << "_res->length (1);" << endl;
      o << "_res[0].objref = CORBA::Object::_duplicate (_for_recep_" << n << ");" << endl;
      o << BL_CLOSE;
    }
    else {
      o << "_res->length (_for_recep_" << n << ".length());" << endl;
      o << "for (CORBA::ULong _idx=0; _idx<_res->length(); _idx++) " << BL_OPEN;
      o << "_res[_idx].ck = _for_recep_" << n << "[_idx].ck;" << endl;
      o << "_res[_idx].objref = CORBA::Object::_duplicate (_for_recep_" << n << "[_idx].objref);" << endl;
      o << BL_CLOSE;
    }

    o << "return _res._retn();" << endl;
    o << BL_CLOSE << endl;
  }

  o << "throw Components::InvalidName();" << endl;
  o << "return new Components::ConnectionDescriptions;" << endl;
  o << BL_CLOSE << endl;

  o << "/*" << endl
    << " * Inherited CCMObject interface" << endl
    << " */" << endl << endl;

  // get_component_def

  o << "CORBA::Object_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::get_component_def ()" << endl;
  o << BL_OPEN;
  o << "return CORBA::Object::_nil ();" << endl;
  o << BL_CLOSE << endl;

  // get_ccm_home

  o << "Components::CCMHome_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::get_ccm_home ()" << endl;
  o << BL_OPEN;
  o << "return _container->get_reference_for_home ();" << endl;
  o << BL_CLOSE << endl;

  // configuration_complete

  o << "void" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::configuration_complete ()" << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;

  // remove

  o << "void" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::remove ()" << endl;
  o << BL_OPEN;
  if (_type == ServiceComponent) {
    o << "/*" << endl
      << " * remove() has no effect on a Service Component" << endl
      << " */" << endl;
  }
  else if (_type == SessionComponent) {
    o << "Components::CCMHome_var myhome = get_ccm_home ();" << endl;
    o << "Components::CCMObject_var myself = _container->get_reference_for_component (this);" << endl;
    o << "myhome->remove_component (myself);" << endl;
  }
  o << BL_CLOSE << endl;

  o << "/*" << endl
    << " * Overload default implementation" << endl
    << " */" << endl
    << endl;

  o << "CORBA::Object_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::_get_component ()" << endl;
  o << BL_OPEN;
  if (_type == ServiceComponent) {
    o << "_container->get_reference_for_component ();" << endl;
  }
  else if (_type == SessionComponent) {
    o << "_container->get_reference_for_component (this);" << endl;
  }
  o << BL_CLOSE << endl;

  /*
   * Emit Glue code for local facets
   */

  c = comp->contents (CORBA::dk_Provides, 1);

  for (CORBA::ULong j30=0; j30<c->length(); j30++) {
    CORBA::ComponentIR::ProvidesDef_var attr =
      CORBA::ComponentIR::ProvidesDef::_narrow(c[j30]);
    assert (!CORBA::is_nil(attr));
    CORBA::InterfaceDef_var iface = attr->interface_type();
    CORBA::String_var n = attr->name();
    emitInterfaceGlueImpl (iface, comp, n);
  }
}

void
CCMCodeGenCpp::emitHomeGlueImpl (CORBA::ComponentIR::HomeDef_ptr home)
{
  CORBA::String_var n = home->name();
  CORBA::String_var a = home->absolute_name();
  CORBA::String_var home_id = home->id();
  string className = (const char *) ID(n);
  string absName = (const char *) ID(a);
  absName = absName.substr (2);
  string flatName = absName;
  CORBA::ULong idx;

  while ((idx = flatName.find ("::")) != (CORBA::ULong) -1) {
    flatName.replace (idx, 2, "_");
  }

  o << "/*" << endl
    << " * Glue class for home " << absName << endl
    << " */" << endl << endl;

  CORBA::ComponentIR::ComponentDef_var managed = home->managed_component ();
  CORBA::ValueDef_var key = home->primary_key ();
  CORBA::ContainedSeq_var c;

  CORBA::String_var managed_id = managed->id ();
  CORBA::String_var mn = managed->absolute_name ();
  string managedAbsName = (const char *) ID(mn.in());
  managedAbsName = managedAbsName.substr (2);
  string managedFlatName = managedAbsName;

  while ((idx = managedFlatName.find ("::")) != (CORBA::ULong) -1) {
    managedFlatName.replace (idx, 2, "_");
  }

  o << "MICO_CCM_impls::" << endl
    << flatName << "_impl::" << flatName << "_impl "
    << "(CCM_" << absName << " * i, ";
  if (_type == ServiceComponent) {
    o << "MICO::CCM::ServiceContainer * c";
  }
  else if (_type == SessionComponent) {
    o << "MICO::CCM::SessionContainer * c";
  }
  o << ")" << endl;
  o << indent << ": _instance (i), _container (c)";
  o << exdent << endl;
  o << BL_OPEN;
  o << BL_CLOSE << endl;
    
  o << "MICO_CCM_impls::" << endl
    << flatName << "_impl::~" << flatName << "_impl ()" << endl;
  o << BL_OPEN;
  o << "delete _instance;" << endl;
  o << BL_CLOSE << endl;

  o << "/*" << endl
    << " * Implicit operations" << endl
    << " */" << endl << endl;

  if (CORBA::is_nil (key)) {
    emit_type_for_result (managed);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::create ()" << endl;
    o << BL_OPEN;
    if (_type == ServiceComponent) {
      o << "Components::CCMObject_var _co =" << endl
	<< "  _container->get_reference_for_component ();" << endl;
      o << "return " << managedAbsName << "::_narrow (_co);" << endl;
    }
    else if (_type == SessionComponent) {
      o << "CCM_" << managedAbsName << "_ptr _ci = _instance->create ();"
	<< endl;
      o << "PortableServer::ServantBase_var _cs =" << endl
	<< "  new " << managedFlatName << "_impl (_ci, _container);"
	<< endl;
      o << "Components::CCMObject_var _co = " << endl
	<< "  _container->activate_component (_ci, _cs.in());" << endl;
      o << "Components::SessionContext_var _sc =" << endl
	<< "  _container->get_session_context ();" << endl;
      o << "_ci->set_session_context (_sc.in());" << endl;
      o << "_ci->ccm_activate ();" << endl;
      o << "return " << managedAbsName << "::_narrow (_co);" << endl;
    }
    o << BL_CLOSE << endl;
  }
  else {
    assert (0);

#if 0
    emit_type_for_result (managed);
    o << " create (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;

    emit_type_for_result (managed);
    o << " find_by_primary_key (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;
    
    o << "void remove (";
    emit_type_for_param (key, CORBA::PARAM_IN);
    o << ");" << endl;
#endif
  }

  o << "/*" << endl
    << " * Explicit operations" << endl
    << " */" << endl << endl;

  // Emit factories

  c = home->contents (CORBA::dk_Factory, 1);

  if (c->length()) {
    o << "// factories" << endl << endl;
  }
  else {
    o << "// no factories" << endl << endl;
  }

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j1]);
    CORBA::String_var n = op->name();

    assert (_type == SessionComponent);

    emit_type_for_result (managed);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::" << ID(n.in()) << " (";
    CORBA::ParDescriptionSeq_var p = op->params();
    for (CORBA::ULong k1=0; k1<p->length(); k1++) {
      if (k1 != 0)
	o << ", ";
      emit_type_for_param (p[k1].type_def, p[k1].mode );
      o << " " << ID(p[k1].name);
    }
    o << ")" << endl;
    o << BL_OPEN;
    o << "CCM_" << managedAbsName << "_ptr _ci =" << endl
      << "  _instance->" << ID(n.in()) << " (";
    for (CORBA::ULong k2=0; k2<p->length(); k2++) {
      if (k2 != 0)
	o << ", ";
      o << ID(p[k2].name);
    }
    o << ");" << endl;

    o << "PortableServer::ServantBase_var _cs = new "
      << managedFlatName << "_impl (_ci, _container);" << endl;
    o << "Components::CCMObject_var _co =" << endl
      << "  _container->activate_component (\"" << home_id << "\"," << endl
      << "                                  \"" << managed_id << "\"," << endl
      << "                                  _cs.in());" << endl;
    o << "Components::SessionContext_var _sc =" << endl
      << "  _container->get_session_context ();" << endl;
    o << "_ci->set_session_context (_sc.in());" << endl;
    o << "_ci->ccm_activate ();" << endl;
    o << "return " << managedAbsName << "::_narrow (_co);" << endl;
  }

  // Emit finder

  c = home->contents (CORBA::dk_Finder, 1);

  if (c->length()) {
    o << "// finders" << endl << endl;
  }
  else {
    o << "// no finders" << endl << endl;
  }

  for (CORBA::ULong j2=0; j2<c->length(); j2++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j2]);
    CORBA::String_var n = op->name();

    assert (_type == SessionComponent);

    emit_type_for_result (managed);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::" << ID(n.in()) << " (";
    CORBA::ParDescriptionSeq_var p = op->params();
    for (CORBA::ULong k1=0; k1<p->length(); k1++) {
      if (k1 != 0)
	o << ", ";
      emit_type_for_param (p[k1].type_def, p[k1].mode );
      o << " " << ID(p[k1].name);
    }
    o << ")" << endl;
    o << BL_OPEN;
    o << "CCM_" << managedAbsName << "_var _ci =" << endl
      << "  _instance->" << ID(n.in()) << " (";
    for (CORBA::ULong k2=0; k2<p->length(); k2++) {
      if (k2 != 0)
	o << ", ";
      o << ID(p[k2].name);
    }
    o << ");" << endl;
    o << "CORBA::Object_var _co = _container->get_reference_for_instance (_ci.in());" << endl;
    o << "if (CORBA::is_nil (_co)) " << BL_OPEN;
    o << "PortableServer::ServantBase_var _cs = new "
      << managedFlatName << "_impl (_ci, _container);" << endl;
    o << " _co =" << endl
      << "  _container->activate_component (\"" << home_id << "\"," << endl
      << "                                  \"" << managed_id << "\"," << endl
      << "                                  _cs.in());" << endl;
    o << "Components::SessionContext_var _sc =" << endl
      << "  _container->get_session_context ();" << endl;
    o << "_ci->set_session_context (_sc.in());" << endl;
    o << "_ci->ccm_activate ();" << endl;
    o << BL_CLOSE;
    o << "return " << managedAbsName << "::_narrow (_co);" << endl;
  }

  if (c->length()) {
    o << "// attributes" << endl << endl;
  }
  else {
    o << "// no attributes" << endl << endl;
  }

  c = home->contents (CORBA::dk_Attribute, 1);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j3]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();

    emit_type_for_result (type_id);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::" << ID(n.in()) << " ()" << endl;
    o << BL_OPEN;
    o << "return _instance->" << ID(n.in()) << " ();" << endl;
    o << BL_CLOSE << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << endl;
      o << "MICO_CCM_impls::" << endl;
      o << flatName << "_impl::" << ID(n.in()) << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "_instance->" << ID(n.in()) << " (_value);" << endl;
      o << BL_CLOSE << endl;
    }
  }

  if (c->length()) {
    o << "// operations" << endl << endl;
  }
  else {
    o << "// no operations" << endl << endl;
  }

  c = home->contents (CORBA::dk_Operation, 1);

  for (CORBA::ULong j4=0; j4<c->length(); j4++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j4]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::TypeCode_var rtc = type_id->type ();
    CORBA::String_var n = op->name();
    
    emit_type_for_result (type_id);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::" << ID(n.in()) << " (";
    
    for (CORBA::ULong k1=0; k1<p->length(); k1++) {
      if (k1 != 0)
	o << ", ";
      emit_type_for_param (p[k1].type_def, p[k1].mode);
      o << " " << ID(p[k1].name);
    }
    o << ")" << endl;
    
    o << BL_OPEN;
    
    if (rtc->kind() != CORBA::tk_void) {
      o << "return ";
    }
    
    o << "_instance->" << ID(n.in()) << " (";
    for (CORBA::ULong k2=0; k2<p->length(); k2++) {
      if (k2 != 0)
	o << ", ";
      o << ID(p[k2].name);
    }
    o << ");" << endl;
    
    o << BL_CLOSE << endl;
  }
  
  /*
   * CCMHome interfaces
   */

  o << "/*" << endl
    << " * Inherited CCMHome interface" << endl
    << " */" << endl << endl;

  // get_component_def

  o << "CORBA::Object_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::get_component_def ()" << endl;
  o << BL_OPEN;
  o << "return CORBA::Object::_nil ();" << endl;
  o << BL_CLOSE << endl;

  // get_home_def

  o << "CORBA::Object_ptr" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::get_home_def ()" << endl;
  o << BL_OPEN;
  o << "return CORBA::Object::_nil ();" << endl;
  o << BL_CLOSE << endl;

  // remove_component

  o << "void" << endl;
  o << "MICO_CCM_impls::" << endl;
  o << flatName << "_impl::remove_component (Components::CCMObject_ptr _co)"
    << endl;
  o << BL_OPEN;
  if (_type == ServiceComponent) {
    o << "/*" << endl
      << " * remove_component() has no effect on a Service Component" << endl
      << " */" << endl;
  }
  else if (_type == SessionComponent) {
    o << "PortableServer::ServantBase_var _cs =" << endl
      << "  _container->get_skeleton_for_reference (_co);" << endl;
    o << "CORBA::LocalObject_var _ci =" << endl
      << "  _container->get_instance_for_component (_cs.in());" << endl;
    o << "CCM_" << managedAbsName << "_var _cti =" << endl
      << "  CCM_" << managedAbsName << "::_narrow (_ci.in());" << endl;
    o << endl;
    o << "_cti->ccm_passivate ();" << endl;
    o << "_cti->ccm_remove ();" << endl;
    o << "_container->deactivate_component (_cs);" << endl;
  }
  o << BL_CLOSE << endl;

  if (CORBA::is_nil (key)) {
    o << "/*" << endl
      << " * Inherited KeylessCCMHome interface" << endl
      << " */" << endl << endl;

    o << "Components::CCMObject_ptr" << endl;
    o << "MICO_CCM_impls::" << endl;
    o << flatName << "_impl::create_component ()" << endl;
    o << BL_OPEN;
    o << "return create ();" << endl;
    o << BL_CLOSE << endl;
  }
};

/*
 * ----------------------------------------------------------------------
 * This code produces glue for facets that are implemented locally, i.e.
 * a component has returned a local interface reference from a provide_*
 * method. We therefore need to implement the POA skeleton for that inter-
 * face and delegate calls to the user implementation.
 * ----------------------------------------------------------------------
 */

void
CCMCodeGenCpp::emitInterfaceGlueDecl (CORBA::InterfaceDef_ptr iface,
				      CORBA::ComponentIR::ComponentDef_ptr comp,
				      const char * facet_name)
{
  CORBA::String_var n = comp->name();
  CORBA::String_var a = comp->absolute_name();
  string compClassName = (const char *) ID(n);
  string compAbsName = (const char *) ID(a);
  compAbsName = compAbsName.substr (2);
  string compFlatName = compAbsName;
  CORBA::ULong idx;

  while ((idx = compFlatName.find ("::")) != (CORBA::ULong) -1) {
    compFlatName.replace (idx, 2, "_");
  }

  n = iface->name ();
  a = iface->absolute_name ();
  string ifaceClassName = (const char *) ID(n);
  string ifaceAbsName = (const char *) ID(a);
  ifaceAbsName = ifaceAbsName.substr (2);
  string ifaceFlatName = ifaceAbsName;

  while ((idx = ifaceFlatName.find ("::")) != (CORBA::ULong) -1) {
    ifaceFlatName.replace (idx, 2, "_");
  }

  string fullName = compFlatName;
  fullName += "_";
  fullName += facet_name;
  fullName += "_impl";

  o << "/*" << endl
    << " * Glue class for facet " << facet_name << " of component "
    << compAbsName << endl
    << " * type " << ifaceAbsName << endl
    << " */" << endl << endl;

  o << "class " << fullName << " :" << indent << indent << endl;
  o << "virtual public POA_" << ifaceAbsName << "," << endl;
  o << "virtual public PortableServer::RefCountServantBase";
  o << exdent << exdent << endl << BL_OPEN;

  CORBA::ContainedSeq_var c;

  o << "private:" << indent << endl;
  o << ifaceAbsName << " * _instance;" << endl;

  o << exdent << endl;
  o << "public:" << indent << endl;

  o << fullName << " (" << ifaceAbsName << " *);" << endl;
  o << "~" << fullName << " ();" << endl;
  o << endl;

  /*
   * Prototypes
   */

  o << "/*" << endl
    << " * Attributes" << endl
    << " */" << endl << endl;

  c = iface->contents (CORBA::dk_Attribute, 0);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << " ();" << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << ID( n.in() ) << " (";
      emit_type_for_param( type_id, CORBA::PARAM_IN );
      o << " _value);" << endl;
    }
  }

  if (c->length()) {
    o << endl;
  }
  else {
    o << "// none" << endl << endl;
  }

  o << "/*" << endl
    << " * Operations" << endl
    << " */" << endl << endl;

  c = iface->contents (CORBA::dk_Operation, 0);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j3]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::String_var n = op->name();
    emit_type_for_result( type_id );
    o << " " << ID( n.in() ) << "(";
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::ULong k;
    for( k = 0; k < p->length(); k++ ) {
      if( k != 0 )
	o << ",";
      o << " ";
      emit_type_for_param( p[ k ].type_def, p[ k ].mode );
      o << " " << ID(p[ k ].name);
    }
    o << ");" << endl;
  }
  
  if (c->length()) {
    o << endl;
  }
  else {
    o << "// none" << endl << endl;
  }

  o << exdent << BL_CLOSE_SEMI << endl << endl;
}

void
CCMCodeGenCpp::emitInterfaceGlueImpl (CORBA::InterfaceDef_ptr iface,
				      CORBA::ComponentIR::ComponentDef_ptr comp,
				      const char * facet_name)
{
  CORBA::String_var n = comp->name();
  CORBA::String_var a = comp->absolute_name();
  string compClassName = (const char *) ID(n);
  string compAbsName = (const char *) ID(a);
  compAbsName = compAbsName.substr (2);
  string compFlatName = compAbsName;
  CORBA::ULong idx;

  while ((idx = compFlatName.find ("::")) != (CORBA::ULong) -1) {
    compFlatName.replace (idx, 2, "_");
  }

  n = iface->name ();
  a = iface->absolute_name ();
  string ifaceClassName = (const char *) ID(n);
  string ifaceAbsName = (const char *) ID(a);
  ifaceAbsName = ifaceAbsName.substr (2);
  string ifaceFlatName = ifaceAbsName;

  while ((idx = ifaceFlatName.find ("::")) != (CORBA::ULong) -1) {
    ifaceFlatName.replace (idx, 2, "_");
  }

  string fullName = compFlatName;
  fullName += "_";
  fullName += facet_name;
  fullName += "_impl";

  o << "/*" << endl
    << " * Glue class for facet " << facet_name << " of component "
    << compAbsName << endl
    << " * type " << ifaceAbsName << endl
    << " */" << endl << endl;

  CORBA::ContainedSeq_var c;

  o << "MICO_CCM_impls::" << endl
    << fullName << "::" << fullName << " (" << ifaceAbsName << " * i)" << endl;
  o << BL_OPEN;
  o << "_instance = i;" << endl;
  o << BL_CLOSE << endl;

  o << "MICO_CCM_impls::" << endl
    << fullName << "::~" << fullName << " ()" << endl;
  o << BL_OPEN;
  o << "delete _instance;" << endl;
  o << BL_CLOSE << endl;

  /*
   * Delegators
   */

  o << "/*" << endl
    << " * Attributes" << endl
    << " */" << endl << endl;

  c = iface->contents (CORBA::dk_Attribute, 0);

  for (CORBA::ULong j1=0; j1<c->length(); j1++) {
    CORBA::AttributeDef_var attr = CORBA::AttributeDef::_narrow(c[j1]);
    assert (!CORBA::is_nil(attr));
    CORBA::IDLType_var type_id = attr->type_def();
    CORBA::String_var n = attr->name();

    emit_type_for_result (type_id);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << fullName << "::" << ID(n.in()) << " ()" << endl;
    o << BL_OPEN;
    o << "return _instance->" << ID(n.in()) << " ();" << endl;
    o << BL_CLOSE << endl;

    if( attr->mode() == CORBA::ATTR_NORMAL ) {
      o << "void " << endl;
      o << "MICO_CCM_impls::" << endl;
      o << fullName << "::" << ID(n.in()) << " (";
      emit_type_for_param (type_id, CORBA::PARAM_IN);
      o << " _value)" << endl;
      o << BL_OPEN;
      o << "_instance->" << ID(n.in()) << " (_value);" << endl;
      o << BL_CLOSE << endl;
    }
  }

  o << "/*" << endl
    << " * Operations" << endl
    << " */" << endl << endl;

  c = iface->contents (CORBA::dk_Operation, 0);

  for (CORBA::ULong j3=0; j3<c->length(); j3++) {
    CORBA::OperationDef_var op = CORBA::OperationDef::_narrow(c[j3]);
    CORBA::IDLType_var type_id = op->result_def();
    CORBA::ParDescriptionSeq_var p = op->params();
    CORBA::TypeCode_var rtc = type_id->type ();
    CORBA::String_var n = op->name();
    
    emit_type_for_result (type_id);
    o << endl;
    o << "MICO_CCM_impls::" << endl;
    o << fullName << "::" << ID(n.in()) << " (";

    for (CORBA::ULong k1=0; k1<p->length(); k1++) {
      if (k1 != 0)
	o << ", ";
      emit_type_for_param (p[k1].type_def, p[k1].mode);
      o << " " << ID(p[k1].name);
    }
    o << ")" << endl;
    
    o << BL_OPEN;
    
    if (rtc->kind() != CORBA::tk_void) {
      o << "return ";
    }
    
    o << "_instance->" << ID(n.in()) << " (";
    for (CORBA::ULong k2=0; k2<p->length(); k2++) {
      if (k2 != 0)
	o << ", ";
      o << ID(p[k2].name);
    }
    o << ");" << endl;
    
    o << BL_CLOSE << endl;
  }
}

/*
 * ----------------------------------------------------------------------
 */

void
usage ()
{
  cout << "usage:" << endl
       << "  mico-ccm <options> idl-file" << endl
       << endl
       << "possible <options> are:" << endl
       << "    --session      Make code for Session Components" << endl
       << "    --service      Make code for Service Components" << endl
       << "    --standalone   Make a standalone program" << endl;
}

int
main (int argc, char *argv[])
{
  CORBA::Container_var container;
  CORBA::Repository_var repository;
  DB db;
  
  // ORB initialization
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);

#ifdef _WINDOWS
  // Some parts of the idl-compiler can't handle backslashes in paths
  // replace all the backslashes by slashes
  // runtime library can handle slashes fine
  // assume that only paths have backslashes(true for now)
  // (changing the argv[] is allowed)
  for(int i=1; i<argc; i++)
  {
      char *argp=argv[i];
      while(argp && *argp)
      {
          if(*argp=='\\')
              *argp='/';
          
          argp++;
      }
  }
  
#endif

  /*
   * Process command-line options
   */

  CCMCodeGenCpp::ComponentType type = CCMCodeGenCpp::SessionComponent;
  MICOGetOpt::OptMap opts;
  IDLParam params;
  bool standalone = true;

  // IDL Compiler options
  opts["--c++-suffix"] = "arg-expected";
  opts["--hh-suffix"]  = "arg-expected";
  opts["--name"]       = "arg-expected";

  // Preprocessor options
  opts["-I"]           = "arg-expected";
  opts["-D"]           = "arg-expected";

  // CCM Code Generation options
  opts["--session"]    = "";
  opts["--service"]    = "";
  opts["--standalone"] = "";

  MICOGetOpt opt_parser (opts);
  if (!opt_parser.parse (argc, argv)) {
    usage();
    exit(1);
  }

  for (MICOGetOpt::OptVec::const_iterator i=opt_parser.opts().begin();
       i != opt_parser.opts().end(); i++) {
    string arg = (*i).first;
    string val = (*i).second;

    if (arg == "-I") {
      params.cpp_options += " ";
      params.cpp_options += arg + val;
      params.inc_paths.push_back (val);
    }
    else if (arg == "-D") {
      params.cpp_options += " ";
      params.cpp_options += arg + val;
    }
    else if (arg == "--c++-suffix") {
      params.cpp_suffix = val;
    }
    else if (arg == "--hh-suffix") {
      params.hh_suffix = val;
    }
    else if (arg == "--name") {
      params.name = val;
    }
    else if (arg == "--repo-id") {
      params.repo_id = val;
    }
    else if (arg == "--service") {
      type = CCMCodeGenCpp::ServiceComponent;
    }
    else if (arg == "--session") {
      type = CCMCodeGenCpp::SessionComponent;
    }
    else if (arg == "--standalone") {
      standalone = true;
    }
  }

  if (argc == 2 && *argv[1] != '-') {
    params.name = argv[1];
  }
  else if (argc > 2) {
    usage ();
    exit (1);
  }

  /*
   * Determine Interface Repository to use
   */

  if (argc == 1) {
    /*
     * When no filename is given on the command line, connect to remote IFR
     */

    CORBA::Object_var obj =
      orb->resolve_initial_references ("InterfaceRepository");
    repository = CORBA::Repository::_narrow (obj);

    if (CORBA::is_nil (repository)) {
      cerr << "error: cannot connect to remote interface repository." << endl;
      exit (1);
    }
  }
  else {
    /*
     * Else, use local IR
     */

    repository = MICO::create_interface_repository (orb);
  }

  assert (!CORBA::is_nil (repository));

  /*
   * Input file processing
   */
  
  if (argc == 2) {

    /*
     * Step 1: Invoke the Preprocessor
     */

    string cmd = CPP;
    cmd += " -D __MICO_IDL__ ";
    cmd += params.cpp_options;
    cmd += " -I";
    cmd += ABSEXECDIR;
    cmd += "/include ";
    cmd += argv[1];

    FILE* inp_file = OSMisc::popen( cmd.c_str(), "r" );

    if( inp_file == NULL ) {
      cerr << "error: cannot open input file: " << argv[1] << endl;
      exit( 1 );
    }
    
    int dummy_char = fgetc (inp_file);
    if (dummy_char == EOF) {
      cerr << "error: cannot execute " << CPP << endl;
      exit( 1 );
    }
    ungetc (dummy_char, inp_file);

    if( params.cpp_only() ) {
      int ch = fgetc( inp_file );
      while( ch != EOF ) {
	fputc( ch, stdout );
	ch = fgetc( inp_file );
      }
      exit( 0 );
    }

    /*
     * Step 2: Invoke the Parser (bison)
     */
    
    Parser parser( inp_file, params.file.c_str() );
    parser.parse();

    OSMisc::pclose( inp_file );

    /*
     * Step 3: Traverse the Parse Tree and load Interface Repository
     */

    db.set_toplevel_fname (params.file.c_str());
    IDLParser idlParser (db);
    idlParser.collect (repository, parser.getRootNode());
    db.set_repoids (repository);
  }

  /*
   * At this time, we are connected to an Interface Repository, and
   * this IR has been loaded with the contents of the IDL file (if
   * given on the command line).
   */

  /*
   * Determine which portions of the IR to dump. This is selected by
   * using the --repo-id option on the command line, else the whole
   * contents are dumped.
   */

  container = CORBA::Container::_duplicate (repository);
  
  if (params.repo_id != "" && params.repo_id != "::") {
    CORBA::Contained_var contained =
      repository->lookup_id( (char *) params.repo_id.c_str() );
    if( CORBA::is_nil( contained ) ) {
      contained = repository->lookup( (char *) params.repo_id.c_str() );
      if( CORBA::is_nil( contained ) ) {
	cerr << "error: repo-id " << params.repo_id << " not found in IR";
	  cerr << endl;
	  exit( 1 );
      }
    }
    container = CORBA::Container::_narrow( contained );
    if( CORBA::is_nil( container ) ) {
      cerr << "error: repo-id " << params.repo_id << " is not a container";
      cerr << endl;
      exit( 1 );
    }
    if( container->def_kind() != CORBA::dk_Module ) {
      cerr << "error: can only generate code from module";
      cerr << endl;
      exit( 1 );
    }
  }

  /*
   * Determine output file name
   */

  if (argc == 1 && params.name == "") {
    cerr << "error: must have a --name when working from the IFR." << endl;
    exit (1);
  }
  
  string name = params.name;
  string::size_type pos = name.rfind( "." );
  if( (int)pos >= 0 && pos < name.length() )
    name = name.substr( 0, pos );
  pos = name.rfind( "/" );
#ifdef _WINDOWS
   if (pos==string::npos)
     pos = name.rfind( "\\" );
#endif
  if( (int)pos >=0 && pos < name.length() )
    name = name.substr( pos + 1 );
  
  /*
   * Invoke Code Generator
   */

  CCMCodeGenCpp gen (db, params, container, type, standalone);
  gen.emit (name);

  return 0;
}
