/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Widget.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "../include/mhgui/Widget.h"
#include "../include/mhgui/AbstractListener.h"
#include "../include/mhgui/Tooltip.h"

#ifdef __APPLE__
    #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

#include <iostream>

using namespace std;

namespace mhgui {

Widget::Widget (uint32_t          inId,
                const Rect&       inGeometry)
    : Component  (inId, inGeometry),
    parentPanel(NULL),
    tooltip    (NULL)
{
}

Widget::~Widget()
{
  if (parentPanel)
    parentPanel->removeWidget (this);

  delete tooltip;
}

void Widget::setTooltip (const Tooltip& inTooltip)
{
  delete tooltip;
  tooltip = new Tooltip(inTooltip);
}

void Widget::draw()
{
}

void Widget::drawOverlay()
{
}

void Widget::draw_wrapper()
{
  if (tooltip && isLastMouseOver())
  {
    tooltip->draw();
  }
  draw();
}

} // namespace mhgui

