/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Camera.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "../include/mhgui/Camera.h"
#include <iostream>

using namespace Animorph;

namespace mhgui {

Camera::Camera ()
: last_mouse_pos(0.0f, 0.0f),
  last_pos_camera(0.0f, 0.0f, 0.0f),
  width(0), height(0),
  angle (0.0f),
  axis  (0.0f, 0.0f, 0.0f),
  cam_pos(), 
  cam_center(),

  // Ugly Test code following - just for test purposes!
  mCameraPos(0.0f, 0.0f, 0.0f),
  mAngleX(0), mAngleY(0), mAngleZ(0)
{}

Camera::Camera (const Camera& inRHS)
: last_mouse_pos(inRHS.last_mouse_pos),
  last_pos_camera(inRHS.last_pos_camera),
  width(inRHS.width), height(inRHS.height),
  angle (inRHS.angle),
  axis  (inRHS.axis),
  cam_pos(inRHS.cam_pos), 
  cam_center(inRHS.cam_center),

  // Ugly Test code following - just for test purposes!
  mCameraPos(inRHS.mCameraPos),
  mAngleX(inRHS.mAngleX), mAngleY(inRHS.mAngleY), mAngleZ(inRHS.mAngleZ)
{}

Camera& Camera::operator=(const Camera& inRHS)
{
  if (&inRHS != this)
  {
    last_mouse_pos  = inRHS.last_mouse_pos;
    last_pos_camera = inRHS.last_pos_camera;
    width      = inRHS.width;
    height     = inRHS.height;
    angle      = inRHS.angle;
    axis       = inRHS.axis;
    cam_pos    = inRHS.cam_pos;
    cam_center = inRHS.cam_center;

    // Ugly Test code following - just for test purposes!
    mCameraPos = inRHS.mCameraPos;
    mAngleX = inRHS.mAngleX;
    mAngleY = inRHS.mAngleY;
    mAngleZ = inRHS.mAngleZ;
  }
  return *this;
}

void Camera::reshape (int width, int height)
{
  this->width  = width;
  this->height = height;
}

void Camera::rotate (float theta, RotateAxis axis)
{
  Matrix rotate;

  rotate.setRotation (theta, axis);
  cam_pos = rotate * cam_pos;

  if (axis == X_AXIS)
    mAngleX += theta;
  else if (axis == Y_AXIS)
    mAngleY += theta;
  else if (axis == Z_AXIS)
    mAngleZ += theta;
}

void Camera::resetRotation ()
{
  cam_pos.identity();
  mAngleX = mAngleY = mAngleZ = 0.0f;
}

void Camera::resetPosition ()
{
  cam_center.identity();
  mCameraPos.zero();
}

void Camera::rotateMouse (int x, int y)
{
     /*
  Vector3f current_pos_camera = projectMouseOnSphere (x, y);

  angle = last_pos_camera * current_pos_camera;
  axis = crossProduct (last_pos_camera, current_pos_camera);

  axis.normalize ();
*/
  rotate ((M_PI/180) * (y - last_mouse_pos.y), X_AXIS);
  rotate ((M_PI/180) * (x - last_mouse_pos.x), Y_AXIS);

  last_mouse_pos.x = x;
  last_mouse_pos.y = y;
}

void Camera::mouseRotateStart (int x, int y)
{
  //last_pos_camera = projectMouseOnSphere (x, y);
  last_mouse_pos.x = x;
  last_mouse_pos.y = y;
}

Vector3f Camera::projectMouseOnSphere (int x, int y)
{
  float d;
  Vector3f v;

  /* project x, y onto a hemi-sphere centered within width, height. */
  v.x  = (2.0 * x - width) / width;
  v.y = (height - 2.0 * y) / height;
  d = sqrt(v.x * v.x + v.y * v.y);

  v.z = ::cosf((M_PI / 2.0) * ((d < 1.0) ? d : 1.0));

  v.normalize ();

  return v;
}

void Camera::move (float x, float y, float z)
{
  mCameraPos.x += x;
  mCameraPos.y += y;
  mCameraPos.z += z;

  Matrix m_tmp;

  m_tmp.setTranslation (x, y, z);

  cam_center = m_tmp * cam_center;
}

void Camera::applyMatrix ()
{
  Matrix m_tmp;

  m_tmp = cam_center * cam_pos;

  cgutils::displayStart (m_tmp);
}

} // namespace mhgui

