/*            Copyright (C) 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

/*    FIXME: parsing code is hideous.
 *    The parsing of ranges even more so. taurus/parse.c/parseIntSet.
*/

#include <string.h>

#include "impala/matrix.h"
#include "impala/vector.h"
#include "impala/ivp.h"
#include "impala/pval.h"
#include "impala/io.h"
#include "mcl/interpret.h"

#include "util/types.h"
#include "util/err.h"
#include "util/ting.h"
#include "util/opt.h"
#include "util/array.h"

#include "taurus/parse.h"
#include "taurus/la.h"

#define DO_CC     16
#define DO_TP     32

#define MAP_COLS 1
#define MAP_ROWS 2

typedef struct
{  mcxTing*    tagTxt
;  mcxTing*    specTxt          /*  text representation of spec   */
;  mclVector*  cVec             /*  contains col indices    */
;  mclVector*  rVec             /*  contains row indices    */
;  mcxbool     tagIsFname
;  double      lft
;  double      rgt
;  mcxbits     options
;  mcxbits     selOptions
;  mcxbits     mapOptions
;  
}  subSpec     ;


const char* usagelines[];

const char* me = "mcxsubs";

void usage
(  const char**
)  ;


mclVector*  vectorFromString
(  const char* str
,  mclMatrix*  dom
,  mclVector*  vecV
)  ;


int main
(  int                  argc
,  const char*          argv[]
)  
   {  mcxIO             *xfCl       =  NULL
   ;  mcxIO             *xfMx       =  NULL

   ;  mclMatrix         *dom        =  NULL
   ;  mclMatrix         *el2dom     =  NULL
   ;  mclMatrix         *mx         =  NULL
   ;  mclVector         *vecVR      =  NULL
   ;  mclVector         *vecVC      =  NULL

   ;  mcxTing           *fstem      =  mcxTingNew("out.sub-")
   ;  char              *sep        =  NULL

   ;  subSpec           *specList   =  NULL
   ;  int               n_spec      =  0
   ;  mcxBuf            specBuf

   ;  int               status      =  0
   ;  int               digits      =  3
   ;  int               a           =  1
   ;  int               i           =  0
   ;  int               bCltag      =  0

   ;  mcxBufInit(&specBuf,  &specList, sizeof(subSpec), 30)

   ;  if (argc==1)
      goto help

   ;  while(a < argc)
      {  if (!strcmp(argv[a], "-dom") || !strcmp(argv[a], "-dom"))
         {  if (a++ + 1 < argc)
            {  xfCl  =  mcxIOnew(argv[a], "r")
            ;  mcxIOopen(xfCl, EXIT_ON_FAIL)
         ;  }
            else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-stem"))
         {  if (a++ + 1 < argc)
            mcxTingWrite(fstem, argv[a])
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "--tag"))
         {  bCltag   =  1
      ;  }
         else if (!strcmp(argv[a], "-digits"))
         {  if (a++ + 1 < argc)
            digits   =  atoi(argv[a])
         ;  else
            goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-imx"))
         {  if (a++ + 1 < argc)
            {  xfMx  =  mcxIOnew(argv[a], "r")
            ;  mcxIOopen(xfMx, EXIT_ON_FAIL)
         ;  }
            else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-h"))
         {  goto help
      ;  }
         else if (0)
         {  help:
         ;  mcxUsage(stdout, me, usagelines)
         ;  mcxExit(status)
      ;  }
         else if (0)
         {  arg_missing:
         ;  mcxTell(me, "flag <%s> needs argument; see help (-h)", argv[argc-1])
         ;  mcxExit(1)
      ;  }
         else if (argv[a][0] == '-')
         {  mcxTell(me, "unknown flag <%s>", argv[a])
         ;  mcxExit(1)
      ;  }
         else
         {  subSpec*    spec     =  (subSpec*) mcxBufExtend(&specBuf, 1, EXIT_ON_FAIL)

         ;  spec->specTxt        =  mcxTingNew(argv[a])
         ;  spec->tagTxt         =  NULL
         ;  spec->tagIsFname     =  0
         ;  spec->lft            =  0
         ;  spec->rgt            =  0
         ;  spec->options        =  0
         ;  spec->selOptions     =  0
         ;  spec->mapOptions     =  0
         ;  spec->cVec           =  mclvInit(NULL)
         ;  spec->rVec           =  mclvInit(NULL)
      ;  }
         a++
   ;  }

      n_spec =  mcxBufFinalize(&specBuf)

   ;  if (!xfMx)
      {  mcxTell(me, "-imx flag is obligatory, see help (-h)")
      ;  mcxExit(1)
   ;  }
      else
      {  mx    =  mclxRead(xfMx, EXIT_ON_FAIL)
      ;  vecVR =  mclvCopy(NULL, mx->dom_rows)
      ;  vecVC =  mclvCopy(NULL, mx->dom_cols)
   ;  }

      if (xfCl)
      dom    =  mclxRead(xfCl, EXIT_ON_FAIL)

   ;  mcxIOfree(&xfMx)
   ;  mcxIOfree(&xfCl)

   ;  if (bCltag)
      {  if (!dom)
         {  mcxErr(me, "option <--tag> requires <-dom> input")
         ;  mcxExit(1)
      ;  }
         el2dom = mclxTranspose(dom)
   ;  }

      for (i=0;i<n_spec;i++)
      {  subSpec        *spec          =  specList+i

      ;  mclVector      *colVec        =  NULL
      ;  mclVector      *rowVec        =  NULL

      ;  char           *specStr       =  mcxTingStr(spec->specTxt)

      ;  char *rTag =  NULL, *cTag = NULL, *vTag =  NULL, *mTag = NULL
      ;  char *rSpec=  NULL, *cSpec= NULL, *vSpec=  NULL, *mSpec= NULL

      ;  char           rType          =  '\0'
      ;  char           cType          =  '\0'

      ;  char           *tagPtr        =  strchr(specStr, '#')

      ;  if (tagPtr)
         {  *tagPtr        =  '\0'
         ;  tagPtr++

         ;  if (*tagPtr == '#')
            {  spec->tagIsFname  =  1
            ;  tagPtr++
         ;  }
            spec->tagTxt   =  mcxTingNew(tagPtr)
      ;  }
         else
         {  spec->tagTxt   =  mcxTingNew(spec->specTxt->str)
      ;  }
         
         /* vTag and mTag are easy to identify; hence they go first.
         */

         vTag              =  strstr(specStr, "v:")
      ;  mTag              =  strstr(specStr, "f:")

      ;  if (mTag)
         {  mSpec = mTag+2
         ;  *mTag = '\0'
      ;  }

         if (vTag)
         {  vSpec = vTag+2
         ;  *vTag = '\0'
      ;  }

         if (vTag)
         {  char* sep
         ;  while(1)
            {  if ((sep = strchr(vSpec, ',')))
               *sep = '\0'
            ;  if (!strncmp(vSpec, "gq", 2))
               {  spec->lft = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_GQ
               ;  fprintf(stdout, "[mcxsubs] selecting entries gq <%f>\n", spec->lft)
            ;  }
               else if (!strncmp(vSpec, "gt", 2))
               {  spec->lft = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_GT
               ;  fprintf(stdout, "[mcxsubs] selecting entries gt <%f>\n", spec->lft)
            ;  }
               else if (!strncmp(vSpec, "lt", 2))
               {  spec->rgt = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_LT
               ;  fprintf(stdout, "[mcxsubs] selecting entries lt <%f>\n", spec->rgt)
            ;  }
               else if (!strncmp(vSpec, "lq", 2))
               {  spec->rgt = atof(vSpec+2)
               ;  spec->selOptions |= MCLX_LQ
               ;  fprintf(stdout, "[mcxsubs] selecting entries lq <%f>\n", spec->rgt)
            ;  }
               if (sep)
               vSpec = sep+1
            ;  else
               break
         ;  }
         }

         if (mTag)
         {  char* sep
         ;  while(1)
            {  if ((sep = strchr(mSpec, ',')))
               *sep = '\0'
            ;  if (!strncmp(mSpec, "mp", 2))
               {  spec->mapOptions |= (MAP_COLS | MAP_ROWS)
            ;  }
               else if (!strncmp(mSpec, "mr", 2))
               {  spec->mapOptions |= MAP_ROWS
            ;  }
               else if (!strncmp(mSpec, "mc", 2))
               {  spec->mapOptions |= MAP_COLS
            ;  }
               else if (!strncmp(mSpec, "tp", 2))
               {  spec->options |= DO_TP
            ;  }
               else if (!strncmp(mSpec, "cc", 2))
               {  spec->options |= DO_CC
            ;  }
               if (sep)
               mSpec = sep+1
            ;  else
               break
         ;  }
         }

         /* next find cTag and rTag. just search for cCrR.
          * the r in 'f:mr' if present is now hidden
         */

      ;  cTag              =  strpbrk(specStr, "cC")
      ;  rTag              =  strpbrk(specStr, "rR")

         /* next remove syntactic sugar, if present
         */

      ;  sep = specStr
      ;  while ((sep = strchr(sep, '_')))
         {  *sep = '\0'
         ;  sep++
      ;  }

         if (cTag)
         {  cType          =  *cTag
         ;  if (!(cSpec = strchr(cTag+1, ':')))
            {  mcxErr(me, "cannot find <:> tag after <%c> tag", (int) cType)
            ;  mcxExit(1)
         ;  }
            cSpec++
      ;  }

         if (rTag)
         {  rType          =  *rTag
         ;  if (!(rSpec = strchr(rTag+1, ':')))
            {  mcxErr(me, "cannot find <:> tag after <%c> tag", (int) rType)
            ;  mcxExit(1)
         ;  }
            rSpec++
      ;  }

         /* set these at this stage, not earlier.
          * because we need to recognize cr: and rc: etc.
         */

         if (rTag)
         *rTag = '\0'
      ;  if (cTag)
         *cTag = '\0'

      ;  if (cTag)
         {  fprintf(stdout, "[%s] parsing column poly-spec <%s>\n", me, cSpec)
         ;  colVec = vectorFromString(cSpec, dom, vecVC)
         ;  if (cType == 'C')
            colVec = mcldMinus(vecVC, colVec, colVec)
      ;  }
         else
         {  colVec = mclvRenew(colVec, vecVC->ivps, vecVC->n_ivps)
      ;  }

         if (rTag)
         {  fprintf(stdout, "[%s] parsing row poly-spec <%s>\n", me, rSpec)
         ;  rowVec = vectorFromString(rSpec, dom, vecVR)
         ;  if (rType == 'R')
            rowVec = mcldMinus(vecVR, rowVec, rowVec)
      ;  }
         else
         {  rowVec = mclvRenew(rowVec, vecVR->ivps, vecVR->n_ivps)
      ;  }

         spec->cVec = colVec
      ;  spec->rVec = rowVec
         /* need some kind of check here on colVec, rowVec ?? */
   ;  }

      for (i=0;i<n_spec;i++)
      {  mclMatrix* sub

      ;  subSpec* spec   =  specList+i
      ;  mcxTing* tagTxt =  (specList+i)->tagTxt

      ;  mcxTing *fname  =  spec->tagIsFname
                            ?  mcxTingInit(NULL)
                            :  mcxTingNew(fstem->str)
      ;  mcxIO *xf

      ;  mcxTingAppend(fname, tagTxt->str)
      ;  xf    =  mcxIOnew(fname->str, "w")

      ;  if (mcxIOopen(xf, RETURN_ON_FAIL) == STATUS_FAIL)
         {  mcxErr
            (me, "cannot open file <%s> for writing! Ignoring", xf->fn->str)
         ;  mcxTingFree(&fname)
         ;  mcxIOfree(&xf)
         ;  continue
      ;  }

       /*   fixme: must check subness */
         sub =  mclxSub(mx, spec->cVec, spec->rVec)

      ;  if (spec->mapOptions & MAP_COLS)
         mclxMapCols(sub, NULL)

      ;  if (spec->mapOptions & MAP_ROWS)
         mclxMapRows(sub, NULL)

      ;  if (spec->selOptions)
         mclxSelectValues
         (  sub
         ,  spec->selOptions & (MCLX_GQ | MCLX_GT) ? &(spec->lft) : NULL
         ,  spec->selOptions & (MCLX_LQ | MCLX_LT) ? &(spec->rgt) : NULL
         ,  spec->selOptions
         )

      ;  if (spec->options & DO_TP)
         {  mclMatrix* subt = mclxTranspose(sub)
         ;  mclxFree(&sub)
         ;  sub = subt
      ;  }

      ;  if (spec->options & DO_CC)
         mclxMakeCharacteristic(sub)

      ;  if (bCltag)
         mclxTaggedWrite(sub, el2dom, xf, digits, RETURN_ON_FAIL)
      ;  else
         mclxWriteAscii(sub, xf, digits, RETURN_ON_FAIL)

      ;  mclxFree(&sub)
      ;  mcxTingFree(&fname)
      ;  mcxIOfree(&xf)
   ;  }
      mclxFree(&el2dom)
   ;  return 0
;  }


const char* usagelines[] =
{  "Usage: mcxsubs <options> <sub-spec>+"
,  ""
,  "Mandatory option:"
,  "-imx    <fname>  read graph in MCL matrix format"
,  ""
,  "Optional options:"
,  "-dom    <fname>  read domains, must pertain to matrix given by -imx"
,  "-icl    <fname>  alias for -dom"
,  "-stem   <str>    use str as stem for output file names (default out.sub-)"
,  "--tag            tag matrix indices with the domain they are in"
,  "-digits <int i>  output i significant decimals for matrix entries (default 3)"
,  "                    i=-1 suppresses printing of values"
,  ""
,  "You can instruct mcxsubs to extract and return `the submatrix        "
,  "corresponding with column entries A and row entries B', or,          "
,  "alternatively, `the edges going from A to B'. The sets A and B can be"
,  "specified using unions of simple indices and domains and complements"
,  "of these."
,  ""
,  "You may append a string '#tag' or '##tag' to a sub-spec. The former  "
,  "will cause the specified submatrix to be written in the file named   "
,  "<stem>-tag, where <stem> is default 'out.sub-' and changeable using  "
,  "the -stem option. Using '##tag' will simply result in a file named   "
,  "'tag'. Not using a '#' or '##' induced tag makes the sub-spec itself "
,  "the tag.                                                             "
,  ""
,  NULL             /* denotes end of array */
}  ;


mclVector*  vectorFromString
(  const char*    str
,  mclMatrix*     dom
,  mclVector*     vecV
)
   {  mcxTing*     txt     =     mcxTingNew(str)
   ;  char*       mystr    =     mcxTingStr(txt)
   ;  char*       iPtr     =     strpbrk(mystr, "iI")
   ;  char*       sPtr     =     strpbrk(mystr, "dD")
   ;  mclVector   *iVec    =     NULL
   ;  mclVector   *sVec    =     mclvInit(NULL)     /* domain vector */
   ;  mclVector   *subVec  =     NULL

   ;  char        iType    =     '\0'
   ;  char        sType    =     '\0'

   ;  if (iPtr)
      {  iType =  *iPtr
      ;  *iPtr =  '\0'
   ;  }
      if (sPtr)
      {  sType =  *sPtr
      ;  *sPtr =  '\0'
   ;  }


   ;  if (txt->len && !iPtr && !sPtr)
      mcxErr
      (  me
      ,  "warning: no 'i', 'I', 'd', or 'D' tag in specification <%s>"
      ,  txt->str
      )

   ;  if (iPtr)
      {  mcxIL *intList
      ;  fprintf
         (  stdout
         ,  "[mcxsubs] Parsing simple index set [%c%s]\n"
         ,  (int) iType
         ,  iPtr+1
         )

      ;  intList           =  ilParseIntSet(iPtr+1, EXIT_ON_FAIL)
      ;  iVec              =  mclvFromIlist(NULL, intList, 1.0)
      ;  ilFree(&intList)
      ;  if (iType == 'I')
         iVec              =  mcldMinus(vecV, iVec, iVec)
   ;  }
      else
      {  iVec              =  mclvInit(NULL)
   ;  }

   ;  if (sPtr)
      {  int   x
      ;  mcxIL *clsList

      ;  fprintf
         (  stdout
         ,  "[mcxsubs] Parsing domain index set [%c%s]\n"
         ,  (int) sType
         ,  sPtr+1
         )
      ;  clsList           =  ilParseIntSet(sPtr+1, EXIT_ON_FAIL)

      ;  if (!dom)
         {  mcxErr(me, "{d|D}<idx-list> specification requires <-dom> input")
         ;  mcxExit(1)
      ;  }

         for (x=0;x<clsList->n;x++)
         {  long idx = *(clsList->L+x)
         ;  mclVector* vec =     idx == -1
                              ?  dom->dom_rows
                              :  idx == -2
                              ?  dom->dom_cols
                              :  mclxGetVector(dom, idx, RETURN_ON_FAIL, NULL)
         ;  if (!vec)
            {  mcxErr
               (  me
               ,  "<%ld> does not index any column (domain error)"
               ,  (long) idx
               )
            ;  mcxExit(1)
         ;  }
            sVec  =  mcldMerge(sVec, vec, sVec)
      ;  }
         ilFree(&clsList)

      ;  if (sType == 'D')
         sVec =  mcldMinus(vecV, sVec, sVec)
   ;  }

      subVec =  mcldMerge(iVec, sVec, subVec)
   ;  mclvFree(&iVec)
   ;  mclvFree(&sVec)
   ;  return(subVec)
;  }

