/*            Copyright (C) 1999, 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#include "impala/matrix.h"
#include "impala/io.h"
#include "impala/iface.h"

#include "util/io.h"
#include "util/types.h"
#include "util/err.h"
#include "util/opt.h"


const char* usagelines[] =
{  "usage: mcxconvert <fname in> <fname out>"
,  NULL
}  ;


int main
(  int                  argc
,  const char*          argv[]
)
   {  mcxIO             *xfIn
   ;  mcxIO             *xfOut
   ;  mclMatrix*        mx
   ;  const char*       me = "mcxconvert"

   ;  if (argc < 3 || !strcmp(argv[1], "-h"))
      {  mcxUsage(stdout, me, usagelines)
      ;  mcxExit(0)
   ;  }

      xfIn     =  mcxIOnew(argv[1], "r")
   ;  mx       =  mclxRead(xfIn, EXIT_ON_FAIL)

   ;  xfOut    =  mcxIOnew(argv[2], "w")
   ;  mcxIOopen(xfOut, EXIT_ON_FAIL)

   ;  if (mclxFormatFound == 'a')
      {  if (mclxRowCanonical(mx) && mclxColCanonical(mx))
         mclxWriteBinary(mx, xfOut, EXIT_ON_FAIL)
      ;  else
            mcxErr(me, "binary format for non-canonical domains not yet supported")
         ,  exit(1)
   ;  }
      else
      mclxWriteAscii(mx, xfOut, 8, EXIT_ON_FAIL)

   ;  mclxFree(&mx)
   ;  mcxIOfree(&xfIn)
   ;  mcxIOfree(&xfOut)
   ;  return 0
;  }

