/*             Copyright (C) 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#ifndef mcl_clm_h
#define mcl_clm_h

#include "impala/matrix.h"
#include "taurus/ilist.h"
#include "util/types.h"

#define  ENSTRICT_KEEP_OVERLAP   1
#define  ENSTRICT_LEAVE_MISSING  2
#define  ENSTRICT_KEEP_EMPTY     4

#define  ENSTRICT_TRULY          0
#define  ENSTRICT_REPORT_ONLY    ENSTRICT_KEEP_OVERLAP\
                              |  ENSTRICT_LEAVE_MISSING\
                              |  ENSTRICT_KEEP_EMPTY

int  mclcEnstrict
(  mclMatrix*  C1
,  int         *overlap
,  int         *missing
,  int         *empty
,  mcxbits     flags
)  ;



/* 
 *    variance of information
 *    Comparing Clusterings, Marina Meila, Department of Statistics,
 *    University of Washington.
*/
void mclcVIDistance
(  mclMatrix*  cla
,  mclMatrix*  clb
,  mclMatrix*  abmeet
,  double*     abdist
,  double*     badist
)  ;


void mclcSJDistance     /* split join distance */
(  mclMatrix*  cla
,  mclMatrix*  clb
,  mclMatrix*  abmeet
,  mclMatrix*  bameet
,  int*        abdist
,  int*        badist
)  ;


void mclcJQDistance     /* Jacquard index */
(  mclMatrix*  cla
,  mclMatrix*  clb
,  mclMatrix*  abmeet
,  double*     abdist
,  double*     badist
)  ;


mclMatrix*  mclcMeet
(  mclMatrix*  C1
,  mclMatrix*  C2
,  mcxstatus   ON_FAIL
)  ;


mclMatrix* mclcProject
(  mclMatrix*  cl
,  const mclVector*  dom
)  ;


mclMatrix*  mclcContingency
(  mclMatrix*  cl
,  mclMatrix*  dl
)  ;


mcxstatus clmPerformance
(  mclx* mx
,  mclx* cl
,  double vals[5]
)  ;


mcxstatus clmGranularity
(  mclx* cl
,  double vals[8]
)  ;


void clmGranularityPrint
(  FILE* fp
,  const char* info
,  double vals[8]
,  int do_header
)  ;


void clmPerformancePrint
(  FILE* fp
,  const char* info
,  double vals[5]
,  int do_header
)  ;

#endif

