/*           Copyright (C) 1999, 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#ifndef mcl_alg_h
#define mcl_alg_h

#include "impala/matrix.h"

#include "util/opt.h"
#include "util/hash.h"

#include "proc.h"

extern mcxOptAnchor mclAlgOptions[];


typedef struct
{  mcxIO*               xfout
;  mclProcParam*        mpp

;  int                  expandDigits

;  double               centerMatrixWeight
;  double               addDiagWeight

;  int                  pre_pruneNum
;  double               pre_inflation
;  mcxbool              foundOverlap

#  define   ALG_DO_WRITELOG      1
#  define   ALG_DO_WRITECLM      2
#  define   ALG_DO_SHOWLOG       4
#  define   ALG_DO_KEEPOLAP      8
;  long                 fait  /* french do */

;  int                  writeMode
;  int                  sortMode
;  mcxTing*             cline
;  mcxTing*             fnin
;
}  mclAlgParam          ;


mclAlgParam* mclAlgParamNew
(  mclProcParam* mpp
,  const char* prog
,  const char* fn
)  ;

void mclAlgParamFree
(  mclAlgParam** app
)  ;

enum
{  ALG_INIT_OK    =  0
,  ALG_INIT_DONE
,  ALG_INIT_FAIL
}  ;

/* returns one of the above */

mcxstatus mclAlgorithmInit
(  mcxOptList*    opts
,  mcxHash*       hashedOpts
,  const char*    fname
,  mclAlgParam*   map
)  ;

mcxstatus mclAlgorithm
(  mclMatrix*     themx
,  mclAlgParam*   map
)  ;

#endif

