/* -*- C -*- 
  mboxgrep - scan mailbox for messages matching a regular expression
  Copyright (C) 2000, 2001  Daniel Spiljar

  Mboxgrep is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Mboxgrep is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mboxgrep; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: wrap.c,v 1.5 2001/12/02 17:27:02 dspiljar Exp $ */

#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "wrap.h"
#include "mboxgrep.h"

#ifndef APPNAME
#define APPNAME "mboxgrep"
#endif

extern int merr;

int m_open(const char *pathname, int flags, mode_t mode)
{
  int blah;

  blah = open(pathname, flags, mode);
  if (blah == -1 && merr)
    {
      if (merr)
	{
	  fprintf(stderr, "%s: %s: ", APPNAME, pathname);
	  perror(NULL);
	}
/* failure to open a file for writing should be fatal */
      if (((flags & O_WRONLY) == O_WRONLY) || ((flags & O_RDWR) == O_RDWR))
	exit(2);
    }
  return blah;
}      

FILE *m_fopen(const char *path, const char *mode)
{
  FILE *blah;

  blah = fopen(path, mode);
  if (blah == NULL)
    {
      if (merr)
	{
	  fprintf(stderr, "%s: %s: ", APPNAME, path);
	  perror(NULL);
	}
      if (mode[0] == 'w')
	exit (2);
    }
  return blah;
}

FILE *m_fdopen(int fildes, const char *mode)
{
  FILE *blah;

  blah = fdopen(fildes, mode);
  if (blah == NULL)
    {
      if (merr)
	perror(APPNAME);
    }
  return blah;
}

DIR *m_opendir(const char *name)
{
  DIR *blah;

  blah = opendir(name);
  if (blah == NULL)
    {
      if (merr)
	{
	  fprintf(stderr, "%s: %s: ", APPNAME, name);
	  perror(NULL);
	}
    }
  return blah;
}

void *xmalloc(size_t size)
{
  void *foo;

  foo = malloc(size);
  if (foo == NULL)
    {
      if (merr)
	perror(APPNAME);
      exit(2);
    }
  return foo;
}

void *xrealloc(void *ptr, size_t size)
{
  void *foo;

  foo = realloc(ptr, size);
  if (foo == NULL)
    {
      if (merr)
	perror(APPNAME);
      exit(2);
    }
  return foo;
}

void *xcalloc(size_t nmemb, size_t size)
{
  void *foo;

  foo = calloc (nmemb, size);
  if (foo == NULL)
    {
      if (merr)
	perror(APPNAME);
      exit (2);
    }
  return foo;
}

int m_unlink(const char *pathname)
{
  int baz;

  baz = unlink(pathname);
  if (baz == -1)
    {
      if (merr)
	{
	  fprintf(stderr, "%s: %s: ", APPNAME, pathname);
	  perror(NULL);
	}
    }
  return baz;
}
