/* -*- C -*- 
  mboxgrep - scan mailbox for messages matching a regular expression
  Copyright (C) 2000, 2001  Daniel Spiljar

  Mboxgrep is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Mboxgrep is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mboxgrep; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: mboxgrep.h,v 1.7 2001/12/01 23:35:55 dspiljar Exp $ */

#ifndef MBOXGREP_H
#define MBOXGREP_H

#define APPNAME "mboxgrep"
#define VERSION "0.7.4"
#define BUGREPORT_ADDR "dspiljar+mboxgrep@bofhlet.net"

#include <time.h>  /* for tm structure */

typedef enum
{
  MBOX,
  ZMBOX,
  MH,
  NNML,
  NNMH,
  MAILDIR
}
format_t;

typedef enum
{
  NONE,
  FCNTL,
  FLOCK
}
lockmethod_t;

typedef enum
  {
    DISPLAY,
    WRITE,
    COUNT,
    DELETE,
    PIPE
  }
action_t;

typedef struct
{
  char *filename; /* used with directory formats, such as maildir or MH */
  char *msgid; 
  char *from;
  char *headers;
  int hbytes;
  char *body;
  int bbytes;
  time_t date;
}
message_t;

typedef struct
{
  char **md5;
  int n;
}
checksum_t;

#endif /* MBOXGREP_H */
