/* -*- C -*- 
  mboxgrep - scan mailbox for messages matching a regular expression
  Copyright (C) 2000, 2001  Daniel Spiljar

  Mboxgrep is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Mboxgrep is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mboxgrep; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: maildir.h,v 1.2 2001/10/28 17:12:54 dspiljar Exp $ */

#ifndef MAILDIR_H
#define MAILDIR_H

#include <dirent.h>      /* for DIR structure */
#include "mboxgrep.h"

typedef struct
{
  DIR *new;
  DIR *cur;
} maildir_t;

maildir_t *maildir_open(const char *path);
int maildir_check(const char *path);
void maildir_create(const char *path);
void maildir_close(maildir_t *mdp);
message_t *maildir_read_message(maildir_t *mdp);
void maildir_write_message(message_t *m, const char *path);

#endif /* MAILDIR_H */
