/*
 * All global variables for Mathomatic are defined here
 * and duplicated in "externs.h".
 */

#include "includes.h"

int		n_tokens = DEFAULT_N_TOKENS;
int		n_equations;
int		cur_equation;

int		n_lhs[N_EQUATIONS];
int		n_rhs[N_EQUATIONS];

token_type	*lhs[N_EQUATIONS];
token_type	*rhs[N_EQUATIONS];

int		n_tlhs;
int		n_trhs;

token_type	*tlhs;
token_type	*trhs;

token_type	*scratch;

char		*var_names[MAX_VAR_NAMES];	/* storage for long variable names */

int		case_sensitive_flag;	/* "set case_sensitive" flag */
int		groupall = true;	/* "set display2d" flag */
int		in_calc_cmd;		/* true if in calculate command (force approximations) */
int		preserve_roots = true;	/* true if we are to preserve 2^.5, etc. */
int		true_modulus;		/* true for mathematically correct modulus */
int		screen_columns = 80;
int		screen_rows = 24;
int		finance_option;		/* for displaying dollars and cents */
#if	!SILENT
int		debug_level;		/* current debug level */
#endif
int		domain_check;
int		color_flag = true;	/* true for color mode */
int		html_flag;		/* true for HTML mode */
int		partial_flag;		/* true for partial unfactoring of algebraic fractions */
int		symb_flag;		/* true for "simplify symbolic" */
int		high_prec;		/* true while saving equations */
int		input_column;
int		sign_flag;		/* true when all "sign" variables are to compare equal */
int		piping_in_flag;		/* true if input is not a terminal */
double		small_epsilon	= 0.000000000000005;	/* for small accumulated round-off errors */
double		epsilon		= 0.00000000000005;	/* for larger accumulated round-off errors */
char		var_str[MAX_VAR_LEN+80];	/* temp storage for variable names */
char		prompt_str[MAX_VAR_LEN+80];	/* temp storage for prompt strings */
#if	CYGWIN
char		*dir_path;		/* directory path to the executable */
#endif

/* The following are for integer factoring (filled by factor_one()). */
double		unique[64];		/* storage for the unique factors */
int		ucnt[64];		/* number of times the factor occurs */
int		uno;			/* number of unique factors stored in unique[] */

sign_array_type	sign_array;		/* for keeping track of unique "sign" variables */
FILE		*gfp;			/* global output file pointer */
jmp_buf		jmp_save;		/* for setjmp() */
int		test_mode;		/* test mode flag (-t) */
