/* win9x-srvc.c, part of MaraDNS
 * compiled by Jonathan E. Brickman
 * this is a modified tiny extraction from:
 *
 * cygwin_util.c, part of ssh
 * Copyright (c) 2000, 2001, Corinna Vinschen <vinschen@cygnus.com>
 *
 * and daemon.c, also part of ssh
 * Copyright (c) 1990, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * [cygwin_util.c originally] Created: Sat Sep 02 12:17:00 2000 cv
 * [daemon.c is] OpenBSD: daemon.c,v 1.2 1996/08/19 08:22:13
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include <sys/vfs.h>
#include <windows.h>

#ifndef _PATH_DEVNULL
# define _PATH_DEVNULL "/dev/null"
#endif

#ifndef STDIN_FILENO
# define STDIN_FILENO    0
#endif

#ifndef STDOUT_FILENO
# define STDOUT_FILENO   1
#endif

#ifndef STDERR_FILENO
# define STDERR_FILENO   2
#endif

#define is_winnt       (GetVersion() < 0x80000000)

void start_win9x_service(void)
        {
        if (daemon(0, 0) < 0)
                        {
                        printf("daemon() failed: %.200s", strerror(errno));
                        exit(1);
                        }
        }

void register_9x_service(void)
{
        HINSTANCE kerneldll;
        DWORD (*RegisterServiceProcess)(DWORD, DWORD);

        /* The service register mechanism in 9x/Me is pretty different from
         * NT/2K/XP.  9x/Me doesn't really do services per se, but simply
    * has invisible processes.  This function is only called
         * by a fork()'d child 'maradns' when it's going to daemonize.
         */
        if (is_winnt)
                return;
        if (! (kerneldll = LoadLibrary("KERNEL32.DLL")))
                return;
        if (! (RegisterServiceProcess = (DWORD (*)(DWORD, DWORD))
                          GetProcAddress(kerneldll, "RegisterServiceProcess")))
                return;
        RegisterServiceProcess(0, 1);
}

int
daemon(nochdir, noclose)
        int nochdir, noclose;
{
        int fd;

        switch (fork()) {
        case -1:
                return (-1);
        case 0:
                register_9x_service();
                break;
        default:
                /*
                 * This sleep avoids a race condition which kills the
                 * child process if parent is started by a NT/W2K service.
                 */
                sleep(1);
                _exit(0);
        }

        if (setsid() == -1)
                return (-1);

        if (!nochdir)
                (void)chdir("/");

        if (!noclose && (fd = open(_PATH_DEVNULL, O_RDWR, 0)) != -1) {
                (void)dup2(fd, STDIN_FILENO);
                (void)dup2(fd, STDOUT_FILENO);
                (void)dup2(fd, STDERR_FILENO);
                if (fd > 2)
                        (void)close (fd);
        }
        return (0);
}



