/* $Id: mystrings.c,v 1.9 2003/04/26 07:04:33 jtalkington Exp $ */

#include "common.h"

/* str_app_s
 * appends one string to another, returning a new string and
 * freeing the original
 */
char *
str_app_s(char *line, char *append) {
	char *output = NULL;
	int size = 0;

	if(line == NULL) {
		if(append == NULL) {
			return(NULL);
		} else {
			output = strdup(append);
			return(output);
		}
	} else if(append == NULL) {
		return(line);
	}
	
	size = strlen(line) + strlen(append) + 1;

	output = calloc(1, size);
	strcpy(output, line);
	strcat(output, append);

	free(line);

	return(output);
}

/* str_app_c()
 * takes a string and appends one character to the end of it
 * free()ing the originial string,
 * return()ing the new string
 */
char *
str_app_c(char *line, const char append) {
	char *r_output = NULL;
	int size = 0;

	if(line == NULL) {
		r_output = calloc(1, 2);
		memset(r_output, append, 1);
		return(r_output);
	}

	size = (strlen(line) + 2);

	r_output = calloc(1, size);
	/* memset(r_output, '\0', size);*/
	strcpy(r_output, line);
	
	memset(r_output + strlen(r_output), append, 1);

	free(line);

	return(r_output);
}

/* skip_white 
 * takes a char pointer and shifts through to the end of the line or string
 * returning the next non space or tab character before a the end of string
 * ('\0') or line ('\n' or '\r').
 * returns NULL if there isn't one.
 */
char *
skip_white(char *line) {
	
	if(line != NULL) {
		while(*line == ' ' || *line == '\t') {
			line++;
		}
	} else {
		return(NULL);
	}

	if(*line == '\0' || *line == '\n' || *line == '\r') {
		return(NULL);
	}

	return(line);
}
