/* $Id: main.c,v 1.10 2003/04/12 05:59:04 jtalkington Exp $ */

#include "common.h"

int
main(int argc, char *argv[]) {
	char *program = NULL;
	char *section = NULL;
	int line_no = 0;

	line_no = init_config();
	init_query_tree(argc, argv);

	if(line_no != 0) {
		if(Config.mode == CGI_MODE) {
			output_header("Invalid Configuration", NULL);
			printf("<h2>Invalid Configuration: line %i</h2>\n", line_no);
			printf("</body></html>");
			return(1);
		} else {
			fprintf(stderr, "Invalid Configuration: line %i\n", line_no);
			return(1);
		}
	}

	section = get_query_value(SECTION);
	program = get_query_value(PROGRAM);

	if(program != NULL) {
		if(strcmp(program, SECTION_INDEX) == 0) {
			if(section != NULL) {
				 output_section_index(section); 
			} else {
				if(Config.mode == CGI_MODE) {
					output_cover_page();
				} else {
					usage(1);
					/* not reached */
				}
			}
		} else if(section !=NULL && strcmp(section, APROPOS) == 0) {
			output_apropos(program);

		} else {
			output_man_page(program, section);
		}
	} else {
		if(Config.mode == CGI_MODE) {
			output_cover_page();
		} else {
			usage(1);
			/* not reached */
		}
	}
/* who cares about cleanup when we are exiting... */
#ifdef M2W_CLEANUP
	cleanup_query_tree();
	cleanup_config();
#endif /* M2W_CLEANUP */

	return(0);
}
