/* $Id: cover_page.c,v 1.14 2003/04/26 23:35:20 jtalkington Exp $ */

#include "common.h"
#include "cover_page.h"
#include "sections.h"

/* output_cover_page()
 * outputs the cover page which consists of the the section entries with
 * descs and a search form at the bottom.
 */
void
output_cover_page() {
	char hostname[256];
	char *script_name = get_query_value(SCRIPT_NAME);
	
	if(gethostname(hostname, sizeof(hostname)) != 0) {
		strcpy(hostname, "UNABLE TO LOOKUP HOSTNAME");
	}

	output_header(PACKAGE_NAME, NULL);

	printf("<h1>Man Page Lookup</h1>\n<hr />\nThese are the manual pages for <b>%s</b> converted to html on the fly by the <a href=\"%s\">%s</a> program.\n",
			hostname, PROJECT_HOMEPAGE, PACKAGE_NAME);

	printf("<table>\n<tr>\n\t<th align=\"left\">Intro&nbsp;&nbsp;&nbsp;</th>\n\t<th align=\"left\">Index\n</th></tr>\n");

	output_section_cover(&Config.sections, script_name);

	printf("</table>\n");

	output_footer();
}

/* output_search_form()
 * prints out the search for that is at the bottom of some pages and also at
 * the bottom of some pages
 */
void
output_search_form() {
	char *script_name = get_query_value(SCRIPT_NAME);

	if(script_name == NULL) {
		return;
	}

	printf("<hr />\n<form method=\"get\" action=\"");

	printf("%s\">\n", script_name);

	printf("<table>\n<tr>\n\t<th>Command</th>\n\t<th>Section</th>\n</tr>\n<tr>\n<td><input name=\"program\" size=\"24\" /></td>\n<td><select name=\"section\">\n");

#ifndef DISABLE_APROPOS
	if((Config.disabled & D_APROPOS) == 0) {
		printf("\t<option value=\"apropos\">Keyword Search</option>\n");
	}
#endif
	printf("\t<option selected=\"selected\" value=\"\">Any Section</option>\n");

	output_section_search(&Config.sections);

	printf("</select></td>\n<td><input type=\"submit\" value=\"Fetch Man Page\" /></td></tr>\n</table>\n</form>\n<hr />\n");

	fflush(stdout);
}
/* parse_section_line()
 * parses the part of a line that comes after the SECTION keyword
 * returns 0 on success, 1 if the line is invalid
 */

int
parse_section_line(char *line) {
	char *pseudo_section = NULL;
	char *real_section = NULL;
	char *desc = NULL;
	char *tmp = NULL;
	int return_val = 0;

	if(line == NULL) {
		return(1);
	}

	tmp = skip_white(line);

	if(line != NULL) {
		/* the first part is the pseudo_section */
		while(*tmp != ' ' && *tmp != '\t' && *tmp != '\0') {
			pseudo_section = str_app_c(pseudo_section, *tmp);
			tmp++;
		}
		
		tmp = skip_white(tmp);

		if(tmp != NULL) {
			while(*tmp != ' ' && *tmp != '\t' && *tmp != '\0') {
				real_section = str_app_c(real_section, *tmp);
				tmp++;
			}

			tmp = skip_white(tmp);

			if(tmp != NULL) {
				while(*tmp == '\"' || *tmp == '\'') {
					tmp++;
				}

				while(*tmp != '\0') {
					desc = str_app_c(desc, *tmp);
					tmp++;
				}

				if(desc != NULL) {
					add_section(&Config.sections, pseudo_section, real_section, desc);
				} else {
					return_val = 1;
				}

			} else {
				return_val = 1;
			}
		
		} else {
			return_val = 1;
		}
		
	} else {
		return_val = 1;
	}

	if(pseudo_section != NULL) {
		free(pseudo_section);
	}

	if(real_section != NULL) {
		free(real_section);
	}

	if(desc != NULL) {
		free(desc);
	}
	
	return(return_val);
}

void
add_section(struct section_entry **node, char *pseudo_section, char *real_section, char *desc) {
	int result = 0;

	if(pseudo_section == NULL || real_section == NULL || desc == NULL) {
		return;
	}
	
	if((*node) == NULL) {
		(*node) = calloc(1, sizeof(struct section_entry));
		(*node)->pseudo_section = strdup(pseudo_section);
		(*node)->real_section = strdup(real_section);
		(*node)->desc = strdup(desc);

	} else {
		result = strcmp((*node)->pseudo_section, pseudo_section);

		if(result == 0) {
			/* replace the entries */
			free((*node)->real_section);
			free((*node)->desc);

			(*node)->desc = strdup(desc);
			(*node)->real_section = strdup(real_section);

		} else if(result < 0) {
			add_section(&(*node)->right, pseudo_section, real_section, desc);
		} else {
			add_section(&(*node)->left, pseudo_section, real_section, desc);
		}
	}
}

void
output_section_cover(struct section_entry **node, char *script_name) {

	if((*node) == NULL) {
		return;
	}

	if((*node)->left != NULL) {
		output_section_cover(&(*node)->left, script_name);
	}

	if(script_name != NULL) {
		printf("<tr><td align=\"left\"><a href=\"%s?program=intro&amp;section=%s\">%s</a></td>",
				script_name, (*node)->pseudo_section, (*node)->pseudo_section);
	} else {
		printf("<tr><td align=\"left\">%s</td>", (*node)->pseudo_section);
	}

#ifndef DISABLE_SECTION_INDEXES
	if(Config.manpath != NULL && (Config.disabled & D_INDEXES) == 0) {
		printf("<td align=\"left\"><a href=\"%s?program=%s&amp;section=%s\">%s</a></td></tr>\n",
				script_name, SECTION_INDEX, (*node)->pseudo_section, (*node)->desc);
	} else {
#endif /* DISABLE_SECTION_INDEXES */
		printf("<td align=\"left\">%s</td></tr>\n", (*node)->desc);
#ifndef DISABLE_SECTION_INDEXES
	}
#endif

	if((*node)->right != NULL) {
		output_section_cover(&(*node)->right, script_name);
	}
}

void
output_section_search(struct section_entry **node) {
	struct section_entry *right = NULL;

	if((*node) == NULL) {
		return;
	} else {
		right = (*node)->right;
	}

	if((*node)->left != NULL) {
		output_section_search(&(*node)->left);
	}

	printf("\t<option value=\"%s\">%s (%s)</option>\n", (*node)->pseudo_section,
			(*node)->desc, (*node)->pseudo_section);
	
	if(right != NULL) {
		output_section_search(&right);
	}
}

void
output_section_config() {
	output_section_conf(&Config.sections);
}

void
output_section_conf(struct section_entry **node) {
	struct section_entry *right;

	if((*node) == NULL) {
		return;
	} else {
		right = (*node)->right;
	}

	if((*node)->left != NULL) {
		output_section_conf(&(*node)->left);
	}

	printf("SECTION\t%s\t%s\t%s\n", (*node)->pseudo_section, 
			(*node)->real_section, (*node)->desc);

	if(right != NULL) {
		output_section_conf(&right);
	}
}

void
init_default_sections() {
	struct section_entry *cur = NULL;
	int i = 0;

	for(i = 0; i < SECTION_COUNT; i++) {
		cur = &section_matrix[i];

		add_section(&Config.sections, cur->pseudo_section, cur->real_section, cur->desc);
	}
}

/* get_real_section 
 * finds the real section that a psuedo section belongs in
 * returns the real_section if found, NULL if not
 */
char *
get_real_section(char *pseudo) {
	return(find_section(&Config.sections, pseudo));
}

/* the real worker for get_real_section */
char *
find_section(struct section_entry **node, char *pseudo) {
	int result = 0;

	if((*node) == NULL || pseudo == NULL) {
		return(NULL);
	}

	result = strcmp((*node)->pseudo_section, pseudo);

	if(result == 0) {
		return((*node)->real_section);
	} else if(result < 0) {
		return(find_section(&(*node)->right, pseudo));
	} else {
		return(find_section(&(*node)->left, pseudo));
	}
}


#ifdef M2W_CLEANUP
void
cleanup_sections() {
	cleanup_section_node(&Config.sections);
}

void
cleanup_section_node(struct section_entry **node) {
	struct section_entry *right = NULL;

	if((*node) == NULL) {
		return;
	} else {
		right = (*node)->right;
	}

	if((*node)->left != NULL) {
		cleanup_section_node(&(*node)->left);
		(*node)->left = NULL;
	}

	free((*node)->pseudo_section);

	free((*node)->real_section);

	free((*node)->desc);

	free((*node));
	(*node) = NULL;

	if(right != NULL) {
		cleanup_section_node(&right);
	}

}

#endif /* M2W_CLEANUP */

