/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGSYNCCEDEVICEDLLTEST_H__
#define __AGSYNCCEDEVICEDLLTEST_H__

#include <windows.h>
//#include <cesync.h>
#include <AGTypes.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define UID_ID      MAKELONG(CEVT_UI4, 0x0001)
#define STATUS_ID   MAKELONG(CEVT_UI4, 0x0002)
#define BYTES_ID    MAKELONG(CEVT_BLOB, 0x0003)

struct AGReader;
struct AGDBConfig;
struct AGRecord;

#ifndef ExportFunc
#define ExportFunc __declspec( dllexport )
#endif

ExportFunc void * CALLBACK Initialize(AGServerConfig * serverConfig);
ExportFunc void CALLBACK Terminate(void * out);
ExportFunc int32 CALLBACK PerformCommand(void * out, AGCommand command,
                                         uint32 length, void * bytes,
                                         int32 *errCode);
ExportFunc int32 CALLBACK OpenDatabase(void *out,
                                       AGDBConfig *db,
                                       int32 *errCode);
ExportFunc int32 CALLBACK GetNextRecord(void *out,
                                        AGRecord **record,
                                        int32 *errCode);
ExportFunc int32 CALLBACK GetNextModifiedRecord(void *out,
                                                AGRecord **record,
                                                int32 *errCode);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // #ifndef __AGSYNCCEDEVICEDLLTEST_H__