#include <windows.h>
#include <stdio.h>
#include <direct.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <agshlapi.h>   // change to <shlwapi.h> if you're guaranteed to be
                        // running on at least semi-modern Windows machines

//#define printstuff

#define MAXPATHLEN 2000
#define MAX_INSTALLS 1024

typedef struct _UserInfo {
    const char *name;
    const char *dir;
    int id;
} UserInfo;

#define USER_DATA "users.dat"
int nUsers = 0, nAlloced = 4;
UserInfo *users;

char ** installs = NULL;
int nInstalls = 0;
char *sourceDir = NULL;

static BOOL isASCII(char b) {
	int ib = (int)b & 0xff;
    return ib >= 32;
}

static const char *findString(const char *data, const char *maxData) {
    int length = *(data++), i;
    char *name;

    if (length <= 0) {
        return NULL;
    }

    for (i = 0; i < length; i++) {
        if (!isASCII(data[i])) {
            return NULL;
        }
    }

    name = (char *)malloc(length + 1);
    memcpy(name, data, length);
    name[length] = '\0';
    return name;
}

static int findID(const char *data) {
    unsigned char *udata = (unsigned char *)data;
    /*
    return ((udata[0] << 24) |
            (udata[1] << 16) |
            (udata[2] << 8) |
            udata[3]);
            */

    return ((udata[3] << 24) |
            (udata[2] << 16) |
            (udata[1] << 8) |
            udata[0]);
}

static int GetRegString(const char *key, const char *subkey, char *value, long *length) {
    HKEY hKey;
    int ret;

    ret = RegOpenKeyEx(HKEY_CURRENT_USER, key, 0, KEY_READ, &hKey);
    if (ret == ERROR_SUCCESS) {
        ret = RegQueryValueEx(hKey, subkey, 0, NULL, (unsigned char *)value, (unsigned long *)length);

        RegCloseKey(hKey);
    }
    return ret;
}

static int PutRegInt(const char *key, const char *subkey, int value) {
    HKEY hKey;
    int ret;

    ret = RegOpenKeyEx(HKEY_CURRENT_USER, key, 0, KEY_WRITE, &hKey);
    if (ret == ERROR_SUCCESS) {
        int v = value;

        ret = RegSetValueEx(hKey, subkey, 0, REG_DWORD, (unsigned char *)&v, sizeof(v));

        RegCloseKey(hKey);
    }
    return ret;
}

static void getUserDir(char *userDir, const char *subdir) {
    // Get Destination directory using registry to get pilot dir and appending subdir
    long length = MAXPATHLEN;

    if (GetRegString("Software\\U.S. Robotics\\Pilot Desktop\\Core", "Path", userDir, &length)
        != ERROR_SUCCESS) {
        length = MAXPATHLEN;
        if (GetRegString("Software\\Palm Computing\\Pilot Desktop\\Core", "Path", userDir, &length) 
            != ERROR_SUCCESS) {
            printf("Problem finding pilot directory\n");
            _exit(1);
        }
    }
    if (length != 0) {
        strcat(userDir, "\\");
        strcat(userDir, subdir);
    }
}

static void getDstDir(char *dstDir, const char *subdir) {
    // Get Destination directory using registry to get pilot dir and appending subdir and "//Install" on it
    getUserDir(dstDir, subdir);
    strcat(dstDir, "\\Install");
}

static void getUsersFile(char *dstDir) {
    // Get Destination directory using registry to get pilot dir and appending subdir and "//Install" on it
    getUserDir(dstDir, "");
    strcat(dstDir, "users.dat");
}

static void getRegPath(char *regPath) {
    // Get registry path by concatinating the pilot registry and "\\HotSync Manager
    long length = MAXPATHLEN;

    if (GetRegString("Software\\U.S. Robotics\\Pilot Desktop\\Core", "Path", regPath, &length)
        == ERROR_SUCCESS) {
        strcpy(regPath, "Software\\U.S. Robotics\\Pilot Desktop\\HotSync Manager");
    } else {
        length = MAXPATHLEN;
        if (GetRegString("Software\\U.S. Robotics\\Pilot Desktop\\Core", "Path", regPath, &length)
            == ERROR_SUCCESS) {
            strcpy(regPath, "Software\\U.S. Robotics\\Pilot Desktop\\HotSync Manager");
        } else {
            printf("Can't find PalmOS registry path\n");
            _exit(1);
        }
    }
}

static void getRegKey(char *regKey, int id) {
    sprintf(regKey, "Install%u", id);
}

static void getUserInfo() {
    HANDLE hFile;
    HANDLE hMapping;
    char usersFile[MAXPATHLEN + 1];
    const char *userData;
    const char *current;
    const char *maxData;
    int fileSize;
    const char *name, *dir;

    users = (UserInfo *)malloc(nAlloced * sizeof(*users));
    getUsersFile(usersFile);
    hFile = CreateFile(usersFile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (hFile == INVALID_HANDLE_VALUE) {
        printf("Couldn't find users.dat\n");
        _exit(1);
    }
    fileSize = GetFileSize(hFile, NULL);
    hMapping = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, 0, NULL);
    userData = (const char *)MapViewOfFile(hMapping, FILE_MAP_READ, 0, 0, 0);
    maxData = userData + fileSize;

    for (current = userData; current < maxData; current++) {
        if ((name = findString(current, maxData)) &&
            (dir = findString(current + strlen(name) + 1, maxData))) {
            int id = findID(current - 4);
            UserInfo *user;

            if (nUsers == nAlloced) {
                nAlloced *= 2;
                users = (UserInfo *)realloc(users, nAlloced * sizeof(*users));
            }
            user = users + (nUsers++);
            user->name = name;
            user->dir = dir;
            user->id = id;
            current += strlen(name) + strlen(dir) + 1;
        }
    }
    CloseHandle(hMapping);
    CloseHandle(hFile);
}

static void copyFile(const char *srcDir, const char *dstDir, const char *file) {
    char srcFile[MAXPATHLEN+1], dstFile[MAXPATHLEN+1];

    sprintf(srcFile, "%s\\%s", srcDir, file);
    sprintf(dstFile, "%s\\%s", dstDir, file);
    CopyFile(srcFile, dstFile, FALSE);
}

static void installForUser(UserInfo *userInfo) {
    char dstDir[MAXPATHLEN+1], regPath[MAXPATHLEN+1], userDir[MAXPATHLEN+1], regKey[100];
    int one = 1, i;
    struct _stat statBuf;

    getDstDir(dstDir, userInfo->dir);
    getUserDir(userDir, userInfo->dir);
    getRegPath(regPath);
    getRegKey(regKey, userInfo->id);

    if ((_stat(userDir, &statBuf) != 0)
        || !(statBuf.st_mode & _S_IFDIR)) {
        printf("Could not install prcs for user: %s - invalid dir: %s\n", userInfo->name, userDir);
        _exit(1);
    }

    if ((_stat(dstDir, &statBuf) != 0)
        || !(statBuf.st_mode & _S_IFDIR)) {
        mkdir(dstDir);
    }

    // Set the install bit in the reg so that HSM puts these on the device.
    PutRegInt(regPath, regKey, one);

    for (i = 0; i < nInstalls; i++) {
        copyFile(sourceDir, dstDir, installs[i]);
    }
}

void lookForFileType(char * prototype)
{
    HANDLE f;
    WIN32_FIND_DATA findData;
    BOOL done = FALSE;

    f = FindFirstFile(prototype, &findData);
    do {

        if (INVALID_HANDLE_VALUE != f) {

            installs[nInstalls++] = strdup(findData.cFileName);

            if (0 == FindNextFile(f, &findData))
                done = TRUE;

        }
        else
            done = TRUE;

    } while (!done);
}

static void outputPUFile(int nUsers)
{
    char temppath[MAX_PATH];
    HANDLE hFile;
    char num[16];

    GetTempPath(MAX_PATH, temppath);
    PathAppend(temppath, "pu");

    hFile = CreateFile(temppath,
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL);

    if (INVALID_HANDLE_VALUE != hFile) {

        DWORD cbWritten;

        sprintf(num, "%d\r\n", nUsers);

        WriteFile(hFile, num, strlen(num) + 1, &cbWritten, NULL);

        CloseHandle(hFile);

    }

}

BOOL buildInstallsList(char * dirname)
{
    installs = malloc(sizeof(char*) * MAX_INSTALLS);
    if (NULL == installs) {
        printf("Error: couldn't allocate install pointer block.\n");
        return TRUE;
    }

    if (NULL != dirname) {
        SetCurrentDirectory(dirname);
#ifdef printstuff
        printf("Searching for installable items in directory %s...", dirname);
#endif
    }
    sourceDir = (char*)malloc(MAX_PATH);
    GetCurrentDirectory(MAX_PATH, sourceDir);

    lookForFileType("*.prc");
    lookForFileType("*.pdb");

    return FALSE;
}

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{ 
    int i;
    BOOL skipInstall = FALSE;

    if (strlen(lpCmdLine) == 0) {
        if (buildInstallsList(NULL))
            return -1;
    } else {
        char * delim = "\"";
        char * token;
        token = strtok(lpCmdLine, delim);

        if ('*' != token[0]) {

            if (buildInstallsList(token))
                return -1;

        }
        else
            skipInstall = TRUE;

    }

    getUserInfo();

    if (!skipInstall) {

        for (i = 0; i < nUsers; i++) {
            UserInfo *user = users + i;

            installForUser(user);
        }

    }

    outputPUFile(nUsers);

    return 0;
}
