/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <windows.h>
#include <Notify.h>

const LPTSTR cleanupAppName = TEXT("\\Windows\\MALCleanup.exe");
const LPTSTR deleteExt = TEXT(".delete");
const LPTSTR windowsPath = TEXT("\\windows\\");
const LPTSTR wildcardCharacter = TEXT("*");

/*  Search Windows directory for files matching *.delete, and delete them.
*/
static BOOL deleteAllDeadFiles(void)
{
    BOOL deleteFailed = FALSE;
    WIN32_FIND_DATA findData;
    TCHAR buf[MAX_PATH];
    HANDLE findHandle;

    /* Build template for matching files. */
    wcscpy(buf, windowsPath);
    wcscat(buf, wildcardCharacter);
    wcscat(buf, deleteExt);

    /* Start search for files. */
    findHandle = FindFirstFile(buf, &findData);

    /* Loop while we've found stuff. */
    while (INVALID_HANDLE_VALUE != findHandle) {

        /* Build full pathname of file to delete. */
        TCHAR deletebuf[MAX_PATH];
        wcscpy(deletebuf, windowsPath);
        wcscat(deletebuf, findData.cFileName);

        /* Delete.  If we got an error, remember that so that
        we can schedule the cleanup app to try again. */
        if (0 == DeleteFile(deletebuf))
            deleteFailed = TRUE;

        /* Get next file.  Signal done if done. */
        if (0 == FindNextFile(findHandle, &findData)) {
            
            if (ERROR_NO_MORE_FILES == GetLastError())
                findHandle = INVALID_HANDLE_VALUE;

        }

    }

    return deleteFailed;
}

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPTSTR lpCmdLine,
                   int nCmdShow)
{
    /* Call dead file remover. */
    deleteAllDeadFiles();

    /* We're done.  Unregister ourselves so we're not called again. */
    CeRunAppAtEvent(cleanupAppName, NOTIFICATION_EVENT_NONE);

    return 0;
}