// MainDialog.cpp
// Copyright 1998, 1999 AvantGo, Inc.  All rights reserved.
// Owner:  jason

#include <MainDialog.h>
#include <AGTypes.h>
#include <AGUtil.h>
//#include <AGConfigServerSettingsDialog.h>
//#include <AGConfigServerWizard.h>
#include <AGUserConfig.h>
#include <AGServerConfig.h>
#include <AGLocationConfig.h>
//#include <AGConfigProxyWizard.h>
#include <MobileLinkResource.h>
//#include <AGConfigDialogBase.h>
#include <windowsx.h>
#include <winuser.h>
#include <commctrl.h>
#include <stdio.h>
#include <AGSyncCommon.h>
//#include <crtdbg.h>

#define HACK

#ifdef HACK
const char * ONE_TIME_PREFS_NAME = "d:\\avantgo\\agconfig.csc";
#endif
const char * PREFS_NAME = "d:\\avantgo\\malprefs.dat";

// List icons
typedef enum {
    UNCHECKED = 1,
    CHECKED = 2,
    SUBITEM = 3
} listIconTypes;

typedef struct mdWindowInfo {

    HWND hwnd;
    HINSTANCE hInst;
    AGLocationConfig * locationInfo;
    AGUserConfig * userConfig;

} mdWindowInfo;

/* ----------------------------------------------------------------------------
    static int32 writeDiskFunc(void * info, void * data, int32 len)

    Wrapper for AGWriter write function. Writes to file on disk.

*/
static int32 writeDiskFunc(void * info, void * data, int32 len)
{
//    return fwrite(data, 1, len, (FILE *)info);
    return 0;
}

/* ----------------------------------------------------------------------------
    static int32 readDiskFunc(void * info, void * data, int32 len)

    Wrapper for AGReader read function. Reads from file on disk.

*/
static int32 readDiskFunc(void * info, void * data, int32 len)
{
//    return fread(data, 1, len, (FILE *)info);
    return 0;
}

/* ----------------------------------------------------------------------------
    static int32 loadServerSettingsFromDisk(mdWindowInfo * info)

*/
static int32 loadServerSettingsFromDisk(mdWindowInfo * info)
{
//    FILE * f;
//    f = fopen(PREFS_NAME, "rb");
//    if (NULL != f) {
//        AGReader * reader = AGReaderNew(f, readDiskFunc);
//        AGUserConfigReadData(info->userConfig, reader);
//        AGReaderFree(reader);
//        fclose(f);
        return 0;
//    }
//    else {
//        return 1;
//    }
}

/* ----------------------------------------------------------------------------
    static int32 saveServerSettingsToDisk(mdWindowInfo * info)

*/
static int32 saveServerSettingsToDisk(mdWindowInfo * info)
{
//    FILE * f;
//    f = fopen(PREFS_NAME, "wb");
//    if (NULL != f) {
//        AGWriter * writer = AGWriterNew(f, writeDiskFunc);
//        AGUserConfigWriteData(info->userConfig, writer);
//        AGWriterFree(writer);
//        fclose(f);
//        info->userConfig->dirty = FALSE;
        return 0;
//    }
//    return 1;
}

// ----------------------------------------------------------------------------
static void fillInTreeStruct(TV_INSERTSTRUCT &ts, HTREEITEM hParent,
                             HTREEITEM hInsertAfter, UINT mask, HTREEITEM hItem,
                             UINT state, UINT stateMask, LPTSTR pszText,
                             int cchTextMax, int iImage, int iSelectedImage,
                             int cChildren, LPARAM lParam)
{
    ts.hParent              = hParent;
    ts.hInsertAfter         = hInsertAfter;
    ts.item.mask            = mask;
    ts.item.hItem           = hItem;
    ts.item.state           = state;
    ts.item.stateMask       = stateMask;
    ts.item.pszText         = pszText;
    ts.item.cchTextMax      = cchTextMax;
    ts.item.iImage          = iImage;
    ts.item.iSelectedImage  = iSelectedImage;
    ts.item.cChildren       = cChildren;
    ts.item.lParam          = lParam;
}

// ----------------------------------------------------------------------------
static BOOL setupTreeView(HWND hwnd, AGUserConfig * userConfig)
{
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    if (NULL != userConfig) {

        HWND tree = GetDlgItem(hwnd, IDC_SERVER_TREE);
//        _ASSERT(IsWindow(tree));

/*        // Set up the list of images that we'll use to appear next to each
        // server in the list.
        HIMAGELIST treeImageList = ImageList_LoadImage(hInst,
            MAKEINTRESOURCE(IDB_SERVER_LIST), 16, 1, RGB(255,0,0),
            IMAGE_BITMAP, 0);
        _ASSERT(treeImageList != NULL);

        TreeView_SetImageList(tree, treeImageList, TVSIL_STATE);
*/
        // Clear out the tree (redundant).
        TreeView_DeleteAllItems(tree);

        int nServers = AGUserConfigCount(userConfig);

        // Insert each item.
        for (int i = 0; i < nServers; i++) {

            HTREEITEM hTreeItem = NULL;

            __try {

                TV_INSERTSTRUCT treeStr;
                AGServerConfig * sc =
                    AGUserConfigGetServerByIndex(userConfig, i);

                if (NULL == sc)
                    __leave;

                fillInTreeStruct( treeStr, TVI_ROOT, TVI_SORT,
                    TVIF_CHILDREN | TVIF_HANDLE | TVIF_IMAGE | TVIF_PARAM |
                        TVIF_SELECTEDIMAGE |TVIF_STATE | TVIF_TEXT,
                    TreeView_GetRoot(tree),
                    INDEXTOSTATEIMAGEMASK(sc->disabled ? UNCHECKED : CHECKED),
                    TVIS_STATEIMAGEMASK,
#ifdef _WIN32_WCE
                    ConvertAnsiToUnicode(sc->serverName),
#else
                    sc->serverName,
#endif // _WIN32_WCE
                    strlen(sc->serverName),
                    0, 0, 1, sc->uid);

                hTreeItem = TreeView_InsertItem(tree, &treeStr);

                // Add sub-items.
                treeStr.hParent = hTreeItem;
                treeStr.hInsertAfter = TVI_LAST;
                treeStr.item.mask = TVIF_TEXT | TVIF_STATE;
                treeStr.item.state =
                    INDEXTOSTATEIMAGEMASK(SUBITEM);
                treeStr.item.lParam = -1;

                if (NULL != sc->userUrl) {
#ifdef _WIN32_WCE
                    treeStr.item.pszText = ConvertAnsiToUnicode(sc->userUrl),
#else
                    treeStr.item.pszText = sc->userUrl;
#endif // _WIN32_WCE
                    treeStr.item.cchTextMax = strlen(sc->userUrl);
                    TreeView_InsertItem(tree, &treeStr);
                }

                if (NULL != sc->description) {
#ifdef _WIN32_WCE
                    treeStr.item.pszText = ConvertAnsiToUnicode(sc->description),
#else
                    treeStr.item.pszText = sc->description;
#endif // _WIN32_WCE
                    treeStr.item.cchTextMax = strlen(sc->description);
                    TreeView_InsertItem(tree, &treeStr);
                }

                if (NULL != sc->serverUri) {
#ifdef _WIN32_WCE
                    treeStr.item.pszText = ConvertAnsiToUnicode(sc->serverUri),
#else
                    treeStr.item.pszText = sc->serverUri;
#endif // _WIN32_WCE
                    treeStr.item.cchTextMax = strlen(sc->serverUri);
                    TreeView_InsertItem(tree, &treeStr);
                }
            }
            __finally {

            }

        }

        return FALSE;

    }
    else
        return TRUE;
}

// ----------------------------------------------------------------------------
static void enableServerButtons(HWND hwnd, BOOL enable)
{
    EnableWindow(GetDlgItem(hwnd, ID_SERVER_INFO), enable);
    EnableWindow(GetDlgItem(hwnd, ID_REMOVE_SERVER), enable);
}

// ----------------------------------------------------------------------------
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    /* Although the proxy info is loaded at the start of the dialog,
    it isn't saved until the user hits ok on one of the child
    dialogs.  This is for two reasons:  one, the user may choose
    to keep this dialog open while accessing the service (meaning that
    saving at dialog close would be too late), and two, there's no
    reason to save at dialog close if nothing's changed. */
//    AGReadLocationConfigFromDisk(info->locationInfo);

#ifdef HACK
//    FILE * f = fopen(ONE_TIME_PREFS_NAME, "rb");
//    if (NULL != f) {
//        AGServerConfig * sc = AGServerConfigNew();
//        AGReader * reader = AGReaderNew(f, readDiskFunc);
//        AGServerConfigReadData(sc, reader);
//        AGReaderFree(reader);
//        AGUserConfigAddServer(info->userConfig, sc);
//        fclose(f);
//    }
#else
    if (loadServerSettingsFromDisk(info)) {
        // pending(miket):  do something nice here to welcome the user, which
        // is appropriate because we didn't find a prefs file.
    }
#endif

    setupTreeView(hwnd, info->userConfig);

    enableServerButtons(hwnd, FALSE);

//    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
//        lParam, AGConfigDialogBaseProc);
    return FALSE;
}

// ----------------------------------------------------------------------------
static int32 getUIDofCurrentSelection(HWND hwnd)
{
    HWND tree;
    HTREEITEM hTreeItem;
    TV_ITEM item;

    tree = GetDlgItem(hwnd, IDC_SERVER_TREE);
//    _ASSERT(IsWindow(tree));

    // Get the server name of the current selection.
    hTreeItem = TreeView_GetSelection(tree);
    if (NULL == hTreeItem)
        return -1;

    // Get item information, and if child is selected, move up to parent.
    do {
        memset(&item, 0, sizeof(item));
        item.hItem      = hTreeItem;
        item.mask       = TVIF_PARAM;
        TreeView_GetItem(tree, &item);
    } while ((LPARAM)-1 == item.lParam);

    return (int32)item.lParam;
}

// ----------------------------------------------------------------------------
static void onRemoveServer(HWND hwnd)
{
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);
    int result;
    HTREEITEM hTreeItem;
    HWND tree;
    TV_ITEM item;
    char itemText[MAX_PATH];
    char message[MAX_PATH];
    char buf[MAX_PATH];
//    char title[MAX_PATH];
//    int c;

    tree = GetDlgItem(hwnd, IDC_SERVER_TREE);
//    _ASSERT(IsWindow(tree));

    // Get the server name of the current selection.
    hTreeItem = TreeView_GetSelection(tree);
    if (NULL == hTreeItem)
        return;

    // Get item information, and if child is selected, move up to parent.
    do {
        memset(&item, 0, sizeof(item));
        item.hItem      = hTreeItem;
        item.mask       = TVIF_TEXT | TVIF_PARAM;
#ifdef _WIN32_WCE
        item.pszText    = ConvertAnsiToUnicode(itemText);
#else
        item.pszText    = itemText;
#endif
        item.cchTextMax = MAX_PATH;
        TreeView_GetItem(tree, &item);
    } while ((LPARAM)-1 == item.lParam);

//    c = LoadString(info->hInst, IDS_CONFIRM_SERVER_REMOVAL,
//        buf, MAX_PATH);
//    _ASSERT(c);

    sprintf(message, buf, itemText);

//    c = LoadString(info->hInst, IDS_CONFIRM_SERVER_REMOVAL_TITLE,
//        title, MAX_PATH);
//    _ASSERT(c);

//    result = MessageBox(hwnd, message, title,
//        MB_OKCANCEL | MB_ICONEXCLAMATION);

    if (IDOK == result) {
        AGUserConfigRemoveServer(info->userConfig,
            AGUserConfigGetServerByUID(info->userConfig, (int32)item.lParam, AGUSERCONFIG_FIND));
        setupTreeView(hwnd, info->userConfig);
    }

    enableServerButtons(hwnd, (TreeView_GetCount(tree) > 0));
}

// ----------------------------------------------------------------------------
static void handleServerWizard(HWND hwnd, mdWindowInfo * info)
{
    AGServerConfig * sc = NULL;
//    AGConfigServerWizardDo(hwnd, info->hInst, &sc);
    if (NULL != sc) {
        AGUserConfigAddServer(info->userConfig, sc);
        setupTreeView(hwnd, info->userConfig);
    }
}
 
// ----------------------------------------------------------------------------
static void handleServerSettings(HWND hwnd, mdWindowInfo * info)
{
//    AGConfigServerSettingsDialogDo(hwnd, info->hInst,
//        AGUserConfigGetServerByUID(info->userConfig,
//        getUIDofCurrentSelection(hwnd)));
    setupTreeView(hwnd, info->userConfig);
}
 
// ----------------------------------------------------------------------------
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDOK:
#ifdef HACK
/*
                    if (AGUserConfigCount(info->userConfig) > 0) {
                        // Write server configuration info back to disk.
                        FILE * f;
                        f = fopen(ONE_TIME_PREFS_NAME, "wb");
                        if (NULL != f) {
                            AGWriter * writer = AGWriterNew(f, writeDiskFunc);
                            AGServerConfigWriteData(
                                AGUserConfigGetServerByIndex(
                                    info->userConfig, 0), writer);
                            AGWriterFree(writer);
                            fclose(f);
                        }
                    }
*/
#else
                    if (info->userConfig->dirty)
                        saveServerSettingsToDisk(info);
#endif
                    PostQuitMessage(0);
                    break; // fallthrough to base dialog handler
                case ID_SERVER_WIZARD:
//                    MessageBox(hwnd, "For this demonstration version, only the first server added to the server list will be saved in your Mobile Link configuration. Future versions will handle multiple servers.", "Mobile Link", MB_OK | MB_ICONINFORMATION);
//                    handleServerWizard(hwnd, info);
                    return;
                case ID_PROXY_WIZARD:
//                    MessageBox(hwnd, "For this demonstration version, only direct TCP/IP connections are supported. The following user interface is provided only for demonstration purposes. Future versions will fully support proxy servers.", "Mobile Link", MB_OK | MB_ICONINFORMATION);
//                    AGConfigProxyWizardDo(hwnd, info->locationInfo);
                    return;
                case ID_REMOVE_SERVER:
                    onRemoveServer(hwnd);
                    return;
                case ID_SERVER_INFO:
                    handleServerSettings(hwnd, info);
                    return;
                default:
                    break;
            }
            break;
        default:
            break;

    }
//    FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
//        codeNotify, AGConfigDialogBaseProc);
}

// ----------------------------------------------------------------------------
static LRESULT onNotify(HWND hwnd, NMHDR * nmh)
{
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {
        case TVN_SELCHANGED: {

            NM_TREEVIEW * nmtv = (NM_TREEVIEW *)nmh;
            enableServerButtons(hwnd, (nmtv->itemNew.hItem != NULL));

            break;
        }
        default:
            return FALSE;
    }
    return TRUE;
}

// ----------------------------------------------------------------------------
static void onDestroy(HWND hwnd)
{
    mdWindowInfo * info = (mdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);
}

// ----------------------------------------------------------------------------
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
        case WM_NOTIFY:
            return onNotify(hwnd, (NMHDR*)lParam);
    }

    return 0;   // except for WM_INITDIALOG, returning zero means
                // we didn't process the message.
}

// ----------------------------------------------------------------------------
int MainDialogDo(const HWND parentHwnd, const HINSTANCE hInst)
{
    int ret;
    mdWindowInfo info;
    info.hwnd = parentHwnd;
    info.hInst = hInst;
    info.locationInfo = AGLocationConfigNew();
    info.userConfig = AGUserConfigNew();

    ret = DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_MAIN),
        parentHwnd, dialogProc, (LPARAM)&info);

//    AGUserConfigFree(info.userConfig);
//    AGLocationConfigFree(info.locationInfo);

    return ret;
}
