/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGSYNCCEDESKTOP_H__
#define __AGSYNCCEDESKTOP_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <cesync.h>

#define OBJECT_VERSION  1

#define OT_ITEM     1
#define OT_FOLDER   2

class CReplObject
{
public:
    virtual ~CReplObject() {}

    UINT    m_uType;
};

class CFolder: public CReplObject
{
public:
    CFolder( void ) { m_uType = OT_FOLDER; }
    virtual ~CFolder() {}
};

class CItem: public CReplObject
{
public:
    CItem( void ) { m_uType = OT_ITEM; memset( &m_ftModified, 0, sizeof( m_ftModified ) ); }
    virtual ~CItem() {}

    UINT        m_uid;
    FILETIME    m_ftModified;
};

// 
//  === Handler to serialize/deserialize objects ====================
//
class CDataHandler : public IReplObjHandler
{
public:
    CDataHandler( void );
    ~CDataHandler();

    // ******** IUnknown methods **************
    STDMETHODIMP_(ULONG)    AddRef( void );
    STDMETHODIMP_(ULONG)    Release( void );
    STDMETHODIMP            QueryInterface( REFIID riid, void **ppvObject );
    
    // ******** IReplObjHandler methods **************
    STDMETHODIMP Setup( PREPLSETUP pSetup );
    STDMETHODIMP Reset( PREPLSETUP pSetup );

	STDMETHODIMP GetPacket( LPBYTE *lppbData,  DWORD *pcbData, DWORD cbRecommend );
    STDMETHODIMP SetPacket( LPBYTE lpbData, DWORD cbData );
    STDMETHODIMP DeleteObj( PREPLSETUP pSetup );
};

/////////////////////////////////////////////////////////////////////////////
class CStore: public IReplStore
{
private:
    LONG                m_cRef;
    LPUNKNOWN           m_pUnkOuter;

public:
    CStore( LPUNKNOWN );
    ~CStore();

    // ******** IUnknown methods **************
    STDMETHODIMP            QueryInterface(REFIID riid, void **ppvObject);
    STDMETHODIMP_(ULONG)    AddRef(void);
    STDMETHODIMP_(ULONG)    Release(void);

    // ******** IReplStore methods **************
    STDMETHODIMP        Initialize( IReplNotify *, UINT uFlags );
    STDMETHODIMP        GetStoreInfo( PSTOREINFO pStoreInfo );
    STDMETHODIMP        ReportStatus( HREPLFLD hFolder, HREPLITEM hItem, UINT uStatus, UINT uReserved );
    STDMETHODIMP_(int)  CompareStoreIDs( LPBYTE lpbID1, UINT cbID1, LPBYTE lpbID2, UINT cbID2 );

    // object related routines
    STDMETHODIMP_(int)  CompareItem( HREPLITEM hItem1, HREPLITEM hItem2 );
    STDMETHODIMP_(BOOL) IsItemChanged( HREPLFLD hFolder, HREPLITEM hItem, HREPLITEM hItemComp );
    STDMETHODIMP_(BOOL) IsItemReplicated( HREPLFLD hFolder, HREPLITEM hItem );
    STDMETHODIMP_(void) UpdateItem( HREPLFLD hFolder, HREPLITEM hItemDst, HREPLITEM hItemSrc );

    // folder related routines
    STDMETHODIMP        GetFolderInfo( LPSTR lpszName,  HREPLFLD *phFolder, IUnknown **ppObjHandler );
    STDMETHODIMP        IsFolderChanged( HREPLFLD hFolder, BOOL *pfChanged );

    // enumeration of folder objects
    STDMETHODIMP        FindFirstItem( HREPLFLD hFolder,  HREPLITEM *phItem, BOOL *pfExist );    // get first object the folder
    STDMETHODIMP        FindNextItem( HREPLFLD hFolder,  HREPLITEM *phItem, BOOL *pfExist );     // get next object the folder
    STDMETHODIMP        FindItemClose( HREPLFLD hFolder );                                    // done enumerating

    // STD management routines
    STDMETHODIMP_(UINT)     ObjectToBytes( HREPLOBJ hObject, LPBYTE lpb );
    STDMETHODIMP_(HREPLOBJ) BytesToObject( LPBYTE lpb, UINT cb );
    STDMETHODIMP_(void)     FreeObject( HREPLOBJ hObject );
    STDMETHODIMP_(BOOL)     CopyObject( HREPLOBJ hObjSrc, HREPLOBJ hObjDst );
    STDMETHODIMP            IsValidObject( HREPLFLD hFolder, HREPLITEM hObject, UINT uFlags );

    // UI related routines
    STDMETHODIMP        ActivateDialog( UINT uDlg, HWND hwndParent, HREPLFLD hFolder, IEnumReplItem *penum );
    STDMETHODIMP        GetObjTypeUIData( HREPLFLD hFolder, POBJUIDATA pData );
    STDMETHODIMP        GetConflictInfo( PCONFINFO pConfInfo );
    STDMETHODIMP        RemoveDuplicates( LPSTR, UINT );

private:
    IReplNotify     *m_pNotify;
    CDataHandler    *m_pObjHandler;
    UINT            m_uFlags;
};

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // #ifndef __AGSYNCCEDESKTOP_H__