/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

/*pending(miket): We need to figure out what all this does and implement enough
functionality so it behaves like a good ActiveSync client. */

#include <windows.h>
#include <AGSyncCEDesktop.h>
#include <AGSyncCEDesktopCommands.h>
#include <AGSyncCommon.h>
#include <AGSyncCECommon.h>
#include <rapi.h>

HINSTANCE   v_hInst;

BOOL WINAPI DllMain ( HANDLE hInstDLL, ULONG ulReason, LPVOID lpReserved )
{
    switch( ulReason )
    {
    case DLL_PROCESS_ATTACH:
        v_hInst = (HINSTANCE)hInstDLL;
        break;
    }
    return TRUE;
}


/*
  ============ Required OLE implementation for InProc servers ======================

 CClassFactory object creates CStore objects */

class CClassFactory : public IClassFactory 
{
private:
    LONG    m_cRef; 

public:
    CClassFactory( void ) : m_cRef( 0 ) {};

    virtual STDMETHODIMP            QueryInterface( REFIID iid, LPVOID* ppv);
    virtual STDMETHODIMP_(ULONG)    AddRef(); 
    virtual STDMETHODIMP_(ULONG)    Release();

    // IClassFactory members
    virtual STDMETHODIMP CreateInstance(LPUNKNOWN, REFIID, LPVOID*);
    virtual STDMETHODIMP LockServer(BOOL);
};


// Count number of objects and number of locks
static LONG v_cObj = 0;
static LONG v_cLock = 0;

STDAPI DllGetClassObject(REFCLSID rclsid,
                          REFIID riid,
                          LPVOID* ppv)  
{
    if (!IsEqualIID(riid, IID_IUnknown) &&
        !IsEqualIID(riid, IID_IClassFactory))
        return CLASS_E_CLASSNOTAVAILABLE;

    //return our IClassFactory for CStore objects
    *ppv = (LPVOID)new CClassFactory();
    if ( NULL == *ppv ) 
        return E_OUTOFMEMORY;

    //AddRef the object through any interface we return
    ((LPUNKNOWN)*ppv)->AddRef();

    return NOERROR;
}

STDAPI DllCanUnloadNow(void)  
{
    return ResultFromScode( 0L == v_cObj && 0 == v_cLock? S_OK : S_FALSE );
}


STDMETHODIMP CClassFactory::QueryInterface(REFIID riid, LPVOID* ppv)  
{
    *ppv=NULL;
    if (IsEqualIID( riid, IID_IUnknown ) ||
        IsEqualIID( riid, IID_IClassFactory ) ) 
        *ppv=(LPVOID)this;

    if( NULL != *ppv )  
    {
        ((LPUNKNOWN)*ppv)->AddRef();
        return NOERROR;
    }
    return E_NOINTERFACE;
}

STDMETHODIMP_(ULONG) CClassFactory::AddRef( void )
{
    ULONG urc;
    urc = (ULONG)InterlockedIncrement( &m_cRef );
    return(urc);
}

STDMETHODIMP_(ULONG) CClassFactory::Release()
{
    ULONG urc;
    urc = (ULONG)InterlockedDecrement( &m_cRef ); 
    if (urc == 0 ) 
        delete this;

    return urc;
}

STDMETHODIMP CClassFactory::CreateInstance(LPUNKNOWN pUnkOuter,
                                           REFIID riid,
                                           LPVOID* ppvObj)
{
    CStore  *pObj;
    HRESULT hr;
    DWORD   dwLastError = 0;
    
    *ppvObj = NULL;
    hr = E_OUTOFMEMORY;

    if ( NULL != pUnkOuter && !IsEqualIID( riid, IID_IUnknown ) )
        return E_NOINTERFACE;

    pObj = new CStore( pUnkOuter );
    if ( NULL == pObj ) 
        return E_OUTOFMEMORY;

    hr = pObj->QueryInterface( riid, ppvObj );

    InterlockedIncrement( &v_cObj );

    if ( FAILED( hr ) ) 
    {
        delete pObj; // <-- this destroys LastError
        if( dwLastError )
            SetLastError( dwLastError );
    }

    return hr;
}


STDMETHODIMP CClassFactory::LockServer(BOOL fLock)
{
    if (fLock)
        InterlockedIncrement( &v_cLock );
    else     
        InterlockedDecrement( &v_cLock );

    return NOERROR;
}

//
// ================== Basic Implementation of IReplStore ====================
//

CStore::CStore( LPUNKNOWN pUnkOuter )
{
    m_cRef          = 0;
    m_pUnkOuter     = pUnkOuter;
    m_pObjHandler   = new CDataHandler;
}

CStore::~CStore()
{
    delete m_pObjHandler;
    InterlockedDecrement( &v_cObj );
}

//
// ==================== IUnknown Implementation ===========================
//

STDMETHODIMP CStore::QueryInterface( REFIID iid, LPVOID  *ppvObj )
{
    *ppvObj = NULL;   // set to NULL, in case we fail.

    if ( IsEqualIID( iid, IID_IUnknown ) )
        *ppvObj = (void*)this;
    else if ( IsEqualIID( iid, IID_IReplStore ) )
        *ppvObj = (void*)(IReplStore *)this;
    else if ( m_pUnkOuter )
        return m_pUnkOuter->QueryInterface( iid, ppvObj );

    if ( *ppvObj )
    {
        ((IUnknown *)(*ppvObj))->AddRef();
        return NOERROR;
    }
    return E_NOINTERFACE;
}

STDMETHODIMP_(ULONG) CStore::AddRef()
{
    ULONG   urc;

    if ( m_pUnkOuter )
        urc = m_pUnkOuter->AddRef();
    else
        urc = (ULONG)InterlockedIncrement( &m_cRef );
    return urc;
}

STDMETHODIMP_(ULONG) CStore::Release()
{
    ULONG   urc;

    if ( m_pUnkOuter )
        urc = m_pUnkOuter->Release();
    else
    {
        urc =(ULONG)InterlockedDecrement( &m_cRef );
        if ( urc == 0 )
            delete this;
    }
    return urc;
}

//
// ==================== IReplStore Implementation ===========================
//

STDMETHODIMP CStore::Initialize
(
    IReplNotify *pNotify,
    UINT        uFlags
)
{
    return NOERROR;
}

STDMETHODIMP CStore::GetStoreInfo
(
    PSTOREINFO pInfo    // pointers to the STOREINFO structure
)
{
    if ( pInfo->cbStruct != sizeof( STOREINFO ) )
        return E_INVALIDARG;

    pInfo->uFlags = SCF_SINGLE_THREAD | SCF_SIMULATE_RTS;

    // ProgId of the store
    lstrcpy( pInfo->szProgId, "Mobile_Application_Link.Server" );

    lstrcpy( pInfo->szStoreDesc, "Mobile Application Data" );

    pInfo->uTimerRes = 0;

    // construct something that uniquely identifies the store
    // in this sample, we don't need to worry about the difference in stores
    // so just make up something
    pInfo->cbStoreId = 10;
    if ( pInfo->cbStoreId > pInfo->cbMaxStoreId )
        return E_OUTOFMEMORY;

    if ( pInfo->lpbStoreId == NULL )
        return E_POINTER;

    memset( pInfo->lpbStoreId, 0, 10 );
    return NOERROR;
}

STDMETHODIMP_(int) CStore::CompareStoreIDs
(
    LPBYTE  lpbID1,     // points to the first store ID
    UINT    cbID1,      // size of the first store ID
    LPBYTE  lpbID2,     // points to the second store ID
    UINT    cbID2       // size of the second store ID
)
{
    return 0;
}

STDMETHODIMP CStore::ReportStatus
(
    HREPLFLD    hFolder,
    HREPLITEM   hItem,
    UINT        uStatus,
    UINT        uParam
)
{
    switch( uStatus )
    {
    case RSC_INTERRUPT:         // client should abort whatever it's doing now
        break;

    case RSC_BEGIN_SYNC:    // Synchronization is about to start
        AGSyncToServer(v_hInst);
        break;

    case RSC_END_SYNC:      // Synchronization is about to end
        break;

    case RSC_BEGIN_CHECK:   // FindFirstItem is about to be called, followed by FindNextItem
        break;

    case RSC_END_CHECK:     // FindItemClose has been called
        break;

    case RSC_DATE_CHANGED:  // System Date has changed
        break;

    case RSC_RELEASE:       // Server is about to release the store
        break;

    case RSC_REMOTE_SYNC:   // Indicates if remote sync is enabled. uParam will be TRUE if all sync 
                            // will be remote until this status is reported again with uParam set to FALSE
        break;
    }

    return NOERROR;
}


//
//  ==================== Object management routines =====================
//

STDMETHODIMP_(UINT) CStore::ObjectToBytes
(
    HREPLOBJ    hObject,
    LPBYTE      lpb
)
{
    return 0;
}

STDMETHODIMP_(HREPLOBJ) CStore::BytesToObject
(
    LPBYTE  lpb,
    UINT    cb
)
{
    return NULL;
}

STDMETHODIMP_(void) CStore::FreeObject
(
    HREPLOBJ hObject
)
{
}

STDMETHODIMP_(BOOL) CStore::CopyObject
(
    HREPLOBJ    hObjSrc,    // handle to the source object
    HREPLOBJ    hObjDst     // handle to the destination object
)
{
    return TRUE;
}

STDMETHODIMP CStore::IsValidObject
( 
    HREPLFLD    hFolder,    // handle of the folder where this item belongs
    HREPLITEM   hItem,      // handle of the object, could be NULL
    UINT        uFlags      // Reserved. Must be 0.
)
{
    return TRUE;
}

//
// ============= folder related routines  ================
//

STDMETHODIMP CStore::GetFolderInfo
(
    LPSTR           lpszName,       // Name of the object type. It's taken from the registry.
    HREPLFLD        *phFolder,      // Output pointers, points to the handle of the new folder 
    IUnknown        **ppObjHandler  // Output pointers, points to the object handler of this object type
)
{
    CFolder *pFolder = (CFolder *)*phFolder;
    BOOL    fNew = (pFolder == NULL);

    if ( fNew )
        pFolder = new CFolder;

    // either set up the new CFolder class (when fNew is TRUE) or reinitialize the class (when fNew is FALSE)

    *phFolder = (HREPLFLD)pFolder;
    *ppObjHandler = m_pObjHandler;
    return NOERROR;
}

STDMETHODIMP CStore::IsFolderChanged
(
    HREPLFLD    hFolder,    // Handle of the folder
    BOOL        *pfChanged  // Points to a Boolean that will be set to TRUE if folder is changed
)
{
    if ( pfChanged )
        *pfChanged = TRUE;

    return NOERROR;
}



//
// ============= Enumeration of folder objects ================
//

STDMETHODIMP CStore::FindFirstItem
(
    HREPLFLD    hFolder,        // handle to a folder
    HREPLITEM   *phItem,        // Output, points to the handle of the new object
    BOOL        *pfExist        // Output, points to a boolean value that will be set to TRUE if there is an object in the folder
)
{
    if ( pfExist )
        *pfExist = TRUE;
    return NOERROR;
}

STDMETHODIMP CStore::FindNextItem
(
    HREPLFLD    hFolder,        // handle to a folder
    HREPLITEM   *phItem,        // Output, points to the handle of the new object
    BOOL        *pfExist        // Output, points to a boolean value that will be set to TRUE if there is an object in the folder
)
{
    if ( pfExist )
        *pfExist = FALSE;

    return NOERROR;
}

STDMETHODIMP CStore::FindItemClose
(
    HREPLFLD    hFolder        // handle to a folder
)
{
    return NOERROR;
}

//
// ================== object related routines ================
//

STDMETHODIMP_(int) CStore::CompareItem
(
    HREPLITEM hItem1,  // Points to the handle of first object. This handle is guaranteed to be created by IReplStore::FindFirstObject or IReplStore::FindNextObject
    HREPLITEM hItem2   // Points to the handle of second object. This handle is guaranteed to be created by IReplStore::FindFirstObject or IReplStore::FindNextObject
)
{
    return 0;
}

STDMETHODIMP_(BOOL) CStore::IsItemChanged
(
    HREPLFLD    hFolder,    // Handle of a folder
    HREPLITEM   hItem,      // Handle of an object
    HREPLITEM   hItemComp   // Handle of the object used for comparison, could be NULL
)
{
    return TRUE;
}

STDMETHODIMP_(BOOL) CStore::IsItemReplicated
(
    HREPLFLD    hFolder,    // Handle of a folder
    HREPLITEM   hItem       // Handle of an object
)
{
    return FALSE;
}

STDMETHODIMP_(void) CStore::UpdateItem
(
    HREPLFLD    hFolder,    // Handle of a folder
    HREPLITEM   hItemDst,   // Handle of the destination object
    HREPLITEM   hItemSrc    // Handle to the source object, could be NULL.
)
{
}

//
//  ==================== UI related routines =====================
//

STDMETHODIMP CStore::GetConflictInfo( PCONFINFO pConfInfo )
{
    // make sure we have the right version of OBJUIDATA
    if ( pConfInfo->cbStruct != sizeof( CONFINFO ) )
        return E_INVALIDARG;

    return E_NOTIMPL;
}

STDMETHODIMP CStore::ActivateDialog
( 
    UINT            uDlg,           // Which dialog should be actiavted
    HWND            hwndParent,     // Handle of the window that should be used as parent for the dialog
    HREPLFLD        hFolder,        // Points to a valid STD for the folder
    IEnumReplItem   *penum          // Points to a enumerator of object STD for objects stored in the folder
)
{
    const TCHAR * cloption = "-activesync ";
    TCHAR * stringPointer;
    TCHAR * buf;
    char deviceName[MAX_PATH];

    deviceName[0] = '\0';

    stringPointer = (TCHAR*)AGSyncCommonGetStringConstant(agMobileLinkPath,
        FALSE);

    AGCEGetCurrentDeviceInfo(deviceName, NULL, NULL);

    buf = (TCHAR*)malloc((strlen(cloption)
        + strlen(deviceName)
        + 1)
        * sizeof(TCHAR));

    strcpy(buf, cloption);
    strcat(buf, deviceName);

    ShellExecute(hwndParent, "open", stringPointer, buf, NULL, SW_SHOWNORMAL);

    free(buf);
    free(stringPointer);
 
    return NOERROR;

}

STDMETHODIMP CStore::GetObjTypeUIData
( 
    HREPLFLD    hFolder,        // Input, points to a STD of a folder that stores the object 
    POBJUIDATA  pData           // Output, points to a OBJUIDATA structure.
)
{
    // make sure we have the right version of OBJUIDATA
    if ( pData->cbStruct != sizeof( OBJUIDATA ) )
        return E_INVALIDARG;

    // ** You must have the following icons loaded, or the szName will not be displayed in Windows CE Services **
    // pending(miket): get icons
//  pData->hIconLarge = (HICON)LoadImage( hRes, MAKEINTRESOURCE( IDI_ICON ), IMAGE_ICON, 32, 32, 0 );
//  pData->hIconSmall = (HICON)LoadImage( hRes, MAKEINTRESOURCE( IDI_ICON ), IMAGE_ICON, 16, 16, 0 );

    lstrcpy( pData->szName, "Mobile Application Link" );
    lstrcpy( pData->szTypeText, "Mobile Application Link Server" );
    lstrcpy( pData->szPlTypeText, "Mobile Application Link Server" );
    lstrcpy( pData->szSyncText, "Information on Server" );

    return NOERROR;
}

STDMETHODIMP CStore::RemoveDuplicates
( 
    LPSTR   lpszObjType,
    UINT    uFlags
)
{
    return E_NOTIMPL;
}
